/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.transfer;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Iterator;
import java.util.List;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public abstract class InputSlotCrafter<T extends class_1703, C extends class_1263> {
    protected T container;
    private Iterable<SlotAccessor> inputStacks;
    private Iterable<SlotAccessor> inventoryStacks;
    protected class_3222 player;

    protected InputSlotCrafter(T container) {
        this.container = container;
    }

    public void fillInputSlots(class_3222 player, boolean hasShift) {
        this.player = player;
        this.inventoryStacks = this.getInventorySlots();
        this.inputStacks = this.getInputSlots();
        this.cleanInputs();
        RecipeFinder recipeFinder = new RecipeFinder();
        this.populateRecipeFinder(recipeFinder);
        class_2371 ingredients = class_2371.method_10211();
        for (InputIngredient<class_1799> itemStacks : this.getInputs()) {
            ingredients.add((Object)CollectionUtils.toIngredient(itemStacks.get()));
        }
        if (!recipeFinder.findRecipe((class_2371<class_1856>)ingredients, null)) {
            this.cleanInputs();
            this.markDirty();
            throw new NotEnoughMaterialsException();
        }
        this.fillInputSlots(recipeFinder, (class_2371<class_1856>)ingredients, hasShift);
        this.markDirty();
    }

    protected abstract Iterable<SlotAccessor> getInputSlots();

    protected abstract Iterable<SlotAccessor> getInventorySlots();

    protected abstract List<InputIngredient<class_1799>> getInputs();

    protected abstract void populateRecipeFinder(RecipeFinder var1);

    protected abstract void markDirty();

    public void alignRecipeToGrid(Iterable<SlotAccessor> inputStacks, Iterator<Integer> recipeItemIds, int craftsAmount) {
        for (SlotAccessor inputStack : inputStacks) {
            if (!recipeItemIds.hasNext()) {
                return;
            }
            this.acceptAlignedInput(recipeItemIds.next(), inputStack, craftsAmount);
        }
    }

    public void acceptAlignedInput(Integer recipeItemId, SlotAccessor inputStack, int craftsAmount) {
        class_1799 toBeTakenStack = RecipeFinder.getStackFromId(recipeItemId);
        if (!toBeTakenStack.method_7960()) {
            for (int i = 0; i < craftsAmount; ++i) {
                this.fillInputSlot(inputStack, toBeTakenStack);
            }
        }
    }

    protected void fillInputSlot(SlotAccessor slot, class_1799 toBeTakenStack) {
        class_1799 takenStack;
        SlotAccessor takenSlot = this.takeInventoryStack(toBeTakenStack);
        if (takenSlot != null && !(takenStack = takenSlot.getItemStack().method_7972()).method_7960()) {
            if (takenStack.method_7947() > 1) {
                takenSlot.takeStack(1);
            } else {
                takenSlot.setItemStack(class_1799.field_8037);
            }
            takenStack.method_7939(1);
            if (!slot.canPlace(takenStack)) {
                return;
            }
            if (slot.getItemStack().method_7960()) {
                slot.setItemStack(takenStack);
            } else {
                slot.getItemStack().method_7933(1);
            }
        }
    }

    protected void fillInputSlots(RecipeFinder recipeFinder, class_2371<class_1856> ingredients, boolean hasShift) {
        int recipeCrafts = recipeFinder.countRecipeCrafts(ingredients, null);
        IntArrayList recipeItemIds = new IntArrayList();
        int amountToFill = hasShift ? recipeCrafts : 1;
        if (recipeFinder.findRecipe(ingredients, (IntList)recipeItemIds, amountToFill)) {
            int finalCraftsAmount = amountToFill;
            IntListIterator intListIterator = recipeItemIds.iterator();
            while (intListIterator.hasNext()) {
                int itemId = (Integer)intListIterator.next();
                if (itemId == 0) continue;
                finalCraftsAmount = Math.min(finalCraftsAmount, RecipeFinder.getStackFromId(itemId).method_7914());
            }
            if (recipeFinder.findRecipe(ingredients, (IntList)recipeItemIds, finalCraftsAmount)) {
                this.cleanInputs();
                this.alignRecipeToGrid(this.inputStacks, (Iterator<Integer>)recipeItemIds.iterator(), finalCraftsAmount);
            }
        }
    }

    protected abstract void cleanInputs();

    @Nullable
    public SlotAccessor takeInventoryStack(class_1799 itemStack) {
        boolean rejectedModification = false;
        for (SlotAccessor inventoryStack : this.inventoryStacks) {
            class_1799 itemStack1 = inventoryStack.getItemStack();
            if (itemStack1.method_7960() || !InputSlotCrafter.areItemsEqual(itemStack, itemStack1) || itemStack1.method_7986() || itemStack1.method_7942() || itemStack1.method_57826(class_9334.field_49631)) continue;
            if (!inventoryStack.allowModification((class_1657)this.player)) {
                rejectedModification = true;
                continue;
            }
            return inventoryStack;
        }
        if (rejectedModification) {
            throw new IllegalStateException("Unable to take item from inventory due to slot not allowing modification! Item requested: " + String.valueOf(itemStack));
        }
        return null;
    }

    private static boolean areItemsEqual(class_1799 stack1, class_1799 stack2) {
        return class_1799.method_31577((class_1799)stack1, (class_1799)stack2);
    }

    public static class NotEnoughMaterialsException
    extends RuntimeException {
    }
}

