/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.autocrafting;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.MenuTransferException;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_518;
import net.minecraft.class_5455;
import net.minecraft.class_9129;

@Environment(value=EnvType.CLIENT)
public class DefaultCategoryHandler
implements TransferHandler {
    @Override
    public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
        Display display = context.getDisplay();
        class_465<?> containerScreen = context.getContainerScreen();
        if (containerScreen == null) {
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }
        class_1703 menu = context.getMenu();
        MenuInfoContext<class_1703, class_1657, Display> menuInfoContext = DefaultCategoryHandler.ofContext(menu, display);
        MenuInfo<class_1703, Display> menuInfo = MenuInfoRegistry.getInstance().getClient(display, menuInfoContext, menu);
        if (menuInfo == null) {
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }
        return TransferHandler.ApplicabilityResult.createApplicable();
    }

    @Override
    public TransferHandler.Result handle(TransferHandler.Context context) {
        Display display = context.getDisplay();
        class_465<?> containerScreen = context.getContainerScreen();
        class_1703 menu = context.getMenu();
        MenuInfoContext<class_1703, class_1657, Display> menuInfoContext = DefaultCategoryHandler.ofContext(menu, display);
        MenuInfo<class_1703, Display> menuInfo = MenuInfoRegistry.getInstance().getClient(display, menuInfoContext, menu);
        try {
            menuInfo.validate(menuInfoContext);
        }
        catch (MenuTransferException e) {
            if (e.isApplicable()) {
                return TransferHandler.Result.createFailed(e.getError());
            }
            return TransferHandler.Result.createNotApplicable();
        }
        List<InputIngredient<class_1799>> input = menuInfo.getInputsIndexed(menuInfoContext, false);
        List<InputIngredient<class_1799>> missing = this.hasItemsIndexed(menuInfoContext, menu, menuInfo, display, input);
        if (!missing.isEmpty()) {
            IntArrayList missingIndices = new IntArrayList(missing.size());
            for (InputIngredient<class_1799> ingredient2 : missing) {
                missingIndices.add(ingredient2.getIndex());
            }
            IntLinkedOpenHashSet missingIndicesSet = new IntLinkedOpenHashSet((IntCollection)missingIndices);
            List<List> oldInputs = CollectionUtils.map(input, InputIngredient::get);
            return TransferHandler.Result.createFailed((class_2561)class_2561.method_43471((String)"error.rei.not.enough.materials")).renderer((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> DefaultCategoryHandler.lambda$handle$0(menuInfo, menuInfoContext, oldInputs, (IntList)missingIndices, input, missing, (IntSet)missingIndicesSet, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6)).tooltipMissing(CollectionUtils.map(missing, ingredient -> EntryIngredients.ofItemStacks(ingredient.get())));
        }
        if (!ClientHelper.getInstance().canUseMovePackets()) {
            return TransferHandler.Result.createFailed((class_2561)class_2561.method_43471((String)"error.rei.not.on.server"));
        }
        if (!context.isActuallyCrafting()) {
            return TransferHandler.Result.createSuccessful();
        }
        context.getMinecraft().method_1507(containerScreen);
        if (containerScreen instanceof class_518) {
            class_518 listener = (class_518)containerScreen;
            listener.method_2659().field_3092.method_2571();
        }
        class_9129 buf = new class_9129(Unpooled.buffer(), (class_5455)context.getMinecraft().method_1562().method_29091());
        buf.method_10812(display.getCategoryIdentifier().getIdentifier());
        buf.method_52964(context.isStackedCrafting());
        buf.method_10794((class_2520)menuInfo.save(menuInfoContext, display));
        NetworkManager.sendToServer((class_2960)RoughlyEnoughItemsNetwork.MOVE_ITEMS_PACKET, (class_9129)buf);
        return TransferHandler.Result.createSuccessful();
    }

    @Override
    public double getPriority() {
        return -10.0;
    }

    private static MenuInfoContext<class_1703, class_1657, Display> ofContext(final class_1703 menu, final Display display) {
        return new MenuInfoContext<class_1703, class_1657, Display>(){

            @Override
            public class_1703 getMenu() {
                return menu;
            }

            @Override
            public class_1657 getPlayerEntity() {
                return class_310.method_1551().field_1724;
            }

            @Override
            public CategoryIdentifier<Display> getCategoryIdentifier() {
                return display.getCategoryIdentifier();
            }

            @Override
            public Display getDisplay() {
                return display;
            }
        };
    }

    public IntList hasItems(MenuInfoContext<class_1703, class_1657, Display> menuInfoContext, class_1703 menu, MenuInfo<class_1703, Display> info, Display display, List<List<class_1799>> inputs) {
        List<InputIngredient<class_1799>> missing = this.hasItemsIndexed(menuInfoContext, menu, info, display, CollectionUtils.mapIndexed(inputs, InputIngredient::of));
        IntArrayList ids = new IntArrayList(missing.size());
        for (InputIngredient<class_1799> ingredient : missing) {
            ids.add(ingredient.getIndex());
        }
        return ids;
    }

    public List<InputIngredient<class_1799>> hasItemsIndexed(MenuInfoContext<class_1703, class_1657, Display> menuInfoContext, class_1703 menu, MenuInfo<class_1703, Display> info, Display display, List<InputIngredient<class_1799>> inputs) {
        RecipeFinder recipeFinder = new RecipeFinder();
        info.getRecipeFinderPopulator().populate(menuInfoContext, recipeFinder);
        ArrayList<InputIngredient<class_1799>> missing = new ArrayList<InputIngredient<class_1799>>();
        for (InputIngredient<class_1799> possibleStacks : inputs) {
            boolean done = possibleStacks.get().isEmpty();
            for (class_1799 possibleStack : possibleStacks.get()) {
                int invRequiredCount;
                if (done) continue;
                int key = RecipeFinder.getItemId(possibleStack);
                for (invRequiredCount = possibleStack.method_7947(); invRequiredCount > 0 && recipeFinder.contains(key); --invRequiredCount) {
                    recipeFinder.take(key, 1);
                }
                if (invRequiredCount > 0) continue;
                done = true;
                break;
            }
            if (done) continue;
            missing.add(possibleStacks);
        }
        return missing;
    }

    private static /* synthetic */ void lambda$handle$0(MenuInfo menuInfo, MenuInfoContext menuInfoContext, List oldInputs, IntList missingIndices, List input, List missing, IntSet missingIndicesSet, class_332 matrices, int mouseX, int mouseY, float delta, List widgets, Rectangle bounds, Display d) {
        menuInfo.renderMissingInput(menuInfoContext, oldInputs, missingIndices, matrices, mouseX, mouseY, delta, widgets, bounds);
        menuInfo.renderMissingInput(menuInfoContext, input, missing, missingIndicesSet, matrices, mouseX, mouseY, delta, widgets, bounds);
    }
}

