/*
 * Decompiled with CFR 0.152.
 */
package com.bedrockk.molang.runtime;

import com.bedrockk.molang.runtime.MoParams;
import com.bedrockk.molang.runtime.struct.ArrayStruct;
import com.bedrockk.molang.runtime.struct.ContextStruct;
import com.bedrockk.molang.runtime.struct.MoStruct;
import com.bedrockk.molang.runtime.struct.QueryStruct;
import com.bedrockk.molang.runtime.struct.VariableStruct;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.bedrockk.molang.runtime.value.MoValue;
import java.util.Iterator;

public class MoLangEnvironment
implements MoValue {
    public static final String QUERY = "query";
    public static final String MATH = "math";
    public static final String VARIABLE = "variable";
    public static final String TEMP = "temp";
    public static final String CONTEXT = "context";
    public static final String ARRAY = "array";
    public QueryStruct math = null;
    public QueryStruct query = null;
    public VariableStruct variable = null;
    public VariableStruct temp = null;
    public ContextStruct context = null;
    public ArrayStruct array = null;

    public void setStruct(String name, MoStruct struct) {
        switch (name) {
            case "math": {
                this.math = (QueryStruct)struct;
                break;
            }
            case "query": {
                this.query = (QueryStruct)struct;
                break;
            }
            case "variable": {
                this.variable = (VariableStruct)struct;
                break;
            }
            case "temp": {
                this.temp = (VariableStruct)struct;
                break;
            }
            case "context": {
                this.context = (ContextStruct)struct;
                break;
            }
            case "array": {
                this.array = (ArrayStruct)struct;
            }
        }
    }

    public void removeStruct(String name) {
        switch (name) {
            case "context": {
                this.context = null;
                break;
            }
            case "temp": {
                this.temp = null;
                break;
            }
            case "math": {
                this.math = null;
                break;
            }
            case "query": {
                this.query = null;
                break;
            }
            case "variable": {
                this.variable = null;
                break;
            }
            case "array": {
                this.array = null;
            }
        }
    }

    public MoStruct getStruct(String name) {
        return switch (name) {
            case MATH -> this.math;
            case QUERY -> this.query;
            case VARIABLE -> this.variable;
            case TEMP -> this.temp;
            case CONTEXT -> this.context;
            case ARRAY -> this.array;
            default -> null;
        };
    }

    public MoValue getValue(Iterator<String> names) {
        return this.getValue(names, MoParams.EMPTY);
    }

    public MoValue getValue(Iterator<String> names, MoParams params) {
        String main = names.next();
        MoStruct struct = this.getStruct(main);
        if (struct != null) {
            return struct.get(names, params);
        }
        return new DoubleValue(0.0);
    }

    public void setValue(Iterator<String> names, MoValue value) {
        String main = names.next();
        MoStruct struct = this.getStruct(main);
        if (struct != null) {
            struct.set(names, value);
        }
    }

    public void setSimpleVariable(String name, MoValue value) {
        this.variable.setDirectly(name, value);
    }

    public MoValue getSimpleVariable(String name) {
        return this.variable.getMap().get(name);
    }

    @Override
    public Object value() {
        return this;
    }
}

