/*
 * Decompiled with CFR 0.152.
 */
package com.bedrockk.molang.runtime.struct;

import com.bedrockk.molang.runtime.MoParams;
import com.bedrockk.molang.runtime.struct.MoStruct;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.bedrockk.molang.runtime.value.MoValue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Function;

public class QueryStruct
implements MoStruct {
    public final HashMap<String, Function<MoParams, Object>> functions;

    @Override
    public MoValue get(Iterator<String> names, MoParams params) {
        MoParams currentParams;
        String key = names.next();
        Function<MoParams, Object> func = this.functions.get(key);
        MoParams moParams = currentParams = names.hasNext() ? MoParams.EMPTY : params;
        if (func != null) {
            Object result = func.apply(currentParams);
            if (result instanceof MoStruct && names.hasNext()) {
                return ((MoStruct)result).get(names, params);
            }
            return MoValue.of(result);
        }
        return DoubleValue.ZERO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Iterator<String> names, MoValue value) {
        String main = names.next();
        if (!names.hasNext() || main == null) throw new RuntimeException("Cannot set a value in query struct");
        Function<MoParams, Object> function = this.functions.get(main);
        if (function == null) throw new RuntimeException("Cannot set a value in query struct");
        Object struct = function.apply(MoParams.EMPTY);
        if (!(struct instanceof MoStruct)) {
            throw new RuntimeException("Cannot set a value in query struct");
        }
        ((MoStruct)struct).set(names, value);
    }

    @Override
    public void clear() {
        this.functions.clear();
    }

    public QueryStruct addFunction(String name, Function<MoParams, Object> func) {
        this.functions.put(name, func);
        return this;
    }

    public HashMap<String, Function<MoParams, Object>> getFunctions() {
        return this.functions;
    }

    public QueryStruct(HashMap<String, Function<MoParams, Object>> functions) {
        this.functions = functions;
    }
}

