/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.abilities;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.abilities.CommonAbilityType;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.api.data.DataRegistry;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.battles.runner.ShowdownService;
import com.cobblemon.mod.common.net.messages.client.data.AbilityRegistrySyncPacket;
import com.cobblemon.mod.common.pokemon.abilities.HiddenAbilityType;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.google.gson.JsonArray;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\r\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0019J\r\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\"\u001a\u00020\u00062\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\u001eH\u0000\u00a2\u0006\u0004\b \u0010!R\"\u0010%\u001a\n $*\u0004\u0018\u00010#0#8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u001a\u0010*\u001a\u00020)8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R \u0010/\u001a\b\u0012\u0004\u0012\u00020\u00000.8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u0017\u00103\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u0010\u0015R \u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\r068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108\u00a8\u00069"}, d2={"Lcom/cobblemon/mod/common/api/abilities/Abilities;", "Lcom/cobblemon/mod/common/api/data/DataRegistry;", "<init>", "()V", "Lnet/minecraft/class_3300;", "manager", "", "reload", "(Lnet/minecraft/class_3300;)V", "Lnet/minecraft/class_3222;", "player", "sync", "(Lnet/minecraft/class_3222;)V", "Lcom/cobblemon/mod/common/api/abilities/AbilityTemplate;", "ability", "register", "(Lcom/cobblemon/mod/common/api/abilities/AbilityTemplate;)Lcom/cobblemon/mod/common/api/abilities/AbilityTemplate;", "", "all", "()Ljava/util/List;", "first", "()Lcom/cobblemon/mod/common/api/abilities/AbilityTemplate;", "", "name", "get", "(Ljava/lang/String;)Lcom/cobblemon/mod/common/api/abilities/AbilityTemplate;", "getOrException", "", "count", "()I", "", "abilities", "receiveSyncPacket$common", "(Ljava/util/Collection;)V", "receiveSyncPacket", "Lnet/minecraft/class_2960;", "kotlin.jvm.PlatformType", "id", "Lnet/minecraft/class_2960;", "getId", "()Lnet/minecraft/class_2960;", "Lnet/minecraft/class_3264;", "type", "Lnet/minecraft/class_3264;", "getType", "()Lnet/minecraft/class_3264;", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "observable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getObservable", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "DUMMY", "Lcom/cobblemon/mod/common/api/abilities/AbilityTemplate;", "getDUMMY", "", "abilityMap", "Ljava/util/Map;", "common"})
@SourceDebugExtension(value={"SMAP\nAbilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Abilities.kt\ncom/cobblemon/mod/common/api/abilities/Abilities\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1863#2,2:71\n*S KotlinDebug\n*F\n+ 1 Abilities.kt\ncom/cobblemon/mod/common/api/abilities/Abilities\n*L\n67#1:71,2\n*E\n"})
public final class Abilities
implements DataRegistry {
    @NotNull
    public static final Abilities INSTANCE = new Abilities();
    private static final class_2960 id = MiscUtilsKt.cobblemonResource("abilities");
    @NotNull
    private static final class_3264 type = class_3264.field_14190;
    @NotNull
    private static final SimpleObservable<Abilities> observable = new SimpleObservable();
    @NotNull
    private static final AbilityTemplate DUMMY = new AbilityTemplate("dummy", null, null, null, 14, null);
    @NotNull
    private static final Map<String, AbilityTemplate> abilityMap = new LinkedHashMap();

    private Abilities() {
    }

    @Override
    public class_2960 getId() {
        return id;
    }

    @Override
    @NotNull
    public class_3264 getType() {
        return type;
    }

    @NotNull
    public SimpleObservable<Abilities> getObservable() {
        return observable;
    }

    @NotNull
    public final AbilityTemplate getDUMMY() {
        return DUMMY;
    }

    @Override
    public void reload(@NotNull class_3300 manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        PotentialAbility.Companion.getTypes().clear();
        PotentialAbility.Companion.getTypes().add(CommonAbilityType.INSTANCE);
        PotentialAbility.Companion.getTypes().add(HiddenAbilityType.INSTANCE);
        abilityMap.clear();
        JsonArray abilitiesJson = ShowdownService.Companion.getService().getAbilityIds();
        int n = abilitiesJson.size();
        for (int i = 0; i < n; ++i) {
            String id = abilitiesJson.get(i).getAsString();
            Intrinsics.checkNotNull((Object)id);
            AbilityTemplate ability = new AbilityTemplate(id, null, null, null, 14, null);
            this.register(ability);
        }
        Cobblemon.LOGGER.info("Loaded {} abilities", (Object)abilityMap.size());
        Abilities[] abilitiesArray = new Abilities[]{this};
        this.getObservable().emit((Abilities[])abilitiesArray);
    }

    @Override
    public void sync(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        new AbilityRegistrySyncPacket((Collection<AbilityTemplate>)this.all()).sendToPlayer(player);
    }

    @NotNull
    public final AbilityTemplate register(@NotNull AbilityTemplate ability) {
        Intrinsics.checkNotNullParameter((Object)ability, (String)"ability");
        String string = ability.getName().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        abilityMap.put(string, ability);
        return ability;
    }

    @NotNull
    public final List<AbilityTemplate> all() {
        return CollectionsKt.toList((Iterable)abilityMap.values());
    }

    @NotNull
    public final AbilityTemplate first() {
        return (AbilityTemplate)CollectionsKt.first((Iterable)abilityMap.values());
    }

    @Nullable
    public final AbilityTemplate get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return abilityMap.get(string);
    }

    @NotNull
    public final AbilityTemplate getOrException(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        AbilityTemplate abilityTemplate = this.get(name);
        if (abilityTemplate == null) {
            throw new IllegalArgumentException("Unable to find ability of name: " + name);
        }
        return abilityTemplate;
    }

    public final int count() {
        return abilityMap.size();
    }

    public final void receiveSyncPacket$common(@NotNull Collection<AbilityTemplate> abilities) {
        Intrinsics.checkNotNullParameter(abilities, (String)"abilities");
        abilityMap.clear();
        Iterable $this$forEach$iv = abilities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbilityTemplate ability = (AbilityTemplate)element$iv;
            boolean bl2 = false;
            INSTANCE.register(ability);
        }
    }
}

