/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.battles.model.actor;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.PassActionResponse;
import com.cobblemon.mod.common.battles.ShowdownActionRequest;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.exception.IllegalActionChoiceException;
import com.cobblemon.mod.common.net.messages.client.battle.BattleMakeChoicePacket;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000e\u001a\u00020\r2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/cobblemon/mod/common/api/battles/model/actor/AIBattleActor;", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "Ljava/util/UUID;", "gameId", "", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "pokemonList", "Lcom/cobblemon/mod/common/api/battles/model/ai/BattleAI;", "battleAI", "<init>", "(Ljava/util/UUID;Ljava/util/List;Lcom/cobblemon/mod/common/api/battles/model/ai/BattleAI;)V", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "packet", "", "sendUpdate", "(Lcom/cobblemon/mod/common/api/net/NetworkPacket;)V", "onChoiceRequested", "()V", "Lcom/cobblemon/mod/common/api/battles/model/ai/BattleAI;", "getBattleAI", "()Lcom/cobblemon/mod/common/api/battles/model/ai/BattleAI;", "common"})
public abstract class AIBattleActor
extends BattleActor {
    @NotNull
    private final BattleAI battleAI;

    public AIBattleActor(@NotNull UUID gameId, @NotNull List<? extends BattlePokemon> pokemonList, @NotNull BattleAI battleAI) {
        Intrinsics.checkNotNullParameter((Object)gameId, (String)"gameId");
        Intrinsics.checkNotNullParameter(pokemonList, (String)"pokemonList");
        Intrinsics.checkNotNullParameter((Object)battleAI, (String)"battleAI");
        super(gameId, CollectionsKt.toMutableList((Collection)pokemonList));
        this.battleAI = battleAI;
    }

    @NotNull
    public final BattleAI getBattleAI() {
        return this.battleAI;
    }

    @Override
    public void sendUpdate(@NotNull NetworkPacket<?> packet) {
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        super.sendUpdate(packet);
        if (packet instanceof BattleMakeChoicePacket) {
            this.onChoiceRequested();
        }
    }

    public void onChoiceRequested() {
        try {
            ShowdownActionRequest showdownActionRequest = this.getRequest();
            Intrinsics.checkNotNull((Object)showdownActionRequest);
            this.setActionResponses(showdownActionRequest.iterate(this.getActivePokemon(), (Function3)new Function3<ActiveBattlePokemon, ShowdownMoveset, Boolean, ShowdownActionResponse>((Object)this.battleAI){

                public final ShowdownActionResponse invoke(ActiveBattlePokemon p0, ShowdownMoveset p1, boolean p2) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((BattleAI)this.receiver).choose(p0, p1, p2);
                }
            }));
        }
        catch (IllegalActionChoiceException exception) {
            Cobblemon.LOGGER.error("AI was unable to choose a move, we're going to need to pass!");
            exception.printStackTrace();
            ShowdownActionRequest showdownActionRequest = this.getRequest();
            Intrinsics.checkNotNull((Object)showdownActionRequest);
            this.setActionResponses(showdownActionRequest.iterate(this.getActivePokemon(), AIBattleActor::onChoiceRequested$lambda$0));
        }
    }

    private static final PassActionResponse onChoiceRequested$lambda$0(ActiveBattlePokemon activeBattlePokemon, ShowdownMoveset showdownMoveset, boolean bl2) {
        Intrinsics.checkNotNullParameter((Object)activeBattlePokemon, (String)"<unused var>");
        return PassActionResponse.INSTANCE;
    }
}

