/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.dialogue;

import com.cobblemon.mod.common.api.dialogue.ActiveDialogue;
import com.cobblemon.mod.common.api.dialogue.Dialogue;
import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.cobblemon.mod.common.net.messages.client.dialogue.DialogueClosedPacket;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\rJ\u0015\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012R#\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b0\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/cobblemon/mod/common/api/dialogue/DialogueManager;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "playerEntity", "Lcom/cobblemon/mod/common/api/dialogue/Dialogue;", "dialogue", "Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;", "startDialogue", "(Lnet/minecraft/class_3222;Lcom/cobblemon/mod/common/api/dialogue/Dialogue;)Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;", "Lcom/cobblemon/mod/common/entity/npc/NPCEntity;", "npcEntity", "(Lnet/minecraft/class_3222;Lcom/cobblemon/mod/common/entity/npc/NPCEntity;Lcom/cobblemon/mod/common/api/dialogue/Dialogue;)Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;", "activeDialogue", "", "(Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;)V", "stopDialogue", "(Lnet/minecraft/class_3222;)V", "", "Ljava/util/UUID;", "activeDialogues", "Ljava/util/Map;", "getActiveDialogues", "()Ljava/util/Map;", "common"})
public final class DialogueManager {
    @NotNull
    public static final DialogueManager INSTANCE = new DialogueManager();
    @NotNull
    private static final Map<UUID, ActiveDialogue> activeDialogues = new LinkedHashMap();

    private DialogueManager() {
    }

    @NotNull
    public final Map<UUID, ActiveDialogue> getActiveDialogues() {
        return activeDialogues;
    }

    @NotNull
    public final ActiveDialogue startDialogue(@NotNull class_3222 playerEntity, @NotNull Dialogue dialogue) {
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        Intrinsics.checkNotNullParameter((Object)dialogue, (String)"dialogue");
        ActiveDialogue activeDialogue = new ActiveDialogue(playerEntity, dialogue);
        this.startDialogue(activeDialogue);
        return activeDialogue;
    }

    @NotNull
    public final ActiveDialogue startDialogue(@NotNull class_3222 playerEntity, @NotNull NPCEntity npcEntity, @NotNull Dialogue dialogue) {
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        Intrinsics.checkNotNullParameter((Object)npcEntity, (String)"npcEntity");
        Intrinsics.checkNotNullParameter((Object)dialogue, (String)"dialogue");
        ActiveDialogue activeDialogue = new ActiveDialogue(playerEntity, dialogue);
        MoLangExtensionsKt.withNPCValue(activeDialogue.getRuntime(), "npc", npcEntity);
        activeDialogue.setNpc(npcEntity);
        this.startDialogue(activeDialogue);
        return activeDialogue;
    }

    public final void startDialogue(@NotNull ActiveDialogue activeDialogue) {
        Intrinsics.checkNotNullParameter((Object)activeDialogue, (String)"activeDialogue");
        activeDialogue.initialize();
        if (!activeDialogue.getCompletion().isDone()) {
            activeDialogues.put(activeDialogue.getPlayerEntity().method_5667(), activeDialogue);
        }
    }

    public final void stopDialogue(@NotNull class_3222 playerEntity) {
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        ActiveDialogue activeDialogue = PlayerExtensionsKt.getActiveDialogue(playerEntity);
        if (activeDialogue == null) {
            return;
        }
        ActiveDialogue activeDialogue2 = activeDialogue;
        new DialogueClosedPacket(activeDialogue2.getDialogueId()).sendToPlayer(playerEntity);
        activeDialogues.remove(activeDialogue2.getDialogueId());
    }
}

