/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.drop;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.drop.DropEntry;
import com.cobblemon.mod.common.api.drop.ItemDropMethod;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9336;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\r\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0014R\"\u0010\u0016\u001a\u00020\u00158\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\u00020\u001c8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R$\u0010$\u001a\u0004\u0018\u00010#8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\"\u0010*\u001a\u00020\u001c8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010\u001e\u001a\u0004\b+\u0010 \"\u0004\b,\u0010\"R\u001c\u0010.\u001a\u0004\u0018\u00010-8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R*\u00104\u001a\n 3*\u0004\u0018\u000102028\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001c\u0010;\u001a\u0004\u0018\u00010:8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>\u00a8\u0006?"}, d2={"Lcom/cobblemon/mod/common/api/drop/ItemDropEntry;", "Lcom/cobblemon/mod/common/api/drop/DropEntry;", "<init>", "()V", "Lnet/minecraft/class_1309;", "entity", "Lnet/minecraft/class_3218;", "world", "Lnet/minecraft/class_243;", "pos", "Lnet/minecraft/class_3222;", "player", "", "drop", "(Lnet/minecraft/class_1309;Lnet/minecraft/class_3218;Lnet/minecraft/class_243;Lnet/minecraft/class_3222;)V", "Lnet/minecraft/class_9129;", "buffer", "encode", "(Lnet/minecraft/class_9129;)V", "decode", "(Lnet/minecraft/class_9129;)Lcom/cobblemon/mod/common/api/drop/ItemDropEntry;", "", "percentage", "F", "getPercentage", "()F", "setPercentage", "(F)V", "", "quantity", "I", "getQuantity", "()I", "setQuantity", "(I)V", "Lkotlin/ranges/IntRange;", "quantityRange", "Lkotlin/ranges/IntRange;", "getQuantityRange", "()Lkotlin/ranges/IntRange;", "setQuantityRange", "(Lkotlin/ranges/IntRange;)V", "maxSelectableTimes", "getMaxSelectableTimes", "setMaxSelectableTimes", "Lcom/cobblemon/mod/common/api/drop/ItemDropMethod;", "dropMethod", "Lcom/cobblemon/mod/common/api/drop/ItemDropMethod;", "getDropMethod", "()Lcom/cobblemon/mod/common/api/drop/ItemDropMethod;", "Lnet/minecraft/class_2960;", "kotlin.jvm.PlatformType", "item", "Lnet/minecraft/class_2960;", "getItem", "()Lnet/minecraft/class_2960;", "setItem", "(Lnet/minecraft/class_2960;)V", "Lnet/minecraft/class_9323;", "components", "Lnet/minecraft/class_9323;", "getComponents", "()Lnet/minecraft/class_9323;", "common"})
@SourceDebugExtension(value={"SMAP\nItemDropEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemDropEntry.kt\ncom/cobblemon/mod/common/api/drop/ItemDropEntry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1863#2,2:96\n*S KotlinDebug\n*F\n+ 1 ItemDropEntry.kt\ncom/cobblemon/mod/common/api/drop/ItemDropEntry\n*L\n57#1:96,2\n*E\n"})
public class ItemDropEntry
implements DropEntry {
    private float percentage = 100.0f;
    private int quantity = 1;
    @Nullable
    private IntRange quantityRange;
    private int maxSelectableTimes = 1;
    @Nullable
    private final ItemDropMethod dropMethod;
    private class_2960 item = class_2960.method_60654((String)"minecraft:fish");
    @Nullable
    private final class_9323 components;

    @Override
    public float getPercentage() {
        return this.percentage;
    }

    public void setPercentage(float f) {
        this.percentage = f;
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int n) {
        this.quantity = n;
    }

    @Nullable
    public IntRange getQuantityRange() {
        return this.quantityRange;
    }

    public void setQuantityRange(@Nullable IntRange intRange) {
        this.quantityRange = intRange;
    }

    @Override
    public int getMaxSelectableTimes() {
        return this.maxSelectableTimes;
    }

    public void setMaxSelectableTimes(int n) {
        this.maxSelectableTimes = n;
    }

    @Nullable
    public ItemDropMethod getDropMethod() {
        return this.dropMethod;
    }

    public class_2960 getItem() {
        return this.item;
    }

    public void setItem(class_2960 class_29602) {
        this.item = class_29602;
    }

    @Nullable
    public class_9323 getComponents() {
        return this.components;
    }

    @Override
    public void drop(@Nullable class_1309 entity, @NotNull class_3218 world, @NotNull class_243 pos, @Nullable class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        class_1792 class_17922 = (class_1792)world.method_30349().method_30530(class_7924.field_41197).method_10223(this.getItem());
        if (class_17922 == null) {
            Cobblemon.LOGGER.error("Unable to load drop item: " + this.getItem());
            return;
        }
        class_1792 item = class_17922;
        IntRange intRange = this.getQuantityRange();
        class_1799 stack = new class_1799((class_1935)item, intRange != null ? RangesKt.random((IntRange)intRange, (Random)((Random)Random.Default)) : this.getQuantity());
        boolean inLava = Intrinsics.areEqual((Object)world.method_8320(Vec3ExtensionsKt.toBlockPos(pos)).method_26204(), (Object)class_2246.field_10164);
        ItemDropMethod itemDropMethod = this.getDropMethod();
        if (itemDropMethod == null) {
            itemDropMethod = Cobblemon.INSTANCE.getConfig().getDefaultDropItemMethod();
        }
        ItemDropMethod it = itemDropMethod;
        boolean bl2 = false;
        ItemDropMethod dropMethod = inLava ? ItemDropMethod.TO_INVENTORY : it;
        class_9326.class_9327 builder = class_9326.method_57841();
        class_9323 class_93232 = this.getComponents();
        if (class_93232 != null) {
            Iterable $this$forEach$iv = (Iterable)class_93232;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_9336 it2 = (class_9336)element$iv;
                boolean bl3 = false;
                builder.method_57855(it2);
            }
        }
        stack.method_59692(builder.method_57852());
        if (dropMethod == ItemDropMethod.ON_PLAYER && player != null) {
            world.method_8649((class_1297)new class_1542(player.method_37908(), player.method_23317(), player.method_23318(), player.method_23321(), stack));
        } else if (dropMethod == ItemDropMethod.TO_INVENTORY && player != null && !stack.method_7960()) {
            class_2561 name = stack.method_7964();
            int count = stack.method_7947();
            boolean succeeded = player.method_7270(stack);
            if (Cobblemon.INSTANCE.getConfig().getAnnounceDropItems()) {
                class_5250 class_52502;
                if (succeeded) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = count;
                    class_5250 class_52503 = name.method_27661();
                    Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"copy(...)");
                    objectArray[1] = TextKt.green(class_52503);
                    class_52502 = LocalizationUtilsKt.lang("drop.item.inventory", objectArray);
                } else {
                    Object[] objectArray = new Object[]{name};
                    class_5250 class_52504 = LocalizationUtilsKt.lang("drop.item.full", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"lang(...)");
                    class_52502 = TextKt.red(class_52504);
                }
                player.method_43496((class_2561)class_52502);
            }
        } else if (dropMethod == ItemDropMethod.ON_ENTITY && entity != null) {
            world.method_8649((class_1297)new class_1542(entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321(), stack));
        } else {
            world.method_8649((class_1297)new class_1542((class_1937)world, pos.field_1352, pos.field_1351, pos.field_1350, stack));
        }
    }

    public final void encode(@NotNull class_9129 buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.method_52941(this.getPercentage());
        buffer.method_10804(this.getQuantity());
        buffer.method_10812(this.getItem());
        buffer.method_43826((Object)this.getQuantityRange(), (arg_0, arg_1) -> ItemDropEntry.encode$lambda$3((arg_0, arg_1) -> ItemDropEntry.encode$lambda$2(buffer, arg_0, arg_1), arg_0, arg_1));
    }

    @NotNull
    public final ItemDropEntry decode(@NotNull class_9129 buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.setPercentage(buffer.readFloat());
        this.setQuantity(buffer.method_10816());
        this.setItem(buffer.method_10810());
        this.setQuantityRange((IntRange)buffer.method_43827(arg_0 -> ItemDropEntry.decode$lambda$5(arg_0 -> ItemDropEntry.decode$lambda$4(buffer, arg_0), arg_0)));
        return this;
    }

    @Override
    public boolean canDrop(@Nullable Pokemon pokemon) {
        return DropEntry.DefaultImpls.canDrop(this, pokemon);
    }

    private static final Unit encode$lambda$2(class_9129 $buffer, class_2540 class_25402, IntRange it) {
        Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
        $buffer.method_10804(it.getFirst());
        $buffer.method_10804(it.getLast());
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$3(Function2 $tmp0, Object object, IntRange object2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(object, (Object)object2);
    }

    private static final IntRange decode$lambda$4(class_9129 $buffer, class_2540 it) {
        Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
        return new IntRange($buffer.method_10816(), $buffer.method_10816());
    }

    private static final IntRange decode$lambda$5(Function1 $tmp0, Object object) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (IntRange)$tmp0.invoke(object);
    }
}

