/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.events.pokemon;

import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010!\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ/\u0010\u000f\u001a\u00020\t2 \u0010\u000e\u001a\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0017\u001a\u0004\b\u001e\u0010\u0019R\"\u0010\u0015\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u001f\u001a\u0004\b\u0015\u0010 \"\u0004\b!\u0010\"R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R4\u0010&\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\f0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010%\u00a8\u0006'"}, d2={"Lcom/cobblemon/mod/common/api/events/pokemon/ShinyChanceCalculationEvent;", "", "", "baseChance", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "<init>", "(FLcom/cobblemon/mod/common/pokemon/Pokemon;)V", "modifier", "", "addModifier", "(F)V", "Lkotlin/Function3;", "Lnet/minecraft/class_3222;", "function", "addModificationFunction", "(Lkotlin/jvm/functions/Function3;)V", "player", "calculate", "(Lnet/minecraft/class_3222;)F", "", "isShiny", "(Lnet/minecraft/class_3222;)Z", "F", "getBaseChance", "()F", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getPokemon", "()Lcom/cobblemon/mod/common/pokemon/Pokemon;", "chance", "getChance", "Z", "()Z", "setShiny", "(Z)V", "", "modifiers", "Ljava/util/List;", "modificationFunctions", "common"})
public final class ShinyChanceCalculationEvent {
    private final float baseChance;
    @NotNull
    private final Pokemon pokemon;
    private final float chance;
    private boolean isShiny;
    @NotNull
    private final List<Float> modifiers;
    @NotNull
    private final List<Function3<Float, class_3222, Pokemon, Float>> modificationFunctions;

    public ShinyChanceCalculationEvent(float baseChance, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        this.baseChance = baseChance;
        this.pokemon = pokemon;
        this.chance = this.baseChance;
        this.modifiers = new ArrayList();
        this.modificationFunctions = new ArrayList();
    }

    public final float getBaseChance() {
        return this.baseChance;
    }

    @NotNull
    public final Pokemon getPokemon() {
        return this.pokemon;
    }

    public final float getChance() {
        return this.chance;
    }

    public final boolean isShiny() {
        return this.isShiny;
    }

    public final void setShiny(boolean bl2) {
        this.isShiny = bl2;
    }

    public final void addModifier(float modifier) {
        this.modifiers.add(Float.valueOf(modifier));
    }

    public final void addModificationFunction(@NotNull Function3<? super Float, ? super class_3222, ? super Pokemon, Float> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.modificationFunctions.add(function);
    }

    public final float calculate(@Nullable class_3222 player) {
        float result = this.baseChance;
        Iterator<Float> iterator = this.modifiers.iterator();
        while (iterator.hasNext()) {
            float f = ((Number)iterator.next()).floatValue();
            result += f;
        }
        for (Function3 function3 : this.modificationFunctions) {
            result = ((Number)function3.invoke((Object)Float.valueOf(result), (Object)player, (Object)this.pokemon)).floatValue();
        }
        return result;
    }

    public final boolean isShiny(@Nullable class_3222 player) {
        return this.calculate(player) >= this.chance || this.isShiny;
    }
}

