/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.pasture;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.pasture.PastureLink;
import com.cobblemon.mod.common.net.messages.client.pasture.ClosePasturePacket;
import com.cobblemon.mod.common.util.MapExtensionsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016R#\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/cobblemon/mod/common/api/pasture/PastureLinkManager;", "", "<init>", "()V", "Ljava/util/UUID;", "playerId", "Lcom/cobblemon/mod/common/api/pasture/PastureLink;", "getLinkByPlayerId", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/api/pasture/PastureLink;", "link", "", "createLink", "(Ljava/util/UUID;Lcom/cobblemon/mod/common/api/pasture/PastureLink;)V", "Lnet/minecraft/class_3222;", "player", "getLinkByPlayer", "(Lnet/minecraft/class_3222;)Lcom/cobblemon/mod/common/api/pasture/PastureLink;", "Lnet/minecraft/class_3218;", "world", "Lnet/minecraft/class_2338;", "pos", "removeAt", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)V", "", "links", "Ljava/util/Map;", "getLinks", "()Ljava/util/Map;", "common"})
public final class PastureLinkManager {
    @NotNull
    public static final PastureLinkManager INSTANCE = new PastureLinkManager();
    @NotNull
    private static final Map<UUID, PastureLink> links = new LinkedHashMap();

    private PastureLinkManager() {
    }

    @NotNull
    public final Map<UUID, PastureLink> getLinks() {
        return links;
    }

    @Nullable
    public final PastureLink getLinkByPlayerId(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return links.get(playerId);
    }

    public final void createLink(@NotNull UUID playerId, @NotNull PastureLink link) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        links.put(playerId, link);
    }

    @Nullable
    public final PastureLink getLinkByPlayer(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PastureLink link = this.getLinkByPlayerId(uUID);
        if (!(link == null || player.method_37908().method_40134().method_40226(link.getDimension()) && link.getPos().method_19769((class_2374)player.method_19538(), 10.0))) {
            links.remove(player.method_5667());
            return null;
        }
        return link;
    }

    public final void removeAt(@NotNull class_3218 world, @NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        MapExtensionsKt.removeIf(links, arg_0 -> PastureLinkManager.removeAt$lambda$0(world, pos, arg_0));
    }

    private static final boolean removeAt$lambda$0(class_3218 $world, class_2338 $pos, Map.Entry entry) {
        boolean shouldRemove;
        block0: {
            Intrinsics.checkNotNullParameter((Object)$world, (String)"$world");
            Intrinsics.checkNotNullParameter((Object)$pos, (String)"$pos");
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            UUID uuid = (UUID)entry.getKey();
            PastureLink pastureLink = (PastureLink)entry.getValue();
            shouldRemove = $world.method_40134().method_40226(pastureLink.getDimension()) && Intrinsics.areEqual((Object)pastureLink.getPos(), (Object)$pos);
            class_3222 class_32222 = PlayerExtensionsKt.getPlayer(uuid);
            if (class_32222 == null) break block0;
            CobblemonNetwork.INSTANCE.sendPacket(class_32222, new ClosePasturePacket());
        }
        return shouldRemove;
    }
}

