/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.pokeball.catching.modifiers;

import com.cobblemon.mod.common.api.pokeball.catching.CatchRateModifier;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.pokemon.Pokemon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1309;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B:\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0004\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\b\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\b\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010 R2\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u00048\u0006\u00a2\u0006\f\n\u0004\b\n\u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010$\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lcom/cobblemon/mod/common/api/pokeball/catching/modifiers/BaseStatModifier;", "Lcom/cobblemon/mod/common/api/pokeball/catching/CatchRateModifier;", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "stat", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "value", "", "comparator", "", "multiplier", "<init>", "(Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;Lkotlin/jvm/functions/Function1;F)V", "isGuaranteed", "()Z", "Lnet/minecraft/class_1309;", "thrower", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "(Lnet/minecraft/class_1309;Lcom/cobblemon/mod/common/pokemon/Pokemon;)F", "Lcom/cobblemon/mod/common/api/pokeball/catching/CatchRateModifier$Behavior;", "behavior", "(Lnet/minecraft/class_1309;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lcom/cobblemon/mod/common/api/pokeball/catching/CatchRateModifier$Behavior;", "isValid", "(Lnet/minecraft/class_1309;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "currentCatchRate", "modifyCatchRate", "(FLnet/minecraft/class_1309;Lcom/cobblemon/mod/common/pokemon/Pokemon;)F", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "getStat", "()Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "Lkotlin/jvm/functions/Function1;", "getComparator", "()Lkotlin/jvm/functions/Function1;", "F", "getMultiplier", "()F", "common"})
public final class BaseStatModifier
implements CatchRateModifier {
    @NotNull
    private final Stat stat;
    @NotNull
    private final Function1<Integer, Boolean> comparator;
    private final float multiplier;

    public BaseStatModifier(@NotNull Stat stat, @NotNull Function1<? super Integer, Boolean> comparator, float multiplier) {
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        this.stat = stat;
        this.comparator = comparator;
        this.multiplier = multiplier;
        if (this.stat.getType() != Stat.Type.PERMANENT) {
            throw new IllegalArgumentException(this.stat.getIdentifier() + " is not of type PERMANENT");
        }
    }

    @NotNull
    public final Stat getStat() {
        return this.stat;
    }

    @NotNull
    public final Function1<Integer, Boolean> getComparator() {
        return this.comparator;
    }

    public final float getMultiplier() {
        return this.multiplier;
    }

    @Override
    public boolean isGuaranteed() {
        return false;
    }

    @Override
    public float value(@NotNull class_1309 thrower, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)thrower, (String)"thrower");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        return this.multiplier;
    }

    @Override
    @NotNull
    public CatchRateModifier.Behavior behavior(@NotNull class_1309 thrower, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)thrower, (String)"thrower");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        return CatchRateModifier.Behavior.MULTIPLY;
    }

    @Override
    public boolean isValid(@NotNull class_1309 thrower, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)thrower, (String)"thrower");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Integer n = pokemon.getForm().getBaseStats().get(this.stat);
        if (n == null) {
            return false;
        }
        int valStat = n;
        return (Boolean)this.comparator.invoke((Object)valStat);
    }

    @Override
    public float modifyCatchRate(float currentCatchRate, @NotNull class_1309 thrower, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)thrower, (String)"thrower");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        return ((Number)this.behavior(thrower, pokemon).getMutator().invoke((Object)Float.valueOf(currentCatchRate), (Object)Float.valueOf(this.value(thrower, pokemon)))).floatValue();
    }
}

