/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.pokemon.feature;

import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeatureProvider;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeatures;
import com.cobblemon.mod.common.api.pokemon.feature.SynchronizedSpeciesFeature;
import com.cobblemon.mod.common.api.properties.CustomPokemonProperty;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2487;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0017\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010#\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010%\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b%\u0010&R\u001a\u0010\u0004\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010'\u001a\u0004\b(\u0010 R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lcom/cobblemon/mod/common/api/pokemon/feature/FlagSpeciesFeature;", "Lcom/cobblemon/mod/common/api/pokemon/feature/SynchronizedSpeciesFeature;", "Lcom/cobblemon/mod/common/api/properties/CustomPokemonProperty;", "", "name", "<init>", "(Ljava/lang/String;)V", "", "enabled", "(Ljava/lang/String;Z)V", "Lnet/minecraft/class_2487;", "pokemonNBT", "saveToNBT", "(Lnet/minecraft/class_2487;)Lnet/minecraft/class_2487;", "Lcom/cobblemon/mod/common/api/pokemon/feature/SpeciesFeature;", "loadFromNBT", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/api/pokemon/feature/SpeciesFeature;", "Lcom/google/gson/JsonObject;", "pokemonJSON", "saveToJSON", "(Lcom/google/gson/JsonObject;)Lcom/google/gson/JsonObject;", "loadFromJSON", "(Lcom/google/gson/JsonObject;)Lcom/cobblemon/mod/common/api/pokemon/feature/SpeciesFeature;", "Lnet/minecraft/class_9129;", "buffer", "toClient", "", "saveToBuffer", "(Lnet/minecraft/class_9129;Z)V", "loadFromBuffer", "(Lnet/minecraft/class_9129;)V", "asString", "()Ljava/lang/String;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "apply", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "matches", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Ljava/lang/String;", "getName", "Z", "getEnabled", "()Z", "setEnabled", "(Z)V", "common"})
public class FlagSpeciesFeature
implements SynchronizedSpeciesFeature,
CustomPokemonProperty {
    @NotNull
    private final String name;
    private boolean enabled;

    public FlagSpeciesFeature(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public FlagSpeciesFeature(@NotNull String name, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name);
        this.enabled = enabled;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl2) {
        this.enabled = bl2;
    }

    @Override
    @NotNull
    public class_2487 saveToNBT(@NotNull class_2487 pokemonNBT) {
        Intrinsics.checkNotNullParameter((Object)pokemonNBT, (String)"pokemonNBT");
        pokemonNBT.method_10556(this.getName(), this.enabled);
        return pokemonNBT;
    }

    @Override
    @NotNull
    public SpeciesFeature loadFromNBT(@NotNull class_2487 pokemonNBT) {
        Intrinsics.checkNotNullParameter((Object)pokemonNBT, (String)"pokemonNBT");
        this.enabled = pokemonNBT.method_10545(this.getName()) ? pokemonNBT.method_10577(this.getName()) : this.enabled;
        return this;
    }

    @Override
    @NotNull
    public JsonObject saveToJSON(@NotNull JsonObject pokemonJSON) {
        Intrinsics.checkNotNullParameter((Object)pokemonJSON, (String)"pokemonJSON");
        pokemonJSON.addProperty(this.getName(), Boolean.valueOf(this.enabled));
        return pokemonJSON;
    }

    @Override
    @NotNull
    public SpeciesFeature loadFromJSON(@NotNull JsonObject pokemonJSON) {
        Boolean isEnabled;
        Intrinsics.checkNotNullParameter((Object)pokemonJSON, (String)"pokemonJSON");
        JsonElement jsonElement = pokemonJSON.get(this.getName());
        Boolean bl2 = isEnabled = jsonElement != null ? Boolean.valueOf(jsonElement.getAsBoolean()) : null;
        this.enabled = bl2 != null ? bl2 : this.enabled;
        return this;
    }

    @Override
    public void saveToBuffer(@NotNull class_9129 buffer, boolean toClient) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.method_52964(this.enabled);
    }

    @Override
    public void loadFromBuffer(@NotNull class_9129 buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.enabled = buffer.readBoolean();
    }

    @Override
    @NotNull
    public String asString() {
        return this.getName() + "=" + this.enabled;
    }

    @Override
    public void apply(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        SpeciesFeatureProvider<? extends SpeciesFeature> speciesFeatureProvider = SpeciesFeatures.INSTANCE.getFeature(this.getName());
        if (speciesFeatureProvider == null) {
            return;
        }
        SpeciesFeatureProvider<? extends SpeciesFeature> featureProvider = speciesFeatureProvider;
        if (SpeciesFeatures.INSTANCE.getFeaturesFor(pokemon.getSpecies()).contains(featureProvider)) {
            FlagSpeciesFeature existingFeature = (FlagSpeciesFeature)pokemon.getFeature(this.getName());
            if (existingFeature != null) {
                existingFeature.enabled = this.enabled;
            } else {
                pokemon.getFeatures().add(new FlagSpeciesFeature(this.getName(), this.enabled));
            }
            pokemon.updateAspects();
        }
    }

    @Override
    public boolean matches(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        FlagSpeciesFeature flagSpeciesFeature = (FlagSpeciesFeature)pokemon.getFeature(this.getName());
        return flagSpeciesFeature != null ? flagSpeciesFeature.enabled == this.enabled : false;
    }

    @Override
    public void apply(@NotNull PokemonEntity pokemonEntity) {
        CustomPokemonProperty.DefaultImpls.apply(this, pokemonEntity);
    }

    @Override
    public boolean matches(@NotNull PokemonEntity pokemonEntity) {
        return CustomPokemonProperty.DefaultImpls.matches(this, pokemonEntity);
    }
}

