/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.pokemon.feature;

import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeatureProvider;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeatures;
import com.cobblemon.mod.common.api.pokemon.feature.SynchronizedSpeciesFeature;
import com.cobblemon.mod.common.api.properties.CustomPokemonProperty;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.BufferUtilsKt;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_2487;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\"\u001a\u00020\u00192\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020\u00172\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b$\u0010%R\u001a\u0010\u0004\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010&\u001a\u0004\b'\u0010\u001fR\"\u0010\u0005\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010&\u001a\u0004\b(\u0010\u001f\"\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lcom/cobblemon/mod/common/api/pokemon/feature/StringSpeciesFeature;", "Lcom/cobblemon/mod/common/api/pokemon/feature/SynchronizedSpeciesFeature;", "Lcom/cobblemon/mod/common/api/properties/CustomPokemonProperty;", "", "name", "value", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "Lnet/minecraft/class_2487;", "pokemonNBT", "saveToNBT", "(Lnet/minecraft/class_2487;)Lnet/minecraft/class_2487;", "Lcom/cobblemon/mod/common/api/pokemon/feature/SpeciesFeature;", "loadFromNBT", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/api/pokemon/feature/SpeciesFeature;", "Lcom/google/gson/JsonObject;", "pokemonJSON", "saveToJSON", "(Lcom/google/gson/JsonObject;)Lcom/google/gson/JsonObject;", "loadFromJSON", "(Lcom/google/gson/JsonObject;)Lcom/cobblemon/mod/common/api/pokemon/feature/SpeciesFeature;", "Lnet/minecraft/class_9129;", "buffer", "", "toClient", "", "saveToBuffer", "(Lnet/minecraft/class_9129;Z)V", "loadFromBuffer", "(Lnet/minecraft/class_9129;)V", "asString", "()Ljava/lang/String;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "apply", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "matches", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Ljava/lang/String;", "getName", "getValue", "setValue", "(Ljava/lang/String;)V", "common"})
@SourceDebugExtension(value={"SMAP\nStringSpeciesFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringSpeciesFeature.kt\ncom/cobblemon/mod/common/api/pokemon/feature/StringSpeciesFeature\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class StringSpeciesFeature
implements SynchronizedSpeciesFeature,
CustomPokemonProperty {
    @NotNull
    private final String name;
    @NotNull
    private String value;

    public StringSpeciesFeature(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.name = name;
        this.value = value;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    public final void setValue(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.value = string;
    }

    @Override
    @NotNull
    public class_2487 saveToNBT(@NotNull class_2487 pokemonNBT) {
        Intrinsics.checkNotNullParameter((Object)pokemonNBT, (String)"pokemonNBT");
        pokemonNBT.method_10582(this.getName(), this.value);
        return pokemonNBT;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SpeciesFeature loadFromNBT(@NotNull class_2487 pokemonNBT) {
        String string;
        block4: {
            block3: {
                void it;
                String string2;
                Intrinsics.checkNotNullParameter((Object)pokemonNBT, (String)"pokemonNBT");
                StringSpeciesFeature stringSpeciesFeature = this;
                string = pokemonNBT.method_10558(this.getName());
                if (string == null) break block3;
                String string3 = string2 = string;
                StringSpeciesFeature stringSpeciesFeature2 = stringSpeciesFeature;
                boolean bl2 = false;
                boolean bl3 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
                stringSpeciesFeature = stringSpeciesFeature2;
                string = bl3 ? string2 : null;
                if (string == null) break block3;
                String string4 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                string = string4;
                if (string4 != null) break block4;
            }
            return this;
        }
        stringSpeciesFeature.value = string;
        return this;
    }

    @Override
    @NotNull
    public JsonObject saveToJSON(@NotNull JsonObject pokemonJSON) {
        Intrinsics.checkNotNullParameter((Object)pokemonJSON, (String)"pokemonJSON");
        pokemonJSON.addProperty(this.getName(), this.value);
        return pokemonJSON;
    }

    @Override
    @NotNull
    public SpeciesFeature loadFromJSON(@NotNull JsonObject pokemonJSON) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)pokemonJSON, (String)"pokemonJSON");
                object = pokemonJSON.get(this.getName());
                if (object == null || (object = object.getAsString()) == null) break block2;
                String string = ((String)object).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                object = string;
                if (string != null) break block3;
            }
            return this;
        }
        this.value = object;
        return this;
    }

    @Override
    public void saveToBuffer(@NotNull class_9129 buffer, boolean toClient) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        BufferUtilsKt.writeString((ByteBuf)buffer, this.value);
    }

    @Override
    public void loadFromBuffer(@NotNull class_9129 buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.value = BufferUtilsKt.readString((ByteBuf)buffer);
    }

    @Override
    @NotNull
    public String asString() {
        return this.getName() + "=" + this.value;
    }

    @Override
    public void apply(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        SpeciesFeatureProvider<? extends SpeciesFeature> speciesFeatureProvider = SpeciesFeatures.INSTANCE.getFeature(this.getName());
        if (speciesFeatureProvider == null) {
            return;
        }
        SpeciesFeatureProvider<? extends SpeciesFeature> featureProvider = speciesFeatureProvider;
        if (SpeciesFeatures.INSTANCE.getFeaturesFor(pokemon.getSpecies()).contains(featureProvider)) {
            StringSpeciesFeature existingFeature = (StringSpeciesFeature)pokemon.getFeature(this.getName());
            if (existingFeature != null) {
                existingFeature.value = this.value;
            } else {
                pokemon.getFeatures().add(new StringSpeciesFeature(this.getName(), this.value));
            }
            pokemon.updateAspects();
        }
    }

    @Override
    public boolean matches(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        StringSpeciesFeature stringSpeciesFeature = (StringSpeciesFeature)pokemon.getFeature(this.getName());
        return Intrinsics.areEqual((Object)(stringSpeciesFeature != null ? stringSpeciesFeature.value : null), (Object)this.value);
    }

    @Override
    public void apply(@NotNull PokemonEntity pokemonEntity) {
        CustomPokemonProperty.DefaultImpls.apply(this, pokemonEntity);
    }

    @Override
    public boolean matches(@NotNull PokemonEntity pokemonEntity) {
        return CustomPokemonProperty.DefaultImpls.matches(this, pokemonEntity);
    }
}

