/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.entity.Despawner;
import com.cobblemon.mod.common.api.spawning.CobblemonWorldSpawnerManager;
import com.cobblemon.mod.common.api.spawning.SpawnDetailPresets;
import com.cobblemon.mod.common.api.spawning.SpawnerManager;
import com.cobblemon.mod.common.api.spawning.condition.AreaSpawningCondition;
import com.cobblemon.mod.common.api.spawning.condition.BasicSpawningCondition;
import com.cobblemon.mod.common.api.spawning.condition.FishingSpawningCondition;
import com.cobblemon.mod.common.api.spawning.condition.GroundedSpawningCondition;
import com.cobblemon.mod.common.api.spawning.condition.SeafloorSpawningCondition;
import com.cobblemon.mod.common.api.spawning.condition.SpawningCondition;
import com.cobblemon.mod.common.api.spawning.condition.SubmergedSpawningCondition;
import com.cobblemon.mod.common.api.spawning.condition.SurfaceSpawningCondition;
import com.cobblemon.mod.common.api.spawning.context.FishingSpawningContext;
import com.cobblemon.mod.common.api.spawning.context.GroundedSpawningContext;
import com.cobblemon.mod.common.api.spawning.context.LavafloorSpawningContext;
import com.cobblemon.mod.common.api.spawning.context.SeafloorSpawningContext;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.context.SubmergedSpawningContext;
import com.cobblemon.mod.common.api.spawning.context.SurfaceSpawningContext;
import com.cobblemon.mod.common.api.spawning.context.calculators.GroundedSpawningContextCalculator;
import com.cobblemon.mod.common.api.spawning.context.calculators.LavafloorSpawningContextCalculator;
import com.cobblemon.mod.common.api.spawning.context.calculators.SeafloorSpawningContextCalculator;
import com.cobblemon.mod.common.api.spawning.context.calculators.SpawningContextCalculator;
import com.cobblemon.mod.common.api.spawning.context.calculators.SubmergedSpawningContextCalculator;
import com.cobblemon.mod.common.api.spawning.context.calculators.SurfaceSpawningContextCalculator;
import com.cobblemon.mod.common.api.spawning.detail.NPCSpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.fishing.FishingSpawner;
import com.cobblemon.mod.common.api.spawning.preset.BasicSpawnDetailPreset;
import com.cobblemon.mod.common.api.spawning.preset.BestSpawnerConfig;
import com.cobblemon.mod.common.api.spawning.preset.PokemonSpawnDetailPreset;
import com.cobblemon.mod.common.entity.pokemon.CobblemonAgingDespawner;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\u00020\u001c8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/cobblemon/mod/common/api/spawning/BestSpawner;", "", "<init>", "()V", "", "loadConfig", "onServerStarted", "Lcom/cobblemon/mod/common/api/spawning/preset/BestSpawnerConfig;", "config", "Lcom/cobblemon/mod/common/api/spawning/preset/BestSpawnerConfig;", "getConfig", "()Lcom/cobblemon/mod/common/api/spawning/preset/BestSpawnerConfig;", "setConfig", "(Lcom/cobblemon/mod/common/api/spawning/preset/BestSpawnerConfig;)V", "", "Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;", "spawnerManagers", "Ljava/util/List;", "getSpawnerManagers", "()Ljava/util/List;", "Lcom/cobblemon/mod/common/api/entity/Despawner;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "defaultPokemonDespawner", "Lcom/cobblemon/mod/common/api/entity/Despawner;", "getDefaultPokemonDespawner", "()Lcom/cobblemon/mod/common/api/entity/Despawner;", "setDefaultPokemonDespawner", "(Lcom/cobblemon/mod/common/api/entity/Despawner;)V", "Lcom/cobblemon/mod/common/api/spawning/fishing/FishingSpawner;", "fishingSpawner", "Lcom/cobblemon/mod/common/api/spawning/fishing/FishingSpawner;", "getFishingSpawner", "()Lcom/cobblemon/mod/common/api/spawning/fishing/FishingSpawner;", "setFishingSpawner", "(Lcom/cobblemon/mod/common/api/spawning/fishing/FishingSpawner;)V", "common"})
@SourceDebugExtension(value={"SMAP\nBestSpawner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BestSpawner.kt\ncom/cobblemon/mod/common/api/spawning/BestSpawner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1863#2,2:127\n*S KotlinDebug\n*F\n+ 1 BestSpawner.kt\ncom/cobblemon/mod/common/api/spawning/BestSpawner\n*L\n123#1:127,2\n*E\n"})
public final class BestSpawner {
    @NotNull
    public static final BestSpawner INSTANCE = new BestSpawner();
    @NotNull
    private static BestSpawnerConfig config = new BestSpawnerConfig();
    @NotNull
    private static final List<SpawnerManager> spawnerManagers;
    @NotNull
    private static Despawner<PokemonEntity> defaultPokemonDespawner;
    public static FishingSpawner fishingSpawner;

    private BestSpawner() {
    }

    @NotNull
    public final BestSpawnerConfig getConfig() {
        return config;
    }

    public final void setConfig(@NotNull BestSpawnerConfig bestSpawnerConfig) {
        Intrinsics.checkNotNullParameter((Object)bestSpawnerConfig, (String)"<set-?>");
        config = bestSpawnerConfig;
    }

    @NotNull
    public final List<SpawnerManager> getSpawnerManagers() {
        return spawnerManagers;
    }

    @NotNull
    public final Despawner<PokemonEntity> getDefaultPokemonDespawner() {
        return defaultPokemonDespawner;
    }

    public final void setDefaultPokemonDespawner(@NotNull Despawner<PokemonEntity> despawner) {
        Intrinsics.checkNotNullParameter(despawner, (String)"<set-?>");
        defaultPokemonDespawner = despawner;
    }

    @NotNull
    public final FishingSpawner getFishingSpawner() {
        FishingSpawner fishingSpawner = BestSpawner.fishingSpawner;
        if (fishingSpawner != null) {
            return fishingSpawner;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fishingSpawner");
        return null;
    }

    public final void setFishingSpawner(@NotNull FishingSpawner fishingSpawner) {
        Intrinsics.checkNotNullParameter((Object)fishingSpawner, (String)"<set-?>");
        BestSpawner.fishingSpawner = fishingSpawner;
    }

    public final void loadConfig() {
        Cobblemon.LOGGER.info("Starting the Best Spawner...");
        SpawningCondition.Companion.register("basic", BasicSpawningCondition.class);
        SpawningCondition.Companion.register("area", AreaSpawningCondition.class);
        SpawningCondition.Companion.register("submerged", SubmergedSpawningCondition.class);
        SpawningCondition.Companion.register("grounded", GroundedSpawningCondition.class);
        SpawningCondition.Companion.register("surface", SurfaceSpawningCondition.class);
        SpawningCondition.Companion.register("seafloor", SeafloorSpawningCondition.class);
        SpawningCondition.Companion.register("fishing", FishingSpawningCondition.class);
        Cobblemon.LOGGER.info("Loaded " + SpawningCondition.Companion.getConditionTypes().size() + " spawning condition types.");
        SpawningContextCalculator.Companion.register$default(SpawningContextCalculator.Companion, GroundedSpawningContextCalculator.INSTANCE, null, 2, null);
        SpawningContextCalculator.Companion.register$default(SpawningContextCalculator.Companion, SeafloorSpawningContextCalculator.INSTANCE, null, 2, null);
        SpawningContextCalculator.Companion.register$default(SpawningContextCalculator.Companion, LavafloorSpawningContextCalculator.INSTANCE, null, 2, null);
        SpawningContextCalculator.Companion.register$default(SpawningContextCalculator.Companion, SubmergedSpawningContextCalculator.INSTANCE, null, 2, null);
        SpawningContextCalculator.Companion.register$default(SpawningContextCalculator.Companion, SurfaceSpawningContextCalculator.INSTANCE, null, 2, null);
        SpawningContext.Companion.register("grounded", GroundedSpawningContext.class, "grounded");
        SpawningContext.Companion.register("seafloor", SeafloorSpawningContext.class, "seafloor");
        SpawningContext.Companion.register("lavafloor", LavafloorSpawningContext.class, "grounded");
        SpawningContext.Companion.register("submerged", SubmergedSpawningContext.class, "submerged");
        SpawningContext.Companion.register("surface", SurfaceSpawningContext.class, "surface");
        SpawningContext.Companion.register("fishing", FishingSpawningContext.class, "fishing");
        Cobblemon.LOGGER.info("Loaded " + SpawningContext.Companion.getContexts().size() + " spawning context types.");
        SpawnDetail.Companion.registerSpawnType(PokemonSpawnDetail.Companion.getTYPE(), PokemonSpawnDetail.class);
        SpawnDetail.Companion.registerSpawnType(NPCSpawnDetail.Companion.getTYPE(), NPCSpawnDetail.class);
        Cobblemon.LOGGER.info("Loaded " + SpawnDetail.Companion.getSpawnDetailTypes().size() + " spawn detail types.");
        config = BestSpawnerConfig.Companion.load();
        SpawnDetailPresets.INSTANCE.registerPresetType("basic", BasicSpawnDetailPreset.class);
        SpawnDetailPresets.INSTANCE.registerPresetType("pokemon", PokemonSpawnDetailPreset.class);
    }

    public final void onServerStarted() {
        Iterable $this$forEach$iv = spawnerManagers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpawnerManager p0 = (SpawnerManager)element$iv;
            boolean bl2 = false;
            p0.onServerStarted();
        }
        this.setFishingSpawner(new FishingSpawner(null, null, 3, null));
    }

    private static final int defaultPokemonDespawner$lambda$0(PokemonEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTicksLived();
    }

    static {
        Object[] objectArray = new SpawnerManager[]{CobblemonWorldSpawnerManager.INSTANCE};
        spawnerManagers = CollectionsKt.mutableListOf((Object[])objectArray);
        defaultPokemonDespawner = new CobblemonAgingDespawner(0.0f, 0.0f, 0, 0, BestSpawner::defaultPokemonDespawner$lambda$0, 15, null);
    }
}

