/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.api.spawning.spawner.TickingSpawner;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.cobblemon.mod.common.world.gamerules.CobblemonGameRules;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020\u0004H\u0086\b\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0003J\u000f\u0010\u0013\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0003R\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00148F\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\bR\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00148F\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0016\u001a\u0004\b\u001a\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;", "T", "", "getSpawnersOfType", "()Ljava/util/List;", "", "name", "getSpawnerByName", "(Ljava/lang/String;)Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;", "spawner", "", "registerSpawner", "(Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;)V", "unregisterSpawner", "onServerStarted", "onServerTick", "", "spawners", "Ljava/util/List;", "getSpawners", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawningInfluence;", "influences", "getInfluences", "common"})
@SourceDebugExtension(value={"SMAP\nSpawnerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnerManager.kt\ncom/cobblemon/mod/common/api/spawning/SpawnerManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n44#1:86\n808#2,11:74\n808#2,11:87\n1863#2,2:98\n1#3:85\n*S KotlinDebug\n*F\n+ 1 SpawnerManager.kt\ncom/cobblemon/mod/common/api/spawning/SpawnerManager\n*L\n71#1:86\n44#1:74,11\n71#1:87,11\n71#1:98,2\n*E\n"})
public class SpawnerManager {
    @NotNull
    private final List<Spawner> spawners = new ArrayList();
    @NotNull
    private final List<SpawningInfluence> influences = new ArrayList();

    @NotNull
    public final List<Spawner> getSpawners() {
        MinecraftServer minecraftServer = DistributionUtilsKt.server();
        boolean bl2 = minecraftServer != null ? !minecraftServer.method_18854() : false;
        if (bl2) {
            Cobblemon.LOGGER.error("Illegal access to spawners list from non-server thread!");
            new Exception().printStackTrace();
        }
        return this.spawners;
    }

    @NotNull
    public final List<SpawningInfluence> getInfluences() {
        MinecraftServer minecraftServer = DistributionUtilsKt.server();
        boolean bl2 = minecraftServer != null ? !minecraftServer.method_18854() : false;
        if (bl2) {
            Cobblemon.LOGGER.error("Illegal access to influences from non-server thread!");
            new Exception().printStackTrace();
        }
        return this.influences;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T extends Spawner> List<T> getSpawnersOfType() {
        void $this$filterIsInstanceTo$iv$iv;
        boolean $i$f$getSpawnersOfType = false;
        Iterable $this$filterIsInstance$iv = this.getSpawners();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element$iv$iv instanceof Object)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public Spawner getSpawnerByName(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable iterable = this.getSpawners();
            for (Object t : iterable) {
                Spawner it = (Spawner)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public void registerSpawner(@NotNull Spawner spawner) {
        Intrinsics.checkNotNullParameter((Object)spawner, (String)"spawner");
        this.getSpawners().add(spawner);
        if (!(spawner instanceof TickingSpawner)) {
            spawner.getInfluences().addAll((Collection<SpawningInfluence>)this.getInfluences());
        }
    }

    public void unregisterSpawner(@NotNull Spawner spawner) {
        Intrinsics.checkNotNullParameter((Object)spawner, (String)"spawner");
        this.getSpawners().remove(spawner);
        if (!(spawner instanceof TickingSpawner)) {
            spawner.getInfluences().removeAll((Collection)this.getInfluences());
        }
    }

    public void onServerStarted() {
        this.getSpawners().clear();
    }

    /*
     * WARNING - void declaration
     */
    public void onServerTick() {
        void $this$filterIsInstanceTo$iv$iv$iv;
        block6: {
            block5: {
                if (!Cobblemon.INSTANCE.getConfig().getEnableSpawning()) break block5;
                MinecraftServer minecraftServer = DistributionUtilsKt.server();
                boolean bl2 = minecraftServer != null && (minecraftServer = minecraftServer.method_3767()) != null ? !minecraftServer.method_8355(CobblemonGameRules.DO_POKEMON_SPAWNING) : false;
                if (!bl2) break block6;
            }
            return;
        }
        this.getInfluences().removeIf(arg_0 -> SpawnerManager.onServerTick$lambda$2(SpawnerManager::onServerTick$lambda$1, arg_0));
        SpawnerManager this_$iv = this;
        boolean $i$f$getSpawnersOfType = false;
        Iterable $this$filterIsInstance$iv$iv = this_$iv.getSpawners();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof TickingSpawner)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TickingSpawner p0 = (TickingSpawner)element$iv;
            boolean bl3 = false;
            p0.tick();
        }
    }

    private static final boolean onServerTick$lambda$1(SpawningInfluence it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isExpired();
    }

    private static final boolean onServerTick$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

