/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.detail;

import com.cobblemon.mod.common.api.data.JsonDataRegistry;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.api.spawning.SpawnLoader;
import com.cobblemon.mod.common.api.spawning.SpawnSet;
import com.cobblemon.mod.common.api.spawning.condition.PrecalculationResult;
import com.cobblemon.mod.common.api.spawning.condition.RootPrecalculation;
import com.cobblemon.mod.common.api.spawning.condition.SpawningPrecalculation;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ#\u0010\u0011\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J)\u0010\u0019\u001a\u00020\u00002\u001a\u0010\u0018\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016\"\u0006\u0012\u0002\b\u00030\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001b\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u001f2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b \u0010!J\u0015\u0010#\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0005\u00a2\u0006\u0004\b#\u0010$R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010%\u001a\u0004\b&\u0010'R\"\u0010)\u001a\n (*\u0004\u0018\u00010\u000f0\u000f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u001a\u0010.\u001a\u00020-8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R \u00103\u001a\b\u0012\u0004\u0012\u00020\u0000028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106R\u001a\u00108\u001a\u0002078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;R>\u0010=\u001a&\u0012\f\u0012\n (*\u0004\u0018\u00010\u00020\u0002 (*\u0012\u0012\f\u0012\n (*\u0004\u0018\u00010\u00020\u0002\u0018\u00010<0<8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@R\"\u0010A\u001a\n (*\u0004\u0018\u00010\u00050\u00058\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bA\u0010%\u001a\u0004\bB\u0010'R\u001d\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00040C8\u0006\u00a2\u0006\f\n\u0004\bD\u0010E\u001a\u0004\bF\u0010GR&\u0010I\u001a\u0006\u0012\u0002\b\u00030H8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010J\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR!\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170C8\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010E\u001a\u0004\bO\u0010G\u00a8\u0006P"}, d2={"Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "Lcom/cobblemon/mod/common/api/data/JsonDataRegistry;", "Lcom/cobblemon/mod/common/api/spawning/SpawnSet;", "", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "", "name", "<init>", "(Ljava/lang/String;)V", "Lnet/minecraft/class_3222;", "player", "", "sync", "(Lnet/minecraft/class_3222;)V", "", "Lnet/minecraft/class_2960;", "data", "reload", "(Ljava/util/Map;)V", "", "iterator", "()Ljava/util/Iterator;", "", "Lcom/cobblemon/mod/common/api/spawning/condition/SpawningPrecalculation;", "precalculators", "addPrecalculators", "([Lcom/cobblemon/mod/common/api/spawning/condition/SpawningPrecalculation;)Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "precalculate", "()V", "Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;", "ctx", "", "retrieve", "(Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;)Ljava/util/List;", "newName", "copy", "(Ljava/lang/String;)Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "kotlin.jvm.PlatformType", "id", "Lnet/minecraft/class_2960;", "getId", "()Lnet/minecraft/class_2960;", "Lnet/minecraft/class_3264;", "type", "Lnet/minecraft/class_3264;", "getType", "()Lnet/minecraft/class_3264;", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "observable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getObservable", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "Lcom/google/gson/reflect/TypeToken;", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "getTypeToken", "()Lcom/google/gson/reflect/TypeToken;", "resourcePath", "getResourcePath", "", "details", "Ljava/util/List;", "getDetails", "()Ljava/util/List;", "Lcom/cobblemon/mod/common/api/spawning/condition/PrecalculationResult;", "precalculation", "Lcom/cobblemon/mod/common/api/spawning/condition/PrecalculationResult;", "getPrecalculation", "()Lcom/cobblemon/mod/common/api/spawning/condition/PrecalculationResult;", "setPrecalculation", "(Lcom/cobblemon/mod/common/api/spawning/condition/PrecalculationResult;)V", "getPrecalculators", "common"})
@SourceDebugExtension(value={"SMAP\nSpawnPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnPool.kt\ncom/cobblemon/mod/common/api/spawning/detail/SpawnPool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n774#2:111\n865#2,2:112\n*S KotlinDebug\n*F\n+ 1 SpawnPool.kt\ncom/cobblemon/mod/common/api/spawning/detail/SpawnPool\n*L\n49#1:111\n49#1:112,2\n*E\n"})
public final class SpawnPool
implements JsonDataRegistry<SpawnSet>,
Iterable<SpawnDetail>,
KMappedMarker {
    @NotNull
    private final String name;
    private final class_2960 id;
    @NotNull
    private final class_3264 type;
    @NotNull
    private final SimpleObservable<SpawnPool> observable;
    @NotNull
    private final Gson gson;
    private final TypeToken<SpawnSet> typeToken;
    private final String resourcePath;
    @NotNull
    private final List<SpawnDetail> details;
    @NotNull
    private PrecalculationResult<?> precalculation;
    @NotNull
    private final List<SpawningPrecalculation<?>> precalculators;

    public SpawnPool(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.id = MiscUtilsKt.cobblemonResource("spawn_pool_" + this.name);
        this.type = class_3264.field_14190;
        this.observable = new SimpleObservable();
        Gson gson2 = SpawnLoader.INSTANCE.getGson();
        Intrinsics.checkNotNullExpressionValue((Object)gson2, (String)"<get-gson>(...)");
        this.gson = gson2;
        this.typeToken = TypeToken.get(SpawnSet.class);
        this.resourcePath = this.getId().method_12832();
        this.details = new ArrayList();
        this.precalculation = RootPrecalculation.INSTANCE.generate(this.details, CollectionsKt.emptyList());
        this.precalculators = new ArrayList();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    @NotNull
    public class_3264 getType() {
        return this.type;
    }

    @NotNull
    public SimpleObservable<SpawnPool> getObservable() {
        return this.observable;
    }

    @Override
    @NotNull
    public Gson getGson() {
        return this.gson;
    }

    @Override
    public TypeToken<SpawnSet> getTypeToken() {
        return this.typeToken;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public void sync(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reload(@NotNull Map<class_2960, SpawnSet> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.details.clear();
        for (SpawnSet set : data.values()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = set;
            List<SpawnDetail> list = this.details;
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SpawnDetail it = (SpawnDetail)element$iv$iv;
                boolean bl2 = false;
                if (!it.isValid()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list.addAll((List)destination$iv$iv);
        }
        this.precalculate();
    }

    @NotNull
    public final List<SpawnDetail> getDetails() {
        return this.details;
    }

    @NotNull
    public final PrecalculationResult<?> getPrecalculation() {
        return this.precalculation;
    }

    public final void setPrecalculation(@NotNull PrecalculationResult<?> precalculationResult) {
        Intrinsics.checkNotNullParameter(precalculationResult, (String)"<set-?>");
        this.precalculation = precalculationResult;
    }

    @NotNull
    public final List<SpawningPrecalculation<?>> getPrecalculators() {
        return this.precalculators;
    }

    @Override
    @NotNull
    public Iterator<SpawnDetail> iterator() {
        return this.details.iterator();
    }

    @NotNull
    public final SpawnPool addPrecalculators(SpawningPrecalculation<?> ... precalculators) {
        Intrinsics.checkNotNullParameter(precalculators, (String)"precalculators");
        CollectionsKt.addAll((Collection)this.precalculators, (Object[])precalculators);
        this.precalculate();
        return this;
    }

    public final void precalculate() {
        this.precalculation = this.precalculators.isEmpty() ? RootPrecalculation.INSTANCE.generate(this.details, CollectionsKt.emptyList()) : ((SpawningPrecalculation)CollectionsKt.first(this.precalculators)).generate(this.details, this.precalculators.subList(1, this.precalculators.size()));
    }

    @NotNull
    public final List<SpawnDetail> retrieve(@NotNull SpawningContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this.precalculation.retrieve(ctx);
    }

    @NotNull
    public final SpawnPool copy(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        SpawnPool copy = new SpawnPool(newName);
        copy.details.addAll((Collection<SpawnDetail>)this.details);
        copy.precalculators.addAll((Collection)this.precalculators);
        copy.precalculation = this.precalculation;
        return copy;
    }

    @Override
    public void reload(@NotNull class_3300 manager) {
        JsonDataRegistry.DefaultImpls.reload(this, manager);
    }
}

