/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.influence;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.context.calculators.SpawningContextCalculator;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.api.storage.PokemonStoreManager;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.cobblemon.mod.common.util.math.SimpleMathExtensionsKt;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0011\u001a\u00020\u00102\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0016\u001a\u0004\b\u0017\u0010\rR\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001f\u0010\u001d\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\"\u0010!\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\u0018\u001a\u0004\b\"\u0010\u001a\"\u0004\b#\u0010$R\"\u0010%\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010\u0016\u001a\u0004\b&\u0010\r\"\u0004\b'\u0010(\u00a8\u0006*"}, d2={"Lcom/cobblemon/mod/common/api/spawning/influence/PlayerLevelRangeInfluence;", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawningInfluence;", "Lnet/minecraft/class_3222;", "player", "", "variation", "Lkotlin/ranges/IntRange;", "noPokemonRange", "", "recalculationMillis", "<init>", "(Lnet/minecraft/class_3222;ILkotlin/ranges/IntRange;J)V", "getPlayerLevelRange", "()Lkotlin/ranges/IntRange;", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "action", "", "affectAction", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;)V", "I", "getVariation", "()I", "Lkotlin/ranges/IntRange;", "getNoPokemonRange", "J", "getRecalculationMillis", "()J", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "lastCalculatedTime", "getLastCalculatedTime", "setLastCalculatedTime", "(J)V", "previousRange", "getPreviousRange", "setPreviousRange", "(Lkotlin/ranges/IntRange;)V", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nPlayerLevelRangeInfluence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerLevelRangeInfluence.kt\ncom/cobblemon/mod/common/api/spawning/influence/PlayerLevelRangeInfluence\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public class PlayerLevelRangeInfluence
implements SpawningInfluence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int variation;
    @NotNull
    private final IntRange noPokemonRange;
    private final long recalculationMillis;
    private final UUID uuid;
    private long lastCalculatedTime;
    @NotNull
    private IntRange previousRange;
    private static final int TYPICAL_VARIATION = 5;

    public PlayerLevelRangeInfluence(@NotNull class_3222 player, int variation, @NotNull IntRange noPokemonRange, long recalculationMillis) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)noPokemonRange, (String)"noPokemonRange");
        this.variation = variation;
        this.noPokemonRange = noPokemonRange;
        this.recalculationMillis = recalculationMillis;
        this.uuid = player.method_5667();
        this.previousRange = this.noPokemonRange;
    }

    public /* synthetic */ PlayerLevelRangeInfluence(class_3222 class_32222, int n, IntRange intRange, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            intRange = new IntRange(1, Cobblemon.INSTANCE.getConfig().getMinimumLevelRangeMax());
        }
        if ((n2 & 8) != 0) {
            l = 5000L;
        }
        this(class_32222, n, intRange, l);
    }

    public final int getVariation() {
        return this.variation;
    }

    @NotNull
    public final IntRange getNoPokemonRange() {
        return this.noPokemonRange;
    }

    public final long getRecalculationMillis() {
        return this.recalculationMillis;
    }

    public final UUID getUuid() {
        return this.uuid;
    }

    public final long getLastCalculatedTime() {
        return this.lastCalculatedTime;
    }

    public final void setLastCalculatedTime(long l) {
        this.lastCalculatedTime = l;
    }

    @NotNull
    public final IntRange getPreviousRange() {
        return this.previousRange;
    }

    public final void setPreviousRange(@NotNull IntRange intRange) {
        Intrinsics.checkNotNullParameter((Object)intRange, (String)"<set-?>");
        this.previousRange = intRange;
    }

    @NotNull
    public final IntRange getPlayerLevelRange() {
        IntRange intRange;
        if (System.currentTimeMillis() - this.lastCalculatedTime > this.recalculationMillis) {
            IntRange intRange2;
            this.lastCalculatedTime = System.currentTimeMillis();
            PokemonStoreManager pokemonStoreManager = Cobblemon.INSTANCE.getStorage();
            UUID uUID = this.uuid;
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"uuid");
            MinecraftServer minecraftServer = DistributionUtilsKt.server();
            Intrinsics.checkNotNull((Object)minecraftServer);
            class_5455.class_6890 class_68902 = minecraftServer.method_30611();
            Intrinsics.checkNotNullExpressionValue((Object)class_68902, (String)"registryAccess(...)");
            PlayerPartyStore party = pokemonStoreManager.getParty(uUID, (class_5455)class_68902);
            PlayerLevelRangeInfluence playerLevelRangeInfluence = this;
            if (CollectionsKt.any((Iterable)party)) {
                Iterable iterable = party;
                PlayerLevelRangeInfluence playerLevelRangeInfluence2 = playerLevelRangeInfluence;
                Iterator iterator = iterable.iterator();
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                Pokemon it = (Pokemon)iterator.next();
                boolean bl2 = false;
                int n = it.getLevel();
                while (iterator.hasNext()) {
                    Pokemon it2 = (Pokemon)iterator.next();
                    $i$a$-maxOf-PlayerLevelRangeInfluence$getPlayerLevelRange$maximumLevel$1 = false;
                    int n2 = it2.getLevel();
                    if (n >= n2) continue;
                    n = n2;
                }
                int n3 = n;
                playerLevelRangeInfluence = playerLevelRangeInfluence2;
                int maximumLevel = n3;
                intRange2 = new IntRange(Math.max(maximumLevel - this.variation, 1), Math.min(Cobblemon.INSTANCE.getConfig().getMaxPokemonLevel(), Math.max(maximumLevel + this.variation, Cobblemon.INSTANCE.getConfig().getMinimumLevelRangeMax())));
            } else {
                intRange2 = this.noPokemonRange;
            }
            playerLevelRangeInfluence.previousRange = intRange2;
            intRange = this.previousRange;
        } else {
            intRange = this.previousRange;
        }
        return intRange;
    }

    @Override
    public void affectAction(@NotNull SpawnAction<?> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (action instanceof PokemonSpawnAction && ((PokemonSpawnAction)action).getProps().getLevel() == null) {
            IntRange playerLevelRange = this.getPlayerLevelRange();
            IntRange derivedLevelRange = ((PokemonSpawnAction)action).getDetail().getDerivedLevelRange();
            IntRange spawnLevelRange = SimpleMathExtensionsKt.intersection(playerLevelRange, derivedLevelRange);
            int pokemonRangeWidth = derivedLevelRange.getLast() - derivedLevelRange.getFirst();
            if (spawnLevelRange.isEmpty()) {
                spawnLevelRange = derivedLevelRange.getFirst() > playerLevelRange.getLast() ? new IntRange(derivedLevelRange.getFirst(), (int)((float)derivedLevelRange.getFirst() + (float)pokemonRangeWidth / 4.0f)) : new IntRange((int)((float)derivedLevelRange.getFirst() + (float)(3 * pokemonRangeWidth) / 4.0f), derivedLevelRange.getLast());
            }
            ((PokemonSpawnAction)action).getProps().setLevel(RangesKt.random((IntRange)spawnLevelRange, (Random)((Random)Random.Default)));
        }
    }

    @Override
    public boolean isExpired() {
        return SpawningInfluence.DefaultImpls.isExpired(this);
    }

    @Override
    public boolean affectSpawnable(@NotNull SpawnDetail detail, @NotNull SpawningContext ctx) {
        return SpawningInfluence.DefaultImpls.affectSpawnable(this, detail, ctx);
    }

    @Override
    public float affectWeight(@NotNull SpawnDetail detail, @NotNull SpawningContext ctx, float weight) {
        return SpawningInfluence.DefaultImpls.affectWeight(this, detail, ctx, weight);
    }

    @Override
    public void affectSpawn(@NotNull class_1297 entity) {
        SpawningInfluence.DefaultImpls.affectSpawn(this, entity);
    }

    @Override
    public float affectBucketWeight(@NotNull SpawnBucket bucket, float weight) {
        return SpawningInfluence.DefaultImpls.affectBucketWeight(this, bucket, weight);
    }

    @Override
    public boolean isAllowedPosition(@NotNull class_3218 world, @NotNull class_2338 pos, @NotNull SpawningContextCalculator<?, ?> contextCalculator) {
        return SpawningInfluence.DefaultImpls.isAllowedPosition(this, world, pos, contextCalculator);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/api/spawning/influence/PlayerLevelRangeInfluence$Companion;", "", "<init>", "()V", "", "TYPICAL_VARIATION", "I", "getTYPICAL_VARIATION", "()I", "common"})
    public static final class Companion {
        private Companion() {
        }

        public final int getTYPICAL_VARIATION() {
            return TYPICAL_VARIATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

