/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.preset;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.context.RegisteredSpawningContext;
import com.cobblemon.mod.common.util.adapters.RegisteredSpawningContextAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u00020\t8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR#\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lcom/cobblemon/mod/common/api/spawning/preset/BestSpawnerConfig;", "", "<init>", "()V", "", "version", "I", "getVersion", "()I", "", "replaceWithNewVersion", "Z", "getReplaceWithNewVersion", "()Z", "", "", "", "contextWeights", "Ljava/util/Map;", "getContextWeights", "()Ljava/util/Map;", "", "Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;", "buckets", "Ljava/util/List;", "getBuckets", "()Ljava/util/List;", "Companion", "common"})
public final class BestSpawnerConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int version;
    private final boolean replaceWithNewVersion;
    @NotNull
    private final Map<String, Float> contextWeights;
    @NotNull
    private final List<SpawnBucket> buckets;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter((Type)((Object)RegisteredSpawningContext.class), (Object)RegisteredSpawningContextAdapter.INSTANCE).setLenient().disableHtmlEscaping().create();
    @NotNull
    public static final String CONFIG_NAME = "best-spawner-config";
    @NotNull
    public static final String INTERNAL_PATH = "/data/cobblemon/spawning/best-spawner-config.json";
    @NotNull
    public static final String EXTERNAL_PATH = "config/cobblemon/spawning/best-spawner-config.json";

    public BestSpawnerConfig() {
        this.replaceWithNewVersion = true;
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"grounded", (Object)Float.valueOf(1.0f)), TuplesKt.to((Object)"submerged", (Object)Float.valueOf(0.99f)), TuplesKt.to((Object)"surface", (Object)Float.valueOf(0.01f)), TuplesKt.to((Object)"seafloor", (Object)Float.valueOf(1.0f))};
        this.contextWeights = MapsKt.mutableMapOf((Pair[])objectArray);
        objectArray = new SpawnBucket[]{new SpawnBucket("common", 93.8f), new SpawnBucket("uncommon", 5.0f), new SpawnBucket("rare", 1.0f), new SpawnBucket("ultra-rare", 0.2f)};
        this.buckets = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public final int getVersion() {
        return this.version;
    }

    public final boolean getReplaceWithNewVersion() {
        return this.replaceWithNewVersion;
    }

    @NotNull
    public final Map<String, Float> getContextWeights() {
        return this.contextWeights;
    }

    @NotNull
    public final List<SpawnBucket> getBuckets() {
        return this.buckets;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u0011\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0006J\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u0003R\u001f\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00118\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/cobblemon/mod/common/api/spawning/preset/BestSpawnerConfig$Companion;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/spawning/preset/BestSpawnerConfig;", "load", "()Lcom/cobblemon/mod/common/api/spawning/preset/BestSpawnerConfig;", "loadInternal", "loadExternal", "", "saveExternal", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "", "CONFIG_NAME", "Ljava/lang/String;", "INTERNAL_PATH", "EXTERNAL_PATH", "common"})
    public static final class Companion {
        private Companion() {
        }

        public final Gson getGSON() {
            return GSON;
        }

        @NotNull
        public final BestSpawnerConfig load() {
            BestSpawnerConfig internal = this.loadInternal();
            if (Cobblemon.INSTANCE.getConfig().getExportSpawnConfig()) {
                BestSpawnerConfig bestSpawnerConfig;
                BestSpawnerConfig external = this.loadExternal();
                if (external == null) {
                    this.saveExternal();
                    bestSpawnerConfig = internal;
                } else if (external.getReplaceWithNewVersion() && internal.getVersion() > external.getVersion()) {
                    this.saveExternal();
                    bestSpawnerConfig = internal;
                } else {
                    bestSpawnerConfig = external;
                }
                return bestSpawnerConfig;
            }
            return internal;
        }

        private final BestSpawnerConfig loadInternal() {
            InputStream inputStream = Cobblemon.class.getResourceAsStream(BestSpawnerConfig.INTERNAL_PATH);
            Intrinsics.checkNotNull((Object)inputStream);
            InputStreamReader reader = new InputStreamReader(inputStream);
            BestSpawnerConfig config = (BestSpawnerConfig)this.getGSON().fromJson((Reader)reader, BestSpawnerConfig.class);
            reader.close();
            Intrinsics.checkNotNull((Object)config);
            return config;
        }

        private final BestSpawnerConfig loadExternal() {
            BestSpawnerConfig bestSpawnerConfig;
            File configFile = new File(BestSpawnerConfig.EXTERNAL_PATH);
            configFile.getParentFile().mkdirs();
            if (configFile.exists()) {
                BestSpawnerConfig bestSpawnerConfig2;
                try {
                    FileReader reader = new FileReader(configFile);
                    BestSpawnerConfig config = (BestSpawnerConfig)this.getGSON().fromJson((Reader)reader, BestSpawnerConfig.class);
                    reader.close();
                    bestSpawnerConfig2 = config;
                }
                catch (Exception e) {
                    Cobblemon.LOGGER.error("Unable to load external Best Spawner configuration", (Throwable)e);
                    bestSpawnerConfig2 = null;
                }
                bestSpawnerConfig = bestSpawnerConfig2;
            } else {
                bestSpawnerConfig = null;
            }
            return bestSpawnerConfig;
        }

        public final void saveExternal() {
            InputStream inputStream = Cobblemon.class.getResourceAsStream(BestSpawnerConfig.INTERNAL_PATH);
            Intrinsics.checkNotNull((Object)inputStream);
            InputStream stream = inputStream;
            byte[] bytes = stream.readAllBytes();
            stream.close();
            File configFile = new File(BestSpawnerConfig.EXTERNAL_PATH);
            configFile.getParentFile().mkdirs();
            configFile.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(configFile);
            outputStream.write(bytes);
            outputStream.close();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

