/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.spawner;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.SpawnerManager;
import com.cobblemon.mod.common.api.spawning.WorldSlice;
import com.cobblemon.mod.common.api.spawning.context.AreaContextResolver;
import com.cobblemon.mod.common.api.spawning.context.AreaSpawningContext;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.context.calculators.AreaSpawningContextCalculator;
import com.cobblemon.mod.common.api.spawning.context.calculators.SpawningContextCalculator;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnPool;
import com.cobblemon.mod.common.api.spawning.prospecting.SpawningProspector;
import com.cobblemon.mod.common.api.spawning.spawner.AreaSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningArea;
import com.cobblemon.mod.common.api.spawning.spawner.TickingSpawner;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_10;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 62\u00020\u0001:\u00016B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\nH&\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\f\u00a2\u0006\u0004\b\u001e\u0010\u001fR\"\u0010!\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\"\u0010(\u001a\u00020'8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R,\u00100\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030/0.8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u00101\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u00067"}, d2={"Lcom/cobblemon/mod/common/api/spawning/spawner/AreaSpawner;", "Lcom/cobblemon/mod/common/api/spawning/spawner/TickingSpawner;", "", "name", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "spawns", "Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;", "manager", "<init>", "(Ljava/lang/String;Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;)V", "Lcom/cobblemon/mod/common/api/spawning/SpawnCause;", "cause", "Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningArea;", "getArea", "(Lcom/cobblemon/mod/common/api/spawning/SpawnCause;)Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningArea;", "Lkotlin/Pair;", "Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "run", "(Lcom/cobblemon/mod/common/api/spawning/SpawnCause;)Lkotlin/Pair;", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_2791;", "chunk", "Lnet/minecraft/class_2338$class_2339;", "startPos", "", "isValidStartPoint", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2791;Lnet/minecraft/class_2338$class_2339;)Z", "area", "constrainArea", "(Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningArea;)Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningArea;", "Lcom/cobblemon/mod/common/api/spawning/prospecting/SpawningProspector;", "prospector", "Lcom/cobblemon/mod/common/api/spawning/prospecting/SpawningProspector;", "getProspector", "()Lcom/cobblemon/mod/common/api/spawning/prospecting/SpawningProspector;", "setProspector", "(Lcom/cobblemon/mod/common/api/spawning/prospecting/SpawningProspector;)V", "Lcom/cobblemon/mod/common/api/spawning/context/AreaContextResolver;", "resolver", "Lcom/cobblemon/mod/common/api/spawning/context/AreaContextResolver;", "getResolver", "()Lcom/cobblemon/mod/common/api/spawning/context/AreaContextResolver;", "setResolver", "(Lcom/cobblemon/mod/common/api/spawning/context/AreaContextResolver;)V", "", "Lcom/cobblemon/mod/common/api/spawning/context/calculators/AreaSpawningContextCalculator;", "contextCalculators", "Ljava/util/List;", "getContextCalculators", "()Ljava/util/List;", "setContextCalculators", "(Ljava/util/List;)V", "Companion", "common"})
public abstract class AreaSpawner
extends TickingSpawner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private SpawningProspector prospector;
    @NotNull
    private AreaContextResolver resolver;
    @NotNull
    private List<? extends AreaSpawningContextCalculator<?>> contextCalculators;
    public static final int CHUNK_REACH = 3;

    public AreaSpawner(@NotNull String name, @NotNull SpawnPool spawns, @NotNull SpawnerManager manager) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)spawns, (String)"spawns");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        super(name, spawns, manager);
        this.prospector = Cobblemon.INSTANCE.getProspector();
        this.resolver = Cobblemon.INSTANCE.getAreaContextResolver();
        this.contextCalculators = SpawningContextCalculator.Companion.getPrioritizedAreaCalculators();
    }

    @Nullable
    public abstract SpawningArea getArea(@NotNull SpawnCause var1);

    @NotNull
    public final SpawningProspector getProspector() {
        return this.prospector;
    }

    public final void setProspector(@NotNull SpawningProspector spawningProspector) {
        Intrinsics.checkNotNullParameter((Object)spawningProspector, (String)"<set-?>");
        this.prospector = spawningProspector;
    }

    @NotNull
    public final AreaContextResolver getResolver() {
        return this.resolver;
    }

    public final void setResolver(@NotNull AreaContextResolver areaContextResolver2) {
        Intrinsics.checkNotNullParameter((Object)areaContextResolver2, (String)"<set-?>");
        this.resolver = areaContextResolver2;
    }

    @NotNull
    public final List<AreaSpawningContextCalculator<?>> getContextCalculators() {
        return this.contextCalculators;
    }

    public final void setContextCalculators(@NotNull List<? extends AreaSpawningContextCalculator<?>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.contextCalculators = list;
    }

    @Override
    @Nullable
    public Pair<SpawningContext, SpawnDetail> run(@NotNull SpawnCause cause) {
        SpawningArea constrainedArea;
        SpawningArea area;
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        SpawningArea spawningArea = area = this.getArea(cause);
        SpawningArea spawningArea2 = constrainedArea = spawningArea != null ? this.constrainArea(spawningArea) : null;
        if (constrainedArea != null) {
            int chunksCovered;
            class_238 areaBox = class_238.method_30048((class_243)new class_243(Vec3ExtensionsKt.toVec3f(constrainedArea.getCenter())), (double)96.0, (double)1000.0, (double)96.0);
            class_3218 class_32182 = constrainedArea.getWorld();
            Intrinsics.checkNotNull((Object)areaBox);
            if (!WorldExtensionsKt.isBoxLoaded(class_32182, areaBox)) {
                return null;
            }
            int numberNearby2 = constrainedArea.getWorld().method_8390(PokemonEntity.class, areaBox, arg_0 -> AreaSpawner.run$lambda$0((Function1)run.numberNearby.1.INSTANCE, arg_0)).size();
            if ((float)numberNearby2 / (float)(chunksCovered = 9) >= Cobblemon.INSTANCE.getConfig().getPokemonPerChunk()) {
                return null;
            }
            WorldSlice slice = this.prospector.prospect(this, constrainedArea);
            List<AreaSpawningContext> contexts = this.resolver.resolve(this, this.contextCalculators, slice);
            return this.getSpawningSelector().select(this, contexts);
        }
        return null;
    }

    public final boolean isValidStartPoint(@NotNull class_1937 world, @NotNull class_2791 chunk, @NotNull class_2338.class_2339 startPos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
        int y = startPos.method_10264();
        if (!world.method_8477((class_2338)startPos) || !world.method_8477((class_2338)startPos.method_33098(y + 1))) {
            return false;
        }
        class_2680 mid = chunk.method_8320((class_2338)startPos.method_33098(y));
        class_2680 above = chunk.method_8320((class_2338)startPos.method_33098(y + 1));
        if (!above.method_26171(class_10.field_51)) {
            return false;
        }
        return !mid.method_26215();
    }

    @Nullable
    public final SpawningArea constrainArea(@NotNull SpawningArea area) {
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        class_2338.class_2339 basePos = new class_2338.class_2339(area.getBaseX(), area.getBaseY(), area.getBaseZ());
        int originalY = area.getBaseY();
        Pair pair = new Pair((Object)class_4076.method_18675((int)area.getBaseX()), (Object)class_4076.method_18675((int)area.getBaseZ()));
        int chunkX = ((Number)pair.component1()).intValue();
        int chunkZ = ((Number)pair.component2()).intValue();
        if (!area.getWorld().method_37116(class_1923.method_8331((int)chunkX, (int)chunkZ))) {
            return null;
        }
        class_2791 class_27912 = area.getWorld().method_22342(chunkX, chunkZ, class_2806.field_12803);
        if (class_27912 == null) {
            return null;
        }
        class_2791 chunk = class_27912;
        boolean valid = this.isValidStartPoint((class_1937)area.getWorld(), chunk, basePos);
        if (!valid) {
            int offset = 1;
            do {
                class_1937 class_19372 = (class_1937)area.getWorld();
                class_2338.class_2339 class_23392 = basePos.method_33098(originalY + offset);
                Intrinsics.checkNotNullExpressionValue((Object)class_23392, (String)"setY(...)");
                if (this.isValidStartPoint(class_19372, chunk, class_23392)) {
                    valid = true;
                    basePos.method_33098(originalY + offset);
                    break;
                }
                class_1937 class_19373 = (class_1937)area.getWorld();
                class_2338.class_2339 class_23393 = basePos.method_33098(originalY - offset);
                Intrinsics.checkNotNullExpressionValue((Object)class_23393, (String)"setY(...)");
                if (!this.isValidStartPoint(class_19373, chunk, class_23393)) continue;
                valid = true;
                basePos.method_33098(originalY + offset);
                break;
            } while (++offset <= Cobblemon.INSTANCE.getConfig().getMaxVerticalCorrectionBlocks());
        }
        if (valid) {
            class_2338 min = WorldExtensionsKt.squeezeWithinBounds((class_1937)area.getWorld(), (class_2338)basePos);
            class_1937 class_19374 = (class_1937)area.getWorld();
            class_2338.class_2339 class_23394 = basePos.method_10100(area.getLength(), area.getHeight(), area.getWidth());
            Intrinsics.checkNotNullExpressionValue((Object)class_23394, (String)"move(...)");
            class_2338 max = WorldExtensionsKt.squeezeWithinBounds(class_19374, (class_2338)class_23394);
            if (area.getWorld().method_8477(min) && area.getWorld().method_8477(max) && min.method_10263() < max.method_10263() && min.method_10264() < max.method_10264() && min.method_10260() < max.method_10260()) {
                return new SpawningArea(area.getCause(), area.getWorld(), min.method_10263(), min.method_10264(), min.method_10260(), max.method_10263() - min.method_10263(), max.method_10264() - min.method_10264(), max.method_10260() - min.method_10260());
            }
        }
        return null;
    }

    private static final boolean run$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/api/spawning/spawner/AreaSpawner$Companion;", "", "<init>", "()V", "", "CHUNK_REACH", "I", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

