/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.spawner;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.SpawnerManager;
import com.cobblemon.mod.common.api.spawning.detail.SpawnPool;
import com.cobblemon.mod.common.api.spawning.spawner.AreaSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningArea;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0012\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u0017\u001a\u00020\u00168\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/cobblemon/mod/common/api/spawning/spawner/PlayerSpawner;", "Lcom/cobblemon/mod/common/api/spawning/spawner/AreaSpawner;", "Lnet/minecraft/class_3222;", "player", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "spawns", "Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;", "manager", "<init>", "(Lnet/minecraft/class_3222;Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;)V", "getCauseEntity", "()Lnet/minecraft/class_3222;", "Lcom/cobblemon/mod/common/api/spawning/SpawnCause;", "cause", "Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningArea;", "getArea", "(Lcom/cobblemon/mod/common/api/spawning/SpawnCause;)Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningArea;", "Ljava/util/UUID;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "", "ticksBetweenSpawns", "F", "getTicksBetweenSpawns", "()F", "setTicksBetweenSpawns", "(F)V", "common"})
public final class PlayerSpawner
extends AreaSpawner {
    @NotNull
    private final UUID uuid;
    private float ticksBetweenSpawns;

    public PlayerSpawner(@NotNull class_3222 player, @NotNull SpawnPool spawns, @NotNull SpawnerManager manager) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)spawns, (String)"spawns");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        String string = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        super(string, spawns, manager);
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        this.uuid = uUID;
        this.ticksBetweenSpawns = Cobblemon.INSTANCE.getConfig().getTicksBetweenSpawnAttempts();
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @Override
    public float getTicksBetweenSpawns() {
        return this.ticksBetweenSpawns;
    }

    @Override
    public void setTicksBetweenSpawns(float f) {
        this.ticksBetweenSpawns = f;
    }

    @Nullable
    public class_3222 getCauseEntity() {
        return PlayerExtensionsKt.getPlayer(this.uuid);
    }

    @Override
    @Nullable
    public SpawningArea getArea(@NotNull SpawnCause cause) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        class_3222 class_32222 = PlayerExtensionsKt.getPlayer(this.uuid);
        if (class_32222 == null) {
            return null;
        }
        class_3222 player = class_32222;
        int sliceDiameter = Cobblemon.INSTANCE.getConfig().getWorldSliceDiameter();
        int sliceHeight = Cobblemon.INSTANCE.getConfig().getWorldSliceHeight();
        Random.Default rand = Random.Default;
        class_243 center = player.method_19538();
        float r = MiscUtilsKt.nextBetween((Random)rand, Cobblemon.INSTANCE.getConfig().getMinimumSliceDistanceFromPlayer(), Cobblemon.INSTANCE.getConfig().getMaximumSliceDistanceFromPlayer());
        double thetatemp = Math.atan(player.method_18798().field_1350 / player.method_18798().field_1352) + (double)MiscUtilsKt.nextBetween((Random)rand, -1.5707964f, 1.5707964f);
        double theta = player.method_18798().method_37267() < 0.1 ? rand.nextDouble() * (double)2 * (double)((float)Math.PI) : (player.method_18798().field_1352 < 0.0 ? (double)((float)Math.PI) - thetatemp : thetatemp);
        double x = center.field_1352 + (double)r * Math.cos(theta);
        double z = center.field_1350 + (double)r * Math.sin(theta);
        class_1937 class_19372 = player.method_37908();
        Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        return new SpawningArea(cause, (class_3218)class_19372, class_3532.method_15384((double)(x - (double)((float)sliceDiameter / 2.0f))), class_3532.method_15384((double)(center.field_1351 - (double)((float)sliceHeight / 2.0f))), class_3532.method_15384((double)(z - (double)((float)sliceDiameter / 2.0f))), sliceDiameter, sliceHeight, sliceDiameter);
    }
}

