/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.spawner;

import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.SpawnerManager;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.detail.EntitySpawnResult;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnPool;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.api.spawning.selection.FlatContextWeightedSelector;
import com.cobblemon.mod.common.api.spawning.selection.SpawningSelector;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0015\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001b2\u0006\u0010\u001a\u001a\u00020\u0019H&\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b \u0010!J+\u0010&\u001a\u00020\u0011\"\u0004\b\u0000\u0010\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000#2\u0006\u0010%\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b&\u0010'J\u0011\u0010)\u001a\u0004\u0018\u00010(H\u0016\u00a2\u0006\u0004\b)\u0010*J\u0013\u0010-\u001a\b\u0012\u0004\u0012\u00020,0+\u00a2\u0006\u0004\b-\u0010.J\u0015\u00100\u001a\b\u0012\u0004\u0012\u00020,0/H\u0016\u00a2\u0006\u0004\b0\u0010.R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u00101\u001a\u0004\b2\u00103R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u00104\u001a\u0004\b5\u0010\u0015\"\u0004\b6\u0010\u0018R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u00107\u001a\u0004\b8\u00109R\u0016\u0010\u0010\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010:R \u0010;\u001a\b\u0012\u0004\u0012\u00020,0/8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010.R\"\u0010>\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b>\u0010?\u001a\u0004\b@\u0010\f\"\u0004\bA\u0010BR\u001d\u0010C\u001a\b\u0012\u0004\u0012\u00020(0/8\u0006\u00a2\u0006\f\n\u0004\bC\u0010<\u001a\u0004\bD\u0010.R\"\u0010F\u001a\u00020E8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010G\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\"\u0010M\u001a\u00020L8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bM\u0010N\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u001c\u0010U\u001a\u00020L8&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\bS\u0010P\"\u0004\bT\u0010RR\"\u0010V\u001a\u00020L8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bV\u0010N\u001a\u0004\bW\u0010P\"\u0004\bX\u0010RR\"\u0010Z\u001a\u00020Y8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bZ\u0010[\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_\u00a8\u0006`"}, d2={"Lcom/cobblemon/mod/common/api/spawning/spawner/TickingSpawner;", "Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;", "", "name", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "spawns", "Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;", "manager", "<init>", "(Ljava/lang/String;Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;)V", "", "canSpawn", "()Z", "Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;", "getSpawningSelector", "()Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;", "selector", "", "setSpawningSelector", "(Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;)V", "getSpawnPool", "()Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "spawnPool", "setSpawnPool", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;)V", "Lcom/cobblemon/mod/common/api/spawning/SpawnCause;", "cause", "Lkotlin/Pair;", "Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "run", "(Lcom/cobblemon/mod/common/api/spawning/SpawnCause;)Lkotlin/Pair;", "tick", "()V", "R", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "action", "result", "afterSpawn", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;Ljava/lang/Object;)V", "Lnet/minecraft/class_1297;", "getCauseEntity", "()Lnet/minecraft/class_1297;", "", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawningInfluence;", "getAllInfluences", "()Ljava/util/List;", "", "copyInfluences", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "getSpawns", "setSpawns", "Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;", "getManager", "()Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;", "Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;", "influences", "Ljava/util/List;", "getInfluences", "active", "Z", "getActive", "setActive", "(Z)V", "spawnedEntities", "getSpawnedEntities", "", "lastSpawnTime", "J", "getLastSpawnTime", "()J", "setLastSpawnTime", "(J)V", "", "ticksUntilNextSpawn", "F", "getTicksUntilNextSpawn", "()F", "setTicksUntilNextSpawn", "(F)V", "getTicksBetweenSpawns", "setTicksBetweenSpawns", "ticksBetweenSpawns", "tickTimerMultiplier", "getTickTimerMultiplier", "setTickTimerMultiplier", "", "removalCheckTicks", "I", "getRemovalCheckTicks", "()I", "setRemovalCheckTicks", "(I)V", "common"})
public abstract class TickingSpawner
implements Spawner {
    @NotNull
    private final String name;
    @NotNull
    private SpawnPool spawns;
    @NotNull
    private final SpawnerManager manager;
    @NotNull
    private SpawningSelector selector;
    @NotNull
    private final List<SpawningInfluence> influences;
    private boolean active;
    @NotNull
    private final List<class_1297> spawnedEntities;
    private long lastSpawnTime;
    private float ticksUntilNextSpawn;
    private float tickTimerMultiplier;
    private int removalCheckTicks;

    public TickingSpawner(@NotNull String name, @NotNull SpawnPool spawns, @NotNull SpawnerManager manager) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)spawns, (String)"spawns");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.name = name;
        this.spawns = spawns;
        this.manager = manager;
        this.selector = new FlatContextWeightedSelector();
        this.influences = new ArrayList();
        this.active = true;
        this.spawnedEntities = new ArrayList();
        this.ticksUntilNextSpawn = 100.0f;
        this.tickTimerMultiplier = 1.0f;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final SpawnPool getSpawns() {
        return this.spawns;
    }

    public final void setSpawns(@NotNull SpawnPool spawnPool) {
        Intrinsics.checkNotNullParameter((Object)spawnPool, (String)"<set-?>");
        this.spawns = spawnPool;
    }

    @NotNull
    public final SpawnerManager getManager() {
        return this.manager;
    }

    @Override
    @NotNull
    public List<SpawningInfluence> getInfluences() {
        return this.influences;
    }

    @Override
    public boolean canSpawn() {
        return this.active;
    }

    @Override
    @NotNull
    public SpawningSelector getSpawningSelector() {
        return this.selector;
    }

    @Override
    public void setSpawningSelector(@NotNull SpawningSelector selector) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        this.selector = selector;
    }

    @Override
    @NotNull
    public SpawnPool getSpawnPool() {
        return this.spawns;
    }

    @Override
    public void setSpawnPool(@NotNull SpawnPool spawnPool) {
        Intrinsics.checkNotNullParameter((Object)spawnPool, (String)"spawnPool");
        this.spawns = spawnPool;
    }

    @Nullable
    public abstract Pair<SpawningContext, SpawnDetail> run(@NotNull SpawnCause var1);

    public final boolean getActive() {
        return this.active;
    }

    public final void setActive(boolean bl2) {
        this.active = bl2;
    }

    @NotNull
    public final List<class_1297> getSpawnedEntities() {
        return this.spawnedEntities;
    }

    public final long getLastSpawnTime() {
        return this.lastSpawnTime;
    }

    public final void setLastSpawnTime(long l) {
        this.lastSpawnTime = l;
    }

    public final float getTicksUntilNextSpawn() {
        return this.ticksUntilNextSpawn;
    }

    public final void setTicksUntilNextSpawn(float f) {
        this.ticksUntilNextSpawn = f;
    }

    public abstract float getTicksBetweenSpawns();

    public abstract void setTicksBetweenSpawns(float var1);

    public final float getTickTimerMultiplier() {
        return this.tickTimerMultiplier;
    }

    public final void setTickTimerMultiplier(float f) {
        this.tickTimerMultiplier = f;
    }

    public final int getRemovalCheckTicks() {
        return this.removalCheckTicks;
    }

    public final void setRemovalCheckTicks(int n) {
        this.removalCheckTicks = n;
    }

    public void tick() {
        int n = this.removalCheckTicks;
        this.removalCheckTicks = n + 1;
        this.getInfluences().removeIf(arg_0 -> TickingSpawner.tick$lambda$1(TickingSpawner::tick$lambda$0, arg_0));
        if (this.removalCheckTicks == 60) {
            this.spawnedEntities.removeIf(arg_0 -> TickingSpawner.tick$lambda$3(TickingSpawner::tick$lambda$2, arg_0));
            this.removalCheckTicks = 0;
        }
        if (!this.active) {
            return;
        }
        this.ticksUntilNextSpawn -= this.tickTimerMultiplier;
        if (this.ticksUntilNextSpawn <= 0.0f) {
            Pair<SpawningContext, SpawnDetail> spawn = this.run(new SpawnCause(this, this.chooseBucket(), this.getCauseEntity()));
            this.ticksUntilNextSpawn = this.getTicksBetweenSpawns();
            if (spawn != null) {
                SpawningContext ctx = (SpawningContext)spawn.getFirst();
                SpawnDetail detail = (SpawnDetail)spawn.getSecond();
                SpawnAction<?> spawnAction = detail.doSpawn(ctx);
                spawnAction.complete();
            }
        }
    }

    @Override
    public <R> void afterSpawn(@NotNull SpawnAction<R> action, R result) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Spawner.DefaultImpls.afterSpawn(this, action, result);
        if (result instanceof EntitySpawnResult) {
            this.spawnedEntities.addAll((Collection<class_1297>)((EntitySpawnResult)result).getEntities());
        }
        this.lastSpawnTime = System.currentTimeMillis();
    }

    @Nullable
    public class_1297 getCauseEntity() {
        return null;
    }

    @NotNull
    public final List<SpawningInfluence> getAllInfluences() {
        return CollectionsKt.plus((Collection)this.getInfluences(), (Iterable)this.manager.getInfluences());
    }

    @Override
    @NotNull
    public List<SpawningInfluence> copyInfluences() {
        return CollectionsKt.toMutableList((Collection)this.getAllInfluences());
    }

    @Override
    @NotNull
    public List<SpawnDetail> getMatchingSpawns(@NotNull SpawningContext ctx) {
        return Spawner.DefaultImpls.getMatchingSpawns(this, ctx);
    }

    @Override
    @NotNull
    public SpawnBucket chooseBucket() {
        return Spawner.DefaultImpls.chooseBucket(this);
    }

    private static final boolean tick$lambda$0(SpawningInfluence it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isExpired();
    }

    private static final boolean tick$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean tick$lambda$2(class_1297 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.method_31481();
    }

    private static final boolean tick$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

