/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.spawner;

import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnPool;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.api.spawning.selection.FlatContextWeightedSelector;
import com.cobblemon.mod.common.api.spawning.selection.SpawningSelector;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010!\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ=\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J)\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH&\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b%\u0010&R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010'\u001a\u0004\b(\u0010)R\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010*\u001a\u0004\b+\u0010#\"\u0004\b,\u0010&R\u0016\u0010\u001e\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010-R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100.8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0011\u0010/\u001a\u0004\b0\u00101\u00a8\u00062"}, d2={"Lcom/cobblemon/mod/common/api/spawning/spawner/TriggerSpawner;", "Lcom/cobblemon/mod/common/api/spawning/SpawnCause;", "T", "Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;", "", "name", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "spawns", "<init>", "(Ljava/lang/String;Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;)V", "cause", "Lnet/minecraft/class_3218;", "world", "Lnet/minecraft/class_2338;", "pos", "", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawningInfluence;", "influences", "Ljava/util/concurrent/CompletableFuture;", "run", "(Lcom/cobblemon/mod/common/api/spawning/SpawnCause;Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;Ljava/util/List;)Ljava/util/concurrent/CompletableFuture;", "Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;", "parseContext", "(Lcom/cobblemon/mod/common/api/spawning/SpawnCause;Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;", "", "canSpawn", "()Z", "Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;", "getSpawningSelector", "()Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;", "selector", "", "setSpawningSelector", "(Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;)V", "getSpawnPool", "()Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "spawnPool", "setSpawnPool", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;)V", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "getSpawns", "setSpawns", "Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;", "", "Ljava/util/List;", "getInfluences", "()Ljava/util/List;", "common"})
@SourceDebugExtension(value={"SMAP\nTriggerSpawner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TriggerSpawner.kt\ncom/cobblemon/mod/common/api/spawning/spawner/TriggerSpawner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public abstract class TriggerSpawner<T extends SpawnCause>
implements Spawner {
    @NotNull
    private final String name;
    @NotNull
    private SpawnPool spawns;
    @NotNull
    private SpawningSelector selector;
    @NotNull
    private final List<SpawningInfluence> influences;

    public TriggerSpawner(@NotNull String name, @NotNull SpawnPool spawns) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)spawns, (String)"spawns");
        this.name = name;
        this.spawns = spawns;
        this.selector = new FlatContextWeightedSelector();
        this.influences = new ArrayList();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final SpawnPool getSpawns() {
        return this.spawns;
    }

    public final void setSpawns(@NotNull SpawnPool spawnPool) {
        Intrinsics.checkNotNullParameter((Object)spawnPool, (String)"<set-?>");
        this.spawns = spawnPool;
    }

    @Override
    @NotNull
    public List<SpawningInfluence> getInfluences() {
        return this.influences;
    }

    @Nullable
    public CompletableFuture<?> run(@NotNull T cause, @NotNull class_3218 world, @NotNull class_2338 pos, @NotNull List<? extends SpawningInfluence> influences) {
        Intrinsics.checkNotNullParameter(cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(influences, (String)"influences");
        SpawningContext spawningContext = this.parseContext(cause, world, pos);
        if (spawningContext == null) {
            return null;
        }
        SpawningContext context = spawningContext;
        context.getInfluences().addAll((Collection<SpawningInfluence>)influences);
        Pair<SpawningContext, SpawnDetail> pair = this.selector.select(this, CollectionsKt.listOf((Object)context));
        if (pair != null) {
            Pair<SpawningContext, SpawnDetail> pair2 = pair;
            boolean bl2 = false;
            SpawnDetail spawn = (SpawnDetail)pair2.component2();
            SpawnAction<?> action = spawn.doSpawn(context);
            action.complete();
            return action.getFuture();
        }
        return null;
    }

    public static /* synthetic */ CompletableFuture run$default(TriggerSpawner triggerSpawner, SpawnCause spawnCause, class_3218 class_32182, class_2338 class_23382, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: run");
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return triggerSpawner.run(spawnCause, class_32182, class_23382, list);
    }

    @Nullable
    public abstract SpawningContext parseContext(@NotNull T var1, @NotNull class_3218 var2, @NotNull class_2338 var3);

    @Override
    public boolean canSpawn() {
        return true;
    }

    @Override
    @NotNull
    public SpawningSelector getSpawningSelector() {
        return this.selector;
    }

    @Override
    public void setSpawningSelector(@NotNull SpawningSelector selector) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        this.selector = selector;
    }

    @Override
    @NotNull
    public SpawnPool getSpawnPool() {
        return this.spawns;
    }

    @Override
    public void setSpawnPool(@NotNull SpawnPool spawnPool) {
        Intrinsics.checkNotNullParameter((Object)spawnPool, (String)"spawnPool");
        this.spawns = spawnPool;
    }

    @Override
    public <R> void afterSpawn(@NotNull SpawnAction<R> action, R result) {
        Spawner.DefaultImpls.afterSpawn(this, action, result);
    }

    @Override
    @NotNull
    public List<SpawnDetail> getMatchingSpawns(@NotNull SpawningContext ctx) {
        return Spawner.DefaultImpls.getMatchingSpawns(this, ctx);
    }

    @Override
    @NotNull
    public List<SpawningInfluence> copyInfluences() {
        return Spawner.DefaultImpls.copyInfluences(this);
    }

    @Override
    @NotNull
    public SpawnBucket chooseBucket() {
        return Spawner.DefaultImpls.chooseBucket(this);
    }
}

