/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.adapter.conversions;

import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.experience.SidemodExperienceSource;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.adapter.conversions.CobblemonConverter;
import com.cobblemon.mod.common.api.storage.adapter.conversions.ReforgedConversion;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.pokeball.PokeBall;
import com.cobblemon.mod.common.pokemon.EVs;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002()B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJI\u0010\u0013\u001a\u0004\u0018\u00018\u0001\"\b\b\u0000\u0010\n*\u00020\t\"\u000e\b\u0001\u0010\f*\b\u0012\u0004\u0012\u00028\u00000\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ5\u0010$\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\f2\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010!\u001a\u00020 2\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\"\u00a2\u0006\u0004\b$\u0010%R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010&\u001a\u0004\b'\u0010\b\u00a8\u0006*"}, d2={"Lcom/cobblemon/mod/common/api/storage/adapter/conversions/ReforgedConversion;", "Lcom/cobblemon/mod/common/api/storage/adapter/conversions/CobblemonConverter;", "Lnet/minecraft/class_2487;", "Ljava/nio/file/Path;", "base", "<init>", "(Ljava/nio/file/Path;)V", "root", "()Ljava/nio/file/Path;", "Lcom/cobblemon/mod/common/api/storage/StorePosition;", "E", "Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "T", "Ljava/lang/Class;", "storeClass", "Ljava/util/UUID;", "uuid", "Lnet/minecraft/class_5455;", "registryAccess", "load", "(Ljava/lang/Class;Ljava/util/UUID;Lnet/minecraft/class_5455;)Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "user", "nbt", "Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;", "party", "(Ljava/util/UUID;Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;", "Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "pc", "(Ljava/util/UUID;Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "translate", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "", "key", "Lcom/cobblemon/mod/common/api/storage/adapter/conversions/ReforgedConversion$Translator;", "translator", "find", "(Lnet/minecraft/class_2487;Ljava/lang/String;Lcom/cobblemon/mod/common/api/storage/adapter/conversions/ReforgedConversion$Translator;)Ljava/lang/Object;", "Ljava/nio/file/Path;", "getBase", "Translator", "ReforgedNatures", "common"})
@SourceDebugExtension(value={"SMAP\nReforgedConversion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReforgedConversion.kt\ncom/cobblemon/mod/common/api/storage/adapter/conversions/ReforgedConversion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1#2:194\n2632#3,3:195\n1863#3,2:198\n1863#3,2:200\n*S KotlinDebug\n*F\n+ 1 ReforgedConversion.kt\ncom/cobblemon/mod/common/api/storage/adapter/conversions/ReforgedConversion\n*L\n104#1:195,3\n127#1:198,2\n130#1:200,2\n*E\n"})
public final class ReforgedConversion
implements CobblemonConverter<class_2487> {
    @NotNull
    private final Path base;

    public ReforgedConversion(@NotNull Path base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        this.base = base;
    }

    @NotNull
    public final Path getBase() {
        return this.base;
    }

    @Override
    @NotNull
    public Path root() {
        Path path = this.base.resolve("data").resolve("pokemon");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @Override
    @Nullable
    public <E extends StorePosition, T extends PokemonStore<E>> T load(@NotNull Class<T> storeClass, @NotNull UUID uuid, @NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter(storeClass, (String)"storeClass");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        String string = storeClass.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String extension = Intrinsics.areEqual((Object)string2, (Object)"playerpartystore") ? "pk" : "comp";
        Path target = this.root().resolve(uuid + "." + extension);
        Intrinsics.checkNotNull((Object)target);
        if (!this.exists(target)) {
            return null;
        }
        class_2487 nbt = class_2507.method_10633((Path)target);
        if (nbt != null) {
            PokemonStore pokemonStore = Intrinsics.areEqual((Object)extension, (Object)"pk") ? (PokemonStore)this.party(uuid, nbt) : (PokemonStore)this.pc(uuid, nbt);
            Intrinsics.checkNotNull((Object)pokemonStore, (String)"null cannot be cast to non-null type T of com.cobblemon.mod.common.api.storage.adapter.conversions.ReforgedConversion.load");
            return (T)pokemonStore;
        }
        return null;
    }

    @Override
    @NotNull
    public PlayerPartyStore party(@NotNull UUID user, @NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        PlayerPartyStore result = new PlayerPartyStore(user);
        for (int x = 0; x < 6; ++x) {
            String key = "party" + x;
            if (!nbt.method_10545(key)) continue;
            class_2487 class_24872 = nbt.method_10562(key);
            Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"getCompound(...)");
            result.add(this.translate(class_24872));
        }
        return result;
    }

    @Override
    @NotNull
    public PCStore pc(@NotNull UUID user, @NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        PCStore result = new PCStore(user);
        int box = 0;
        while (nbt.method_10545("BoxNumber" + box)) {
            class_2487 storage = nbt.method_10562("BoxNumber" + box);
            for (int x = 0; x < 30; ++x) {
                if (!storage.method_10545("pc" + x)) continue;
                class_2487 class_24872 = storage.method_10562("pc" + x);
                Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"getCompound(...)");
                Pokemon pokemon = this.translate(class_24872);
                if (result.add(pokemon)) continue;
                result.getBackupStore().add(pokemon);
            }
            ++box;
        }
        result.tryRestoreBackedUpPokemon();
        return result;
    }

    @Override
    @NotNull
    public Pokemon translate(@NotNull class_2487 nbt) {
        PokeBall pokeBall;
        String ball2;
        Object element$iv;
        Object object;
        Iterator $this$none$iv;
        boolean bl2;
        FormData formData;
        Object v1;
        Object it;
        PokemonProperties.Companion companion;
        Pokemon result;
        block16: {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            result = new Pokemon();
            result.setUuid(nbt.method_25926("UUID"));
            Species species = PokemonSpecies.getByPokedexNumber$default(PokemonSpecies.INSTANCE, nbt.method_10550("ndex"), null, 2, null);
            if (species == null) {
                throw new IllegalStateException("Failed to read a species with pokedex identifier " + nbt.method_10550("ndex"));
            }
            result.setSpecies(species);
            Iterable iterable = result.getSpecies().getForms();
            companion = PokemonProperties.Companion;
            Iterable iterable2 = iterable;
            for (Object object2 : iterable2) {
                it = (FormData)object2;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)((FormData)it).getName(), (Object)nbt.method_10558("Variant"))) continue;
                v1 = object2;
                break block16;
            }
            v1 = null;
        }
        if ((formData = (FormData)v1) == null) {
            formData = result.getSpecies().getStandardForm();
        }
        PokemonProperties.Companion.parse$default(companion, formData.getName(), null, null, 6, null).apply(result);
        result.setGender(Gender.values()[nbt.method_10550("Gender")]);
        Boolean bl4 = (Boolean)this.find(nbt, "IsShiny", translate.2.INSTANCE);
        if (bl4 != null) {
            bl2 = bl4;
        } else {
            String string = (String)this.find(nbt, "palette", translate.3.INSTANCE);
            Boolean bl5 = string != null ? Boolean.valueOf(string.equals("shiny")) : null;
            bl2 = bl5 != null ? bl5 : false;
        }
        result.setShiny(bl2);
        result.setLevel(nbt.method_10550("Level"));
        result.addExperience(new SidemodExperienceSource("Reforged"), nbt.method_10550("EXP"));
        Pokemon.setFriendship$default(result, nbt.method_10550("Friendship"), false, 2, null);
        String string = nbt.method_10558("Ability");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        AbilityTemplate abilityTemplate = Abilities.INSTANCE.get(string);
        if (abilityTemplate != null) {
            boolean bl6;
            Pokemon bl3;
            block17: {
                Object object2;
                AbilityTemplate template = abilityTemplate;
                boolean bl7 = false;
                object2 = result.getForm().getAbilities();
                it = template;
                bl3 = result;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)((Object)$this$none$iv)).isEmpty()) {
                    bl6 = true;
                } else {
                    object = $this$none$iv.iterator();
                    while (object.hasNext()) {
                        Object element$iv2 = object.next();
                        PotentialAbility it2 = (PotentialAbility)element$iv2;
                        boolean bl8 = false;
                        if (!Intrinsics.areEqual((Object)it2.getTemplate(), (Object)template)) continue;
                        bl6 = false;
                        break block17;
                    }
                    bl6 = true;
                }
            }
            boolean bl9 = bl6;
            bl3.updateAbility(AbilityTemplate.create$default((AbilityTemplate)it, bl9, null, 2, null));
        }
        String string2 = ((ReforgedNatures)((Object)ReforgedNatures.getEntries().get(nbt.method_10550("Nature")))).name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        class_2960 class_29602 = class_2960.method_60654((String)string2);
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"parse(...)");
        Nature nature = Natures.INSTANCE.getNature(class_29602);
        if (nature == null) {
            nature = Natures.INSTANCE.getRandomNature();
        }
        result.setNature(nature);
        String string3 = ((ReforgedNatures)((Object)ReforgedNatures.getEntries().get(nbt.method_10550("MintNature")))).name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        class_2960 class_29603 = class_2960.method_60654((String)string3);
        Intrinsics.checkNotNullExpressionValue((Object)class_29603, (String)"parse(...)");
        result.setMintedNature(Natures.INSTANCE.getNature(class_29603));
        result.setCurrentHealth(nbt.method_10550("Health"));
        IVs ivs = new IVs();
        ivs.set(Stats.HP, nbt.method_10550("IVHP"));
        ivs.set(Stats.ATTACK, nbt.method_10550("IVAttack"));
        ivs.set(Stats.DEFENCE, nbt.method_10550("IVDefense"));
        ivs.set(Stats.SPECIAL_ATTACK, nbt.method_10550("IVSpAtt"));
        ivs.set(Stats.SPECIAL_DEFENCE, nbt.method_10550("IVSpDef"));
        ivs.set(Stats.SPEED, nbt.method_10550("IVSpeed"));
        EVs evs = new EVs();
        evs.set(Stats.HP, nbt.method_10550("EVHP"));
        evs.set(Stats.ATTACK, nbt.method_10550("EVAttack"));
        evs.set(Stats.DEFENCE, nbt.method_10550("EVDefense"));
        evs.set(Stats.SPECIAL_ATTACK, nbt.method_10550("EVSpecialAttack"));
        evs.set(Stats.SPECIAL_DEFENCE, nbt.method_10550("EVSpecialDefense"));
        evs.set(Stats.SPEED, nbt.method_10550("EVSpeed"));
        Object $this$forEach$iv = ivs;
        boolean $i$f$forEach = false;
        $this$none$iv = $this$forEach$iv.iterator();
        while ($this$none$iv.hasNext()) {
            element$iv = $this$none$iv.next();
            Map.Entry stat = (Map.Entry)element$iv;
            boolean bl10 = false;
            result.setIV((Stat)stat.getKey(), ((Number)stat.getValue()).intValue());
        }
        $this$forEach$iv = evs;
        $i$f$forEach = false;
        $this$none$iv = $this$forEach$iv.iterator();
        while ($this$none$iv.hasNext()) {
            element$iv = $this$none$iv.next();
            Map.Entry stat = (Map.Entry)element$iv;
            boolean bl11 = false;
            result.setEV((Stat)stat.getKey(), ((Number)stat.getValue()).intValue());
        }
        Iterator iterator = nbt.method_10554("Moveset", 10).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        $this$forEach$iv = iterator;
        while ($this$forEach$iv.hasNext()) {
            class_2520 move = (class_2520)$this$forEach$iv.next();
            Intrinsics.checkNotNull((Object)move, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            class_2487 compound = (class_2487)move;
            String string4 = compound.method_10558("MoveID");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
            CharSequence stat = string4;
            Regex bl11 = new Regex("[-\\s]", RegexOption.IGNORE_CASE);
            object = "";
            String id = bl11.replace(stat, (String)object);
            int pp = compound.method_10550("MovePP");
            int level = compound.method_10550("MovePPLevel");
            String string5 = id.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
            MoveTemplate template = Moves.INSTANCE.getByNameOrDummy(string5);
            result.getMoveSet().add(template.create(pp, level));
        }
        String string6 = ball2 = (String)this.find(nbt, "CaughtBall", translate.ball.1.INSTANCE);
        if (string6 != null) {
            class_2960 class_29604 = class_2960.method_60654((String)string6);
            Intrinsics.checkNotNullExpressionValue((Object)class_29604, (String)"parse(...)");
            pokeBall = PokeBalls.INSTANCE.getPokeBall(class_29604);
            if (pokeBall == null) {
                pokeBall = PokeBalls.INSTANCE.getPOKE_BALL();
            }
        } else {
            pokeBall = PokeBalls.INSTANCE.getPOKE_BALL();
        }
        result.setCaughtBall(pokeBall);
        return result;
    }

    @Nullable
    public final <T> T find(@NotNull class_2487 nbt, @NotNull String key, @NotNull Translator<? extends T> translator) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(translator, (String)"translator");
        if (nbt.method_10545(key)) {
            return translator.from(nbt, key);
        }
        return null;
    }

    @Override
    public boolean exists(@NotNull Path target) {
        return CobblemonConverter.DefaultImpls.exists(this, target);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u001c\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001c\u00a8\u0006\u001d"}, d2={"Lcom/cobblemon/mod/common/api/storage/adapter/conversions/ReforgedConversion$ReforgedNatures;", "", "<init>", "(Ljava/lang/String;I)V", "HARDY", "SERIOUS", "DOCILE", "BASHFUL", "QUIRKY", "LONELY", "BRAVE", "ADAMANT", "NAUGHTY", "BOLD", "RELAXED", "IMPISH", "LAX", "TIMID", "HASTY", "JOLLY", "NAIVE", "MODEST", "MILD", "QUIET", "RASH", "CALM", "GENTLE", "SASSY", "CAREFUL", "common"})
    public static final class ReforgedNatures
    extends Enum<ReforgedNatures> {
        public static final /* enum */ ReforgedNatures HARDY = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures SERIOUS = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures DOCILE = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures BASHFUL = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures QUIRKY = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures LONELY = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures BRAVE = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures ADAMANT = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures NAUGHTY = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures BOLD = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures RELAXED = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures IMPISH = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures LAX = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures TIMID = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures HASTY = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures JOLLY = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures NAIVE = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures MODEST = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures MILD = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures QUIET = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures RASH = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures CALM = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures GENTLE = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures SASSY = new ReforgedNatures();
        public static final /* enum */ ReforgedNatures CAREFUL = new ReforgedNatures();
        private static final /* synthetic */ ReforgedNatures[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ReforgedNatures[] values() {
            return (ReforgedNatures[])$VALUES.clone();
        }

        public static ReforgedNatures valueOf(String value) {
            return Enum.valueOf(ReforgedNatures.class, value);
        }

        @NotNull
        public static EnumEntries<ReforgedNatures> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = reforgedNaturesArray = new ReforgedNatures[]{ReforgedNatures.HARDY, ReforgedNatures.SERIOUS, ReforgedNatures.DOCILE, ReforgedNatures.BASHFUL, ReforgedNatures.QUIRKY, ReforgedNatures.LONELY, ReforgedNatures.BRAVE, ReforgedNatures.ADAMANT, ReforgedNatures.NAUGHTY, ReforgedNatures.BOLD, ReforgedNatures.RELAXED, ReforgedNatures.IMPISH, ReforgedNatures.LAX, ReforgedNatures.TIMID, ReforgedNatures.HASTY, ReforgedNatures.JOLLY, ReforgedNatures.NAIVE, ReforgedNatures.MODEST, ReforgedNatures.MILD, ReforgedNatures.QUIET, ReforgedNatures.RASH, ReforgedNatures.CALM, ReforgedNatures.GENTLE, ReforgedNatures.SASSY, ReforgedNatures.CAREFUL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00e6\u0080\u0001\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J!\u0010\u0007\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/api/storage/adapter/conversions/ReforgedConversion$Translator;", "R", "", "Lnet/minecraft/class_2487;", "nbt", "", "key", "from", "(Lnet/minecraft/class_2487;Ljava/lang/String;)Ljava/lang/Object;", "common"})
    public static interface Translator<R> {
        @Nullable
        public R from(@NotNull class_2487 var1, @NotNull String var2);
    }
}

