/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.pc;

import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.api.storage.InvalidSpeciesException;
import com.cobblemon.mod.common.api.storage.StoreCoordinates;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.net.messages.client.storage.pc.SetPCBoxPokemonPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\t\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0096\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\nH\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\"\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010%\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010'\u001a\u00020\u00002\u0006\u0010$\u001a\u00020#2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b'\u0010(J\u001f\u0010)\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b)\u0010*J\u001b\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00020+H\u0016\u00a2\u0006\u0004\b,\u0010-J'\u0010/\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00020.0+H\u0016\u00a2\u0006\u0004\b/\u0010-R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u00100\u001a\u0004\b1\u00102R\u001d\u00104\u001a\b\u0012\u0004\u0012\u00020\u000f038\u0006\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R\"\u00109\u001a\u0002088\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\"\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020?8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010@\u001a\u0004\bA\u0010BR\u0011\u0010E\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0011\u0010G\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010D\u00a8\u0006H"}, d2={"Lcom/cobblemon/mod/common/api/storage/pc/PCBox;", "", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "pc", "<init>", "(Lcom/cobblemon/mod/common/api/storage/pc/PCStore;)V", "", "iterator", "()Ljava/util/Iterator;", "", "index", "get", "(I)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "set", "(ILcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "getFirstAvailablePosition", "()Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "initialize", "()V", "trackPokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Lnet/minecraft/class_3222;", "player", "sendTo", "(Lnet/minecraft/class_3222;)V", "Lnet/minecraft/class_2487;", "nbt", "Lnet/minecraft/class_5455;", "registryAccess", "saveToNBT", "(Lnet/minecraft/class_2487;Lnet/minecraft/class_5455;)Lnet/minecraft/class_2487;", "Lcom/google/gson/JsonObject;", "json", "saveToJSON", "(Lcom/google/gson/JsonObject;Lnet/minecraft/class_5455;)Lcom/google/gson/JsonObject;", "loadFromJSON", "(Lcom/google/gson/JsonObject;Lnet/minecraft/class_5455;)Lcom/cobblemon/mod/common/api/storage/pc/PCBox;", "loadFromNBT", "(Lnet/minecraft/class_2487;Lnet/minecraft/class_5455;)Lcom/cobblemon/mod/common/api/storage/pc/PCBox;", "", "getNonEmptySlots", "()Ljava/util/Map;", "Lkotlin/Function1;", "getNonEmptySlotsForPackets", "Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "getPc", "()Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "boxChangeEmitter", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getBoxChangeEmitter", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "", "emit", "Z", "getEmit", "()Z", "setEmit", "(Z)V", "", "[Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getPokemon", "()[Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getBoxNumber", "()I", "boxNumber", "getUnoccupiedSlots", "unoccupiedSlots", "common"})
@SourceDebugExtension(value={"SMAP\nPCBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PCBox.kt\ncom/cobblemon/mod/common/api/storage/pc/PCBox\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,152:1\n13411#2,3:153\n774#3:156\n865#3,2:157\n1279#3,2:159\n1293#3,4:161\n1246#3,4:167\n462#4:165\n412#4:166\n*S KotlinDebug\n*F\n+ 1 PCBox.kt\ncom/cobblemon/mod/common/api/storage/pc/PCBox\n*L\n81#1:153,3\n150#1:156\n150#1:157,2\n150#1:159,2\n150#1:161,4\n151#1:167,4\n151#1:165\n151#1:166\n*E\n"})
public class PCBox
implements Iterable<Pokemon>,
KMappedMarker {
    @NotNull
    private final PCStore pc;
    @NotNull
    private final SimpleObservable<Unit> boxChangeEmitter;
    private boolean emit;
    @NotNull
    private final Pokemon[] pokemon;

    public PCBox(@NotNull PCStore pc) {
        Intrinsics.checkNotNullParameter((Object)pc, (String)"pc");
        this.pc = pc;
        this.boxChangeEmitter = new SimpleObservable();
        this.emit = true;
        int n = 0;
        Pokemon[] pokemonArray = new Pokemon[30];
        PCBox pCBox = this;
        while (n < 30) {
            int n2 = n++;
            pokemonArray[n2] = null;
        }
        pCBox.pokemon = pokemonArray;
    }

    @NotNull
    public final PCStore getPc() {
        return this.pc;
    }

    @Override
    @NotNull
    public Iterator<Pokemon> iterator() {
        return ArraysKt.filterNotNull((Object[])this.pokemon).iterator();
    }

    @NotNull
    public final SimpleObservable<Unit> getBoxChangeEmitter() {
        return this.boxChangeEmitter;
    }

    protected final boolean getEmit() {
        return this.emit;
    }

    protected final void setEmit(boolean bl2) {
        this.emit = bl2;
    }

    @NotNull
    protected final Pokemon[] getPokemon() {
        return this.pokemon;
    }

    @Nullable
    public Pokemon get(int index) {
        return (0 <= index ? index < 30 : false) ? this.pokemon[index] : null;
    }

    public void set(int index, @Nullable Pokemon pokemon) {
        block4: {
            block5: {
                block6: {
                    StoreCoordinates<?> previousCoordinates;
                    boolean bl2 = 0 <= index ? index < 30 : false;
                    if (!bl2) break block4;
                    this.pokemon[index] = pokemon;
                    if (pokemon == null) break block5;
                    StoreCoordinates<?> storeCoordinates = previousCoordinates = pokemon.getStoreCoordinates().get();
                    Object position = storeCoordinates != null ? storeCoordinates.getPosition() : null;
                    pokemon.getStoreCoordinates().set(new StoreCoordinates<StorePosition>(this.pc, new PCPosition(this.getBoxNumber(), index)));
                    StoreCoordinates<?> storeCoordinates2 = previousCoordinates;
                    if (!((storeCoordinates2 != null ? storeCoordinates2.getStore() : null) instanceof PCStore) || !Intrinsics.areEqual((Object)((PCStore)previousCoordinates.getStore()).getUuid(), (Object)this.pc.getUuid())) break block6;
                    Intrinsics.checkNotNull(position, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.api.storage.pc.PCPosition");
                    if (((PCPosition)position).getBox() == this.getBoxNumber()) break block5;
                }
                this.trackPokemon(pokemon);
            }
            if (this.emit) {
                Unit[] unitArray = new Unit[]{Unit.INSTANCE};
                this.boxChangeEmitter.emit((Unit[])unitArray);
            }
        }
    }

    public final int getBoxNumber() {
        return this.pc.getBoxes().indexOf(this);
    }

    public final int getUnoccupiedSlots() {
        return 30 - ((Collection)ArraysKt.filterNotNull((Object[])this.pokemon)).size();
    }

    @Nullable
    public final PCPosition getFirstAvailablePosition() {
        for (int index = 0; index < 30; ++index) {
            if (this.pokemon[index] != null) continue;
            return new PCPosition(this.getBoxNumber(), index);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void initialize() {
        int box = this.getBoxNumber();
        Pokemon[] $this$forEachIndexed$iv = this.pokemon;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Pokemon item$iv : $this$forEachIndexed$iv) {
            void pokemon;
            int n = index$iv++;
            Pokemon pokemon2 = item$iv;
            int slot = n;
            boolean bl2 = false;
            if (pokemon == null) continue;
            PCPosition position = new PCPosition(box, slot);
            pokemon.getStoreCoordinates().set(new StoreCoordinates<StorePosition>(this.pc, position));
            this.trackPokemon((Pokemon)pokemon);
        }
        Observable.DefaultImpls.subscribe$default(this.boxChangeEmitter, null, arg_0 -> PCBox.initialize$lambda$1(this, arg_0), 1, null);
    }

    public final void trackPokemon(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Observable.DefaultImpls.subscribe$default(pokemon.getChangeObservable().pipe(Observable.Companion.stopAfter(arg_0 -> PCBox.trackPokemon$lambda$2(this, arg_0))), null, arg_0 -> PCBox.trackPokemon$lambda$3(this, arg_0), 1, null);
    }

    public final void sendTo(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        new SetPCBoxPokemonPacket(this).sendToPlayer(player);
    }

    @NotNull
    public class_2487 saveToNBT(@NotNull class_2487 nbt, @NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        for (int slot = 0; slot < 30; ++slot) {
            Pokemon pokemon;
            if (this.pokemon[slot] == null) continue;
            nbt.method_10566("Slot" + slot, (class_2520)Pokemon.saveToNBT$default(pokemon, registryAccess, null, 2, null));
        }
        return nbt;
    }

    @NotNull
    public JsonObject saveToJSON(@NotNull JsonObject json, @NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        for (int slot = 0; slot < 30; ++slot) {
            Pokemon pokemon;
            if (this.pokemon[slot] == null) continue;
            json.add("Slot" + slot, (JsonElement)Pokemon.saveToJSON$default(pokemon, registryAccess, null, 2, null));
        }
        return json;
    }

    @NotNull
    public PCBox loadFromJSON(@NotNull JsonObject json, @NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        for (int slot = 0; slot < 30; ++slot) {
            if (!json.has("Slot" + slot)) continue;
            JsonObject pokemonJson = json.getAsJsonObject("Slot" + slot);
            try {
                Intrinsics.checkNotNull((Object)pokemonJson);
                this.pokemon[slot] = Pokemon.Companion.loadFromJSON(registryAccess, pokemonJson);
                continue;
            }
            catch (InvalidSpeciesException invalidSpeciesException) {
                Intrinsics.checkNotNull((Object)pokemonJson);
                this.pc.handleInvalidSpeciesJSON(pokemonJson);
            }
        }
        return this;
    }

    @NotNull
    public PCBox loadFromNBT(@NotNull class_2487 nbt, @NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        for (int slot = 0; slot < 30; ++slot) {
            if (!nbt.method_10545("Slot" + slot)) continue;
            class_2487 pokemonNBT = nbt.method_10562("Slot" + slot);
            try {
                Intrinsics.checkNotNull((Object)pokemonNBT);
                this.pokemon[slot] = Pokemon.Companion.loadFromNBT(registryAccess, pokemonNBT);
                continue;
            }
            catch (InvalidSpeciesException invalidSpeciesException) {
                Intrinsics.checkNotNull((Object)pokemonNBT);
                this.pc.handleInvalidSpeciesNBT(pokemonNBT);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<Integer, Pokemon> getNonEmptySlots() {
        int it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)RangesKt.until((int)0, (int)30);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = ((Number)element$iv$iv).intValue();
            boolean bl2 = false;
            if (!(this.get(it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Pokemon pokemon;
            it = ((Number)element$iv$iv).intValue();
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)this.get(it));
            map.put(t, pokemon);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<Integer, Function1<class_5455, Pokemon>> getNonEmptySlotsForPackets() {
        void $this$mapValuesTo$iv$iv;
        Map<Integer, Pokemon> $this$mapValues$iv = this.getNonEmptySlots();
        boolean $i$f$mapValues = false;
        Map<Integer, Pokemon> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl3 = false;
            Pokemon pokemon = (Pokemon)entry2.getValue();
            Function1 function1 = arg_0 -> PCBox.getNonEmptySlotsForPackets$lambda$7$lambda$6(pokemon, arg_0);
            map3.put(k, function1);
        }
        return destination$iv$iv;
    }

    private static final Unit initialize$lambda$1(PCBox this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Unit[] unitArray = new Unit[]{Unit.INSTANCE};
        this$0.pc.getPcChangeObservable().emit((Unit[])unitArray);
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean trackPokemon$lambda$2(PCBox this$0, Pokemon it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StoreCoordinates<?> storeCoordinates = it.getStoreCoordinates().get();
        if (storeCoordinates == null) {
            return true;
        }
        StoreCoordinates<?> coordinates = storeCoordinates;
        if (!(coordinates.getStore() instanceof PCStore)) return true;
        if (!Intrinsics.areEqual((Object)((PCStore)coordinates.getStore()).getUuid(), (Object)this$0.pc.getUuid())) return true;
        Object obj = coordinates.getPosition();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.api.storage.pc.PCPosition");
        if (((PCPosition)obj).getBox() == this$0.getBoxNumber()) return false;
        return true;
    }

    private static final Unit trackPokemon$lambda$3(PCBox this$0, Pokemon it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Unit[] unitArray = new Unit[]{Unit.INSTANCE};
        this$0.boxChangeEmitter.emit((Unit[])unitArray);
        return Unit.INSTANCE;
    }

    private static final Pokemon getNonEmptySlotsForPackets$lambda$7$lambda$6(Pokemon $pokemon, class_5455 class_54552) {
        Intrinsics.checkNotNullParameter((Object)$pokemon, (String)"$pokemon");
        Intrinsics.checkNotNullParameter((Object)class_54552, (String)"<unused var>");
        return $pokemon;
    }
}

