/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.pc;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.api.molang.ObjectValue;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.api.storage.BottomlessStore;
import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.StoreCoordinates;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.pc.PCBox;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.net.messages.client.storage.RemoveClientPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.storage.SwapClientPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.storage.pc.InitializePCPacket;
import com.cobblemon.mod.common.net.messages.client.storage.pc.MoveClientPCPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.storage.pc.SetPCPokemonPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0017\u0010\tJ\u0011\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u0015J\u000f\u0010\u001f\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010\"\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u000b\u00a2\u0006\u0004\b\"\u0010#J5\u0010)\u001a\u00020\u00132\u0006\u0010%\u001a\u00020$2\b\b\u0002\u0010&\u001a\u00020\u001b2\u0014\b\u0002\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00130'\u00a2\u0006\u0004\b)\u0010*J\r\u0010+\u001a\u00020\u0013\u00a2\u0006\u0004\b+\u0010 J\u001f\u00100\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010/\u001a\u00020.H\u0016\u00a2\u0006\u0004\b0\u00101J%\u00102\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010-\u001a\u00020,2\u0006\u0010/\u001a\u00020.H\u0016\u00a2\u0006\u0004\b2\u00103J\r\u00104\u001a\u00020\u0013\u00a2\u0006\u0004\b4\u0010 J\u001f\u00107\u001a\u0002052\u0006\u00106\u001a\u0002052\u0006\u0010/\u001a\u00020.H\u0016\u00a2\u0006\u0004\b7\u00108J%\u00109\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u00106\u001a\u0002052\u0006\u0010/\u001a\u00020.H\u0016\u00a2\u0006\u0004\b9\u0010:J \u0010;\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0004\b;\u0010<J\u0017\u0010=\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b=\u0010>J\u001f\u0010A\u001a\u00020\u00132\u0006\u0010?\u001a\u00020\u00022\u0006\u0010@\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\bA\u0010BJ\u001d\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00020C2\u0006\u0010-\u001a\u00020,H\u0016\u00a2\u0006\u0004\bD\u0010EJ\u001f\u0010F\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010-\u001a\u00020,H\u0016\u00a2\u0006\u0004\bF\u0010GJ\u0015\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00130HH\u0016\u00a2\u0006\u0004\bI\u0010JJ!\u0010K\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00022\b\u0010!\u001a\u0004\u0018\u00010\u000bH\u0014\u00a2\u0006\u0004\bK\u0010<J\u001a\u0010L\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\bL\u0010MJ\r\u0010N\u001a\u00020\u0013\u00a2\u0006\u0004\bN\u0010 R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010O\u001a\u0004\bP\u0010QR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010R\u001a\u0004\bS\u0010TR\u001d\u0010W\u001a\b\u0012\u0004\u0012\u00020V0U8\u0006\u00a2\u0006\f\n\u0004\bW\u0010X\u001a\u0004\bY\u0010\u0011R\"\u0010Z\u001a\u00020\u001b8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bZ\u0010[\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R\u0017\u0010a\u001a\u00020`8\u0006\u00a2\u0006\f\n\u0004\ba\u0010b\u001a\u0004\bc\u0010dR\u001d\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00030e8\u0006\u00a2\u0006\f\n\u0004\bf\u0010g\u001a\u0004\bh\u0010iR\u001d\u0010k\u001a\b\u0012\u0004\u0012\u00020\u00000j8\u0006\u00a2\u0006\f\n\u0004\bk\u0010l\u001a\u0004\bm\u0010nR\u001d\u0010o\u001a\b\u0012\u0004\u0012\u00020\u00130H8\u0006\u00a2\u0006\f\n\u0004\bo\u0010p\u001a\u0004\bq\u0010J\u00a8\u0006r"}, d2={"Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "Ljava/util/UUID;", "uuid", "Lnet/minecraft/class_5250;", "name", "<init>", "(Ljava/util/UUID;Lnet/minecraft/class_5250;)V", "(Ljava/util/UUID;)V", "", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "iterator", "()Ljava/util/Iterator;", "", "Lnet/minecraft/class_3222;", "getObservingPlayers", "()Ljava/util/List;", "player", "", "addObserver", "(Lnet/minecraft/class_3222;)V", "playerID", "removeObserver", "getFirstAvailablePosition", "()Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "position", "", "isValidPosition", "(Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;)Z", "sendTo", "initialize", "()V", "pokemon", "relocateEvictedBoxPokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "", "newSize", "lockNewSize", "Lkotlin/Function1;", "overflowHandler", "resize", "(IZLkotlin/jvm/functions/Function1;)V", "tryRestoreBackedUpPokemon", "Lnet/minecraft/class_2487;", "nbt", "Lnet/minecraft/class_5455;", "registryAccess", "saveToNBT", "(Lnet/minecraft/class_2487;Lnet/minecraft/class_5455;)Lnet/minecraft/class_2487;", "loadFromNBT", "(Lnet/minecraft/class_2487;Lnet/minecraft/class_5455;)Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "removeDuplicates", "Lcom/google/gson/JsonObject;", "json", "saveToJSON", "(Lcom/google/gson/JsonObject;Lnet/minecraft/class_5455;)Lcom/google/gson/JsonObject;", "loadFromJSON", "(Lcom/google/gson/JsonObject;Lnet/minecraft/class_5455;)Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "set", "(Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "remove", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "position1", "position2", "swap", "(Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;)V", "Lcom/cobblemon/mod/common/api/storage/StoreCoordinates;", "loadPositionFromNBT", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/api/storage/StoreCoordinates;", "savePositionToNBT", "(Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;Lnet/minecraft/class_2487;)V", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getAnyChangeObservable", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "setAtPosition", "get", "(Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "clearPC", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "Lnet/minecraft/class_5250;", "getName", "()Lnet/minecraft/class_5250;", "", "Lcom/cobblemon/mod/common/api/storage/pc/PCBox;", "boxes", "Ljava/util/List;", "getBoxes", "lockedSize", "Z", "getLockedSize", "()Z", "setLockedSize", "(Z)V", "Lcom/cobblemon/mod/common/api/storage/BottomlessStore;", "backupStore", "Lcom/cobblemon/mod/common/api/storage/BottomlessStore;", "getBackupStore", "()Lcom/cobblemon/mod/common/api/storage/BottomlessStore;", "", "observingUUIDs", "Ljava/util/Set;", "getObservingUUIDs", "()Ljava/util/Set;", "Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "struct", "Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "getStruct", "()Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "pcChangeObservable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getPcChangeObservable", "common"})
@SourceDebugExtension(value={"SMAP\nPCStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PCStore.kt\ncom/cobblemon/mod/common/api/storage/pc/PCStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,260:1\n1368#2:261\n1454#2,5:262\n1611#2,9:267\n1863#2:276\n1864#2:278\n1620#2:279\n1863#2:280\n1864#2:282\n1863#2,2:283\n1863#2,2:285\n1368#2:287\n1454#2,5:288\n1863#2,2:293\n1872#2,3:295\n1872#2,3:298\n1863#2:301\n1864#2:304\n1#3:277\n1#3:281\n216#4,2:302\n*S KotlinDebug\n*F\n+ 1 PCStore.kt\ncom/cobblemon/mod/common/api/storage/pc/PCStore\n*L\n56#1:261\n56#1:262,5\n57#1:267,9\n57#1:276\n57#1:278\n57#1:279\n72#1:280\n72#1:282\n82#1:283,2\n86#1:285,2\n109#1:287\n109#1:288,5\n109#1:293,2\n134#1:295,3\n176#1:298,3\n254#1:301\n254#1:304\n57#1:277\n255#1:302,2\n*E\n"})
public class PCStore
extends PokemonStore<PCPosition> {
    @NotNull
    private final UUID uuid;
    @NotNull
    private final class_5250 name;
    @NotNull
    private final List<PCBox> boxes;
    private boolean lockedSize;
    @NotNull
    private final BottomlessStore backupStore;
    @NotNull
    private final Set<UUID> observingUUIDs;
    @NotNull
    private final ObjectValue<PCStore> struct;
    @NotNull
    private final SimpleObservable<Unit> pcChangeObservable;

    public PCStore(@NotNull UUID uuid, @NotNull class_5250 name) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.uuid = uuid;
        this.name = name;
        this.boxes = new ArrayList();
        this.backupStore = new BottomlessStore(new UUID(0L, 0L));
        Object[] objectArray = new UUID[]{this.uuid};
        this.observingUUIDs = SetsKt.mutableSetOf((Object[])objectArray);
        this.struct = MoLangFunctions.INSTANCE.asMoLangValue(this);
        this.pcChangeObservable = new SimpleObservable();
    }

    @Override
    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final class_5250 getName() {
        return this.name;
    }

    public PCStore(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        class_5250 class_52502 = LocalizationUtilsKt.lang("your_pc", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"lang(...)");
        this(uuid, class_52502);
    }

    @NotNull
    public final List<PCBox> getBoxes() {
        return this.boxes;
    }

    protected final boolean getLockedSize() {
        return this.lockedSize;
    }

    protected final void setLockedSize(boolean bl2) {
        this.lockedSize = bl2;
    }

    @NotNull
    public final BottomlessStore getBackupStore() {
        return this.backupStore;
    }

    @NotNull
    public final Set<UUID> getObservingUUIDs() {
        return this.observingUUIDs;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<Pokemon> iterator() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.boxes;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PCBox it = (PCBox)element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = CollectionsKt.toList((Iterable)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return ((List)destination$iv$iv).iterator();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<class_3222> getObservingPlayers() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.observingUUIDs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            class_3222 it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            UUID it = (UUID)element$iv$iv;
            boolean bl3 = false;
            if (PlayerExtensionsKt.getPlayer(it) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ObjectValue<PCStore> getStruct() {
        return this.struct;
    }

    public final void addObserver(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        this.observingUUIDs.add(uUID);
        this.sendTo(player);
    }

    public final void removeObserver(@NotNull UUID playerID) {
        Intrinsics.checkNotNullParameter((Object)playerID, (String)"playerID");
        this.observingUUIDs.remove(playerID);
    }

    @NotNull
    public final SimpleObservable<Unit> getPcChangeObservable() {
        return this.pcChangeObservable;
    }

    @Override
    @Nullable
    public PCPosition getFirstAvailablePosition() {
        Iterable $this$forEach$iv = this.boxes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PCBox it = (PCBox)element$iv;
            boolean bl2 = false;
            PCPosition pCPosition = it.getFirstAvailablePosition();
            if (pCPosition == null) continue;
            PCPosition it2 = pCPosition;
            boolean bl3 = false;
            return it2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isValidPosition(@NotNull PCPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        int n = this.boxes.size();
        int n2 = position.getBox();
        if (0 > n2) return false;
        if (n2 >= n) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        n = position.getSlot();
        if (0 > n) return false;
        if (n >= 30) return false;
        return true;
    }

    @Override
    public void sendTo(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        new InitializePCPacket(this).sendToPlayer(player);
        Iterable $this$forEach$iv = this.boxes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PCBox it = (PCBox)element$iv;
            boolean bl2 = false;
            it.sendTo(player);
        }
    }

    @Override
    public void initialize() {
        Iterable $this$forEach$iv = this.boxes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PCBox it = (PCBox)element$iv;
            boolean bl2 = false;
            it.initialize();
        }
        this.backupStore.initialize();
    }

    public final void relocateEvictedBoxPokemon(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        PCPosition space = this.getFirstAvailablePosition();
        if (space != null) {
            this.set(space, pokemon);
        } else {
            this.backupStore.add(pokemon);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void resize(int newSize, boolean lockNewSize, @NotNull Function1<? super Pokemon, Unit> overflowHandler) {
        Intrinsics.checkNotNullParameter(overflowHandler, (String)"overflowHandler");
        if (newSize <= 0) {
            throw new IllegalArgumentException("Invalid box count: Must be greater than zero.");
        }
        this.lockedSize = lockNewSize;
        if (this.boxes.size() > newSize) {
            void $this$forEach$iv;
            void $this$flatMapTo$iv$iv;
            List slicedBoxes = CollectionsKt.slice(this.boxes, (IntRange)RangesKt.until((int)newSize, (int)this.boxes.size()));
            this.boxes.removeAll(slicedBoxes);
            Iterable $this$flatMap$iv = slicedBoxes;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                PCBox it = (PCBox)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = it;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                overflowHandler.invoke(element$iv);
            }
        } else {
            while (this.boxes.size() < newSize) {
                this.boxes.add(new PCBox(this));
            }
            this.tryRestoreBackedUpPokemon();
        }
        Unit[] unitArray = new Unit[]{Unit.INSTANCE};
        this.pcChangeObservable.emit((Unit[])unitArray);
    }

    public static /* synthetic */ void resize$default(PCStore pCStore, int n, boolean bl2, Function1 function1, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resize");
        }
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        if ((n2 & 4) != 0) {
            function1 = (Function1)new Function1<Pokemon, Unit>((Object)pCStore){

                public final void invoke(Pokemon p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((PCStore)this.receiver).relocateEvictedBoxPokemon(p0);
                }
            };
        }
        pCStore.resize(n, bl2, (Function1<? super Pokemon, Unit>)function1);
    }

    public final void tryRestoreBackedUpPokemon() {
        PCPosition newPosition = this.getFirstAvailablePosition();
        List backedUpPokemon = CollectionsKt.toMutableList((Collection)this.backupStore.getPokemon());
        while (newPosition != null && !((Collection)backedUpPokemon).isEmpty()) {
            this.set(newPosition, (Pokemon)backedUpPokemon.remove(0));
            newPosition = this.getFirstAvailablePosition();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public class_2487 saveToNBT(@NotNull class_2487 nbt, @NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        nbt.method_10575("BoxCount", (short)this.boxes.size());
        nbt.method_10556("BoxCountLocked", this.lockedSize);
        Iterable $this$forEachIndexed$iv = this.boxes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void box;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PCBox pCBox = (PCBox)item$iv;
            int index = n;
            boolean bl2 = false;
            nbt.method_10566("Box" + index, (class_2520)box.saveToNBT(new class_2487(), registryAccess));
        }
        nbt.method_10566("BackupStore", (class_2520)this.backupStore.saveToNBT(new class_2487(), registryAccess));
        return nbt;
    }

    @Override
    @NotNull
    public PokemonStore<PCPosition> loadFromNBT(@NotNull class_2487 nbt, @NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        int boxCountStored = nbt.method_10568("BoxCount");
        int n = boxCountStored;
        for (int boxNumber = 0; boxNumber < n; ++boxNumber) {
            PCBox pCBox = new PCBox(this);
            class_2487 class_24872 = nbt.method_10562("Box" + boxNumber);
            Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"getCompound(...)");
            this.boxes.add(pCBox.loadFromNBT(class_24872, registryAccess));
        }
        this.lockedSize = nbt.method_10577("BoxCountLocked");
        if (!this.lockedSize && this.boxes.size() != Cobblemon.INSTANCE.getConfig().getDefaultBoxCount()) {
            PCStore.resize$default(this, Cobblemon.INSTANCE.getConfig().getDefaultBoxCount(), false, null, 4, null);
        } else {
            this.tryRestoreBackedUpPokemon();
        }
        this.removeDuplicates();
        return this;
    }

    public final void removeDuplicates() {
        List knownUUIDs = new ArrayList();
        for (PCBox box : this.boxes) {
            for (int i = 0; i < 30; ++i) {
                Pokemon pokemon;
                if (box.get(i) == null) continue;
                if (!knownUUIDs.contains(pokemon.getUuid())) {
                    UUID uUID = pokemon.getUuid();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
                    knownUUIDs.add(uUID);
                    continue;
                }
                box.set(i, null);
                Unit[] unitArray = new Unit[]{Unit.INSTANCE};
                this.pcChangeObservable.emit((Unit[])unitArray);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsonObject saveToJSON(@NotNull JsonObject json, @NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        json.addProperty("BoxCount", (Number)((short)this.boxes.size()));
        json.addProperty("BoxCountLocked", Boolean.valueOf(this.lockedSize));
        Iterable $this$forEachIndexed$iv = this.boxes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void box;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PCBox pCBox = (PCBox)item$iv;
            int index = n;
            boolean bl2 = false;
            json.add("Box" + index, (JsonElement)box.saveToJSON(new JsonObject(), registryAccess));
        }
        json.add("BackupStore", (JsonElement)this.backupStore.saveToJSON(new JsonObject(), registryAccess));
        return json;
    }

    @Override
    @NotNull
    public PokemonStore<PCPosition> loadFromJSON(@NotNull JsonObject json, @NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        int boxCountStored = json.get("BoxCount").getAsShort();
        int n = boxCountStored;
        for (int boxNumber = 0; boxNumber < n; ++boxNumber) {
            PCBox pCBox = new PCBox(this);
            JsonObject jsonObject = json.getAsJsonObject("Box" + boxNumber);
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
            this.boxes.add(pCBox.loadFromJSON(jsonObject, registryAccess));
        }
        this.lockedSize = json.get("BoxCountLocked").getAsBoolean();
        if (!this.lockedSize && this.boxes.size() != Cobblemon.INSTANCE.getConfig().getDefaultBoxCount()) {
            PCStore.resize$default(this, Cobblemon.INSTANCE.getConfig().getDefaultBoxCount(), false, null, 4, null);
        } else {
            this.tryRestoreBackedUpPokemon();
        }
        this.removeDuplicates();
        return this;
    }

    @Override
    public void set(@NotNull PCPosition position, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        super.set((StorePosition)position, pokemon);
        this.sendPacketToObservers(new SetPCPokemonPacket(this.uuid, position, (Function1<? super class_5455, ? extends Pokemon>)((Function1)arg_0 -> PCStore.set$lambda$9(pokemon, arg_0))));
    }

    @Override
    public boolean remove(@NotNull Pokemon pokemon) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (super.remove(pokemon)) {
            PokemonStore pokemonStore = this;
            UUID uUID = pokemon.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
            this.sendPacketToObservers(new RemoveClientPokemonPacket(pokemonStore, uUID));
            bl2 = true;
        } else {
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public void swap(@NotNull PCPosition position1, @NotNull PCPosition position2) {
        Intrinsics.checkNotNullParameter((Object)position1, (String)"position1");
        Intrinsics.checkNotNullParameter((Object)position2, (String)"position2");
        Pokemon pokemon1 = this.get(position1);
        Pokemon pokemon2 = this.get(position2);
        super.swap((StorePosition)position1, (StorePosition)position2);
        if (pokemon1 != null && pokemon2 != null) {
            PokemonStore pokemonStore = this;
            UUID uUID = pokemon1.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
            UUID uUID2 = pokemon2.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"<get-uuid>(...)");
            this.sendPacketToObservers(new SwapClientPokemonPacket(pokemonStore, uUID, uUID2));
        } else if (pokemon1 != null || pokemon2 != null) {
            PCPosition newPosition = pokemon1 == null ? position1 : position2;
            Pokemon pokemon = pokemon1;
            if (pokemon == null) {
                Pokemon pokemon3 = pokemon2;
                pokemon = pokemon3;
                Intrinsics.checkNotNull((Object)pokemon3);
            }
            Pokemon pokemon4 = pokemon;
            UUID uUID = pokemon4.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
            this.sendPacketToObservers(new MoveClientPCPokemonPacket(this.uuid, uUID, newPosition));
        }
    }

    @Override
    @NotNull
    public StoreCoordinates<PCPosition> loadPositionFromNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        return new StoreCoordinates<StorePosition>(this, new PCPosition(nbt.method_10568("Box"), nbt.method_10571("Slot")));
    }

    @Override
    public void savePositionToNBT(@NotNull PCPosition position, @NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.method_10575("Box", (short)position.getBox());
        nbt.method_10567("Slot", (byte)position.getSlot());
    }

    @NotNull
    public SimpleObservable<Unit> getAnyChangeObservable() {
        return this.pcChangeObservable;
    }

    @Override
    protected void setAtPosition(@NotNull PCPosition position, @Nullable Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        int n = this.boxes.size();
        int n2 = position.getBox();
        if (!(0 <= n2 ? n2 < n : false)) {
            throw new IllegalArgumentException("Invalid box number " + position.getBox() + ". Should be between 0 and " + this.boxes.size());
        }
        this.boxes.get(position.getBox()).set(position.getSlot(), pokemon);
    }

    @Override
    @Nullable
    public Pokemon get(@NotNull PCPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        int n = this.boxes.size();
        int n2 = position.getBox();
        return !(0 <= n2 ? n2 < n : false) ? null : this.boxes.get(position.getBox()).get(position.getSlot());
    }

    public final void clearPC() {
        Iterable $this$forEach$iv = this.boxes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PCBox box = (PCBox)element$iv;
            boolean bl2 = false;
            Map<Integer, Pokemon> $this$forEach$iv2 = box.getNonEmptySlots();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<Integer, Pokemon>> iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, Pokemon> element$iv2;
                Map.Entry<Integer, Pokemon> it = element$iv2 = iterator.next();
                boolean bl3 = false;
                this.remove((StorePosition)new PCPosition(box.getBoxNumber(), ((Number)it.getKey()).intValue()));
            }
        }
    }

    private static final Pokemon set$lambda$9(Pokemon $pokemon, class_5455 it) {
        Intrinsics.checkNotNullParameter((Object)$pokemon, (String)"$pokemon");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $pokemon;
    }
}

