/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.player;

import com.cobblemon.mod.common.api.pokedex.PokedexManager;
import com.cobblemon.mod.common.api.scheduling.ScheduledTask;
import com.cobblemon.mod.common.api.scheduling.ServerTaskTracker;
import com.cobblemon.mod.common.api.storage.player.GeneralPlayerData;
import com.cobblemon.mod.common.api.storage.player.InstancedPlayerData;
import com.cobblemon.mod.common.api.storage.player.PlayerInstancedDataFactory;
import com.cobblemon.mod.common.api.storage.player.PlayerInstancedDataStoreType;
import com.cobblemon.mod.common.api.storage.player.PlayerInstancedDataStoreTypes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\t\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010\u001eJ\u000f\u0010 \u001a\u00020\bH\u0016\u00a2\u0006\u0004\b \u0010\u0003J\u0017\u0010\"\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010\"\u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\"\u0010$J\u0017\u0010&\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010&\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b&\u0010(R'\u0010*\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040)8\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R#\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020.0)8\u0006\u00a2\u0006\f\n\u0004\b/\u0010+\u001a\u0004\b0\u0010-\u00a8\u00061"}, d2={"Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataStoreManager;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataFactory;", "factory", "Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataStoreType;", "dataType", "", "setFactory", "(Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataFactory;Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataStoreType;)V", "Lnet/minecraft/server/MinecraftServer;", "server", "setup", "(Lnet/minecraft/server/MinecraftServer;)V", "Ljava/util/UUID;", "playerId", "Lcom/cobblemon/mod/common/api/storage/player/InstancedPlayerData;", "get", "(Ljava/util/UUID;Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataStoreType;)Lcom/cobblemon/mod/common/api/storage/player/InstancedPlayerData;", "Lnet/minecraft/class_1657;", "player", "(Lnet/minecraft/class_1657;Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataStoreType;)Lcom/cobblemon/mod/common/api/storage/player/InstancedPlayerData;", "saveAllOfOneType", "(Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataStoreType;)V", "playerData", "saveSingle", "(Lcom/cobblemon/mod/common/api/storage/player/InstancedPlayerData;Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataStoreType;)V", "Lnet/minecraft/class_3222;", "onPlayerDisconnect", "(Lnet/minecraft/class_3222;)V", "syncAllToPlayer", "saveAllStores", "Lcom/cobblemon/mod/common/api/storage/player/GeneralPlayerData;", "getGenericData", "(Lnet/minecraft/class_3222;)Lcom/cobblemon/mod/common/api/storage/player/GeneralPlayerData;", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/api/storage/player/GeneralPlayerData;", "Lcom/cobblemon/mod/common/api/pokedex/PokedexManager;", "getPokedexData", "(Lnet/minecraft/class_3222;)Lcom/cobblemon/mod/common/api/pokedex/PokedexManager;", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/api/pokedex/PokedexManager;", "", "factories", "Ljava/util/Map;", "getFactories", "()Ljava/util/Map;", "Lcom/cobblemon/mod/common/api/scheduling/ScheduledTask;", "saveTasks", "getSaveTasks", "common"})
@SourceDebugExtension(value={"SMAP\nPlayerInstancedDataStoreManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerInstancedDataStoreManager.kt\ncom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataStoreManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1863#2,2:119\n1863#2,2:121\n1863#2,2:123\n1863#2,2:125\n*S KotlinDebug\n*F\n+ 1 PlayerInstancedDataStoreManager.kt\ncom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataStoreManager\n*L\n39#1:119,2\n86#1:121,2\n92#1:123,2\n98#1:125,2\n*E\n"})
public class PlayerInstancedDataStoreManager {
    @NotNull
    private final Map<PlayerInstancedDataStoreType, PlayerInstancedDataFactory<?>> factories = new LinkedHashMap();
    @NotNull
    private final Map<PlayerInstancedDataStoreType, ScheduledTask> saveTasks = new LinkedHashMap();

    @NotNull
    public final Map<PlayerInstancedDataStoreType, PlayerInstancedDataFactory<?>> getFactories() {
        return this.factories;
    }

    @NotNull
    public final Map<PlayerInstancedDataStoreType, ScheduledTask> getSaveTasks() {
        return this.saveTasks;
    }

    public void setFactory(@NotNull PlayerInstancedDataFactory<?> factory, @NotNull PlayerInstancedDataStoreType dataType) {
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        this.factories.put(dataType, factory);
    }

    public void setup(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Iterable $this$forEach$iv = this.factories.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerInstancedDataFactory it = (PlayerInstancedDataFactory)element$iv;
            boolean bl2 = false;
            it.setup(server);
        }
        this.saveTasks.put(PlayerInstancedDataStoreTypes.INSTANCE.getGENERAL(), new ScheduledTask.Builder().execute((Function1<? super ScheduledTask, Unit>)((Function1)arg_0 -> PlayerInstancedDataStoreManager.setup$lambda$1(this, arg_0))).delay(30.0f).interval(120.0f).infiniteIterations().tracker(ServerTaskTracker.INSTANCE).build());
        this.saveTasks.put(PlayerInstancedDataStoreTypes.INSTANCE.getPOKEDEX(), new ScheduledTask.Builder().execute((Function1<? super ScheduledTask, Unit>)((Function1)arg_0 -> PlayerInstancedDataStoreManager.setup$lambda$2(this, arg_0))).delay(30.0f).interval(120.0f).infiniteIterations().tracker(ServerTaskTracker.INSTANCE).build());
    }

    @NotNull
    public InstancedPlayerData get(@NotNull UUID playerId, @NotNull PlayerInstancedDataStoreType dataType) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        if (!this.factories.containsKey(dataType)) {
            throw new UnsupportedOperationException("No factory registered for " + dataType);
        }
        PlayerInstancedDataFactory<?> playerInstancedDataFactory = this.factories.get(dataType);
        Intrinsics.checkNotNull(playerInstancedDataFactory);
        return playerInstancedDataFactory.getForPlayer(playerId);
    }

    @NotNull
    public InstancedPlayerData get(@NotNull class_1657 player, @NotNull PlayerInstancedDataStoreType dataType) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return this.get(uUID, dataType);
    }

    public void saveAllOfOneType(@NotNull PlayerInstancedDataStoreType dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        if (!this.factories.containsKey(dataType)) {
            throw new UnsupportedOperationException("No factory registered for " + dataType);
        }
        PlayerInstancedDataFactory<?> playerInstancedDataFactory = this.factories.get(dataType);
        Intrinsics.checkNotNull(playerInstancedDataFactory);
        playerInstancedDataFactory.saveAll();
    }

    public void saveSingle(@NotNull InstancedPlayerData playerData, @NotNull PlayerInstancedDataStoreType dataType) {
        Intrinsics.checkNotNullParameter((Object)playerData, (String)"playerData");
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        if (!this.factories.containsKey(dataType)) {
            throw new UnsupportedOperationException("No factory registered for " + dataType);
        }
        PlayerInstancedDataFactory<?> playerInstancedDataFactory = this.factories.get(dataType);
        Intrinsics.checkNotNull(playerInstancedDataFactory);
        playerInstancedDataFactory.saveSingle(playerData.getUuid());
    }

    public void onPlayerDisconnect(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable $this$forEach$iv = this.factories.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerInstancedDataFactory it = (PlayerInstancedDataFactory)element$iv;
            boolean bl2 = false;
            it.onPlayerDisconnect(player);
        }
    }

    public void syncAllToPlayer(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable $this$forEach$iv = this.factories.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerInstancedDataFactory it = (PlayerInstancedDataFactory)element$iv;
            boolean bl2 = false;
            it.sendToPlayer(player);
        }
    }

    public void saveAllStores() {
        Iterable $this$forEach$iv = this.factories.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerInstancedDataFactory it = (PlayerInstancedDataFactory)element$iv;
            boolean bl2 = false;
            it.saveAll();
        }
    }

    @NotNull
    public GeneralPlayerData getGenericData(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return this.getGenericData(uUID);
    }

    @NotNull
    public GeneralPlayerData getGenericData(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        InstancedPlayerData instancedPlayerData = this.get(playerId, PlayerInstancedDataStoreTypes.INSTANCE.getGENERAL());
        Intrinsics.checkNotNull((Object)instancedPlayerData, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.api.storage.player.GeneralPlayerData");
        return (GeneralPlayerData)instancedPlayerData;
    }

    @NotNull
    public PokedexManager getPokedexData(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return this.getPokedexData(uUID);
    }

    @NotNull
    public PokedexManager getPokedexData(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        InstancedPlayerData instancedPlayerData = this.get(playerId, PlayerInstancedDataStoreTypes.INSTANCE.getPOKEDEX());
        Intrinsics.checkNotNull((Object)instancedPlayerData, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.api.pokedex.PokedexManager");
        return (PokedexManager)instancedPlayerData;
    }

    private static final Unit setup$lambda$1(PlayerInstancedDataStoreManager this$0, ScheduledTask it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.saveAllOfOneType(PlayerInstancedDataStoreTypes.INSTANCE.getGENERAL());
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$2(PlayerInstancedDataStoreManager this$0, ScheduledTask it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.saveAllOfOneType(PlayerInstancedDataStoreTypes.INSTANCE.getPOKEDEX());
        return Unit.INSTANCE;
    }
}

