/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.interaction.RequestManager;
import com.cobblemon.mod.common.api.interaction.ServerPlayerActionRequest;
import com.cobblemon.mod.common.api.interaction.ServerTeamActionRequest;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.BattleBuilder;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.ErroredBattleStart;
import com.cobblemon.mod.common.battles.TeamManager;
import com.cobblemon.mod.common.net.messages.client.battle.BattleChallengeExpiredPacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleChallengeNotificationPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003'()B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001b\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\r\u0010\fJ\u0017\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u000e\u0010\fJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0019\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020!8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\"\u0010#R \u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006*"}, d2={"Lcom/cobblemon/mod/common/battles/ChallengeManager;", "Lcom/cobblemon/mod/common/api/interaction/RequestManager;", "Lcom/cobblemon/mod/common/battles/ChallengeManager$BattleChallenge;", "<init>", "()V", "request", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "expirationPacket", "(Lcom/cobblemon/mod/common/battles/ChallengeManager$BattleChallenge;)Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "notificationPacket", "", "onDecline", "(Lcom/cobblemon/mod/common/battles/ChallengeManager$BattleChallenge;)V", "onSend", "onAccept", "Lnet/minecraft/class_3222;", "player", "target", "", "isValidInteraction", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;)Z", "canAccept", "(Lcom/cobblemon/mod/common/battles/ChallengeManager$BattleChallenge;)Z", "", "players", "validateDimension", "(Ljava/util/Collection;)Z", "validateProximity", "(Ljava/util/Collection;)Lnet/minecraft/class_3222;", "Ljava/util/UUID;", "lead", "setLead", "(Lnet/minecraft/class_3222;Ljava/util/UUID;)Ljava/util/UUID;", "", "MAX_BATTLE_RADIUS", "D", "", "selectedLead", "Ljava/util/Map;", "BattleChallenge", "SinglesBattleChallenge", "MultiBattleChallenge", "common"})
@SourceDebugExtension(value={"SMAP\nChallengeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChallengeManager.kt\ncom/cobblemon/mod/common/battles/ChallengeManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1611#2,9:195\n1863#2:204\n1864#2:206\n1620#2:207\n1611#2,9:208\n1863#2:217\n1864#2:219\n1620#2:220\n295#2,2:221\n1863#2,2:223\n295#2,2:225\n1#3:205\n1#3:218\n*S KotlinDebug\n*F\n+ 1 ChallengeManager.kt\ncom/cobblemon/mod/common/battles/ChallengeManager\n*L\n102#1:195,9\n102#1:204\n102#1:206\n102#1:207\n139#1:208,9\n139#1:217\n139#1:219\n139#1:220\n181#1:221,2\n188#1:223,2\n189#1:225,2\n102#1:205\n139#1:218\n*E\n"})
public final class ChallengeManager
extends RequestManager<BattleChallenge> {
    @NotNull
    public static final ChallengeManager INSTANCE = new ChallengeManager();
    public static final double MAX_BATTLE_RADIUS = 15.0;
    @NotNull
    private static final Map<UUID, UUID> selectedLead;

    private ChallengeManager() {
    }

    @Override
    @NotNull
    protected NetworkPacket<?> expirationPacket(@NotNull BattleChallenge request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new BattleChallengeExpiredPacket(request);
    }

    @Override
    @NotNull
    protected NetworkPacket<?> notificationPacket(@NotNull BattleChallenge request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new BattleChallengeNotificationPacket(request);
    }

    @Override
    protected void onDecline(@NotNull BattleChallenge request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object[] objectArray = new Object[2];
        class_5250 class_52502 = request.getReceiver().method_5477().method_27661();
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"copy(...)");
        objectArray[0] = TextKt.aqua(class_52502);
        objectArray[1] = request.getBattleFormat().getBattleType().getDisplayName();
        request.notifySender(true, "decline.sender", objectArray);
        objectArray = new Object[2];
        class_5250 class_52503 = request.getSender().method_5477().method_27661();
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"copy(...)");
        objectArray[0] = TextKt.aqua(class_52503);
        objectArray[1] = request.getBattleFormat().getBattleType().getDisplayName();
        request.notifyReceiver(false, "decline.receiver", objectArray);
    }

    @Override
    protected void onSend(@NotNull BattleChallenge request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object[] objectArray = new Object[2];
        class_5250 class_52502 = request.getReceiver().method_5477().method_27661();
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"copy(...)");
        objectArray[0] = TextKt.aqua(class_52502);
        objectArray[1] = request.getBattleFormat().getBattleType().getDisplayName();
        request.notifySender(false, "sent", objectArray);
        objectArray = new Object[2];
        class_5250 class_52503 = request.getSender().method_5477().method_27661();
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"copy(...)");
        objectArray[0] = TextKt.aqua(class_52503);
        objectArray[1] = request.getBattleFormat().getBattleType().getDisplayName();
        request.notifyReceiver(false, "received", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onAccept(@NotNull BattleChallenge request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request instanceof MultiBattleChallenge) {
            void $this$mapNotNullTo$iv$iv;
            List players = CollectionsKt.plus((Collection)((MultiBattleChallenge)request).getReceiverTeam().getTeamPlayers(), (Iterable)((MultiBattleChallenge)request).getSenderTeam().getTeamPlayers());
            Iterable $this$mapNotNull$iv = players;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                UUID it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                class_3222 it = (class_3222)element$iv$iv;
                boolean bl3 = false;
                if (((Pokemon)CollectionsKt.first((Iterable)PlayerExtensionsKt.party(it))).getUuid() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List leadPokemon = (List)destination$iv$iv;
            v0 = BattleBuilder.pvp2v2$default(BattleBuilder.INSTANCE, players, leadPokemon, ((MultiBattleChallenge)request).getBattleFormat(), false, false, null, 56, null).ifErrored((Function1<? super ErroredBattleStart, Unit>)((Function1)arg_0 -> ChallengeManager.onAccept$lambda$2(players, arg_0)));
        } else {
            v0 = BattleBuilder.pvp1v1$default(BattleBuilder.INSTANCE, request.getReceiver(), request.getSender(), selectedLead.get(request.getReceiver().method_5667()), selectedLead.get(request.getSender().method_5667()), request.getBattleFormat(), false, false, null, 224, null).ifErrored((Function1<? super ErroredBattleStart, Unit>)((Function1)arg_0 -> ChallengeManager.onAccept$lambda$5(request, arg_0)));
        }
    }

    @Override
    public boolean isValidInteraction(@NotNull class_3222 player, @NotNull class_3222 target) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return PlayerExtensionsKt.canInteractWith(player, (class_1309)target, Cobblemon.INSTANCE.getConfig().getBattlePvPMaxDistance());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean canAccept(@NotNull BattleChallenge request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request instanceof MultiBattleChallenge) {
            void $this$mapNotNullTo$iv$iv;
            TeamManager.MultiBattleTeam existingReceiverTeam = TeamManager.INSTANCE.getTeam(((MultiBattleChallenge)request).getReceiverID());
            TeamManager.MultiBattleTeam existingSenderTeam = TeamManager.INSTANCE.getTeam(((MultiBattleChallenge)request).getSenderID());
            if (existingReceiverTeam == null || existingSenderTeam == null) {
                ((MultiBattleChallenge)request).notifySender(true, "error.missing_team", new Object[0]);
                ((MultiBattleChallenge)request).notifyReceiver(true, "error.missing_team", new Object[0]);
                return false;
            }
            List players = CollectionsKt.plus((Collection)existingReceiverTeam.getTeamPlayers(), (Iterable)existingSenderTeam.getTeamPlayers());
            Iterable $this$mapNotNull$iv = players;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                UUID it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                class_3222 it = (class_3222)element$iv$iv;
                boolean bl3 = false;
                if (((Pokemon)CollectionsKt.first((Iterable)PlayerExtensionsKt.party(it))).getUuid() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List leads = (List)destination$iv$iv;
            class_3222 farAwayPlayer = this.validateProximity(players);
            if (((Collection)players).size() != 4) {
                Object[] objectArray = new Object[]{2};
                ((MultiBattleChallenge)request).notifySender(true, "error.invalid_team_size", objectArray);
                objectArray = new Object[]{2};
                ((MultiBattleChallenge)request).notifyReceiver(true, "error.invalid_team_size", objectArray);
                return false;
            } else if (((Collection)leads).size() != ((Collection)players).size()) {
                ((MultiBattleChallenge)request).notifySender(true, "error.insufficient_pokemon", new Object[0]);
                ((MultiBattleChallenge)request).notifyReceiver(true, "error.insufficient_pokemon", new Object[0]);
                return false;
            } else if (this.validateDimension(players)) {
                ((MultiBattleChallenge)request).notifySender(true, "error.player_different_dimension", new Object[0]);
                ((MultiBattleChallenge)request).notifyReceiver(true, "error.player_different_dimension", new Object[0]);
                return false;
            } else {
                if (farAwayPlayer == null) return true;
                MultiBattleChallenge multiBattleChallenge = (MultiBattleChallenge)request;
                Object[] objectArray = new Object[1];
                class_5250 class_52502 = farAwayPlayer.method_5477().method_27661();
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"copy(...)");
                objectArray[0] = TextKt.aqua(class_52502);
                multiBattleChallenge.notifySender(true, "error.player_distance", objectArray);
                MultiBattleChallenge multiBattleChallenge2 = (MultiBattleChallenge)request;
                objectArray = new Object[1];
                class_5250 class_52503 = farAwayPlayer.method_5477().method_27661();
                Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"copy(...)");
                objectArray[0] = TextKt.aqua(class_52503);
                multiBattleChallenge2.notifyReceiver(true, "error.player_distance", objectArray);
            }
            return false;
        } else if (CollectionsKt.none((Iterable)PlayerExtensionsKt.party(request.getReceiver()))) {
            Object[] objectArray = new Object[1];
            class_5250 class_52504 = request.getReceiver().method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"copy(...)");
            objectArray[0] = TextKt.aqua(class_52504);
            request.notifySender(true, "error.insufficient_pokemon.other", objectArray);
            request.notifyReceiver(true, "error.insufficient_pokemon.self", new Object[0]);
            return false;
        } else {
            if (!CollectionsKt.none((Iterable)PlayerExtensionsKt.party(request.getSender()))) return true;
            request.notifySender(true, "error.insufficient_pokemon.self", new Object[0]);
            Object[] objectArray = new Object[1];
            class_5250 class_52505 = request.getSender().method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"copy(...)");
            objectArray[0] = TextKt.aqua(class_52505);
            request.notifyReceiver(true, "error.insufficient_pokemon.other", objectArray);
        }
        return false;
    }

    private final boolean validateDimension(Collection<? extends class_3222> players) {
        Object v0;
        block1: {
            class_5321 dimension = ((class_3222)CollectionsKt.first((Iterable)players)).method_37908().method_27983();
            Iterable $this$firstOrNull$iv = players;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                class_3222 it = (class_3222)element$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it.method_37908().method_27983(), (Object)dimension))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        class_3222 playerInWrongDimension = v0;
        return playerInWrongDimension != null;
    }

    private final class_3222 validateProximity(Collection<? extends class_3222> players) {
        Object v0;
        block2: {
            class_243 averagePos = null;
            averagePos = new class_243(0.0, 0.0, 0.0);
            Iterable $this$forEach$iv = players;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 it = (class_3222)element$iv;
                boolean bl2 = false;
                averagePos = averagePos.method_1019(it.method_19538().method_18805(1.0 / (double)players.size(), 0.0, 1.0 / (double)players.size()));
            }
            Iterable $this$firstOrNull$iv = players;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                class_3222 it = (class_3222)element$iv;
                boolean bl3 = false;
                if (!(it.method_19538().method_1023(0.0, it.method_19538().field_1351, 0.0).method_1025(averagePos) > 225.0)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        class_3222 farAwayPlayer = v0;
        return farAwayPlayer;
    }

    @Nullable
    public final UUID setLead(@NotNull class_3222 player, @NotNull UUID lead) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)lead, (String)"lead");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return selectedLead.put(uUID, lead);
    }

    private static final class_5250 onAccept$lambda$2$lambda$1(class_5250 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TextKt.red(it);
    }

    private static final Unit onAccept$lambda$2(List $players, ErroredBattleStart erredStart) {
        Intrinsics.checkNotNullParameter((Object)$players, (String)"$players");
        Intrinsics.checkNotNullParameter((Object)erredStart, (String)"erredStart");
        erredStart.sendTo($players, (Function1<? super class_5250, ? extends class_5250>)((Function1)ChallengeManager::onAccept$lambda$2$lambda$1));
        return Unit.INSTANCE;
    }

    private static final class_5250 onAccept$lambda$5$lambda$3(class_5250 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TextKt.red(it);
    }

    private static final class_5250 onAccept$lambda$5$lambda$4(class_5250 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TextKt.red(it);
    }

    private static final Unit onAccept$lambda$5(BattleChallenge $request, ErroredBattleStart it) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.sendTo((class_1297)$request.getReceiver(), (Function1<? super class_5250, ? extends class_5250>)((Function1)ChallengeManager::onAccept$lambda$5$lambda$3));
        it.sendTo((class_1297)$request.getSender(), (Function1<? super class_5250, ? extends class_5250>)((Function1)ChallengeManager::onAccept$lambda$5$lambda$4));
        return Unit.INSTANCE;
    }

    static {
        RequestManager.Companion.register(INSTANCE);
        selectedLead = new LinkedHashMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0007\u001a\u00020\u00048&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\b8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\f\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/cobblemon/mod/common/battles/ChallengeManager$BattleChallenge;", "Lcom/cobblemon/mod/common/api/interaction/ServerPlayerActionRequest;", "<init>", "()V", "Ljava/util/UUID;", "getSelectedPokemonId", "()Ljava/util/UUID;", "selectedPokemonId", "Lcom/cobblemon/mod/common/battles/BattleFormat;", "getBattleFormat", "()Lcom/cobblemon/mod/common/battles/BattleFormat;", "battleFormat", "requestID", "Ljava/util/UUID;", "getRequestID", "common"})
    public static abstract class BattleChallenge
    implements ServerPlayerActionRequest {
        @NotNull
        private final UUID requestID;

        public BattleChallenge() {
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            this.requestID = uUID;
        }

        @NotNull
        public abstract UUID getSelectedPokemonId();

        @NotNull
        public abstract BattleFormat getBattleFormat();

        @Override
        @NotNull
        public UUID getRequestID() {
            return this.requestID;
        }

        @Override
        @NotNull
        public UUID getReceiverID() {
            return ServerPlayerActionRequest.DefaultImpls.getReceiverID(this);
        }

        @Override
        @NotNull
        public UUID getSenderID() {
            return ServerPlayerActionRequest.DefaultImpls.getSenderID(this);
        }

        @Override
        public void sendToSender(@NotNull NetworkPacket<?> packet) {
            ServerPlayerActionRequest.DefaultImpls.sendToSender(this, packet);
        }

        @Override
        public void sendToReceiver(@NotNull NetworkPacket<?> packet) {
            ServerPlayerActionRequest.DefaultImpls.sendToReceiver(this, packet);
        }

        @Override
        public void notifySender(boolean error, @NotNull String langKey, Object ... params) {
            ServerPlayerActionRequest.DefaultImpls.notifySender(this, error, langKey, params);
        }

        @Override
        public void notifyReceiver(boolean error, @NotNull String langKey, Object ... params) {
            ServerPlayerActionRequest.DefaultImpls.notifyReceiver(this, error, langKey, params);
        }

        @Override
        public void notify(@NotNull class_3222 player, boolean error, @NotNull String langKey, Object ... params) {
            ServerPlayerActionRequest.DefaultImpls.notify(this, player, error, langKey, params);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016JB\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001a\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\nH\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u0016J\u0010\u0010 \u001a\u00020\u001fH\u00d6\u0001\u00a2\u0006\u0004\b \u0010!R\u001a\u0010\u0004\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\"\u001a\u0004\b#\u0010\u000fR\u001a\u0010\u0005\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\"\u001a\u0004\b$\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010%\u001a\u0004\b&\u0010\u0012R\u001a\u0010\t\u001a\u00020\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\t\u0010'\u001a\u0004\b(\u0010\u0014R\u001a\u0010\u000b\u001a\u00020\n8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010)\u001a\u0004\b*\u0010\u0016R\u001a\u0010+\u001a\u00020\u001f8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010!R\u001a\u0010/\u001a\u00020.8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u001a\u00103\u001a\u00020.8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b3\u00100\u001a\u0004\b4\u00102\u00a8\u00065"}, d2={"Lcom/cobblemon/mod/common/battles/ChallengeManager$MultiBattleChallenge;", "Lcom/cobblemon/mod/common/battles/ChallengeManager$BattleChallenge;", "Lcom/cobblemon/mod/common/api/interaction/ServerTeamActionRequest;", "Lnet/minecraft/class_3222;", "sender", "receiver", "Ljava/util/UUID;", "selectedPokemonId", "Lcom/cobblemon/mod/common/battles/BattleFormat;", "battleFormat", "", "expiryTime", "<init>", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;Ljava/util/UUID;Lcom/cobblemon/mod/common/battles/BattleFormat;I)V", "component1", "()Lnet/minecraft/class_3222;", "component2", "component3", "()Ljava/util/UUID;", "component4", "()Lcom/cobblemon/mod/common/battles/BattleFormat;", "component5", "()I", "copy", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;Ljava/util/UUID;Lcom/cobblemon/mod/common/battles/BattleFormat;I)Lcom/cobblemon/mod/common/battles/ChallengeManager$MultiBattleChallenge;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_3222;", "getSender", "getReceiver", "Ljava/util/UUID;", "getSelectedPokemonId", "Lcom/cobblemon/mod/common/battles/BattleFormat;", "getBattleFormat", "I", "getExpiryTime", "key", "Ljava/lang/String;", "getKey", "Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "senderTeam", "Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "getSenderTeam", "()Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "receiverTeam", "getReceiverTeam", "common"})
    public static final class MultiBattleChallenge
    extends BattleChallenge
    implements ServerTeamActionRequest {
        @NotNull
        private final class_3222 sender;
        @NotNull
        private final class_3222 receiver;
        @NotNull
        private final UUID selectedPokemonId;
        @NotNull
        private final BattleFormat battleFormat;
        private final int expiryTime;
        @NotNull
        private final String key;
        @NotNull
        private final TeamManager.MultiBattleTeam senderTeam;
        @NotNull
        private final TeamManager.MultiBattleTeam receiverTeam;

        public MultiBattleChallenge(@NotNull class_3222 sender, @NotNull class_3222 receiver, @NotNull UUID selectedPokemonId, @NotNull BattleFormat battleFormat, int expiryTime) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter((Object)selectedPokemonId, (String)"selectedPokemonId");
            Intrinsics.checkNotNullParameter((Object)battleFormat, (String)"battleFormat");
            this.sender = sender;
            this.receiver = receiver;
            this.selectedPokemonId = selectedPokemonId;
            this.battleFormat = battleFormat;
            this.expiryTime = expiryTime;
            this.key = "challenge.multi";
            TeamManager.MultiBattleTeam multiBattleTeam = PlayerExtensionsKt.getBattleTeam(this.getSender());
            if (multiBattleTeam == null) {
                throw new IllegalArgumentException("Sending player is not part of a team!");
            }
            this.senderTeam = multiBattleTeam;
            TeamManager.MultiBattleTeam multiBattleTeam2 = PlayerExtensionsKt.getBattleTeam(this.getReceiver());
            if (multiBattleTeam2 == null) {
                throw new IllegalArgumentException("Target player is not part of a team!");
            }
            this.receiverTeam = multiBattleTeam2;
        }

        public /* synthetic */ MultiBattleChallenge(class_3222 class_32222, class_3222 class_32223, UUID uUID, BattleFormat battleFormat, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x10) != 0) {
                n = 20;
            }
            this(class_32222, class_32223, uUID, battleFormat, n);
        }

        @Override
        @NotNull
        public class_3222 getSender() {
            return this.sender;
        }

        @Override
        @NotNull
        public class_3222 getReceiver() {
            return this.receiver;
        }

        @Override
        @NotNull
        public UUID getSelectedPokemonId() {
            return this.selectedPokemonId;
        }

        @Override
        @NotNull
        public BattleFormat getBattleFormat() {
            return this.battleFormat;
        }

        @Override
        public int getExpiryTime() {
            return this.expiryTime;
        }

        @Override
        @NotNull
        public String getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public TeamManager.MultiBattleTeam getSenderTeam() {
            return this.senderTeam;
        }

        @Override
        @NotNull
        public TeamManager.MultiBattleTeam getReceiverTeam() {
            return this.receiverTeam;
        }

        @NotNull
        public final class_3222 component1() {
            return this.sender;
        }

        @NotNull
        public final class_3222 component2() {
            return this.receiver;
        }

        @NotNull
        public final UUID component3() {
            return this.selectedPokemonId;
        }

        @NotNull
        public final BattleFormat component4() {
            return this.battleFormat;
        }

        public final int component5() {
            return this.expiryTime;
        }

        @NotNull
        public final MultiBattleChallenge copy(@NotNull class_3222 sender, @NotNull class_3222 receiver, @NotNull UUID selectedPokemonId, @NotNull BattleFormat battleFormat, int expiryTime) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter((Object)selectedPokemonId, (String)"selectedPokemonId");
            Intrinsics.checkNotNullParameter((Object)battleFormat, (String)"battleFormat");
            return new MultiBattleChallenge(sender, receiver, selectedPokemonId, battleFormat, expiryTime);
        }

        public static /* synthetic */ MultiBattleChallenge copy$default(MultiBattleChallenge multiBattleChallenge, class_3222 class_32222, class_3222 class_32223, UUID uUID, BattleFormat battleFormat, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                class_32222 = multiBattleChallenge.sender;
            }
            if ((n2 & 2) != 0) {
                class_32223 = multiBattleChallenge.receiver;
            }
            if ((n2 & 4) != 0) {
                uUID = multiBattleChallenge.selectedPokemonId;
            }
            if ((n2 & 8) != 0) {
                battleFormat = multiBattleChallenge.battleFormat;
            }
            if ((n2 & 0x10) != 0) {
                n = multiBattleChallenge.expiryTime;
            }
            return multiBattleChallenge.copy(class_32222, class_32223, uUID, battleFormat, n);
        }

        @NotNull
        public String toString() {
            return "MultiBattleChallenge(sender=" + this.sender + ", receiver=" + this.receiver + ", selectedPokemonId=" + this.selectedPokemonId + ", battleFormat=" + this.battleFormat + ", expiryTime=" + this.expiryTime + ")";
        }

        public int hashCode() {
            int result = this.sender.hashCode();
            result = result * 31 + this.receiver.hashCode();
            result = result * 31 + this.selectedPokemonId.hashCode();
            result = result * 31 + this.battleFormat.hashCode();
            result = result * 31 + Integer.hashCode(this.expiryTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MultiBattleChallenge)) {
                return false;
            }
            MultiBattleChallenge multiBattleChallenge = (MultiBattleChallenge)other;
            if (!Intrinsics.areEqual((Object)this.sender, (Object)multiBattleChallenge.sender)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.receiver, (Object)multiBattleChallenge.receiver)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.selectedPokemonId, (Object)multiBattleChallenge.selectedPokemonId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.battleFormat, (Object)multiBattleChallenge.battleFormat)) {
                return false;
            }
            return this.expiryTime == multiBattleChallenge.expiryTime;
        }

        @Override
        @NotNull
        public UUID getReceiverID() {
            return ServerTeamActionRequest.DefaultImpls.getReceiverID(this);
        }

        @Override
        @NotNull
        public UUID getSenderID() {
            return ServerTeamActionRequest.DefaultImpls.getSenderID(this);
        }

        @Override
        public void sendToSender(@NotNull NetworkPacket<?> packet) {
            ServerTeamActionRequest.DefaultImpls.sendToSender(this, packet);
        }

        @Override
        public void sendToReceiver(@NotNull NetworkPacket<?> packet) {
            ServerTeamActionRequest.DefaultImpls.sendToReceiver(this, packet);
        }

        @Override
        public void notifySender(boolean error, @NotNull String langKey, Object ... params) {
            ServerTeamActionRequest.DefaultImpls.notifySender(this, error, langKey, params);
        }

        @Override
        public void notifyReceiver(boolean error, @NotNull String langKey, Object ... params) {
            ServerTeamActionRequest.DefaultImpls.notifyReceiver(this, error, langKey, params);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015JB\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001a\u0010\u001b\u001a\u00020\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\tH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u0015J\u0010\u0010\u001f\u001a\u00020\u001eH\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010 R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010!\u001a\u0004\b#\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u00058\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010$\u001a\u0004\b%\u0010\u0011R\u001a\u0010\b\u001a\u00020\u00078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\b\u0010&\u001a\u0004\b'\u0010\u0013R\u001a\u0010\n\u001a\u00020\t8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\n\u0010(\u001a\u0004\b)\u0010\u0015R\u001a\u0010*\u001a\u00020\u001e8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010 \u00a8\u0006-"}, d2={"Lcom/cobblemon/mod/common/battles/ChallengeManager$SinglesBattleChallenge;", "Lcom/cobblemon/mod/common/battles/ChallengeManager$BattleChallenge;", "Lnet/minecraft/class_3222;", "sender", "receiver", "Ljava/util/UUID;", "selectedPokemonId", "Lcom/cobblemon/mod/common/battles/BattleFormat;", "battleFormat", "", "expiryTime", "<init>", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;Ljava/util/UUID;Lcom/cobblemon/mod/common/battles/BattleFormat;I)V", "component1", "()Lnet/minecraft/class_3222;", "component2", "component3", "()Ljava/util/UUID;", "component4", "()Lcom/cobblemon/mod/common/battles/BattleFormat;", "component5", "()I", "copy", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;Ljava/util/UUID;Lcom/cobblemon/mod/common/battles/BattleFormat;I)Lcom/cobblemon/mod/common/battles/ChallengeManager$SinglesBattleChallenge;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_3222;", "getSender", "getReceiver", "Ljava/util/UUID;", "getSelectedPokemonId", "Lcom/cobblemon/mod/common/battles/BattleFormat;", "getBattleFormat", "I", "getExpiryTime", "key", "Ljava/lang/String;", "getKey", "common"})
    public static final class SinglesBattleChallenge
    extends BattleChallenge {
        @NotNull
        private final class_3222 sender;
        @NotNull
        private final class_3222 receiver;
        @NotNull
        private final UUID selectedPokemonId;
        @NotNull
        private final BattleFormat battleFormat;
        private final int expiryTime;
        @NotNull
        private final String key;

        public SinglesBattleChallenge(@NotNull class_3222 sender, @NotNull class_3222 receiver, @NotNull UUID selectedPokemonId, @NotNull BattleFormat battleFormat, int expiryTime) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter((Object)selectedPokemonId, (String)"selectedPokemonId");
            Intrinsics.checkNotNullParameter((Object)battleFormat, (String)"battleFormat");
            this.sender = sender;
            this.receiver = receiver;
            this.selectedPokemonId = selectedPokemonId;
            this.battleFormat = battleFormat;
            this.expiryTime = expiryTime;
            this.key = "challenge";
        }

        public /* synthetic */ SinglesBattleChallenge(class_3222 class_32222, class_3222 class_32223, UUID uUID, BattleFormat battleFormat, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x10) != 0) {
                n = 20;
            }
            this(class_32222, class_32223, uUID, battleFormat, n);
        }

        @Override
        @NotNull
        public class_3222 getSender() {
            return this.sender;
        }

        @Override
        @NotNull
        public class_3222 getReceiver() {
            return this.receiver;
        }

        @Override
        @NotNull
        public UUID getSelectedPokemonId() {
            return this.selectedPokemonId;
        }

        @Override
        @NotNull
        public BattleFormat getBattleFormat() {
            return this.battleFormat;
        }

        @Override
        public int getExpiryTime() {
            return this.expiryTime;
        }

        @Override
        @NotNull
        public String getKey() {
            return this.key;
        }

        @NotNull
        public final class_3222 component1() {
            return this.sender;
        }

        @NotNull
        public final class_3222 component2() {
            return this.receiver;
        }

        @NotNull
        public final UUID component3() {
            return this.selectedPokemonId;
        }

        @NotNull
        public final BattleFormat component4() {
            return this.battleFormat;
        }

        public final int component5() {
            return this.expiryTime;
        }

        @NotNull
        public final SinglesBattleChallenge copy(@NotNull class_3222 sender, @NotNull class_3222 receiver, @NotNull UUID selectedPokemonId, @NotNull BattleFormat battleFormat, int expiryTime) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter((Object)selectedPokemonId, (String)"selectedPokemonId");
            Intrinsics.checkNotNullParameter((Object)battleFormat, (String)"battleFormat");
            return new SinglesBattleChallenge(sender, receiver, selectedPokemonId, battleFormat, expiryTime);
        }

        public static /* synthetic */ SinglesBattleChallenge copy$default(SinglesBattleChallenge singlesBattleChallenge, class_3222 class_32222, class_3222 class_32223, UUID uUID, BattleFormat battleFormat, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                class_32222 = singlesBattleChallenge.sender;
            }
            if ((n2 & 2) != 0) {
                class_32223 = singlesBattleChallenge.receiver;
            }
            if ((n2 & 4) != 0) {
                uUID = singlesBattleChallenge.selectedPokemonId;
            }
            if ((n2 & 8) != 0) {
                battleFormat = singlesBattleChallenge.battleFormat;
            }
            if ((n2 & 0x10) != 0) {
                n = singlesBattleChallenge.expiryTime;
            }
            return singlesBattleChallenge.copy(class_32222, class_32223, uUID, battleFormat, n);
        }

        @NotNull
        public String toString() {
            return "SinglesBattleChallenge(sender=" + this.sender + ", receiver=" + this.receiver + ", selectedPokemonId=" + this.selectedPokemonId + ", battleFormat=" + this.battleFormat + ", expiryTime=" + this.expiryTime + ")";
        }

        public int hashCode() {
            int result = this.sender.hashCode();
            result = result * 31 + this.receiver.hashCode();
            result = result * 31 + this.selectedPokemonId.hashCode();
            result = result * 31 + this.battleFormat.hashCode();
            result = result * 31 + Integer.hashCode(this.expiryTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SinglesBattleChallenge)) {
                return false;
            }
            SinglesBattleChallenge singlesBattleChallenge = (SinglesBattleChallenge)other;
            if (!Intrinsics.areEqual((Object)this.sender, (Object)singlesBattleChallenge.sender)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.receiver, (Object)singlesBattleChallenge.receiver)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.selectedPokemonId, (Object)singlesBattleChallenge.selectedPokemonId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.battleFormat, (Object)singlesBattleChallenge.battleFormat)) {
                return false;
            }
            return this.expiryTime == singlesBattleChallenge.expiryTime;
        }
    }
}

