/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.battles.runner.ShowdownService;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J!\u0010\t\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0003R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR&\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/cobblemon/mod/common/battles/ShowdownThread;", "Ljava/lang/Thread;", "<init>", "()V", "", "launch", "Lkotlin/Function1;", "Lcom/cobblemon/mod/common/battles/runner/ShowdownService;", "action", "queue", "(Lkotlin/jvm/functions/Function1;)V", "run", "Ljava/util/concurrent/CountDownLatch;", "latch", "Ljava/util/concurrent/CountDownLatch;", "Ljava/util/Queue;", "whenReady", "Ljava/util/Queue;", "common"})
public final class ShowdownThread
extends Thread {
    @NotNull
    private final CountDownLatch latch = new CountDownLatch(1);
    @NotNull
    private final Queue<Function1<ShowdownService, Unit>> whenReady = new LinkedList();

    public ShowdownThread() {
        super("Cobblemon Showdown");
    }

    public final void launch() {
        this.start();
        this.latch.await();
        for (Function1 function1 : this.whenReady) {
            function1.invoke((Object)ShowdownService.Companion.getService());
        }
    }

    public final void queue(@NotNull Function1<? super ShowdownService, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (this.latch.getCount() == 0L) {
            action.invoke((Object)ShowdownService.Companion.getService());
        } else {
            this.whenReady.add(action);
        }
    }

    @Override
    public void run() {
        Cobblemon.LOGGER.info("Starting showdown service...");
        ShowdownService.Companion.getService().openConnection();
        Cobblemon.LOGGER.info("Showdown has been started!");
        this.latch.countDown();
    }
}

