/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.interaction.RequestManager;
import com.cobblemon.mod.common.api.interaction.ServerPlayerActionRequest;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.ChallengeManager;
import com.cobblemon.mod.common.net.messages.client.battle.TeamJoinNotificationPacket;
import com.cobblemon.mod.common.net.messages.client.battle.TeamMemberAddNotificationPacket;
import com.cobblemon.mod.common.net.messages.client.battle.TeamMemberRemoveNotificationPacket;
import com.cobblemon.mod.common.net.messages.client.battle.TeamRequestExpiredPacket;
import com.cobblemon.mod.common.net.messages.client.battle.TeamRequestNotificationPacket;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000201B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\b\u0010\fJ\u001b\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\r\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001b\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\r\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ!\u0010\u001d\u001a\u00020\u00072\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001b\"\u00020\u0005\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020!2\u0006\u0010\r\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\"\u0010#J\u001f\u0010%\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010(\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b(\u0010\u0017R\u0014\u0010*\u001a\u00020)8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b*\u0010+R \u0010-\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R \u0010/\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u0010.\u00a8\u00062"}, d2={"Lcom/cobblemon/mod/common/battles/TeamManager;", "Lcom/cobblemon/mod/common/api/interaction/RequestManager;", "Lcom/cobblemon/mod/common/battles/TeamManager$TeamRequest;", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "getTeam", "(Lnet/minecraft/class_3222;)Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "Ljava/util/UUID;", "teamID", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "request", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "notificationPacket", "(Lcom/cobblemon/mod/common/battles/TeamManager$TeamRequest;)Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "expirationPacket", "teamEntry", "", "disbandTeam", "(Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;)V", "removeTeamMember", "(Lnet/minecraft/class_3222;)V", "team", "joinTeam", "(Lnet/minecraft/class_3222;Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;)V", "", "players", "createTeam", "([Lnet/minecraft/class_3222;)Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "onAccept", "(Lcom/cobblemon/mod/common/battles/TeamManager$TeamRequest;)V", "", "canAccept", "(Lcom/cobblemon/mod/common/battles/TeamManager$TeamRequest;)Z", "target", "isValidInteraction", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;)Z", "sender", "onLogoff", "", "MAX_TEAM_MEMBER_COUNT", "I", "", "playerToTeam", "Ljava/util/Map;", "multiBattleTeams", "TeamRequest", "MultiBattleTeam", "common"})
@SourceDebugExtension(value={"SMAP\nTeamManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamManager.kt\ncom/cobblemon/mod/common/battles/TeamManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,201:1\n1611#2,9:202\n1863#2:211\n1864#2:213\n1620#2:214\n1863#2,2:215\n1863#2,2:217\n1863#2,2:220\n1611#2,9:222\n1863#2:231\n1864#2:233\n1620#2:234\n1863#2,2:235\n1611#2,9:237\n1863#2:246\n1864#2:248\n1620#2:249\n1863#2,2:251\n1#3:212\n1#3:219\n1#3:232\n1#3:247\n1#3:264\n13346#4:250\n13347#4:253\n11420#4,9:254\n13346#4:263\n13347#4:265\n11429#4:266\n13346#4,2:267\n*S KotlinDebug\n*F\n+ 1 TeamManager.kt\ncom/cobblemon/mod/common/battles/TeamManager\n*L\n81#1:202,9\n81#1:211\n81#1:213\n81#1:214\n82#1:215,2\n85#1:217,2\n93#1:220,2\n111#1:222,9\n111#1:231\n111#1:233\n111#1:234\n120#1:235,2\n135#1:237,9\n135#1:246\n135#1:248\n135#1:249\n144#1:251,2\n81#1:212\n111#1:232\n135#1:247\n153#1:264\n143#1:250\n143#1:253\n153#1:254,9\n153#1:263\n153#1:265\n153#1:266\n156#1:267,2\n*E\n"})
public final class TeamManager
extends RequestManager<TeamRequest> {
    @NotNull
    public static final TeamManager INSTANCE = new TeamManager();
    public static final int MAX_TEAM_MEMBER_COUNT = 2;
    @NotNull
    private static final Map<UUID, MultiBattleTeam> playerToTeam;
    @NotNull
    private static final Map<UUID, MultiBattleTeam> multiBattleTeams;

    private TeamManager() {
    }

    @Nullable
    public final MultiBattleTeam getTeam(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return playerToTeam.get(player.method_5667());
    }

    @Nullable
    public final MultiBattleTeam getTeam(@NotNull UUID teamID) {
        Intrinsics.checkNotNullParameter((Object)teamID, (String)"teamID");
        return multiBattleTeams.get(teamID);
    }

    @Override
    @NotNull
    protected NetworkPacket<?> notificationPacket(@NotNull TeamRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new TeamRequestNotificationPacket(request);
    }

    @Override
    @NotNull
    protected NetworkPacket<?> expirationPacket(@NotNull TeamRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new TeamRequestExpiredPacket(request);
    }

    public final void disbandTeam(@NotNull MultiBattleTeam teamEntry) {
        Iterator $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)teamEntry, (String)"teamEntry");
        Iterable $this$mapNotNull$iv = teamEntry.getTeamPlayersUUID();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TeamRequest it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            UUID member = (UUID)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)member);
            if ((TeamRequest)INSTANCE.getOutboundRequest(member) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List pendingTeamRequests = (List)destination$iv$iv;
        Iterable $this$forEach$iv = pendingTeamRequests;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            TeamRequest it = (TeamRequest)element$iv;
            boolean bl5 = false;
            RequestManager.cancelRequest$default(INSTANCE, it, false, 2, null);
        }
        List list = ChallengeManager.INSTANCE.getInboundRequests(teamEntry.getTeamID());
        if (list != null) {
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv2) {
                ChallengeManager.BattleChallenge it = (ChallengeManager.BattleChallenge)element$iv;
                boolean bl6 = false;
                ChallengeManager.INSTANCE.declineRequest((ServerPlayerActionRequest)it);
            }
        }
        ChallengeManager.BattleChallenge battleChallenge = (ChallengeManager.BattleChallenge)ChallengeManager.INSTANCE.getOutboundRequest(teamEntry.getTeamID());
        if (battleChallenge != null) {
            ChallengeManager.BattleChallenge it = battleChallenge;
            boolean bl7 = false;
            RequestManager.cancelRequest$default(ChallengeManager.INSTANCE, it, false, 2, null);
        }
        $this$forEach$iv = teamEntry.getTeamPlayersUUID();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 it;
            UUID member = (UUID)element$iv;
            boolean bl8 = false;
            playerToTeam.remove(member);
            Intrinsics.checkNotNull((Object)member);
            if (PlayerExtensionsKt.getPlayer(member) == null) continue;
            boolean bl9 = false;
            UUID uUID = it.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            CobblemonNetwork.INSTANCE.sendPacketToPlayer(it, new TeamMemberRemoveNotificationPacket(uUID));
        }
        multiBattleTeams.remove(teamEntry.getTeamID());
    }

    /*
     * WARNING - void declaration
     */
    public final void removeTeamMember(@NotNull class_3222 player) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        MultiBattleTeam multiBattleTeam = playerToTeam.get(player.method_5667());
        if (multiBattleTeam == null) {
            return;
        }
        MultiBattleTeam teamEntry = multiBattleTeam;
        teamEntry.getTeamPlayers().remove(player);
        playerToTeam.remove(player.method_5667());
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        TeamMemberRemoveNotificationPacket notificationPacket = new TeamMemberRemoveNotificationPacket(uUID);
        CobblemonNetwork.INSTANCE.sendPacketToPlayer(player, notificationPacket);
        Iterable $this$mapNotNull$iv = teamEntry.getTeamPlayersUUID();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            class_3222 it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            UUID it = (UUID)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            if (PlayerExtensionsKt.getPlayer(it) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List teamServerPlayers = (List)destination$iv$iv;
        CobblemonNetwork.INSTANCE.sendPacketToPlayers(teamServerPlayers, notificationPacket);
        if (((Collection)teamEntry.getTeamPlayersUUID()).size() == 1) {
            this.disbandTeam(teamEntry);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void joinTeam(@NotNull class_3222 player, @NotNull MultiBattleTeam team) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        List list = this.getInboundRequests(uUID);
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                TeamRequest it = (TeamRequest)element$iv2;
                boolean bl2 = false;
                RequestManager.cancelRequest$default(INSTANCE, it, false, 2, null);
            }
        }
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        class_5250 class_52502 = player.method_5477().method_27661();
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"copy(...)");
        TeamMemberAddNotificationPacket teamNotifyPacket = new TeamMemberAddNotificationPacket(uUID2, class_52502);
        CobblemonNetwork.INSTANCE.sendPacketToPlayers((Iterable<? extends class_3222>)team.getTeamPlayers(), teamNotifyPacket);
        team.getTeamPlayers().add(player);
        UUID uUID3 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
        playerToTeam.put(uUID3, team);
        Iterable $i$f$forEach = team.getTeamPlayers();
        List<UUID> list2 = team.getTeamPlayersUUID();
        boolean $i$f$mapNotNull = false;
        element$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            class_5250 it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl3 = false;
            class_3222 it = (class_3222)element$iv$iv;
            boolean bl4 = false;
            if (it.method_5477().method_27662() == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        List<UUID> list4 = list2;
        TeamJoinNotificationPacket joinerPacket = new TeamJoinNotificationPacket(list4, list3);
        CobblemonNetwork.INSTANCE.sendPacketToPlayer(player, joinerPacket);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MultiBattleTeam createTeam(class_3222 ... players) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        boolean $i$f$forEach;
        class_3222 element$iv;
        Intrinsics.checkNotNullParameter((Object)players, (String)"players");
        class_3222[] $this$forEach$iv = players;
        boolean $i$f$forEach2 = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            class_3222 it = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            UUID uUID = it.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            List list = INSTANCE.getInboundRequests(uUID);
            if (list == null) continue;
            Iterable $this$forEach$iv2 = list;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                TeamRequest it2 = (TeamRequest)element$iv2;
                boolean bl3 = false;
                RequestManager.cancelRequest$default(INSTANCE, it2, false, 2, null);
            }
        }
        MultiBattleTeam team = new MultiBattleTeam(Arrays.copyOf(players, players.length));
        multiBattleTeams.put(team.getTeamID(), team);
        class_3222[] class_3222Array = players;
        List<UUID> list = team.getTeamPlayersUUID();
        boolean $i$f$mapNotNull = false;
        element$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        int n2 = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n2; ++i) {
            class_5250 it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl4 = false;
            void it = element$iv$iv;
            boolean bl5 = false;
            if (it.method_5477().method_27662() == null) continue;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        List<UUID> list3 = list;
        TeamJoinNotificationPacket joinerPacket = new TeamJoinNotificationPacket(list3, list2);
        class_3222[] $this$forEach$iv3 = players;
        boolean $i$f$forEach3 = false;
        int n3 = $this$forEach$iv3.length;
        for (int i = 0; i < n3; ++i) {
            class_3222 element$iv3;
            class_3222 it = element$iv3 = $this$forEach$iv3[i];
            boolean bl7 = false;
            UUID uUID = it.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            playerToTeam.put(uUID, team);
            CobblemonNetwork.INSTANCE.sendPacketToPlayer(it, joinerPacket);
        }
        return team;
    }

    @Override
    protected void onAccept(@NotNull TeamRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super.onAccept((ServerPlayerActionRequest)request);
        MultiBattleTeam existingTeam = this.getTeam(request.getSender());
        if (existingTeam == null) {
            class_3222[] class_3222Array = new class_3222[]{request.getReceiver(), request.getSender()};
            this.createTeam(class_3222Array);
        } else {
            this.joinTeam(request.getReceiver(), existingTeam);
        }
    }

    @Override
    protected boolean canAccept(@NotNull TeamRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        MultiBattleTeam existingReceiverTeam = this.getTeam(request.getReceiverID());
        MultiBattleTeam existingSenderTeam = this.getTeam(request.getSenderID());
        if (CollectionsKt.none((Iterable)PlayerExtensionsKt.party(request.getSender()))) {
            request.notifySender(true, "error.no_pokemon", new Object[0]);
            request.notifyReceiver(true, "error.no_pokemon", new Object[0]);
        } else if (existingReceiverTeam != null) {
            Object[] objectArray = new Object[1];
            class_5250 class_52502 = request.getReceiver().method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"copy(...)");
            objectArray[0] = TextKt.aqua(class_52502);
            request.notifySender(true, "error.existing_team.other", objectArray);
            request.notifyReceiver(true, "error.existing_team.self", new Object[0]);
        } else if (existingSenderTeam != null && ((Collection)existingSenderTeam.getTeamPlayersUUID()).size() >= 2) {
            Object[] objectArray = new Object[1];
            class_5250 class_52503 = request.getReceiver().method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"copy(...)");
            objectArray[0] = TextKt.aqua(class_52503);
            request.notifySender(true, "error.max_team_size.other", objectArray);
            request.notifyReceiver(true, "error.max_team_size.self", new Object[0]);
        } else {
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidInteraction(@NotNull class_3222 player, @NotNull class_3222 target) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return PlayerExtensionsKt.canInteractWith(player, (class_1309)target, Cobblemon.INSTANCE.getConfig().getTradeMaxDistance());
    }

    @Override
    protected void onLogoff(@NotNull class_3222 sender) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        super.onLogoff(sender);
        this.removeTeamMember(sender);
    }

    static {
        RequestManager.Companion.register(INSTANCE);
        playerToTeam = new LinkedHashMap();
        multiBattleTeams = new LinkedHashMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0007\"\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u000b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0017\u001a\u0004\b\u0018\u0010\nR\u0017\u0010\u001a\u001a\u00020\u00198\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001f\u0010!\u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00190\u00190\u001e8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\n\u00a8\u0006\""}, d2={"Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "", "", "Lnet/minecraft/class_3222;", "teamPlayers", "<init>", "(Ljava/util/List;)V", "", "([Lnet/minecraft/class_3222;)V", "component1", "()Ljava/util/List;", "copy", "(Ljava/util/List;)Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "getTeamPlayers", "Ljava/util/UUID;", "teamID", "Ljava/util/UUID;", "getTeamID", "()Ljava/util/UUID;", "", "kotlin.jvm.PlatformType", "getTeamPlayersUUID", "teamPlayersUUID", "common"})
    @SourceDebugExtension(value={"SMAP\nTeamManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamManager.kt\ncom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n1557#2:202\n1628#2,3:203\n*S KotlinDebug\n*F\n+ 1 TeamManager.kt\ncom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam\n*L\n63#1:202\n63#1:203,3\n*E\n"})
    public static final class MultiBattleTeam {
        @NotNull
        private final List<class_3222> teamPlayers;
        @NotNull
        private final UUID teamID;

        public MultiBattleTeam(@NotNull List<class_3222> teamPlayers) {
            Intrinsics.checkNotNullParameter(teamPlayers, (String)"teamPlayers");
            this.teamPlayers = teamPlayers;
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            this.teamID = uUID;
        }

        @NotNull
        public final List<class_3222> getTeamPlayers() {
            return this.teamPlayers;
        }

        public MultiBattleTeam(class_3222 ... teamPlayers) {
            Intrinsics.checkNotNullParameter((Object)teamPlayers, (String)"teamPlayers");
            this(ArraysKt.toMutableList((Object[])teamPlayers));
        }

        @NotNull
        public final UUID getTeamID() {
            return this.teamID;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<UUID> getTeamPlayersUUID() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.teamPlayers;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                class_3222 class_32222 = (class_3222)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.method_5667());
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final List<class_3222> component1() {
            return this.teamPlayers;
        }

        @NotNull
        public final MultiBattleTeam copy(@NotNull List<class_3222> teamPlayers) {
            Intrinsics.checkNotNullParameter(teamPlayers, (String)"teamPlayers");
            return new MultiBattleTeam(teamPlayers);
        }

        public static /* synthetic */ MultiBattleTeam copy$default(MultiBattleTeam multiBattleTeam, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = multiBattleTeam.teamPlayers;
            }
            return multiBattleTeam.copy(list);
        }

        @NotNull
        public String toString() {
            return "MultiBattleTeam(teamPlayers=" + this.teamPlayers + ")";
        }

        public int hashCode() {
            return ((Object)this.teamPlayers).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MultiBattleTeam)) {
                return false;
            }
            MultiBattleTeam multiBattleTeam = (MultiBattleTeam)other;
            return Intrinsics.areEqual(this.teamPlayers, multiBattleTeam.teamPlayers);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\nR\u001a\u0010\u0004\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0019\u001a\u0004\b\u001b\u0010\nR\u001a\u0010\u0006\u001a\u00020\u00058\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b\u001d\u0010\rR\u001a\u0010\u001e\u001a\u00020\u00168\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010\u0018R\u001a\u0010\"\u001a\u00020!8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/cobblemon/mod/common/battles/TeamManager$TeamRequest;", "Lcom/cobblemon/mod/common/api/interaction/ServerPlayerActionRequest;", "Lnet/minecraft/class_3222;", "sender", "receiver", "", "expiryTime", "<init>", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;I)V", "component1", "()Lnet/minecraft/class_3222;", "component2", "component3", "()I", "copy", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;I)Lcom/cobblemon/mod/common/battles/TeamManager$TeamRequest;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_3222;", "getSender", "getReceiver", "I", "getExpiryTime", "key", "Ljava/lang/String;", "getKey", "Ljava/util/UUID;", "requestID", "Ljava/util/UUID;", "getRequestID", "()Ljava/util/UUID;", "common"})
    public static final class TeamRequest
    implements ServerPlayerActionRequest {
        @NotNull
        private final class_3222 sender;
        @NotNull
        private final class_3222 receiver;
        private final int expiryTime;
        @NotNull
        private final String key;
        @NotNull
        private final UUID requestID;

        public TeamRequest(@NotNull class_3222 sender, @NotNull class_3222 receiver, int expiryTime) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            this.sender = sender;
            this.receiver = receiver;
            this.expiryTime = expiryTime;
            this.key = "team";
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            this.requestID = uUID;
        }

        public /* synthetic */ TeamRequest(class_3222 class_32222, class_3222 class_32223, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                n = 60;
            }
            this(class_32222, class_32223, n);
        }

        @Override
        @NotNull
        public class_3222 getSender() {
            return this.sender;
        }

        @Override
        @NotNull
        public class_3222 getReceiver() {
            return this.receiver;
        }

        @Override
        public int getExpiryTime() {
            return this.expiryTime;
        }

        @Override
        @NotNull
        public String getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public UUID getRequestID() {
            return this.requestID;
        }

        @NotNull
        public final class_3222 component1() {
            return this.sender;
        }

        @NotNull
        public final class_3222 component2() {
            return this.receiver;
        }

        public final int component3() {
            return this.expiryTime;
        }

        @NotNull
        public final TeamRequest copy(@NotNull class_3222 sender, @NotNull class_3222 receiver, int expiryTime) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            return new TeamRequest(sender, receiver, expiryTime);
        }

        public static /* synthetic */ TeamRequest copy$default(TeamRequest teamRequest, class_3222 class_32222, class_3222 class_32223, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                class_32222 = teamRequest.sender;
            }
            if ((n2 & 2) != 0) {
                class_32223 = teamRequest.receiver;
            }
            if ((n2 & 4) != 0) {
                n = teamRequest.expiryTime;
            }
            return teamRequest.copy(class_32222, class_32223, n);
        }

        @NotNull
        public String toString() {
            return "TeamRequest(sender=" + this.sender + ", receiver=" + this.receiver + ", expiryTime=" + this.expiryTime + ")";
        }

        public int hashCode() {
            int result = this.sender.hashCode();
            result = result * 31 + this.receiver.hashCode();
            result = result * 31 + Integer.hashCode(this.expiryTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TeamRequest)) {
                return false;
            }
            TeamRequest teamRequest = (TeamRequest)other;
            if (!Intrinsics.areEqual((Object)this.sender, (Object)teamRequest.sender)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.receiver, (Object)teamRequest.receiver)) {
                return false;
            }
            return this.expiryTime == teamRequest.expiryTime;
        }

        @Override
        @NotNull
        public UUID getReceiverID() {
            return ServerPlayerActionRequest.DefaultImpls.getReceiverID(this);
        }

        @Override
        @NotNull
        public UUID getSenderID() {
            return ServerPlayerActionRequest.DefaultImpls.getSenderID(this);
        }

        @Override
        public void sendToSender(@NotNull NetworkPacket<?> packet) {
            ServerPlayerActionRequest.DefaultImpls.sendToSender(this, packet);
        }

        @Override
        public void sendToReceiver(@NotNull NetworkPacket<?> packet) {
            ServerPlayerActionRequest.DefaultImpls.sendToReceiver(this, packet);
        }

        @Override
        public void notifySender(boolean error, @NotNull String langKey, Object ... params) {
            ServerPlayerActionRequest.DefaultImpls.notifySender(this, error, langKey, params);
        }

        @Override
        public void notifyReceiver(boolean error, @NotNull String langKey, Object ... params) {
            ServerPlayerActionRequest.DefaultImpls.notifyReceiver(this, error, langKey, params);
        }

        @Override
        public void notify(@NotNull class_3222 player, boolean error, @NotNull String langKey, Object ... params) {
            ServerPlayerActionRequest.DefaultImpls.notify(this, player, error, langKey, params);
        }
    }
}

