/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.actor;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.EntityBackedBattleActor;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.experience.BattleExperienceSource;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.net.messages.client.battle.BattleMusicPacket;
import com.cobblemon.mod.common.pokemon.AddExperienceResult;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001b\u0010\u001d\u001a\u00020\u00182\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001c\u0010 \u001a\u0004\u0018\u00010\u001f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u0016\u0010&\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R.\u0010)\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010'8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u00100\u001a\u00020/8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103\u00a8\u00064"}, d2={"Lcom/cobblemon/mod/common/battles/actor/PlayerBattleActor;", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "Lcom/cobblemon/mod/common/api/battles/model/actor/EntityBackedBattleActor;", "Lnet/minecraft/class_3222;", "Ljava/util/UUID;", "uuid", "", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "pokemonList", "<init>", "(Ljava/util/UUID;Ljava/util/List;)V", "Lnet/minecraft/class_5250;", "getName", "()Lnet/minecraft/class_5250;", "", "name", "nameOwned", "(Ljava/lang/String;)Lnet/minecraft/class_5250;", "", "getPlayerUUIDs", "()Ljava/util/Set;", "battlePokemon", "", "experience", "", "awardExperience", "(Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;I)V", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "packet", "sendUpdate", "(Lcom/cobblemon/mod/common/api/net/NetworkPacket;)V", "Lnet/minecraft/class_243;", "initialPos", "Lnet/minecraft/class_243;", "getInitialPos", "()Lnet/minecraft/class_243;", "getEntity", "()Lnet/minecraft/class_3222;", "entity", "Lnet/minecraft/class_3414;", "value", "battleTheme", "Lnet/minecraft/class_3414;", "getBattleTheme", "()Lnet/minecraft/class_3414;", "setBattleTheme", "(Lnet/minecraft/class_3414;)V", "Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "type", "Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "getType", "()Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "common"})
@SourceDebugExtension(value={"SMAP\nPlayerBattleActor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerBattleActor.kt\ncom/cobblemon/mod/common/battles/actor/PlayerBattleActor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1#2:71\n1#2:82\n1611#3,9:72\n1863#3:81\n1864#3:83\n1620#3:84\n*S KotlinDebug\n*F\n+ 1 PlayerBattleActor.kt\ncom/cobblemon/mod/common/battles/actor/PlayerBattleActor\n*L\n67#1:82\n67#1:72,9\n67#1:81\n67#1:83\n67#1:84\n*E\n"})
public final class PlayerBattleActor
extends BattleActor
implements EntityBackedBattleActor<class_3222> {
    @Nullable
    private final class_243 initialPos;
    @Nullable
    private class_3414 battleTheme;
    @NotNull
    private final ActorType type;

    public PlayerBattleActor(@NotNull UUID uuid, @NotNull List<? extends BattlePokemon> pokemonList) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter(pokemonList, (String)"pokemonList");
        super(uuid, CollectionsKt.toMutableList((Collection)pokemonList));
        class_3222 class_32222 = this.getEntity();
        this.initialPos = class_32222 != null ? class_32222.method_19538() : null;
        this.type = ActorType.PLAYER;
    }

    @Override
    @Nullable
    public class_243 getInitialPos() {
        return this.initialPos;
    }

    @Override
    @Nullable
    public class_3222 getEntity() {
        return PlayerExtensionsKt.getPlayer(this.getUuid());
    }

    @Nullable
    public final class_3414 getBattleTheme() {
        return this.battleTheme;
    }

    public final void setBattleTheme(@Nullable class_3414 value) {
        if (this.isInitialized() && this.getBattle().getStarted()) {
            this.sendUpdate(new BattleMusicPacket(value, 0.0f, 0.0f, 6, null));
        }
        this.battleTheme = value;
    }

    @Override
    @NotNull
    public class_5250 getName() {
        class_3222 class_32222 = this.getEntity();
        if (class_32222 == null || (class_32222 = class_32222.method_5477()) == null || (class_32222 = class_32222.method_27661()) == null) {
            class_32222 = TextKt.red("Offline Player");
        }
        return class_32222;
    }

    @Override
    @NotNull
    public class_5250 nameOwned(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object[] objectArray = new Object[]{this.getName(), name};
        class_5250 class_52502 = LocalizationUtilsKt.battleLang("owned_pokemon", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"battleLang(...)");
        return class_52502;
    }

    @Override
    @NotNull
    public ActorType getType() {
        return this.type;
    }

    @NotNull
    public Set<UUID> getPlayerUUIDs() {
        return SetsKt.setOf((Object)this.getUuid());
    }

    @Override
    public void awardExperience(@NotNull BattlePokemon battlePokemon, int experience) {
        block4: {
            BattleExperienceSource source;
            block5: {
                Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
                if (this.getBattle().isPvP() && !Cobblemon.INSTANCE.getConfig().getAllowExperienceFromPvP()) {
                    return;
                }
                source = new BattleExperienceSource(this.getBattle(), CollectionsKt.toList((Iterable)battlePokemon.getFacedOpponents()));
                if (!Intrinsics.areEqual((Object)battlePokemon.getEffectedPokemon(), (Object)battlePokemon.getOriginalPokemon()) || experience <= 0) break block4;
                class_3222 class_32222 = PlayerExtensionsKt.getPlayer(this.getUuid());
                if (class_32222 == null) break block5;
                class_3222 it = class_32222;
                boolean bl2 = false;
                AddExperienceResult addExperienceResult = battlePokemon.getEffectedPokemon().addExperienceWithPlayer(it, source, experience);
                if (addExperienceResult != null) break block4;
            }
            PlayerBattleActor $this$awardExperience_u24lambda_u241 = this;
            boolean bl3 = false;
            battlePokemon.getEffectedPokemon().addExperience(source, experience);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendUpdate(@NotNull NetworkPacket<?> packet) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        Iterable iterable = this.getPlayerUUIDs();
        CobblemonNetwork cobblemonNetwork = CobblemonNetwork.INSTANCE;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            class_3222 it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            UUID it = (UUID)element$iv$iv;
            boolean bl3 = false;
            if (PlayerExtensionsKt.getPlayer(it) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        cobblemonNetwork.sendPacketToPlayers((List)destination$iv$iv, packet);
    }
}

