/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.ai;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.api.battles.interpreter.BattleContext;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.DefaultActionResponse;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.MoveActionResponse;
import com.cobblemon.mod.common.battles.ShowdownActionRequest;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.ShowdownPokemon;
import com.cobblemon.mod.common.battles.ShowdownSide;
import com.cobblemon.mod.common.battles.SwitchActionResponse;
import com.cobblemon.mod.common.battles.Targetable;
import com.cobblemon.mod.common.battles.ai.ActiveTracker;
import com.cobblemon.mod.common.battles.ai.StrongBattleAIKt;
import com.cobblemon.mod.common.battles.interpreter.ContextManager;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\u000bJ\u001d\u0010\r\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u000bJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0011J/\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u001b\u0010\u001cJ9\u0010 \u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00142\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b \u0010!J)\u0010&\u001a\u00020%2\u0006\u0010#\u001a\u00020\"2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010$\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b&\u0010'J%\u0010-\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020(2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\u0006\u00a2\u0006\u0004\b-\u0010.J1\u0010/\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\"2\u0006\u0010)\u001a\u00020(2\u0006\u0010+\u001a\u00020*2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b/\u00100J-\u00102\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\"2\u0006\u0010)\u001a\u00020(2\u0006\u0010+\u001a\u00020*2\u0006\u00101\u001a\u00020\u000f\u00a2\u0006\u0004\b2\u00103J/\u00104\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020(2\u0006\u0010+\u001a\u00020*2\u0006\u0010#\u001a\u00020\"2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0004\b4\u00105J\u001d\u00107\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\t\u001a\u000206\u00a2\u0006\u0004\b7\u00108J\u001d\u00109\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\t\u001a\u000206\u00a2\u0006\u0004\b9\u0010:J%\u0010=\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u000e\u0010<\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010;\u00a2\u0006\u0004\b=\u0010>J\u001d\u0010A\u001a\u00020\u001a2\u0006\u0010?\u001a\u00020\b2\u0006\u0010@\u001a\u00020\u0016\u00a2\u0006\u0004\bA\u0010BJ\u001d\u0010D\u001a\u00020\u001a2\u0006\u0010C\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u0006\u00a2\u0006\u0004\bD\u0010EJ\u001d\u0010H\u001a\u00020\u001a2\u0006\u0010F\u001a\u00020\u00062\u0006\u0010G\u001a\u00020\u0006\u00a2\u0006\u0004\bH\u0010EJ\u0015\u0010J\u001a\u00020\u000f2\u0006\u0010I\u001a\u00020\u0016\u00a2\u0006\u0004\bJ\u0010KJ\u0015\u0010M\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020L\u00a2\u0006\u0004\bM\u0010NJ\u0017\u0010P\u001a\u00020\u001a2\u0006\u0010O\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bP\u0010QJ#\u0010T\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\u00020S2\u0006\u0010R\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bT\u0010UJ'\u0010W\u001a\u00020V2\u0006\u0010#\u001a\u00020\"2\u0006\u0010)\u001a\u00020(2\u0006\u0010+\u001a\u00020*H\u0002\u00a2\u0006\u0004\bW\u0010XJ\u001f\u0010Z\u001a\u00020Y2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\bZ\u0010[J!\u0010`\u001a\u00020\u00162\u0006\u0010]\u001a\u00020\\2\b\u0010_\u001a\u0004\u0018\u00010^H\u0002\u00a2\u0006\u0004\b`\u0010aJ#\u0010c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060b2\u0006\u0010+\u001a\u00020*H\u0002\u00a2\u0006\u0004\bc\u0010dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010eR\u001a\u0010f\u001a\b\u0012\u0004\u0012\u00020\b0;8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bf\u0010gR\u001a\u0010h\u001a\b\u0012\u0004\u0012\u00020\b0;8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bh\u0010gR\u001a\u0010i\u001a\b\u0012\u0004\u0012\u00020\b0;8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bi\u0010gR\u001a\u0010j\u001a\b\u0012\u0004\u0012\u00020\b0;8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bj\u0010gR\u001a\u0010l\u001a\b\u0012\u0004\u0012\u00020\b0k8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bl\u0010mR\u001a\u0010n\u001a\b\u0012\u0004\u0012\u00020\b0;8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bn\u0010gR \u0010o\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0S8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bo\u0010pR\u0014\u0010q\u001a\u00020\u001a8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bq\u0010rR\u0016\u0010s\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bs\u0010rR\u0014\u0010t\u001a\u00020\u001a8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bt\u0010rR\u0014\u0010u\u001a\u00020\u001a8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bu\u0010rR\u0014\u0010v\u001a\u00020\u00028\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bv\u0010eR\u0014\u0010w\u001a\u00020\u001a8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bw\u0010rR\u0014\u0010x\u001a\u00020\u001a8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bx\u0010rR\u0014\u0010y\u001a\u00020\u00028\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\by\u0010eR\u0014\u0010z\u001a\u00020\u00028\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bz\u0010eR\u0014\u0010{\u001a\u00020\u001a8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b{\u0010rR\u0014\u0010|\u001a\u00020\u00028\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b|\u0010eR\u0014\u0010}\u001a\u00020\u001a8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b}\u0010rR\u0014\u0010~\u001a\u00020\u00028\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b~\u0010eR\u0014\u0010\u007f\u001a\u00020\u001a8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u007f\u0010rR\u0016\u0010\u0080\u0001\u001a\u00020\u001a8\u0002X\u0082D\u00a2\u0006\u0007\n\u0005\b\u0080\u0001\u0010rR\u0016\u0010\u0081\u0001\u001a\u00020\u001a8\u0002X\u0082D\u00a2\u0006\u0007\n\u0005\b\u0081\u0001\u0010rR\u0018\u0010\u0083\u0001\u001a\u00030\u0082\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0083\u0001\u0010\u0084\u0001\u00a8\u0006\u0085\u0001"}, d2={"Lcom/cobblemon/mod/common/battles/ai/StrongBattleAI;", "Lcom/cobblemon/mod/common/api/battles/model/ai/BattleAI;", "", "skill", "<init>", "(I)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "stat", "getBaseStats", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Ljava/lang/String;)I", "getIVs", "getEVs", "skillLevel", "", "checkSkillLevel", "(I)Z", "checkSwitchOutSkill", "checkUseItemSkill", "Lcom/cobblemon/mod/common/battles/InBattleMove;", "move", "Lcom/cobblemon/mod/common/battles/ai/ActiveTracker$TrackerPokemon;", "mon", "opponent", "currentWeather", "", "calculateDamage", "(Lcom/cobblemon/mod/common/battles/InBattleMove;Lcom/cobblemon/mod/common/battles/ai/ActiveTracker$TrackerPokemon;Lcom/cobblemon/mod/common/battles/ai/ActiveTracker$TrackerPokemon;Ljava/lang/String;)D", "selectedMove", "Lcom/cobblemon/mod/common/battles/ShowdownMoveset;", "moveset", "mostDamagingMove", "(Lcom/cobblemon/mod/common/battles/InBattleMove;Lcom/cobblemon/mod/common/battles/ShowdownMoveset;Lcom/cobblemon/mod/common/battles/ai/ActiveTracker$TrackerPokemon;Lcom/cobblemon/mod/common/battles/ai/ActiveTracker$TrackerPokemon;Ljava/lang/String;)Z", "Lcom/cobblemon/mod/common/battles/ActiveBattlePokemon;", "activeBattlePokemon", "forceSwitch", "Lcom/cobblemon/mod/common/battles/ShowdownActionResponse;", "choose", "(Lcom/cobblemon/mod/common/battles/ActiveBattlePokemon;Lcom/cobblemon/mod/common/battles/ShowdownMoveset;Z)Lcom/cobblemon/mod/common/battles/ShowdownActionResponse;", "Lcom/cobblemon/mod/common/battles/ShowdownActionRequest;", "request", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "nonActiveMon", "estimatePartyMatchup", "(Lcom/cobblemon/mod/common/battles/ShowdownActionRequest;Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;Lcom/cobblemon/mod/common/pokemon/Pokemon;)D", "estimateMatchup", "(Lcom/cobblemon/mod/common/battles/ActiveBattlePokemon;Lcom/cobblemon/mod/common/battles/ShowdownActionRequest;Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;Lcom/cobblemon/mod/common/pokemon/Pokemon;)D", "canDynamax", "shouldDynamax", "(Lcom/cobblemon/mod/common/battles/ActiveBattlePokemon;Lcom/cobblemon/mod/common/battles/ShowdownActionRequest;Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;Z)Z", "shouldSwitchOut", "(Lcom/cobblemon/mod/common/battles/ShowdownActionRequest;Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;Lcom/cobblemon/mod/common/battles/ActiveBattlePokemon;Lcom/cobblemon/mod/common/battles/ShowdownMoveset;)Z", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "statEstimationActive", "(Lcom/cobblemon/mod/common/battles/ai/ActiveTracker$TrackerPokemon;Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;)D", "statEstimation", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;)D", "", "possibleMoves", "getMoveSlot", "(Ljava/lang/String;Ljava/util/List;)Ljava/lang/String;", "moveID", "defender", "moveDamageMultiplier", "(Ljava/lang/String;Lcom/cobblemon/mod/common/battles/ai/ActiveTracker$TrackerPokemon;)D", "attacker", "bestDamageMultiplier", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblemon/mod/common/pokemon/Pokemon;)D", "attackingPokemon", "defendingPokemon", "typeMatchup", "trackerPokemon", "isBoosted", "(Lcom/cobblemon/mod/common/battles/ai/ActiveTracker$TrackerPokemon;)Z", "Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "expectedHits", "(Lcom/cobblemon/mod/common/api/moves/MoveTemplate;)I", "condition", "getHpFraction", "(Ljava/lang/String;)D", "name", "", "getNonZeroStats", "(Ljava/lang/String;)Ljava/util/Map;", "", "updateActiveTracker", "(Lcom/cobblemon/mod/common/battles/ActiveBattlePokemon;Lcom/cobblemon/mod/common/battles/ShowdownActionRequest;Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V", "Lcom/cobblemon/mod/common/battles/MoveActionResponse;", "chooseMove", "(Lcom/cobblemon/mod/common/battles/InBattleMove;Lcom/cobblemon/mod/common/battles/ActiveBattlePokemon;)Lcom/cobblemon/mod/common/battles/MoveActionResponse;", "Lcom/cobblemon/mod/common/battles/ai/ActiveTracker$TrackerActor;", "actor", "Ljava/util/UUID;", "pokemonUUID", "getActiveTrackerPokemon", "(Lcom/cobblemon/mod/common/battles/ai/ActiveTracker$TrackerActor;Ljava/util/UUID;)Lcom/cobblemon/mod/common/battles/ai/ActiveTracker$TrackerPokemon;", "Lkotlin/Pair;", "getCurrentPlayer", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)Lkotlin/Pair;", "I", "entryHazards", "Ljava/util/List;", "antiHazardsMoves", "antiBoostMoves", "pivotMoves", "", "setupMoves", "Ljava/util/Set;", "selfRecoveryMoves", "weatherSetupMoves", "Ljava/util/Map;", "speedTierCoefficient", "D", "trickRoomCoefficient", "typeMatchupWeightConsideration", "moveDamageWeightConsideration", "antiBoostWeightConsideration", "hpWeightConsideration", "hpFractionCoefficient", "boostWeightCoefficient", "switchOutMatchupThreshold", "selfKoMoveMatchupThreshold", "trickRoomThreshold", "recoveryMoveThreshold", "accuracySwitchThreshold", "hpSwitchOutThreshold", "randomProtectChance", "statusDamageConsiderationThreshold", "Lcom/cobblemon/mod/common/battles/ai/ActiveTracker;", "activeTracker", "Lcom/cobblemon/mod/common/battles/ai/ActiveTracker;", "common"})
@SourceDebugExtension(value={"SMAP\nStrongBattleAI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StrongBattleAI.kt\ncom/cobblemon/mod/common/battles/ai/StrongBattleAI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,1940:1\n774#2:1941\n865#2,2:1942\n1782#2,4:1944\n1782#2,4:1948\n1782#2,4:1952\n1782#2,4:1956\n1782#2,4:1960\n1782#2,4:1964\n1782#2,4:1968\n1782#2,4:1972\n1782#2,4:1976\n1782#2,4:1980\n1782#2,4:1984\n1782#2,4:1988\n1782#2,4:1992\n1782#2,4:1996\n1782#2,4:2000\n1782#2,4:2004\n1782#2,4:2008\n1782#2,4:2012\n1782#2,4:2016\n1782#2,4:2020\n1863#2,2:2024\n1863#2,2:2026\n774#2:2028\n865#2,2:2029\n774#2:2031\n865#2,2:2032\n827#2:2035\n855#2,2:2036\n774#2:2038\n865#2,2:2039\n774#2:2041\n865#2,2:2042\n774#2:2044\n865#2,2:2045\n774#2:2047\n865#2,2:2048\n774#2:2050\n865#2,2:2051\n1782#2,4:2053\n774#2:2057\n865#2,2:2058\n295#2,2:2060\n295#2,2:2062\n774#2:2064\n865#2,2:2065\n774#2:2067\n865#2,2:2068\n774#2:2070\n865#2,2:2071\n774#2:2073\n865#2,2:2074\n1782#2,4:2076\n774#2:2080\n865#2,2:2081\n774#2:2083\n865#2,2:2084\n774#2:2086\n865#2,2:2087\n774#2:2089\n865#2,2:2090\n774#2:2092\n865#2,2:2093\n2632#2,3:2095\n1755#2,3:2098\n2632#2,3:2101\n2632#2,3:2104\n774#2:2107\n865#2,2:2108\n774#2:2110\n865#2,2:2111\n774#2:2113\n865#2,2:2114\n774#2:2116\n865#2,2:2117\n774#2:2119\n865#2,2:2120\n1755#2,3:2122\n774#2:2125\n865#2,2:2126\n774#2:2128\n865#2,2:2129\n774#2:2131\n865#2,2:2132\n1755#2,3:2134\n295#2,2:2137\n2632#2,3:2139\n774#2:2142\n865#2,2:2143\n774#2:2145\n865#2,2:2146\n774#2:2148\n865#2,2:2149\n774#2:2151\n865#2,2:2152\n774#2:2154\n865#2,2:2155\n774#2:2157\n865#2,2:2158\n1755#2,3:2160\n1755#2,3:2163\n1782#2,4:2166\n1782#2,4:2170\n774#2:2174\n865#2,2:2175\n1755#2,3:2177\n1755#2,3:2180\n774#2:2183\n865#2,2:2184\n774#2:2186\n865#2,2:2187\n1734#2,3:2189\n1755#2,3:2192\n360#2,7:2195\n1863#2,2:2202\n1557#2:2204\n1628#2,3:2205\n1782#2,4:2208\n1782#2,4:2212\n1782#2,4:2216\n1782#2,4:2220\n1782#2,4:2224\n1782#2,4:2228\n1782#2,4:2232\n1782#2,4:2236\n1782#2,4:2240\n1782#2,4:2244\n1246#2,4:2250\n1246#2,4:2256\n1782#2,4:2260\n360#2,7:2264\n1782#2,4:2271\n360#2,7:2275\n774#2:2282\n865#2,2:2283\n1#3:2034\n477#4:2248\n423#4:2249\n477#4:2254\n423#4:2255\n*S KotlinDebug\n*F\n+ 1 StrongBattleAI.kt\ncom/cobblemon/mod/common/battles/ai/StrongBattleAI\n*L\n517#1:1941\n517#1:1942,2\n551#1:1944,4\n552#1:1948,4\n553#1:1952,4\n554#1:1956,4\n555#1:1960,4\n557#1:1964,4\n558#1:1968,4\n559#1:1972,4\n560#1:1976,4\n561#1:1980,4\n564#1:1984,4\n565#1:1988,4\n566#1:1992,4\n567#1:1996,4\n568#1:2000,4\n570#1:2004,4\n571#1:2008,4\n572#1:2012,4\n573#1:2016,4\n574#1:2020,4\n619#1:2024,2\n622#1:2026,2\n632#1:2028\n632#1:2029,2\n639#1:2031\n639#1:2032,2\n728#1:2035\n728#1:2036,2\n759#1:2038\n759#1:2039,2\n760#1:2041\n760#1:2042,2\n777#1:2044\n777#1:2045,2\n778#1:2047\n778#1:2048,2\n797#1:2050\n797#1:2051,2\n813#1:2053,4\n819#1:2057\n819#1:2058,2\n825#1:2060,2\n834#1:2062,2\n845#1:2064\n845#1:2065,2\n852#1:2067\n852#1:2068,2\n853#1:2070\n853#1:2071,2\n856#1:2073\n856#1:2074,2\n862#1:2076,4\n877#1:2080\n877#1:2081,2\n885#1:2083\n885#1:2084,2\n891#1:2086\n891#1:2087,2\n908#1:2089\n908#1:2090,2\n915#1:2092\n915#1:2093,2\n917#1:2095,3\n918#1:2098,3\n919#1:2101,3\n920#1:2104,3\n928#1:2107\n928#1:2108,2\n944#1:2110\n944#1:2111,2\n957#1:2113\n957#1:2114,2\n970#1:2116\n970#1:2117,2\n1005#1:2119\n1005#1:2120,2\n1011#1:2122,3\n1090#1:2125\n1090#1:2126,2\n1098#1:2128\n1098#1:2129,2\n1115#1:2131\n1115#1:2132,2\n1189#1:2134,3\n1238#1:2137,2\n1241#1:2139,3\n1247#1:2142\n1247#1:2143,2\n1257#1:2145\n1257#1:2146,2\n1270#1:2148\n1270#1:2149,2\n1278#1:2151\n1278#1:2152,2\n1297#1:2154\n1297#1:2155,2\n1298#1:2157\n1298#1:2158,2\n1356#1:2160,3\n1405#1:2163,3\n1443#1:2166,4\n1453#1:2170,4\n1480#1:2174\n1480#1:2175,2\n1484#1:2177,3\n1496#1:2180,3\n1500#1:2183\n1500#1:2184,2\n1501#1:2186\n1501#1:2187,2\n1502#1:2189,3\n1510#1:2192,3\n1556#1:2195,7\n1631#1:2202,2\n1748#1:2204\n1748#1:2205,3\n1773#1:2208,4\n1774#1:2212,4\n1775#1:2216,4\n1776#1:2220,4\n1777#1:2224,4\n1779#1:2228,4\n1780#1:2232,4\n1781#1:2236,4\n1782#1:2240,4\n1783#1:2244,4\n1823#1:2250,4\n1839#1:2256,4\n1861#1:2260,4\n1870#1:2264,7\n1892#1:2271,4\n1900#1:2275,7\n1913#1:2282\n1913#1:2283,2\n1823#1:2248\n1823#1:2249\n1839#1:2254\n1839#1:2255\n*E\n"})
public final class StrongBattleAI
implements BattleAI {
    private final int skill;
    @NotNull
    private final List<String> entryHazards;
    @NotNull
    private final List<String> antiHazardsMoves;
    @NotNull
    private final List<String> antiBoostMoves;
    @NotNull
    private final List<String> pivotMoves;
    @NotNull
    private final Set<String> setupMoves;
    @NotNull
    private final List<String> selfRecoveryMoves;
    @NotNull
    private final Map<String, String> weatherSetupMoves;
    private final double speedTierCoefficient;
    private double trickRoomCoefficient;
    private final double typeMatchupWeightConsideration;
    private final double moveDamageWeightConsideration;
    private final int antiBoostWeightConsideration;
    private final double hpWeightConsideration;
    private final double hpFractionCoefficient;
    private final int boostWeightCoefficient;
    private final int switchOutMatchupThreshold;
    private final double selfKoMoveMatchupThreshold;
    private final int trickRoomThreshold;
    private final double recoveryMoveThreshold;
    private final int accuracySwitchThreshold;
    private final double hpSwitchOutThreshold;
    private final double randomProtectChance;
    private final double statusDamageConsiderationThreshold;
    @NotNull
    private final ActiveTracker activeTracker;

    public StrongBattleAI(int skill) {
        this.skill = skill < 0 ? 0 : (skill > 5 ? 5 : skill);
        Object[] objectArray = new String[]{"spikes", "stealthrock", "stickyweb", "toxicspikes"};
        this.entryHazards = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"rapidspin", "defog", "tidyup"};
        this.antiHazardsMoves = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"slearsmog", "haze"};
        this.antiBoostMoves = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"uturn", "flipturn", "partingshot", "batonpass", "chillyreception", "shedtail", "voltswitch", "teleport"};
        this.pivotMoves = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"tailwind", "trickroom", "auroraveil", "lightscreen", "reflect"};
        this.setupMoves = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"healorder", "milkdrink", "recover", "rest", "roost", "slackoff", "softboiled"};
        this.selfRecoveryMoves = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"chillyreception", (Object)"Snow"), TuplesKt.to((Object)"hail", (Object)"Hail"), TuplesKt.to((Object)"raindance", (Object)"RainDance"), TuplesKt.to((Object)"sandstorm", (Object)"Sandstorm"), TuplesKt.to((Object)"snowscape", (Object)"Snow"), TuplesKt.to((Object)"sunnyday", (Object)"SunnyDay")};
        this.weatherSetupMoves = MapsKt.mapOf((Pair[])objectArray);
        this.speedTierCoefficient = 4.0;
        this.trickRoomCoefficient = 1.0;
        this.typeMatchupWeightConsideration = 2.5;
        this.moveDamageWeightConsideration = 0.8;
        this.antiBoostWeightConsideration = 25;
        this.hpWeightConsideration = 0.25;
        this.hpFractionCoefficient = 0.4;
        this.boostWeightCoefficient = 1;
        this.selfKoMoveMatchupThreshold = 0.3;
        this.trickRoomThreshold = 85;
        this.recoveryMoveThreshold = 0.5;
        this.accuracySwitchThreshold = -3;
        this.hpSwitchOutThreshold = 0.3;
        this.randomProtectChance = 0.3;
        this.statusDamageConsiderationThreshold = 0.8;
        this.activeTracker = new ActiveTracker();
    }

    public final int getBaseStats(@NotNull Pokemon pokemon, @NotNull String stat) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        return switch (stat) {
            case "hp" -> {
                Integer v0 = pokemon.getSpecies().getBaseStats().getOrDefault(Stats.HP, 0);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getOrDefault(...)");
                yield ((Number)v0).intValue();
            }
            case "atk" -> {
                Integer v2 = pokemon.getSpecies().getBaseStats().getOrDefault(Stats.ATTACK, 0);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getOrDefault(...)");
                yield ((Number)v2).intValue();
            }
            case "spa" -> {
                Integer v3 = pokemon.getSpecies().getBaseStats().getOrDefault(Stats.SPECIAL_ATTACK, 0);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getOrDefault(...)");
                yield ((Number)v3).intValue();
            }
            case "def" -> {
                Integer v4 = pokemon.getSpecies().getBaseStats().getOrDefault(Stats.DEFENCE, 0);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getOrDefault(...)");
                yield ((Number)v4).intValue();
            }
            case "spd" -> {
                Integer v5 = pokemon.getSpecies().getBaseStats().getOrDefault(Stats.SPECIAL_DEFENCE, 0);
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getOrDefault(...)");
                yield ((Number)v5).intValue();
            }
            case "spe" -> {
                Integer v6 = pokemon.getSpecies().getBaseStats().getOrDefault(Stats.SPEED, 0);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getOrDefault(...)");
                yield ((Number)v6).intValue();
            }
            case "total" -> {
                int v7 = ((Number)pokemon.getSpecies().getBaseStats().getOrDefault(Stats.HP, 0)).intValue();
                Integer v8 = pokemon.getSpecies().getBaseStats().getOrDefault(Stats.ATTACK, 0);
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getOrDefault(...)");
                int v9 = v7 + ((Number)v8).intValue();
                Integer v10 = pokemon.getSpecies().getBaseStats().getOrDefault(Stats.DEFENCE, 0);
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"getOrDefault(...)");
                int v11 = v9 + ((Number)v10).intValue();
                Integer v12 = pokemon.getSpecies().getBaseStats().getOrDefault(Stats.SPECIAL_DEFENCE, 0);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"getOrDefault(...)");
                int v13 = v11 + ((Number)v12).intValue();
                Integer v14 = pokemon.getSpecies().getBaseStats().getOrDefault(Stats.SPEED, 0);
                Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"getOrDefault(...)");
                yield v13 + ((Number)v14).intValue();
            }
            default -> 0;
        };
    }

    public final int getIVs(@NotNull Pokemon pokemon, @NotNull String stat) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        return switch (stat) {
            case "hp" -> pokemon.getIvs().getOrDefault(Stats.HP);
            case "atk" -> pokemon.getIvs().getOrDefault(Stats.ATTACK);
            case "spa" -> pokemon.getIvs().getOrDefault(Stats.SPECIAL_ATTACK);
            case "def" -> pokemon.getIvs().getOrDefault(Stats.DEFENCE);
            case "spd" -> pokemon.getIvs().getOrDefault(Stats.SPECIAL_DEFENCE);
            case "spe" -> pokemon.getIvs().getOrDefault(Stats.SPEED);
            default -> 0;
        };
    }

    public final int getEVs(@NotNull Pokemon pokemon, @NotNull String stat) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        return switch (stat) {
            case "hp" -> pokemon.getEvs().getOrDefault(Stats.HP);
            case "atk" -> pokemon.getEvs().getOrDefault(Stats.ATTACK);
            case "spa" -> pokemon.getEvs().getOrDefault(Stats.SPECIAL_ATTACK);
            case "def" -> pokemon.getEvs().getOrDefault(Stats.DEFENCE);
            case "spd" -> pokemon.getEvs().getOrDefault(Stats.SPECIAL_DEFENCE);
            case "spe" -> pokemon.getEvs().getOrDefault(Stats.SPEED);
            default -> 0;
        };
    }

    public final boolean checkSkillLevel(int skillLevel) {
        if (skillLevel == 5) {
            return true;
        }
        int randomNumber = Random.Default.nextInt(100);
        return randomNumber < skillLevel * 20;
    }

    public final boolean checkSwitchOutSkill(int skillLevel) {
        double randomNumber = Random.Default.nextDouble();
        int n = skillLevel;
        double chance = (0 <= n ? n < 3 : false) ? 0.0 : (n == 3 ? 0.2 : (n == 4 ? 0.6 : (n == 5 ? 1.0 : 0.0)));
        return randomNumber <= chance;
    }

    public final boolean checkUseItemSkill(int skillLevel) {
        double randomNumber = Random.Default.nextDouble();
        int n = skillLevel;
        double chance = (0 <= n ? n < 2 : false) ? 0.0 : (n == 2 ? 0.25 : (n == 3 ? 0.5 : (n == 4 ? 0.75 : (n == 5 ? 1.0 : 0.0))));
        return randomNumber < chance;
    }

    /*
     * Unable to fully structure code
     */
    public final double calculateDamage(@NotNull InBattleMove move, @NotNull ActiveTracker.TrackerPokemon mon, @NotNull ActiveTracker.TrackerPokemon opponent, @Nullable String currentWeather) {
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        Intrinsics.checkNotNullParameter((Object)mon, (String)"mon");
        Intrinsics.checkNotNullParameter((Object)opponent, (String)"opponent");
        moveData = Moves.INSTANCE.getByName(move.getId());
        physicalRatio = this.statEstimationActive(mon, Stats.ATTACK) / this.statEstimationActive(opponent, Stats.DEFENCE);
        specialRatio = this.statEstimationActive(mon, Stats.SPECIAL_ATTACK) / this.statEstimationActive(opponent, Stats.SPECIAL_DEFENCE);
        v0 = moveData;
        Intrinsics.checkNotNull((Object)v0);
        movePower = v0.getPower();
        v1 = mon.getPokemon();
        Intrinsics.checkNotNull((Object)v1);
        pokemonLevel = v1.getLevel();
        statRatio = Intrinsics.areEqual((Object)moveData.getDamageCategory(), (Object)DamageCategories.INSTANCE.getPHYSICAL()) != false ? physicalRatio : specialRatio;
        v2 = mon.getPokemon();
        Intrinsics.checkNotNull((Object)v2);
        if (!CollectionsKt.contains(v2.getTypes(), (Object)moveData.getElementalType())) ** GOTO lbl-1000
        v3 = mon.getPokemon();
        Intrinsics.checkNotNull((Object)v3);
        if (Intrinsics.areEqual((Object)v3.getAbility().getName(), (Object)"adaptability")) {
            v4 = 2.0;
        } else lbl-1000:
        // 2 sources

        {
            v5 = mon.getPokemon();
            Intrinsics.checkNotNull((Object)v5);
            v4 = CollectionsKt.contains(v5.getTypes(), (Object)moveData.getElementalType()) != false ? 1.5 : 1.0;
        }
        STAB = v4;
        weather = Intrinsics.areEqual((Object)currentWeather, (Object)"sunny") != false && (Intrinsics.areEqual((Object)moveData.getElementalType(), (Object)ElementalTypes.INSTANCE.getFIRE()) != false || Intrinsics.areEqual((Object)moveData.getName(), (Object)"hydrosteam") != false) ? 1.5 : (Intrinsics.areEqual((Object)currentWeather, (Object)"sunny") != false && Intrinsics.areEqual((Object)moveData.getElementalType(), (Object)ElementalTypes.INSTANCE.getWATER()) != false && Intrinsics.areEqual((Object)moveData.getName(), (Object)"hydrosteam") == false ? 0.5 : (Intrinsics.areEqual((Object)currentWeather, (Object)"raining") != false && Intrinsics.areEqual((Object)moveData.getElementalType(), (Object)ElementalTypes.INSTANCE.getWATER()) != false ? 1.5 : (Intrinsics.areEqual((Object)currentWeather, (Object)"raining") != false && Intrinsics.areEqual((Object)moveData.getElementalType(), (Object)ElementalTypes.INSTANCE.getFIRE()) != false ? 0.5 : 1.0)));
        damageTypeMultiplier = this.moveDamageMultiplier(move.getId(), opponent);
        v6 = opponent.getPokemon();
        Intrinsics.checkNotNull((Object)v6);
        v7 = v6.getStatus();
        burn = Intrinsics.areEqual((Object)(v7 != null && (v7 = v7.getStatus()) != null ? v7.getShowdownName() : null), (Object)"burn") != false && Intrinsics.areEqual((Object)moveData.getDamageCategory(), (Object)DamageCategories.INSTANCE.getPHYSICAL()) != false ? 0.5 : 1.0;
        damage = (double)(2 * pokemonLevel / 5 + 2) * movePower * statRatio / (double)50 + (double)2;
        damage *= weather;
        damage *= STAB;
        damage *= damageTypeMultiplier;
        return damage *= burn;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean mostDamagingMove(@NotNull InBattleMove selectedMove, @Nullable ShowdownMoveset moveset, @NotNull ActiveTracker.TrackerPokemon mon, @NotNull ActiveTracker.TrackerPokemon opponent, @Nullable String currentWeather) {
        Intrinsics.checkNotNullParameter((Object)selectedMove, (String)"selectedMove");
        Intrinsics.checkNotNullParameter((Object)mon, (String)"mon");
        Intrinsics.checkNotNullParameter((Object)opponent, (String)"opponent");
        if (moveset != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = moveset.getMoves();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                InBattleMove it = (InBattleMove)element$iv$iv;
                boolean bl2 = false;
                if (!(!it.getDisabled() && !Intrinsics.areEqual((Object)it.getId(), (Object)selectedMove.getId()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (InBattleMove move : (List)destination$iv$iv) {
                if (!(this.calculateDamage(move, mon, opponent, currentWeather) > this.calculateDamage(selectedMove, mon, opponent, currentWeather))) continue;
                return false;
            }
            return this.calculateDamage(selectedMove, mon, opponent, currentWeather) > 0.0;
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public ShowdownActionResponse choose(@NotNull ActiveBattlePokemon activeBattlePokemon, @Nullable ShowdownMoveset moveset, boolean forceSwitch) {
        block332: {
            block326: {
                block334: {
                    block319: {
                        block333: {
                            block318: {
                                block331: {
                                    block330: {
                                        block316: {
                                            block315: {
                                                block329: {
                                                    block314: {
                                                        Intrinsics.checkNotNullParameter((Object)activeBattlePokemon, (String)"activeBattlePokemon");
                                                        battle = activeBattlePokemon.getBattle();
                                                        v0 = activeBattlePokemon.getActor().getRequest();
                                                        Intrinsics.checkNotNull((Object)v0);
                                                        request = v0;
                                                        p1Actor = (BattleActor)ArraysKt.first((Object[])battle.getSide1().getActors());
                                                        p2Actor = (BattleActor)ArraysKt.first((Object[])battle.getSide2().getActors());
                                                        activePlayerBattlePokemon = p1Actor.getActivePokemon().get(0).getBattlePokemon();
                                                        activeNPCBattlePokemon = p2Actor.getActivePokemon().get(0).getBattlePokemon();
                                                        v1 = activePlayerBattlePokemon;
                                                        activePlayerBattlePokemonPosBoosts = v1 != null && (v1 = (var11_10 = v1.getContextManager())) != null ? v1.get(BattleContext.Type.BOOST) : null;
                                                        v2 = activeNPCBattlePokemon;
                                                        activeNPCBattlePokemonPosBoosts = v2 != null && (v2 = (var12_12 = v2.getContextManager())) != null ? v2.get(BattleContext.Type.BOOST) : null;
                                                        v3 = activePlayerBattlePokemon;
                                                        activePlayerBattlePokemonNegBoosts = v3 != null && (v3 = (var13_13 = v3.getContextManager())) != null ? v3.get(BattleContext.Type.UNBOOST) : null;
                                                        v4 = activeNPCBattlePokemon;
                                                        activeNPCBattlePokemonNegBoosts = v4 != null && (v4 = (var14_14 = v4.getContextManager())) != null ? v4.get(BattleContext.Type.UNBOOST) : null;
                                                        v5 = activePlayerBattlePokemonPosBoosts;
                                                        if (v5 != null) {
                                                            $this$count$iv = v5;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v6 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (Object element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$playerATKPosBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"atk") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v6 = count$iv;
                                                            }
                                                            v7 = var15_54 = v6;
                                                        } else {
                                                            v7 = 0;
                                                        }
                                                        playerATKPosBoosts = v7;
                                                        v8 = activePlayerBattlePokemonPosBoosts;
                                                        if (v8 != null) {
                                                            $this$count$iv = v8;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v9 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (Object element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$playerDEFPosBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"def") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v9 = count$iv;
                                                            }
                                                            v10 = $this$count$iv = v9;
                                                        } else {
                                                            v10 = 0;
                                                        }
                                                        playerDEFPosBoosts = v10;
                                                        v11 = activePlayerBattlePokemonPosBoosts;
                                                        if (v11 != null) {
                                                            $this$count$iv = v11;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v12 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (E element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$playerSPAPosBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"spa") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v12 = count$iv;
                                                            }
                                                            v13 = $this$count$iv = v12;
                                                        } else {
                                                            v13 = 0;
                                                        }
                                                        playerSPAPosBoosts = v13;
                                                        v14 = activePlayerBattlePokemonPosBoosts;
                                                        if (v14 != null) {
                                                            $this$count$iv = v14;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v15 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$playerSPDPosBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"spd") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v15 = count$iv;
                                                            }
                                                            v16 = $this$count$iv = v15;
                                                        } else {
                                                            v16 = 0;
                                                        }
                                                        playerSPDPosBoosts = v16;
                                                        v17 = activePlayerBattlePokemonPosBoosts;
                                                        if (v17 != null) {
                                                            $this$count$iv = v17;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v18 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$playerSPEPosBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"spe") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v18 = count$iv;
                                                            }
                                                            v19 = $this$count$iv = v18;
                                                        } else {
                                                            v19 = 0;
                                                        }
                                                        playerSPEPosBoosts = v19;
                                                        v20 = activeNPCBattlePokemonPosBoosts;
                                                        if (v20 != null) {
                                                            $this$count$iv = v20;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v21 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$npcATKPosBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"atk") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v21 = count$iv;
                                                            }
                                                            v22 = $this$count$iv = v21;
                                                        } else {
                                                            v22 = 0;
                                                        }
                                                        npcATKPosBoosts = v22;
                                                        v23 = activeNPCBattlePokemonPosBoosts;
                                                        if (v23 != null) {
                                                            $this$count$iv = v23;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v24 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$npcDEFPosBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"def") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v24 = count$iv;
                                                            }
                                                            v25 = $this$count$iv = v24;
                                                        } else {
                                                            v25 = 0;
                                                        }
                                                        npcDEFPosBoosts = v25;
                                                        v26 = activeNPCBattlePokemonPosBoosts;
                                                        if (v26 != null) {
                                                            $this$count$iv = v26;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v27 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$npcSPAPosBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"spa") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v27 = count$iv;
                                                            }
                                                            v28 = $this$count$iv = v27;
                                                        } else {
                                                            v28 = 0;
                                                        }
                                                        npcSPAPosBoosts = v28;
                                                        v29 = activeNPCBattlePokemonPosBoosts;
                                                        if (v29 != null) {
                                                            $this$count$iv = v29;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v30 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$npcSPDPosBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"spd") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v30 = count$iv;
                                                            }
                                                            v31 = $this$count$iv = v30;
                                                        } else {
                                                            v31 = 0;
                                                        }
                                                        npcSPDPosBoosts = v31;
                                                        v32 = activeNPCBattlePokemonPosBoosts;
                                                        if (v32 != null) {
                                                            $this$count$iv = v32;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v33 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$npcSPEPosBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"spe") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v33 = count$iv;
                                                            }
                                                            v34 = $this$count$iv = v33;
                                                        } else {
                                                            v34 = 0;
                                                        }
                                                        npcSPEPosBoosts = v34;
                                                        v35 = activePlayerBattlePokemonNegBoosts;
                                                        if (v35 != null) {
                                                            $this$count$iv = v35;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v36 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$playerATKNegBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"atk") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v36 = count$iv;
                                                            }
                                                            v37 = $this$count$iv = v36;
                                                        } else {
                                                            v37 = 0;
                                                        }
                                                        playerATKNegBoosts = v37;
                                                        v38 = activePlayerBattlePokemonNegBoosts;
                                                        if (v38 != null) {
                                                            $this$count$iv = v38;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v39 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$playerDEFNegBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"def") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v39 = count$iv;
                                                            }
                                                            v40 = $this$count$iv = v39;
                                                        } else {
                                                            v40 = 0;
                                                        }
                                                        playerDEFNegBoosts = v40;
                                                        v41 = activePlayerBattlePokemonNegBoosts;
                                                        if (v41 != null) {
                                                            $this$count$iv = v41;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v42 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$playerSPANegBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"spa") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v42 = count$iv;
                                                            }
                                                            v43 = $this$count$iv = v42;
                                                        } else {
                                                            v43 = 0;
                                                        }
                                                        playerSPANegBoosts = v43;
                                                        v44 = activePlayerBattlePokemonNegBoosts;
                                                        if (v44 != null) {
                                                            $this$count$iv = v44;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v45 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$playerSPDNegBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"spd") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v45 = count$iv;
                                                            }
                                                            v46 = $this$count$iv = v45;
                                                        } else {
                                                            v46 = 0;
                                                        }
                                                        playerSPDNegBoosts = v46;
                                                        v47 = activePlayerBattlePokemonNegBoosts;
                                                        if (v47 != null) {
                                                            $this$count$iv = v47;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v48 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$playerSPENegBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"spe") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v48 = count$iv;
                                                            }
                                                            v49 = $this$count$iv = v48;
                                                        } else {
                                                            v49 = 0;
                                                        }
                                                        playerSPENegBoosts = v49;
                                                        v50 = activeNPCBattlePokemonNegBoosts;
                                                        if (v50 != null) {
                                                            $this$count$iv = v50;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v51 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$npcATKNegBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"atk") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v51 = count$iv;
                                                            }
                                                            v52 = $this$count$iv = v51;
                                                        } else {
                                                            v52 = 0;
                                                        }
                                                        npcATKNegBoosts = v52;
                                                        v53 = activeNPCBattlePokemonNegBoosts;
                                                        if (v53 != null) {
                                                            $this$count$iv = v53;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v54 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$npcDEFNegBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"def") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v54 = count$iv;
                                                            }
                                                            v55 = $this$count$iv = v54;
                                                        } else {
                                                            v55 = 0;
                                                        }
                                                        npcDEFNegBoosts = v55;
                                                        v56 = activeNPCBattlePokemonNegBoosts;
                                                        if (v56 != null) {
                                                            $this$count$iv = v56;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v57 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$npcSPANegBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"spa") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v57 = count$iv;
                                                            }
                                                            v58 = $this$count$iv = v57;
                                                        } else {
                                                            v58 = 0;
                                                        }
                                                        npcSPANegBoosts = v58;
                                                        v59 = activeNPCBattlePokemonNegBoosts;
                                                        if (v59 != null) {
                                                            $this$count$iv = v59;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v60 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$npcSPDNegBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"spd") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v60 = count$iv;
                                                            }
                                                            v61 = $this$count$iv = v60;
                                                        } else {
                                                            v61 = 0;
                                                        }
                                                        npcSPDNegBoosts = v61;
                                                        v62 = activeNPCBattlePokemonNegBoosts;
                                                        if (v62 != null) {
                                                            $this$count$iv = v62;
                                                            $i$f$count = false;
                                                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                                                v63 = 0;
                                                            } else {
                                                                count$iv = 0;
                                                                for (T element$iv : $this$count$iv) {
                                                                    it = (BattleContext)element$iv;
                                                                    $i$a$-count-StrongBattleAI$choose$npcSPENegBoosts$1 = false;
                                                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"spe") || ++count$iv >= 0) continue;
                                                                    CollectionsKt.throwCountOverflow();
                                                                }
                                                                v63 = count$iv;
                                                            }
                                                            v64 = $this$count$iv = v63;
                                                        } else {
                                                            v64 = 0;
                                                        }
                                                        npcSPENegBoosts = v64;
                                                        playerATKBoosts = $this$count$iv = playerATKPosBoosts - playerATKNegBoosts;
                                                        playerDEFBoosts = $i$f$count = playerDEFPosBoosts - playerDEFNegBoosts;
                                                        playerSPABoosts = count$iv = playerSPAPosBoosts - playerSPANegBoosts;
                                                        playerSPDBoosts = element$iv = playerSPDPosBoosts - playerSPDNegBoosts;
                                                        playerSPEBoosts = element$iv = playerSPEPosBoosts - playerSPENegBoosts;
                                                        npcATKBoosts = npcATKPosBoosts - npcATKNegBoosts;
                                                        npcDEFBoosts = npcDEFPosBoosts - npcDEFNegBoosts;
                                                        npcSPABoosts = npcSPAPosBoosts - npcSPANegBoosts;
                                                        npcSPDBoosts = npcSPDPosBoosts - npcSPDNegBoosts;
                                                        npcSPEBoosts = npcSPEPosBoosts - npcSPENegBoosts;
                                                        v65 = activePlayerBattlePokemon;
                                                        if (v65 != null && (v65 = (var45_199 = v65.getOriginalPokemon())) != null && (v65 = (var46_200 = v65.getStatus())) != null && (v65 = (var47_201 = v65.getStatus())) != null && (v65 = (var48_202 /* !! */  = v65.getName())) != null) {
                                                            v66 = (Comparable)v65;
                                                        } else {
                                                            try {
                                                                v67 = activePlayerBattlePokemon;
                                                                var50_204 = v67 != null && (v67 = (var50_204 = v67.getContextManager())) != null && (v67 = (var51_206 = v67.get(BattleContext.Type.STATUS))) != null && (v67 = (var52_211 = (BattleContext)CollectionsKt.last((Iterable)((Iterable)v67)))) != null ? v67.getId() : null;
                                                            }
                                                            catch (Exception e) {
                                                                var50_204 = "";
                                                            }
                                                            var49_214 = var50_204;
                                                            v68 = var49_214;
                                                            v66 = v68 != null ? (Comparable)v68 : (Comparable)"";
                                                        }
                                                        activePlayerPokemonStatus = v66;
                                                        try {
                                                            v69 = activePlayerBattlePokemon;
                                                            var47_201 = v69 != null && (v69 = (var47_201 = v69.getContextManager())) != null && (v69 = (var48_202 /* !! */  = v69.get(BattleContext.Type.VOLATILE))) != null && (v69 = (var49_214 = (BattleContext)CollectionsKt.last((Iterable)((Iterable)v69)))) != null ? v69.getId() : null;
                                                        }
                                                        catch (Exception e) {
                                                            var47_201 = "";
                                                        }
                                                        if ((v70 = (var46_200 = var47_201)) == null) {
                                                            v70 = activePlayerPokemonVolatile = "";
                                                        }
                                                        if ((v71 = activeNPCBattlePokemon) != null && (v71 = (var47_201 = v71.getOriginalPokemon())) != null && (v71 = (e = v71.getStatus())) != null && (v71 = (var49_214 = v71.getStatus())) != null && (v71 = (var50_204 = v71.getName())) != null) {
                                                            v72 = (Comparable)v71;
                                                        } else {
                                                            try {
                                                                v73 = activeNPCBattlePokemon;
                                                                var52_211 = v73 != null && (v73 = (var52_211 = v73.getContextManager())) != null && (v73 = (var53_216 = v73.get(BattleContext.Type.STATUS))) != null && (v73 = (var54_218 = (BattleContext)CollectionsKt.last((Iterable)((Iterable)v73)))) != null ? v73.getId() : null;
                                                            }
                                                            catch (Exception e) {
                                                                var52_211 = "";
                                                            }
                                                            v74 = e = var52_211;
                                                            v72 = v74 != null ? (Comparable)v74 : (Comparable)"";
                                                        }
                                                        activeNPCPokemonStatus = v72;
                                                        try {
                                                            v75 = activeNPCBattlePokemon;
                                                            var49_214 = v75 != null && (v75 = (var49_214 = v75.getContextManager())) != null && (v75 = (var50_204 = v75.get(BattleContext.Type.VOLATILE))) != null && (v75 = (e = (BattleContext)CollectionsKt.last((Iterable)((Iterable)v75)))) != null ? v75.getId() : null;
                                                        }
                                                        catch (Exception e) {
                                                            var49_214 = "";
                                                        }
                                                        if ((v76 = (e = var49_214)) == null) {
                                                            v76 = "";
                                                        }
                                                        activeNPCPokemonVolatile = v76;
                                                        playerSideHazardsList = null;
                                                        playerSideHazardsList = new ArrayList<E>();
                                                        v77 = var49_214 = battle.getSide1().getContextManager().get(BattleContext.Type.HAZARD);
                                                        if (v77 != null) {
                                                            $this$forEach$iv = v77;
                                                            $i$f$forEach = false;
                                                            for (Object element$iv : $this$forEach$iv) {
                                                                it = (BattleContext)element$iv;
                                                                $i$a$-forEach-StrongBattleAI$choose$1 = false;
                                                                playerSideHazardsList.add(it.getId());
                                                            }
                                                            v78 = Unit.INSTANCE;
                                                        } else {
                                                            v78 = null;
                                                        }
                                                        npcSideHazardsList = new ArrayList<E>();
                                                        v79 = $this$forEach$iv = battle.getSide2().getContextManager().get(BattleContext.Type.HAZARD);
                                                        if (v79 != null) {
                                                            $this$forEach$iv = v79;
                                                            $i$f$forEach = false;
                                                            for (Object element$iv : $this$forEach$iv) {
                                                                it = (BattleContext)element$iv;
                                                                $i$a$-forEach-StrongBattleAI$choose$2 = false;
                                                                npcSideHazardsList.add(it.getId());
                                                            }
                                                            v80 = Unit.INSTANCE;
                                                        } else {
                                                            v80 = null;
                                                        }
                                                        playerSideHazards = CollectionsKt.toList((Iterable)playerSideHazardsList);
                                                        npcSideHazards = CollectionsKt.toList((Iterable)npcSideHazardsList);
                                                        canDynamax = false;
                                                        if (!forceSwitch && !activeBattlePokemon.isGone()) break block329;
                                                        if (forceSwitch && battle.getTurn() == 1 || activeBattlePokemon.isGone() && battle.getTurn() == 1) {
                                                            $this$filter$iv = activeBattlePokemon.getActor().getPokemonList();
                                                            $i$f$filter = false;
                                                            var57_228 = $this$filter$iv;
                                                            destination$iv$iv = new ArrayList<E>();
                                                            $i$f$filterTo = false;
                                                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                                                it = (BattlePokemon)element$iv$iv;
                                                                $i$a$-filter-StrongBattleAI$choose$switchTo$1 = false;
                                                                if (!it.canBeSentOut()) continue;
                                                                destination$iv$iv.add(element$iv$iv);
                                                            }
                                                            $this$filter$iv = (List)destination$iv$iv;
                                                            v81 = element$iv = (BattlePokemon)CollectionsKt.randomOrNull((Collection)$this$filter$iv, (Random)((Random)Random.Default));
                                                            if (v81 == null) {
                                                                return new DefaultActionResponse();
                                                            }
                                                            switchTo = v81;
                                                            switchTo.setWillBeSwitchedIn(true);
                                                            return new SwitchActionResponse(switchTo.getUuid());
                                                        }
                                                        if ((!forceSwitch || battle.getTurn() <= 1) && (!activeBattlePokemon.isGone() || battle.getTurn() <= 1)) break block329;
                                                        $this$filter$iv = activeBattlePokemon.getActor().getPokemonList();
                                                        $i$f$filter = false;
                                                        $i$f$filter = $this$filter$iv;
                                                        destination$iv$iv = new ArrayList<E>();
                                                        $i$f$filterTo = false;
                                                        $i$f$filterTo = $this$filterTo$iv$iv.iterator();
                                                        while ($i$f$filterTo.hasNext()) {
                                                            element$iv$iv = $i$f$filterTo.next();
                                                            it = (BattlePokemon)element$iv$iv;
                                                            $i$a$-filter-StrongBattleAI$choose$availableSwitches$1 = false;
                                                            if (it.getHealth() <= 0) ** GOTO lbl-1000
                                                            v82 = it.getUuid();
                                                            v83 = activeBattlePokemon.getBattlePokemon();
                                                            if (v83 == null || (v83 = v83.getUuid()) == null) {
                                                                v83 = true;
                                                            }
                                                            if (!Intrinsics.areEqual((Object)v82, (Object)v83)) {
                                                                v84 = true;
                                                            } else lbl-1000:
                                                            // 2 sources

                                                            {
                                                                v84 = false;
                                                            }
                                                            if (!v84) continue;
                                                            destination$iv$iv.add(element$iv$iv);
                                                        }
                                                        availableSwitches = (List)destination$iv$iv;
                                                        $i$f$filter = availableSwitches;
                                                        $this$filterTo$iv$iv = $i$f$filter.iterator();
                                                        if (!$this$filterTo$iv$iv.hasNext()) {
                                                            v85 = null;
                                                        } else {
                                                            it = (BattlePokemon)$this$filterTo$iv$iv.next();
                                                            $i$a$-maxOfOrNull-StrongBattleAI$choose$bestEstimation$1 = false;
                                                            $i$f$filterTo = this.estimatePartyMatchup(request, battle, it.getEffectedPokemon());
                                                            while ($this$filterTo$iv$iv.hasNext()) {
                                                                it = (BattlePokemon)$this$filterTo$iv$iv.next();
                                                                $i$a$-maxOfOrNull-StrongBattleAI$choose$bestEstimation$1 = false;
                                                                $i$a$-filter-StrongBattleAI$choose$switchTo$1 = this.estimatePartyMatchup(request, battle, it.getEffectedPokemon());
                                                                $i$f$filterTo = Math.max($i$f$filterTo, $i$a$-filter-StrongBattleAI$choose$switchTo$1);
                                                            }
                                                            v85 = $i$f$filterTo;
                                                        }
                                                        bestEstimation = v85;
                                                        $i$a$-maxOfOrNull-StrongBattleAI$choose$bestEstimation$1 = it = (Iterable)availableSwitches;
                                                        $i$f$filterTo = $i$a$-maxOfOrNull-StrongBattleAI$choose$bestEstimation$1.iterator();
                                                        while ($i$f$filterTo.hasNext()) {
                                                            element$iv$iv = $i$f$filterTo.next();
                                                            it = (BattlePokemon)element$iv$iv;
                                                            $i$a$-find-StrongBattleAI$choose$switchTo$2 = false;
                                                            if (!Intrinsics.areEqual((double)this.estimatePartyMatchup(request, battle, it.getEffectedPokemon()), (Double)bestEstimation)) continue;
                                                            v86 = element$iv$iv;
                                                            break block314;
                                                        }
                                                        v86 = null;
                                                    }
                                                    v87 = $this$filterTo$iv$iv = (BattlePokemon)v86;
                                                    if (v87 == null) {
                                                        return new DefaultActionResponse();
                                                    }
                                                    switchTo = v87;
                                                    switchTo.setWillBeSwitchedIn(true);
                                                    it = $this$filterTo$iv$iv = switchTo;
                                                    $i$a$-let-StrongBattleAI$choose$3 = false;
                                                    return new SwitchActionResponse(it.getUuid());
                                                }
                                                this.updateActiveTracker(activeBattlePokemon, request, battle);
                                                v88 = activeBattlePokemon.getBattlePokemon();
                                                Intrinsics.checkNotNull((Object)v88);
                                                activeNPCPokemonUUID = v88.getEffectedPokemon().getUuid();
                                                v89 = switchTo = battle.getSide1().getActivePokemon().get(0).getBattlePokemon();
                                                activePlayerPokemonUUID = v89 != null ? v89.getUuid() : null;
                                                it = $this$filterTo$iv$iv = (Iterable)this.activeTracker.getP2Active().getParty();
                                                for (Object $i$f$filterTo : it) {
                                                    it = (ActiveTracker.TrackerPokemon)$i$f$filterTo;
                                                    $i$a$-find-StrongBattleAI$choose$matchedActiveNPCPokemon$1 = false;
                                                    v90 = it.getPokemon();
                                                    if (!Intrinsics.areEqual((Object)(v90 != null ? v90.getUuid() : null), (Object)activeNPCPokemonUUID)) continue;
                                                    v91 = $i$f$filterTo;
                                                    break block315;
                                                }
                                                v91 = null;
                                            }
                                            matchedActiveNPCPokemon = (ActiveTracker.TrackerPokemon)v91;
                                            it = this.activeTracker.getP1Active().getParty();
                                            $i$a$-let-StrongBattleAI$choose$3 = it;
                                            $i$f$filterTo = $i$a$-let-StrongBattleAI$choose$3.iterator();
                                            while ($i$f$filterTo.hasNext()) {
                                                it = $i$f$filterTo.next();
                                                it = it;
                                                $i$a$-find-StrongBattleAI$choose$matchedActivePlayerPokemon$1 = false;
                                                v92 = it.getPokemon();
                                                if (!Intrinsics.areEqual((Object)(v92 != null ? v92.getUuid() : null), (Object)activePlayerPokemonUUID)) continue;
                                                v93 = it;
                                                break block316;
                                            }
                                            v93 = null;
                                        }
                                        matchedActivePlayerPokemon = v93;
                                        v94 = this.activeTracker.getP1Active();
                                        v95 = matchedActivePlayerPokemon;
                                        Intrinsics.checkNotNull((Object)v95);
                                        v94.setActivePokemon(v95);
                                        v96 = this.activeTracker.getP2Active();
                                        v97 = matchedActiveNPCPokemon;
                                        Intrinsics.checkNotNull((Object)v97);
                                        v96.setActivePokemon(v97);
                                        mon = matchedActiveNPCPokemon;
                                        opponent = matchedActivePlayerPokemon;
                                        if (mon.getProtectCount() > 0) {
                                            if (Random.Default.nextDouble() < this.randomProtectChance) {
                                                mon.setProtectCount(mon.getProtectCount() - 2);
                                                if (mon.getProtectCount() < 0) {
                                                    mon.setProtectCount(0);
                                                }
                                            } else {
                                                mon.setProtectCount(mon.getProtectCount() - 1);
                                            }
                                        }
                                        v98 = ($i$f$filterTo = battle.getContextManager().get(BattleContext.Type.WEATHER)) == null || $i$f$filterTo.isEmpty() != false;
                                        it = battle.getContextManager().get(BattleContext.Type.WEATHER);
                                        currentWeather = (it == null || it.isEmpty() != false) != false ? null : ((v99 = (it = battle.getContextManager().get(BattleContext.Type.WEATHER))) != null && (v99 = (it = v99.iterator())) != null && (v99 = ($i$a$-find-StrongBattleAI$choose$matchedActivePlayerPokemon$1 = (BattleContext)v99.next())) != null ? v99.getId() : null);
                                        it = battle.getContextManager().get(BattleContext.Type.TERRAIN);
                                        currentTerrain = (it == null || it.isEmpty() != false) != false ? null : ((v100 = (it = battle.getContextManager().get(BattleContext.Type.TERRAIN))) != null && (v100 = ($i$a$-find-StrongBattleAI$choose$matchedActivePlayerPokemon$1 = v100.iterator())) != null && (v100 = ($i$a$-filter-StrongBattleAI$choose$switchTo$1 = (BattleContext)v100.next())) != null ? v100.getId() : null);
                                        $i$a$-find-StrongBattleAI$choose$matchedActivePlayerPokemon$1 = battle.getContextManager().get(BattleContext.Type.ROOM);
                                        currentRoom = ($i$a$-find-StrongBattleAI$choose$matchedActivePlayerPokemon$1 == null || $i$a$-find-StrongBattleAI$choose$matchedActivePlayerPokemon$1.isEmpty() != false) != false ? null : ((v101 = ($i$a$-find-StrongBattleAI$choose$matchedActivePlayerPokemon$1 = battle.getContextManager().get(BattleContext.Type.ROOM))) != null && (v101 = ($i$a$-filter-StrongBattleAI$choose$switchTo$1 = v101.iterator())) != null && (v101 = (var64_260 = (BattleContext)v101.next())) != null ? v101.getId() : null);
                                        this.trickRoomCoefficient = Intrinsics.areEqual(currentRoom, (Object)"trickroom") != false ? -1.0 : 1.0;
                                        v102 = moveset;
                                        if (v102 != null && (v102 = ($i$a$-filter-StrongBattleAI$choose$switchTo$1 = v102.getMoves())) != null) {
                                            $this$filterNot$iv = (Iterable)v102;
                                            $i$f$filterNot = false;
                                            var66_263 = $this$filterNot$iv;
                                            destination$iv$iv = new ArrayList<E>();
                                            $i$f$filterNotTo = false;
                                            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                                                it = (InBattleMove)element$iv$iv;
                                                $i$a$-filterNot-StrongBattleAI$choose$allMoves$1 = false;
                                                if (it.getPp() == 0 || it.getDisabled() != false) continue;
                                                destination$iv$iv.add(element$iv$iv);
                                            }
                                            v103 = (List)destination$iv$iv;
                                        } else {
                                            v103 = null;
                                        }
                                        allMoves = v103;
                                        physicalRatio = this.statEstimationActive(mon, Stats.ATTACK) / this.statEstimationActive(opponent, Stats.DEFENCE);
                                        specialRatio = this.statEstimationActive(mon, Stats.SPECIAL_ATTACK) / this.statEstimationActive(opponent, Stats.SPECIAL_DEFENCE);
                                        monSideConditionList = mon.getSideConditions().keySet();
                                        oppSideConditionList = opponent.getSideConditions().keySet();
                                        element$iv$iv = battle.getSide1().getContextManager().get(BattleContext.Type.TAILWIND);
                                        playerSideTailwindCondition = (element$iv$iv == null || element$iv$iv.isEmpty() != false) != false ? null : ((v104 = (element$iv$iv = battle.getSide1().getContextManager().get(BattleContext.Type.TAILWIND))) != null && (v104 = (it = v104.iterator())) != null && (v104 = ($i$a$-filterNot-StrongBattleAI$choose$allMoves$1 = (BattleContext)v104.next())) != null ? v104.getId() : null);
                                        it = battle.getSide1().getContextManager().get(BattleContext.Type.SCREEN);
                                        playerSideScreenCondition = (it == null || it.isEmpty() != false) != false ? null : ((v105 = (it = battle.getSide1().getContextManager().get(BattleContext.Type.SCREEN))) != null && (v105 = ($i$a$-filterNot-StrongBattleAI$choose$allMoves$1 = v105.iterator())) != null && (v105 = (var73_274 = (BattleContext)v105.next())) != null ? v105.getId() : null);
                                        $i$a$-filterNot-StrongBattleAI$choose$allMoves$1 = battle.getSide1().getContextManager().get(BattleContext.Type.HAZARD);
                                        playerSideHazardCondition = ($i$a$-filterNot-StrongBattleAI$choose$allMoves$1 == null || $i$a$-filterNot-StrongBattleAI$choose$allMoves$1.isEmpty() != false) != false ? null : ((v106 = ($i$a$-filterNot-StrongBattleAI$choose$allMoves$1 = battle.getSide1().getContextManager().get(BattleContext.Type.HAZARD))) != null && (v106 = (var73_274 = v106.iterator())) != null && (v106 = (var74_275 = (BattleContext)v106.next())) != null ? v106.getId() : null);
                                        var73_274 = battle.getSide2().getContextManager().get(BattleContext.Type.TAILWIND);
                                        npcSideTailwindCondition = (var73_274 == null || var73_274.isEmpty() != false) != false ? null : ((v107 = (var73_274 = battle.getSide2().getContextManager().get(BattleContext.Type.TAILWIND))) != null && (v107 = (var74_275 = v107.iterator())) != null && (v107 = (var75_276 = (BattleContext)v107.next())) != null ? v107.getId() : null);
                                        var74_275 = battle.getSide2().getContextManager().get(BattleContext.Type.SCREEN);
                                        npcSideScreenCondition = (var74_275 == null || var74_275.isEmpty() != false) != false ? null : ((v108 = (var74_275 = battle.getSide2().getContextManager().get(BattleContext.Type.SCREEN))) != null && (v108 = (var75_276 = v108.iterator())) != null && (v108 = (var76_279 = (BattleContext)v108.next())) != null ? v108.getId() : null);
                                        var75_276 = battle.getSide2().getContextManager().get(BattleContext.Type.HAZARD);
                                        npcSideHazardCondition = (var75_276 == null || var75_276.isEmpty() != false) != false ? null : ((v109 = (var75_276 = battle.getSide2().getContextManager().get(BattleContext.Type.HAZARD))) != null && (v109 = (var76_279 = v109.iterator())) != null && (v109 = (var77_282 = (BattleContext)v109.next())) != null ? v109.getId() : null);
                                        v110 = moveset;
                                        Intrinsics.checkNotNull((Object)v110);
                                        for (InBattleMove move : v110.getMoves()) {
                                            if (!move.mustBeUsed()) continue;
                                            return this.chooseMove(move, activeBattlePokemon);
                                        }
                                        if (this.checkSkillLevel(this.skill)) break block330;
                                        var77_282 = moveset.getMoves();
                                        $i$f$filter = false;
                                        var79_299 = $this$filter$iv;
                                        destination$iv$iv = new ArrayList<E>();
                                        $i$f$filterTo = false;
                                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                                            it = (InBattleMove)element$iv$iv;
                                            $i$a$-filter-StrongBattleAI$choose$move$1 = false;
                                            if (!it.canBeUsed()) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        $this$filter$iv = (List)destination$iv$iv;
                                        $i$f$filter = false;
                                        $this$filterTo$iv$iv = $this$filter$iv;
                                        destination$iv$iv = new ArrayList<E>();
                                        $i$f$filterTo = false;
                                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                                            it = (InBattleMove)element$iv$iv;
                                            $i$a$-filter-StrongBattleAI$choose$move$2 = false;
                                            if (it.mustBeUsed()) ** GOTO lbl-1000
                                            v111 = (List)it.getTarget().getTargetList().invoke((Object)activeBattlePokemon);
                                            if (!(v111 != null ? v111.isEmpty() : false)) lbl-1000:
                                            // 2 sources

                                            {
                                                v112 = true;
                                            } else {
                                                v112 = false;
                                            }
                                            if (!v112) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        $this$filter$iv = (List)destination$iv$iv;
                                        v113 = move = (InBattleMove)CollectionsKt.randomOrNull((Collection)$this$filter$iv, (Random)((Random)Random.Default));
                                        if (v113 == null) {
                                            return new MoveActionResponse("struggle", null, null, 6, null);
                                        }
                                        move = v113;
                                        return this.chooseMove(move, activeBattlePokemon);
                                    }
                                    if (this.checkSwitchOutSkill(this.skill) && this.shouldSwitchOut(request, battle, activeBattlePokemon, moveset)) {
                                        block317: {
                                            $this$filter$iv = p2Actor.getPokemonList();
                                            $i$f$filter = false;
                                            $i$f$filter = $this$filter$iv;
                                            destination$iv$iv = new ArrayList<E>();
                                            $i$f$filterTo = false;
                                            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                                it = (BattlePokemon)element$iv$iv;
                                                $i$a$-filter-StrongBattleAI$choose$availableSwitches$2 = false;
                                                v114 = it.getUuid();
                                                v115 = mon.getPokemon();
                                                Intrinsics.checkNotNull((Object)v115);
                                                if (!(Intrinsics.areEqual((Object)v114, (Object)v115.getUuid()) == false && it.getHealth() > 0)) continue;
                                                destination$iv$iv.add(element$iv$iv);
                                            }
                                            availableSwitches = (List)destination$iv$iv;
                                            $this$filter$iv = p1Actor.getPokemonList();
                                            $i$f$filter = false;
                                            destination$iv$iv = $this$filter$iv;
                                            destination$iv$iv = new ArrayList<E>();
                                            $i$f$filterTo = false;
                                            element$iv$iv = $this$filterTo$iv$iv.iterator();
                                            while (element$iv$iv.hasNext()) {
                                                element$iv$iv = element$iv$iv.next();
                                                it = (BattlePokemon)element$iv$iv;
                                                $i$a$-filter-StrongBattleAI$choose$availablePlayerSwitches$1 = false;
                                                v116 = it.getUuid();
                                                v117 = opponent.getPokemon();
                                                Intrinsics.checkNotNull((Object)v117);
                                                if (!(Intrinsics.areEqual((Object)v116, (Object)v117.getUuid()) == false && it.getHealth() > 0)) continue;
                                                destination$iv$iv.add(element$iv$iv);
                                            }
                                            availablePlayerSwitches = (List)destination$iv$iv;
                                            $i$f$filter = (Iterable)availableSwitches;
                                            $this$filterTo$iv$iv = $i$f$filter.iterator();
                                            if (!$this$filterTo$iv$iv.hasNext()) {
                                                v118 = null;
                                            } else {
                                                it = (BattlePokemon)$this$filterTo$iv$iv.next();
                                                $i$a$-maxOfOrNull-StrongBattleAI$choose$bestEstimation$2 = false;
                                                element$iv$iv = this.estimateMatchup(activeBattlePokemon, request, battle, it.getEffectedPokemon());
                                                while ($this$filterTo$iv$iv.hasNext()) {
                                                    it = (BattlePokemon)$this$filterTo$iv$iv.next();
                                                    $i$a$-maxOfOrNull-StrongBattleAI$choose$bestEstimation$2 = false;
                                                    var87_502 = this.estimateMatchup(activeBattlePokemon, request, battle, it.getEffectedPokemon());
                                                    element$iv$iv = Math.max(element$iv$iv, var87_502);
                                                }
                                                v118 = element$iv$iv;
                                            }
                                            bestEstimation = v118;
                                            $this$filter$iv = moveset.getMoves();
                                            $i$f$filter = false;
                                            $i$a$-maxOfOrNull-StrongBattleAI$choose$bestEstimation$2 = $this$filter$iv;
                                            destination$iv$iv = new ArrayList<E>();
                                            $i$f$filterTo = false;
                                            it = $this$filterTo$iv$iv.iterator();
                                            while (it.hasNext()) {
                                                element$iv$iv = it.next();
                                                it = (InBattleMove)element$iv$iv;
                                                $i$a$-filter-StrongBattleAI$choose$4 = false;
                                                if (!(it.getDisabled() == false)) continue;
                                                destination$iv$iv.add(element$iv$iv);
                                            }
                                            for (Object move : (List)destination$iv$iv) {
                                                if (move.getPp() <= 0 || !this.pivotMoves.contains(move.getId()) || this.moveDamageMultiplier(move.getId(), opponent) == 0.0) continue;
                                                return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                                            }
                                            $i$f$filter = move = (Iterable)availableSwitches;
                                            $this$filterTo$iv$iv = $i$f$filter.iterator();
                                            while ($this$filterTo$iv$iv.hasNext()) {
                                                destination$iv$iv = $this$filterTo$iv$iv.next();
                                                it = (BattlePokemon)destination$iv$iv;
                                                $i$a$-find-StrongBattleAI$choose$bestMatchup$1 = false;
                                                if (!Intrinsics.areEqual((double)this.estimateMatchup(activeBattlePokemon, request, battle, it.getEffectedPokemon()), (Double)bestEstimation)) continue;
                                                v119 = destination$iv$iv;
                                                break block317;
                                            }
                                            v119 = null;
                                        }
                                        bestMatchup = (BattlePokemon)v119;
                                        if (bestMatchup != null) {
                                            it = move = bestMatchup;
                                            $i$a$-let-StrongBattleAI$choose$5 = false;
                                            return new SwitchActionResponse(it.getUuid());
                                        }
                                    }
                                    mon.setFirstTurn(0);
                                    availableSwitches = moveset.getMoves();
                                    v120 = availableSwitches;
                                    v121 = v120 != null ? Boolean.valueOf(v120.isEmpty()) : null;
                                    Intrinsics.checkNotNull((Object)v121);
                                    if (!v121.booleanValue() && !this.shouldSwitchOut(request, battle, activeBattlePokemon, moveset)) break block331;
                                    availableSwitches = request.getSide();
                                    v122 = availableSwitches;
                                    if (v122 != null && (v122 = (availablePlayerSwitches = v122.getPokemon())) != null) {
                                        $this$count$iv = v122;
                                        $i$f$count = false;
                                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                            v123 = 0;
                                        } else {
                                            count$iv = 0;
                                            it = $this$count$iv.iterator();
                                            while (it.hasNext()) {
                                                element$iv = it.next();
                                                it = (ShowdownPokemon)element$iv;
                                                $i$a$-count-StrongBattleAI$choose$6 = false;
                                                if (!(this.getHpFraction(it.getCondition()) == 0.0 == false) || ++count$iv >= 0) continue;
                                                CollectionsKt.throwCountOverflow();
                                            }
                                            v123 = count$iv;
                                        }
                                        v124 = v123 == 1;
                                    } else {
                                        v124 = false;
                                    }
                                    if (!v124) break block332;
                                    v125 = mon.getCurrentHp();
                                    v126 = mon.getPokemon();
                                    Intrinsics.checkNotNull((Object)v126);
                                    if (!(v125 / (double)v126.getHp() == 1.0)) break block332;
                                }
                                nRemainingMons = this.activeTracker.getP2Active().getNRemainingMons();
                                nOppRemainingMons = this.activeTracker.getP1Active().getNRemainingMons();
                                if (Intrinsics.areEqual((Object)activeNPCPokemonStatus, (Object)"slp")) {
                                    $this$filter$iv = moveset.getMoves();
                                    $i$f$filter = false;
                                    it = $this$filter$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterTo = false;
                                    $i$a$-count-StrongBattleAI$choose$6 = $this$filterTo$iv$iv.iterator();
                                    while ($i$a$-count-StrongBattleAI$choose$6.hasNext()) {
                                        element$iv$iv = $i$a$-count-StrongBattleAI$choose$6.next();
                                        it = (InBattleMove)element$iv$iv;
                                        $i$a$-filter-StrongBattleAI$choose$7 = false;
                                        if (!(it.getDisabled() == false)) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    for (InBattleMove move : (List)destination$iv$iv) {
                                        if (!Intrinsics.areEqual((Object)move.getId(), (Object)"sleeptalk")) continue;
                                        return this.chooseMove(move, activeBattlePokemon);
                                    }
                                }
                                if (allMoves == null) break block333;
                                $this$firstOrNull$iv = allMoves;
                                $i$f$firstOrNull = false;
                                $this$filterTo$iv$iv = $this$firstOrNull$iv.iterator();
                                while ($this$filterTo$iv$iv.hasNext()) {
                                    element$iv = $this$filterTo$iv$iv.next();
                                    it = (InBattleMove)element$iv;
                                    $i$a$-firstOrNull-StrongBattleAI$choose$8 = false;
                                    if (it.getPp() <= 0 || !Intrinsics.areEqual((Object)it.getId(), (Object)"fakeout") || mon.getFirstTurn() != 1) ** GOTO lbl-1000
                                    v127 = opponent.getPokemon();
                                    v128 = v127 != null && (v127 = v127.getTypes()) != null ? Boolean.valueOf(CollectionsKt.contains((Iterable)v127, (Object)ElementalTypes.INSTANCE.getGHOST())) : null;
                                    Intrinsics.checkNotNull(v128);
                                    if (!v128.booleanValue()) {
                                        v129 = true;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v129 = false;
                                    }
                                    if (!v129) continue;
                                    v130 = element$iv;
                                    break block318;
                                }
                                v130 = null;
                            }
                            $this$count$iv = v130;
                            if ($this$count$iv != null) {
                                it = $this$firstOrNull$iv = $this$count$iv;
                                $i$a$-let-StrongBattleAI$choose$9 = false;
                                mon.setFirstTurn(0);
                                return this.chooseMove((InBattleMove)it, activeBattlePokemon);
                            }
                        }
                        mon.setFirstTurn(0);
                        if (allMoves == null) break block334;
                        $this$firstOrNull$iv = allMoves;
                        $i$f$firstOrNull = false;
                        $i$a$-let-StrongBattleAI$choose$9 = $this$firstOrNull$iv.iterator();
                        while ($i$a$-let-StrongBattleAI$choose$9.hasNext()) {
                            element$iv = $i$a$-let-StrongBattleAI$choose$9.next();
                            it = (InBattleMove)element$iv;
                            $i$a$-firstOrNull-StrongBattleAI$choose$10 = false;
                            if (!it.getId().equals("explosion") && !it.getId().equals("selfdestruct")) ** GOTO lbl-1000
                            v131 = mon.getCurrentHp();
                            v132 = mon.getPokemon();
                            Intrinsics.checkNotNull((Object)v132);
                            if (!(v131 / (double)v132.getHp() < this.selfKoMoveMatchupThreshold)) ** GOTO lbl-1000
                            v133 = opponent.getCurrentHp();
                            v134 = opponent.getPokemon();
                            Intrinsics.checkNotNull((Object)v134);
                            if (!(v133 / (double)v134.getHp() > 0.5)) ** GOTO lbl-1000
                            v135 = opponent.getPokemon();
                            Intrinsics.checkNotNull((Object)v135);
                            if (!CollectionsKt.contains(v135.getTypes(), (Object)ElementalTypes.INSTANCE.getGHOST()) && it.getPp() > 0) {
                                v136 = true;
                            } else lbl-1000:
                            // 4 sources

                            {
                                v136 = false;
                            }
                            if (!v136) continue;
                            v137 = element$iv;
                            break block319;
                        }
                        v137 = null;
                    }
                    $this$count$iv = v137;
                    if ($this$count$iv != null) {
                        it = $this$firstOrNull$iv = $this$count$iv;
                        $i$a$-let-StrongBattleAI$choose$11 = false;
                        return this.chooseMove((InBattleMove)it, activeBattlePokemon);
                    }
                }
                $this$filter$iv = (Object[])moveset.getMoves();
                $i$f$filter = false;
                $i$a$-let-StrongBattleAI$choose$11 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                $i$a$-firstOrNull-StrongBattleAI$choose$10 = $this$filterTo$iv$iv.iterator();
                while ($i$a$-firstOrNull-StrongBattleAI$choose$10.hasNext()) {
                    element$iv$iv = $i$a$-firstOrNull-StrongBattleAI$choose$10.next();
                    it = (InBattleMove)element$iv$iv;
                    $i$a$-filter-StrongBattleAI$choose$12 = false;
                    if (!(it.getDisabled() == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Object move : (List)destination$iv$iv) {
                    if (!this.selfRecoveryMoves.contains(move.getId())) continue;
                    v138 = mon.getCurrentHp();
                    v139 = mon.getPokemon();
                    Intrinsics.checkNotNull((Object)v139);
                    if (!(v138 / (double)v139.getHp() < this.recoveryMoveThreshold) || move.getPp() <= 0) continue;
                    return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                }
                $this$filter$iv = moveset.getMoves();
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                $i$a$-firstOrNull-StrongBattleAI$choose$10 = $this$filterTo$iv$iv.iterator();
                while ($i$a$-firstOrNull-StrongBattleAI$choose$10.hasNext()) {
                    element$iv$iv = $i$a$-firstOrNull-StrongBattleAI$choose$10.next();
                    it = (InBattleMove)element$iv$iv;
                    $i$a$-filter-StrongBattleAI$choose$13 = false;
                    if (!(it.getDisabled() == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Object move : (List)destination$iv$iv) {
                    $this$filter$iv = p2Actor.getPokemonList();
                    $i$f$filter = false;
                    $i$f$filterTo = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (BattlePokemon)element$iv$iv;
                        $i$a$-filter-StrongBattleAI$choose$availableSwitches$3 = false;
                        v140 = it.getUuid();
                        v141 = mon.getPokemon();
                        Intrinsics.checkNotNull((Object)v141);
                        if (!(Intrinsics.areEqual((Object)v140, (Object)v141.getUuid()) == false && it.getHealth() > 0)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    availableSwitches = (List)destination$iv$iv;
                    if (move.getPp() > 0 && Intrinsics.areEqual((Object)move.getId(), (Object)"tailwind") && !Intrinsics.areEqual((Object)move.getId(), (Object)npcSideTailwindCondition)) {
                        $this$filter$iv = p2Actor.getPokemonList();
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (BattlePokemon)element$iv$iv;
                            $i$a$-filter-StrongBattleAI$choose$14 = false;
                            v142 = it.getUuid();
                            v143 = mon.getPokemon();
                            Intrinsics.checkNotNull((Object)v143);
                            if (!(Intrinsics.areEqual((Object)v142, (Object)v143.getUuid()) == false && it.getHealth() > 0)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        if (((List)destination$iv$iv).size() > 2) {
                            return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                        }
                    }
                    if (move.getPp() > 0 && Intrinsics.areEqual((Object)move.getId(), (Object)"trickroom") && !Intrinsics.areEqual((Object)move.getId(), (Object)currentRoom)) {
                        $this$count$iv = (Object[])availableSwitches;
                        $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            v144 = 0;
                        } else {
                            count$iv = 0;
                            for (T element$iv : $this$count$iv) {
                                it = (BattlePokemon)element$iv;
                                $i$a$-count-StrongBattleAI$choose$15 = false;
                                if (!(this.statEstimation(it.getEffectedPokemon(), Stats.SPEED) <= (double)this.trickRoomThreshold) || ++count$iv >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            v144 = count$iv;
                        }
                        if (v144 >= 2) {
                            return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                        }
                    }
                    if (move.getPp() > 0 && Intrinsics.areEqual((Object)move.getId(), (Object)"auroraveil") && !Intrinsics.areEqual((Object)move.getId(), (Object)npcSideScreenCondition) && CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])($this$count$iv = new String[]{"Hail", "Snow"})), (Object)currentWeather)) {
                        return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                    }
                    if (move.getPp() > 0 && Intrinsics.areEqual((Object)move.getId(), (Object)"lightscreen") && !Intrinsics.areEqual((Object)move.getId(), (Object)npcSideScreenCondition)) {
                        v145 = opponent.getPokemon();
                        Intrinsics.checkNotNull((Object)v145);
                        v146 = this.getBaseStats(v145, "spa");
                        v147 = opponent.getPokemon();
                        Intrinsics.checkNotNull((Object)v147);
                        if (v146 > this.getBaseStats(v147, "atk")) {
                            $this$filter$iv = p2Actor.getPokemonList();
                            $i$f$filter = false;
                            count$iv = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                it = (BattlePokemon)element$iv$iv;
                                $i$a$-filter-StrongBattleAI$choose$16 = false;
                                v148 = it.getUuid();
                                v149 = mon.getPokemon();
                                Intrinsics.checkNotNull((Object)v149);
                                if (!(Intrinsics.areEqual((Object)v148, (Object)v149.getUuid()) == false && it.getHealth() > 0)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            if (((List)destination$iv$iv).size() > 1) {
                                return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                            }
                        }
                    }
                    if (move.getPp() <= 0 || !Intrinsics.areEqual((Object)move.getId(), (Object)"reflect") || Intrinsics.areEqual((Object)move.getId(), (Object)npcSideScreenCondition)) continue;
                    v150 = opponent.getPokemon();
                    Intrinsics.checkNotNull((Object)v150);
                    v151 = this.getBaseStats(v150, "atk");
                    v152 = opponent.getPokemon();
                    Intrinsics.checkNotNull((Object)v152);
                    if (v151 <= this.getBaseStats(v152, "spa")) continue;
                    $this$filter$iv = p2Actor.getPokemonList();
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (BattlePokemon)element$iv$iv;
                        $i$a$-filter-StrongBattleAI$choose$17 = false;
                        v153 = it.getUuid();
                        v154 = mon.getPokemon();
                        Intrinsics.checkNotNull((Object)v154);
                        if (!(Intrinsics.areEqual((Object)v153, (Object)v154.getUuid()) == false && it.getHealth() > 0)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    if (((List)destination$iv$iv).size() <= 1) continue;
                    return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                }
                $this$filter$iv = moveset.getMoves();
                $i$f$filter = false;
                $this$filter$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                destination$iv$iv = $this$filterTo$iv$iv.iterator();
                while (destination$iv$iv.hasNext()) {
                    element$iv$iv = destination$iv$iv.next();
                    it = (InBattleMove)element$iv$iv;
                    $i$a$-filter-StrongBattleAI$choose$18 = false;
                    if (!(it.getDisabled() == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Object move : (List)destination$iv$iv) {
                    if (move.getPp() > 0 && nOppRemainingMons >= 3 && this.entryHazards.contains(move.getId()) && !playerSideHazards.contains(move.getId())) {
                        return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                    }
                    if (move.getPp() <= 0 || nRemainingMons < 2 || !this.antiHazardsMoves.contains(move.getId()) || !(((Collection)npcSideHazards).isEmpty() == false)) continue;
                    return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                }
                $this$filter$iv = moveset.getMoves();
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                destination$iv$iv = $this$filterTo$iv$iv.iterator();
                while (destination$iv$iv.hasNext()) {
                    element$iv$iv = destination$iv$iv.next();
                    it = (InBattleMove)element$iv$iv;
                    $i$a$-filter-StrongBattleAI$choose$19 = false;
                    if (!(it.getDisabled() == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Object move : (List)destination$iv$iv) {
                    if (!this.antiBoostMoves.contains(move.getId()) || !this.isBoosted(opponent) || move.getPp() <= 0) continue;
                    return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                }
                $this$filter$iv = moveset.getMoves();
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                destination$iv$iv = $this$filterTo$iv$iv.iterator();
                while (destination$iv$iv.hasNext()) {
                    element$iv$iv = destination$iv$iv.next();
                    it = (InBattleMove)element$iv$iv;
                    $i$a$-filter-StrongBattleAI$choose$20 = false;
                    if (!(it.getDisabled() == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Object move : (List)destination$iv$iv) {
                    block323: {
                        block322: {
                            block320: {
                                if (move.getPp() <= 0 || !Intrinsics.areEqual((Object)move.getId(), (Object)"courtchange")) continue;
                                $this$none$iv = (Object[])this.entryHazards;
                                $i$f$none = false;
                                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                    v155 = true;
                                } else {
                                    destination$iv$iv = $this$none$iv.iterator();
                                    while (destination$iv$iv.hasNext()) {
                                        element$iv = destination$iv$iv.next();
                                        it = (String)element$iv;
                                        $i$a$-none-StrongBattleAI$choose$21 = false;
                                        if (!monSideConditionList.contains(it)) continue;
                                        v155 = false;
                                        break block320;
                                    }
                                    v155 = true;
                                }
                            }
                            if (v155) {
                                block321: {
                                    $this$none$iv = new String[]{"tailwind", "lightscreen", "reflect"};
                                    $this$any$iv = SetsKt.setOf((Object[])$this$none$iv);
                                    $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        v156 = false;
                                    } else {
                                        destination$iv$iv = $this$any$iv.iterator();
                                        while (destination$iv$iv.hasNext()) {
                                            element$iv = destination$iv$iv.next();
                                            it = (String)element$iv;
                                            $i$a$-any-StrongBattleAI$choose$22 = false;
                                            if (!oppSideConditionList.contains(it)) continue;
                                            v156 = true;
                                            break block321;
                                        }
                                        v156 = false;
                                    }
                                }
                                if (!v156) continue;
                            }
                            $this$any$iv = new String[]{"tailwind", "lightscreen", "reflect"};
                            $this$none$iv = SetsKt.setOf((Object[])$this$any$iv);
                            $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                v157 = true;
                            } else {
                                destination$iv$iv = $this$none$iv.iterator();
                                while (destination$iv$iv.hasNext()) {
                                    element$iv = destination$iv$iv.next();
                                    it = (String)element$iv;
                                    $i$a$-none-StrongBattleAI$choose$23 = false;
                                    if (!monSideConditionList.contains(it)) continue;
                                    v157 = false;
                                    break block322;
                                }
                                v157 = true;
                            }
                        }
                        if (!v157) continue;
                        $this$none$iv = this.entryHazards;
                        $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            v158 = true;
                        } else {
                            destination$iv$iv = $this$none$iv.iterator();
                            while (destination$iv$iv.hasNext()) {
                                element$iv = destination$iv$iv.next();
                                it = (String)element$iv;
                                $i$a$-none-StrongBattleAI$choose$24 = false;
                                if (!oppSideConditionList.contains(it)) continue;
                                v158 = false;
                                break block323;
                            }
                            v158 = true;
                        }
                    }
                    if (!v158) continue;
                    return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                }
                $this$filter$iv = moveset.getMoves();
                $i$f$filter = false;
                $i$f$none = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                it = $this$filterTo$iv$iv.iterator();
                while (it.hasNext()) {
                    element$iv$iv = it.next();
                    it = (InBattleMove)element$iv$iv;
                    $i$a$-filter-StrongBattleAI$choose$25 = false;
                    if (!(it.getDisabled() == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Object move : (List)destination$iv$iv) {
                    if (!Intrinsics.areEqual((Object)move.getId(), (Object)"strengthsap")) continue;
                    v159 = mon.getCurrentHp();
                    v160 = mon.getPokemon();
                    Intrinsics.checkNotNull((Object)v160);
                    if (!(v159 / (double)v160.getHp() < 0.5)) continue;
                    v161 = opponent.getPokemon();
                    Intrinsics.checkNotNull((Object)v161);
                    if (this.getBaseStats(v161, "atk") <= 80 || move.getPp() <= 0) continue;
                    return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                }
                $this$filter$iv = moveset.getMoves();
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                it = $this$filterTo$iv$iv.iterator();
                while (it.hasNext()) {
                    element$iv$iv = it.next();
                    it = (InBattleMove)element$iv$iv;
                    $i$a$-filter-StrongBattleAI$choose$26 = false;
                    if (!(it.getDisabled() == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Object move : (List)destination$iv$iv) {
                    block336: {
                        block335: {
                            if (!Intrinsics.areEqual((Object)move.getId(), (Object)"bellydrum")) continue;
                            v162 = mon.getCurrentHp();
                            v163 = mon.getPokemon();
                            Intrinsics.checkNotNull((Object)v163);
                            if (!(v162 / (double)v163.getHp() > 0.6)) break block335;
                            v164 = mon.getPokemon();
                            Intrinsics.checkNotNull((Object)v164);
                            if (Intrinsics.areEqual((Object)v164.heldItem().method_7909(), (Object)CobblemonItems.SITRUS_BERRY)) break block336;
                        }
                        v165 = mon.getCurrentHp();
                        v166 = mon.getPokemon();
                        Intrinsics.checkNotNull((Object)v166);
                        if (!(v165 / (double)v166.getHp() > 0.8)) continue;
                    }
                    if (npcATKBoosts >= 1 || move.getPp() <= 0) continue;
                    return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                }
                $this$filter$iv = moveset.getMoves();
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                it = $this$filterTo$iv$iv.iterator();
                while (it.hasNext()) {
                    element$iv$iv = it.next();
                    it = (InBattleMove)element$iv$iv;
                    $i$a$-filter-StrongBattleAI$choose$27 = false;
                    if (!(it.getDisabled() == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Object move : (List)destination$iv$iv) {
                    $i$f$filter = this.weatherSetupMoves.get(move.getId());
                    if ($i$f$filter != null) {
                        requiredWeather = $this$filterTo$iv$iv;
                        $i$a$-let-StrongBattleAI$choose$28 = false;
                        if (move.getPp() > 0) {
                            v167 = requiredWeather.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)v167, (String)"toLowerCase(...)");
                            if (!(Intrinsics.areEqual((Object)currentWeather, (Object)v167) || Intrinsics.areEqual((Object)currentWeather, (Object)"PrimordialSea") && Intrinsics.areEqual((Object)requiredWeather, (Object)"RainDance") || Intrinsics.areEqual((Object)currentWeather, (Object)"DesolateLand") && Intrinsics.areEqual((Object)requiredWeather, (Object)"SunnyDay"))) {
                                return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                            }
                        }
                        v168 = Unit.INSTANCE;
                        continue;
                    }
                    v168 = null;
                }
                v169 = mon.getCurrentHp();
                v170 = mon.getPokemon();
                Intrinsics.checkNotNull((Object)v170);
                if (v169 / (double)v170.getHp() == 1.0 && StrongBattleAI.estimateMatchup$default(this, activeBattlePokemon, request, battle, null, 8, null) > 0.0) {
                    $this$filter$iv = moveset.getMoves();
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    it = $this$filterTo$iv$iv.iterator();
                    while (it.hasNext()) {
                        element$iv$iv = it.next();
                        it = (InBattleMove)element$iv$iv;
                        $i$a$-filter-StrongBattleAI$choose$29 = false;
                        if (!(it.getDisabled() == false)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    for (Object move : (List)destination$iv$iv) {
                        if (move.getPp() <= 0 || !this.setupMoves.contains(move.getId())) continue;
                        $this$filterTo$iv$iv = this.getNonZeroStats(move.getId()).keySet();
                        destination$iv$iv = $this$filterTo$iv$iv.iterator();
                        if (!destination$iv$iv.hasNext()) {
                            v171 = null;
                        } else {
                            it = (Stat)destination$iv$iv.next();
                            $i$a$-minOfOrNull-StrongBattleAI$choose$30 = false;
                            v172 = mon.getBoosts().get(it);
                            it = v172 != null ? v172 : 0;
                            while (destination$iv$iv.hasNext()) {
                                it = (Stat)destination$iv$iv.next();
                                $i$a$-minOfOrNull-StrongBattleAI$choose$30 = false;
                                v173 = mon.getBoosts().get(it);
                                it = v173 != null ? v173 : 0;
                                if (it.compareTo(it) <= 0) continue;
                                it = it;
                            }
                            v171 = it;
                        }
                        v174 = $i$f$filter = (Integer)v171;
                        if ((v174 != null ? v174 : 0) >= 6) continue;
                        if (move.getId().equals("curse")) {
                            v175 = mon.getPokemon();
                            Intrinsics.checkNotNull((Object)v175);
                            if (CollectionsKt.contains(v175.getTypes(), (Object)ElementalTypes.INSTANCE.getGHOST())) continue;
                        }
                        return new MoveActionResponse(move.getId(), null, null, 6, null);
                    }
                }
                $this$filter$iv = moveset.getMoves();
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                it = $this$filterTo$iv$iv.iterator();
                while (it.hasNext()) {
                    element$iv$iv = it.next();
                    it = (InBattleMove)element$iv$iv;
                    $i$a$-filter-StrongBattleAI$choose$31 = false;
                    if (!(it.getDisabled() == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                block90: for (Object move : (List)destination$iv$iv) {
                    block337: {
                        block338: {
                            block341: {
                                block340: {
                                    block342: {
                                        block339: {
                                            block324: {
                                                $this$any$iv = moveset.getMoves();
                                                $i$f$any = false;
                                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                                    v176 = false;
                                                } else {
                                                    for (T element$iv : $this$any$iv) {
                                                        it = (InBattleMove)element$iv;
                                                        $i$a$-any-StrongBattleAI$choose$32 = false;
                                                        if (!(this.calculateDamage(it, mon, opponent, currentWeather) >= (double)opponent.getCurrentHp() * this.statusDamageConsiderationThreshold)) continue;
                                                        v176 = true;
                                                        break block324;
                                                    }
                                                    v176 = false;
                                                }
                                            }
                                            if (v176 || !Intrinsics.areEqual((Object)activePlayerPokemonStatus, (Object)"")) continue;
                                            v177 = opponent.getCurrentHp();
                                            v178 = opponent.getPokemon();
                                            Intrinsics.checkNotNull((Object)v178);
                                            if (!(v177 / (double)v178.getHp() > 0.3)) continue;
                                            v179 = mon.getCurrentHp();
                                            v180 = mon.getPokemon();
                                            Intrinsics.checkNotNull((Object)v180);
                                            if (!(v179 / (double)v180.getHp() > 0.5) || ($i$f$any = (status = StrongBattleAIKt.getStatusMoves().get(Moves.INSTANCE.getByName(move.getId())))) == null) continue;
                                            switch ($i$f$any.hashCode()) {
                                                case 110753: {
                                                    if ($i$f$any.equals("par")) break;
                                                    continue block90;
                                                }
                                                case 102849393: {
                                                    if (!$i$f$any.equals("leech")) {
                                                        continue block90;
                                                    }
                                                    break block337;
                                                }
                                                case -1349119470: {
                                                    if (!$i$f$any.equals("cursed")) {
                                                        continue block90;
                                                    }
                                                    break block338;
                                                }
                                                case 113975: {
                                                    if (!$i$f$any.equals("slp")) {
                                                        continue block90;
                                                    }
                                                    break block339;
                                                }
                                                case 111307: {
                                                    if (!$i$f$any.equals("psn")) {
                                                        continue block90;
                                                    }
                                                    break block340;
                                                }
                                                case 115037: {
                                                    if (!$i$f$any.equals("tox")) {
                                                        continue block90;
                                                    }
                                                    break block341;
                                                }
                                                case -793000954: {
                                                    if (!$i$f$any.equals("confusion")) {
                                                        continue block90;
                                                    }
                                                    break block342;
                                                }
                                                case 97822: {
                                                    if (!$i$f$any.equals("brn")) continue block90;
                                                    v181 = element$iv = this.activeTracker.getP1Active().getActivePokemon().getCurrentTypes();
                                                    typing = (v181 != null ? v181.contains("Fire") : false) == false;
                                                    v182 = opponent.getPokemon();
                                                    Intrinsics.checkNotNull((Object)v182);
                                                    stats = this.getBaseStats(v182, "atk") > 80;
                                                    notImmune = StrongBattleAI.choose$hasMajorStatusImmunity(opponent, currentWeather, opponent) == false;
                                                    it = new String[]{"waterbubble", "waterveil", "flareboost", "guts", "magicguard"};
                                                    v183 = CollectionsKt.listOf((Object[])it);
                                                    v184 = opponent.getPokemon();
                                                    Intrinsics.checkNotNull((Object)v184);
                                                    v185 = notAbility = v183.contains(v184.getAbility().getName()) == false;
                                                    if (!typing || !stats || !notImmune || !notAbility) continue block90;
                                                    return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                                                }
                                            }
                                            v186 = stats = this.activeTracker.getP1Active().getActivePokemon().getCurrentTypes();
                                            typing = (v186 != null ? v186.contains("Electric") : false) == false;
                                            v187 = Moves.INSTANCE.getByName(move.getId());
                                            Intrinsics.checkNotNull((Object)v187);
                                            if (!Intrinsics.areEqual((Object)v187.getElementalType(), (Object)ElementalTypes.INSTANCE.getELECTRIC())) ** GOTO lbl-1000
                                            v188 = notImmune = this.activeTracker.getP1Active().getActivePokemon().getCurrentTypes();
                                            v189 = v188 != null ? v188.contains("Ground") : false;
                                            if (v189) {
                                                v190 = true;
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                v190 = false;
                                            }
                                            electricVersusGround = v190;
                                            v191 = opponent.getPokemon();
                                            Intrinsics.checkNotNull((Object)v191);
                                            v192 = this.getBaseStats(v191, "spe");
                                            v193 = mon.getPokemon();
                                            Intrinsics.checkNotNull((Object)v193);
                                            stats = v192 > this.getBaseStats(v193, "spe");
                                            notImmune = StrongBattleAI.choose$hasMajorStatusImmunity(opponent, currentWeather, opponent) == false;
                                            $i$a$-filter-StrongBattleAI$choose$31 = new String[]{"limber", "guts"};
                                            v194 = CollectionsKt.listOf((Object[])$i$a$-filter-StrongBattleAI$choose$31);
                                            v195 = opponent.getPokemon();
                                            Intrinsics.checkNotNull((Object)v195);
                                            v196 = notAbility = v194.contains(v195.getAbility().getName()) == false;
                                            if (!typing || electricVersusGround || !stats || !notImmune || !notAbility) continue;
                                            return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                                        }
                                        v197 = electricVersusGround = this.activeTracker.getP1Active().getActivePokemon().getCurrentTypes();
                                        typing = (v197 != null ? v197.contains("Grass") : false) == false;
                                        moveID = move.getId().equals("spore") != false || move.getId().equals("sleeppowder") != false;
                                        notImmune = StrongBattleAI.choose$hasMajorStatusImmunity(opponent, currentWeather, opponent) == false;
                                        notAbility = new String[]{"insomnia", "sweetveil"};
                                        v198 = CollectionsKt.listOf((Object[])notAbility);
                                        v199 = opponent.getPokemon();
                                        Intrinsics.checkNotNull((Object)v199);
                                        v200 = notAbility = v198.contains(v199.getAbility().getName()) == false;
                                        if (!typing || !moveID || !notImmune || !notAbility) continue;
                                        return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                                    }
                                    if (Intrinsics.areEqual((Object)activePlayerPokemonVolatile, (Object)"confusion")) continue;
                                    typing = new String[]{"owntempo", "oblivious"};
                                    v201 = CollectionsKt.listOf((Object[])typing);
                                    v202 = opponent.getPokemon();
                                    Intrinsics.checkNotNull((Object)v202);
                                    if (v201.contains(v202.getAbility().getName())) continue;
                                    return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                                }
                                v203 = moveID = this.activeTracker.getP1Active().getActivePokemon().getCurrentTypes();
                                if (v203 != null ? v203.contains("Poison") : false) ** GOTO lbl-1000
                                v204 = moveID = this.activeTracker.getP1Active().getActivePokemon().getCurrentTypes();
                                if (!(v204 != null ? v204.contains("Steel") : false)) {
                                    v205 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v205 = false;
                                }
                                typing = v205;
                                notImmune = StrongBattleAI.choose$hasMajorStatusImmunity(opponent, currentWeather, opponent) == false;
                                notAbility = new String[]{"immunity", "poisonheal", "guts", "magicguard"};
                                v206 = CollectionsKt.listOf((Object[])notAbility);
                                v207 = opponent.getPokemon();
                                Intrinsics.checkNotNull((Object)v207);
                                v208 = notAbility = v206.contains(v207.getAbility().getName()) == false;
                                if (!typing || !notImmune || !notAbility) continue;
                                return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                            }
                            v209 = notImmune = this.activeTracker.getP1Active().getActivePokemon().getCurrentTypes();
                            if (v209 != null ? v209.contains("Poison") : false) ** GOTO lbl-1000
                            v210 = notImmune = this.activeTracker.getP1Active().getActivePokemon().getCurrentTypes();
                            if (!(v210 != null ? v210.contains("Steel") : false)) {
                                v211 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v211 = false;
                            }
                            typing = v211;
                            notImmune = StrongBattleAI.choose$hasMajorStatusImmunity(opponent, currentWeather, opponent) == false;
                            notAbility = new String[]{"immunity", "poisonheal", "guts", "magicguard"};
                            v212 = CollectionsKt.listOf((Object[])notAbility);
                            v213 = opponent.getPokemon();
                            Intrinsics.checkNotNull((Object)v213);
                            v214 = notAbility = v212.contains(v213.getAbility().getName()) == false;
                            if (!typing || !notImmune || !notAbility) continue;
                            return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                        }
                        if (Intrinsics.areEqual((Object)activeNPCPokemonVolatile, (Object)"cursed")) continue;
                        v215 = typing = this.activeTracker.getP1Active().getActivePokemon().getCurrentTypes();
                        if (v215 != null ? v215.contains("Ghost") : false) continue;
                        v216 = opponent.getPokemon();
                        Intrinsics.checkNotNull((Object)v216);
                        if (v216.getAbility().getName().equals("magicguard")) continue;
                        return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                    }
                    if (Intrinsics.areEqual((Object)activeNPCPokemonVolatile, (Object)"leech")) continue;
                    if (typing != null ? (typing = this.activeTracker.getP1Active().getActivePokemon().getCurrentTypes()).contains("Grass") : false) continue;
                    typing = new String[]{"liquidooze", "magicguard"};
                    v217 = CollectionsKt.listOf((Object[])typing);
                    v218 = opponent.getPokemon();
                    Intrinsics.checkNotNull((Object)v218);
                    if (v217.contains(v218.getAbility().getName())) continue;
                    return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                }
                $this$filter$iv = moveset.getMoves();
                $i$f$filter = false;
                $i$f$any = $this$filter$iv;
                destination$iv$iv /* !! */  = new ArrayList<E>();
                $i$f$filterTo = false;
                notAbility = $this$filterTo$iv$iv.iterator();
                while (notAbility.hasNext()) {
                    element$iv$iv = notAbility.next();
                    it = (InBattleMove)element$iv$iv;
                    $i$a$-filter-StrongBattleAI$choose$33 = false;
                    if (!(it.getDisabled() == false)) continue;
                    destination$iv$iv /* !! */ .add(element$iv$iv);
                }
                for (Object move : (List)destination$iv$iv /* !! */ ) {
                    if (move.getPp() <= 0) continue;
                }
                $this$filter$iv = moveset.getMoves();
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv /* !! */  = new ArrayList<E>();
                $i$f$filterTo = false;
                notAbility = $this$filterTo$iv$iv.iterator();
                while (notAbility.hasNext()) {
                    element$iv$iv = notAbility.next();
                    it = (InBattleMove)element$iv$iv;
                    $i$a$-filter-StrongBattleAI$choose$34 = false;
                    if (!(it.getDisabled() == false)) continue;
                    destination$iv$iv /* !! */ .add(element$iv$iv);
                }
                for (Object move : (List)destination$iv$iv /* !! */ ) {
                    activeOpponent = opponent.getPokemon();
                    if (move.getPp() <= 0 || !CollectionsKt.listOf((Object[])($this$filterTo$iv$iv = new String[]{"protect", "banefulbunker", "obstruct", "craftyshield", "detect", "quickguard", "spikyshield", "silktrap"})).contains(move.getId())) continue;
                    $this$filterTo$iv$iv = new String[]{"tailwind", "lightscreen", "reflect", "trickroom"};
                    if (!(($this$filterTo$iv$iv = (Collection)CollectionsKt.intersect((Iterable)oppSideConditionList, (Iterable)SetsKt.setOf((Object[])$this$filterTo$iv$iv))).isEmpty() == false) || !CollectionsKt.intersect((Iterable)monSideConditionList, (Iterable)SetsKt.setOf((Object[])($this$filterTo$iv$iv = new String[]{"tailwind", "lightscreen", "reflect"}))).isEmpty()) {
                        v219 = activeOpponent;
                        if ((v219 != null ? v219.getStatus() : null) != null || mon.getProtectCount() != 0) continue;
                        v220 = opponent.getPokemon();
                        Intrinsics.checkNotNull((Object)v220);
                        if (Intrinsics.areEqual((Object)v220.getAbility().getName(), (Object)"unseenfist")) continue;
                    }
                    mon.setProtectCount(3);
                    return this.chooseMove((InBattleMove)move, activeBattlePokemon);
                }
                moveValues = new LinkedHashMap<K, V>();
                $this$filter$iv = moveset.getMoves();
                $i$f$filter = false;
                destination$iv$iv /* !! */  = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (InBattleMove)element$iv$iv;
                    $i$a$-filter-StrongBattleAI$choose$35 = false;
                    if (!(it.getDisabled() == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (InBattleMove move : (List)destination$iv$iv) {
                    block355: {
                        block344: {
                            block354: {
                                block353: {
                                    block352: {
                                        block351: {
                                            block350: {
                                                block349: {
                                                    block348: {
                                                        block347: {
                                                            block346: {
                                                                block345: {
                                                                    block343: {
                                                                        moveData = Moves.INSTANCE.getByName(move.getId());
                                                                        value = this.calculateDamage(move, mon, opponent, currentWeather);
                                                                        if (move.getId().equals("fakeout")) {
                                                                            value = 0.0;
                                                                        }
                                                                        if (move.getId().equals("synchronoise")) {
                                                                            block325: {
                                                                                v221 = mon.getPokemon();
                                                                                Intrinsics.checkNotNull((Object)v221);
                                                                                $this$any$iv = v221.getTypes();
                                                                                $i$f$any = false;
                                                                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                                                                    v222 = false;
                                                                                } else {
                                                                                    element$iv$iv = $this$any$iv.iterator();
                                                                                    while (element$iv$iv.hasNext()) {
                                                                                        it = element$iv = element$iv$iv.next();
                                                                                        $i$a$-any-StrongBattleAI$choose$36 = false;
                                                                                        v223 = opponent.getPokemon();
                                                                                        Intrinsics.checkNotNull((Object)v223);
                                                                                        if (!CollectionsKt.contains(v223.getTypes(), (Object)it)) continue;
                                                                                        v222 = true;
                                                                                        break block325;
                                                                                    }
                                                                                    v222 = false;
                                                                                }
                                                                            }
                                                                            if (!v222) {
                                                                                value = 0.0;
                                                                            }
                                                                        }
                                                                        if (move.getId().equals("soak")) {
                                                                            v224 = $this$any$iv = this.activeTracker.getP1Active().getActivePokemon().getCurrentTypes();
                                                                            v225 = v224 != null ? v224.contains("Steel") : false;
                                                                            if (v225) {
                                                                                v226 = $this$any$iv = this.activeTracker.getP1Active().getActivePokemon().getCurrentTypes();
                                                                                v227 = v226 != null ? v226.contains("Poison") : false;
                                                                                if (v227) {
                                                                                    value = 200.0;
                                                                                }
                                                                            }
                                                                        }
                                                                        v228 = opponent.getPokemon();
                                                                        Intrinsics.checkNotNull((Object)v228);
                                                                        opponentAbility = v228.getAbility();
                                                                        if (!opponentAbility.getTemplate().getName().equals("lightningrod")) break block343;
                                                                        v229 = moveData;
                                                                        Intrinsics.checkNotNull((Object)v229);
                                                                        if (Intrinsics.areEqual((Object)v229.getElementalType(), (Object)ElementalTypes.INSTANCE.getELECTRIC())) break block344;
                                                                    }
                                                                    if (!opponentAbility.getTemplate().getName().equals("flashfire")) break block345;
                                                                    v230 = moveData;
                                                                    Intrinsics.checkNotNull((Object)v230);
                                                                    if (Intrinsics.areEqual((Object)v230.getElementalType(), (Object)ElementalTypes.INSTANCE.getFIRE())) break block344;
                                                                }
                                                                if (!opponentAbility.getTemplate().getName().equals("levitate")) break block346;
                                                                v231 = moveData;
                                                                Intrinsics.checkNotNull((Object)v231);
                                                                if (Intrinsics.areEqual((Object)v231.getElementalType(), (Object)ElementalTypes.INSTANCE.getGROUND())) break block344;
                                                            }
                                                            if (!opponentAbility.getTemplate().getName().equals("sapsipper")) break block347;
                                                            v232 = moveData;
                                                            Intrinsics.checkNotNull((Object)v232);
                                                            if (Intrinsics.areEqual((Object)v232.getElementalType(), (Object)ElementalTypes.INSTANCE.getGRASS())) break block344;
                                                        }
                                                        if (!opponentAbility.getTemplate().getName().equals("motordrive")) break block348;
                                                        v233 = moveData;
                                                        Intrinsics.checkNotNull((Object)v233);
                                                        if (Intrinsics.areEqual((Object)v233.getElementalType(), (Object)ElementalTypes.INSTANCE.getELECTRIC())) break block344;
                                                    }
                                                    if (!opponentAbility.getTemplate().getName().equals("stormdrain")) break block349;
                                                    v234 = moveData;
                                                    Intrinsics.checkNotNull((Object)v234);
                                                    if (Intrinsics.areEqual((Object)v234.getElementalType(), (Object)ElementalTypes.INSTANCE.getWATER())) break block344;
                                                }
                                                if (!opponentAbility.getTemplate().getName().equals("voltabsorb")) break block350;
                                                v235 = moveData;
                                                Intrinsics.checkNotNull((Object)v235);
                                                if (Intrinsics.areEqual((Object)v235.getElementalType(), (Object)ElementalTypes.INSTANCE.getELECTRIC())) break block344;
                                            }
                                            if (!opponentAbility.getTemplate().getName().equals("waterabsorb")) break block351;
                                            v236 = moveData;
                                            Intrinsics.checkNotNull((Object)v236);
                                            if (Intrinsics.areEqual((Object)v236.getElementalType(), (Object)ElementalTypes.INSTANCE.getWATER())) break block344;
                                        }
                                        if (!opponentAbility.getTemplate().getName().equals("immunity")) break block352;
                                        v237 = moveData;
                                        Intrinsics.checkNotNull((Object)v237);
                                        if (Intrinsics.areEqual((Object)v237.getElementalType(), (Object)ElementalTypes.INSTANCE.getPOISON())) break block344;
                                    }
                                    if (!opponentAbility.getTemplate().getName().equals("eartheater")) break block353;
                                    v238 = moveData;
                                    Intrinsics.checkNotNull((Object)v238);
                                    if (Intrinsics.areEqual((Object)v238.getElementalType(), (Object)ElementalTypes.INSTANCE.getGROUND())) break block344;
                                }
                                if (!opponentAbility.getTemplate().getName().equals("suctioncup")) break block354;
                                v239 = moveData;
                                Intrinsics.checkNotNull((Object)v239);
                                if (Intrinsics.areEqual((Object)v239.getName(), (Object)"roar")) break block344;
                            }
                            v240 = moveData;
                            Intrinsics.checkNotNull((Object)v240);
                            if (!Intrinsics.areEqual((Object)v240.getName(), (Object)"whirlwind")) break block355;
                        }
                        value = 0.0;
                    }
                    if (this.pivotMoves.contains(move.getId()) && !(this.moveDamageMultiplier(move.getId(), opponent) == 0.0) && !this.shouldSwitchOut(request, battle, activeBattlePokemon, moveset) && !this.mostDamagingMove(move, moveset, mon, opponent, currentWeather)) {
                        value = 0.0;
                    }
                    if (move.getPp() == 0) {
                        value = 0.0;
                    }
                    element$iv$iv = value;
                    moveValues.put(move, element$iv$iv);
                }
                value = moveValues;
                destination$iv$iv = value.entrySet();
                opponentAbility = destination$iv$iv.iterator();
                if (!opponentAbility.hasNext()) {
                    v241 = null;
                } else {
                    $i$f$any = opponentAbility.next();
                    if (!opponentAbility.hasNext()) {
                        v241 = $i$f$any;
                    } else {
                        it = (Map.Entry)$i$f$any;
                        $i$a$-maxByOrNull-StrongBattleAI$choose$bestMoveValue$1 = false;
                        it = ((Number)it.getValue()).doubleValue();
                        do {
                            $i$a$-maxByOrNull-StrongBattleAI$choose$bestMoveValue$1 = opponentAbility.next();
                            it = (Map.Entry)$i$a$-maxByOrNull-StrongBattleAI$choose$bestMoveValue$1;
                            $i$a$-maxByOrNull-StrongBattleAI$choose$bestMoveValue$1 = false;
                            it = ((Number)it.getValue()).doubleValue();
                            if (Double.compare(it, it) >= 0) continue;
                            $i$f$any = $i$a$-maxByOrNull-StrongBattleAI$choose$bestMoveValue$1;
                            it = it;
                        } while (opponentAbility.hasNext());
                        v241 = $i$f$any;
                    }
                }
                v242 = moveData = (Map.Entry)v241;
                bestMoveValue = v242 != null ? (value = ((Number)v242.getValue()).doubleValue()) : 0.0;
                $this$firstOrNull$iv = moveValues.entrySet();
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Map.Entry)element$iv;
                    $i$a$-firstOrNull-StrongBattleAI$choose$bestMove$1 = false;
                    if (!(((Number)it.getValue()).doubleValue() == bestMoveValue)) continue;
                    v243 = element$iv;
                    break block326;
                }
                v243 = null;
            }
            v244 = value = (Map.Entry)v243;
            v245 = bestMove = v244 != null ? (InBattleMove)v244.getKey() : null;
            Intrinsics.checkNotNull((Object)v245);
            v246 = target = v245.mustBeUsed() != false ? null : (List)bestMove.getTarget().getTargetList().invoke((Object)activeBattlePokemon);
            if (allMoves != null) {
                block327: {
                    $this$none$iv = allMoves;
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        v247 = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            it = (InBattleMove)element$iv;
                            $i$a$-none-StrongBattleAI$choose$37 = false;
                            if (!(Intrinsics.areEqual((Object)it.getId(), (Object)"recharge") != false || Intrinsics.areEqual((Object)it.getId(), (Object)"struggle") != false)) continue;
                            v247 = false;
                            break block327;
                        }
                        v247 = true;
                    }
                }
                if (v247) {
                    if (target == null) {
                        return new MoveActionResponse(bestMove.getId(), null, null, 6, null);
                    }
                    $this$filter$iv = (Iterable)target;
                    $i$f$filter = false;
                    it = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Targetable)element$iv$iv;
                        $i$a$-filter-StrongBattleAI$choose$chosenTarget$1 = false;
                        if (!(it.isAllied(activeBattlePokemon) == false)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    $i$f$none = (Targetable)CollectionsKt.randomOrNull((Collection)$this$filter$iv, (Random)((Random)Random.Default));
                    v248 = $i$f$none;
                    if (v248 == null) {
                        v248 = (Targetable)CollectionsKt.random((Collection)((Collection)target), (Random)((Random)Random.Default));
                    }
                    chosenTarget = v248;
                    v249 = bestMove.getId();
                    Intrinsics.checkNotNull((Object)chosenTarget, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.battles.ActiveBattlePokemon");
                    return new MoveActionResponse(v249, ((ActiveBattlePokemon)chosenTarget).getPNX(), null, 4, null);
                }
                if (target == null) {
                    return new MoveActionResponse(((InBattleMove)CollectionsKt.first((List)allMoves)).getId(), null, null, 6, null);
                }
                $this$filter$iv = (Iterable)target;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Targetable)element$iv$iv;
                    $i$a$-filter-StrongBattleAI$choose$chosenTarget$2 = false;
                    if (!(it.isAllied(activeBattlePokemon) == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$none = (Targetable)CollectionsKt.randomOrNull((Collection)$this$filter$iv, (Random)((Random)Random.Default));
                v250 = $i$f$none;
                if (v250 == null) {
                    v250 = (Targetable)CollectionsKt.random((Collection)((Collection)target), (Random)((Random)Random.Default));
                }
                chosenTarget = v250;
                v251 = ((InBattleMove)CollectionsKt.first((List)allMoves)).getId();
                Intrinsics.checkNotNull((Object)chosenTarget, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.battles.ActiveBattlePokemon");
                return new MoveActionResponse(v251, ((ActiveBattlePokemon)chosenTarget).getPNX(), null, 4, null);
            }
        }
        $this$filter$iv = moveset.getMoves();
        $i$f$filter = false;
        bestMoveValue = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        target = $this$filterTo$iv$iv.iterator();
        while (target.hasNext()) {
            element$iv$iv = target.next();
            it = (InBattleMove)element$iv$iv;
            $i$a$-filter-StrongBattleAI$choose$38 = false;
            if (!(it.getDisabled() == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (InBattleMove move : (List)destination$iv$iv) {
            if (!move.getId().equals("healingwish")) continue;
            v252 = mon.getCurrentHp();
            v253 = mon.getPokemon();
            Intrinsics.checkNotNull((Object)v253);
            if (!(v252 / (double)v253.getHp() < this.selfKoMoveMatchupThreshold)) continue;
            return this.chooseMove(move, activeBattlePokemon);
        }
        if (this.shouldSwitchOut(request, battle, activeBattlePokemon, moveset)) {
            block328: {
                $this$filter$iv = p1Actor.getPokemonList();
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                target = $this$filterTo$iv$iv.iterator();
                while (target.hasNext()) {
                    element$iv$iv = target.next();
                    it = (BattlePokemon)element$iv$iv;
                    $i$a$-filter-StrongBattleAI$choose$availableSwitches$4 = false;
                    v254 = it.getUuid();
                    v255 = mon.getPokemon();
                    Intrinsics.checkNotNull((Object)v255);
                    if (!(Intrinsics.areEqual((Object)v254, (Object)v255.getUuid()) == false && it.getHealth() > 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                availableSwitches = (List)destination$iv$iv;
                $i$f$filter = availableSwitches;
                $this$filterTo$iv$iv = $i$f$filter.iterator();
                if (!$this$filterTo$iv$iv.hasNext()) {
                    v256 = null;
                } else {
                    it = (BattlePokemon)$this$filterTo$iv$iv.next();
                    $i$a$-maxOfOrNull-StrongBattleAI$choose$bestEstimation$4 = false;
                    target = this.estimateMatchup(activeBattlePokemon, request, battle, it.getEffectedPokemon());
                    while ($this$filterTo$iv$iv.hasNext()) {
                        it = (BattlePokemon)$this$filterTo$iv$iv.next();
                        $i$a$-maxOfOrNull-StrongBattleAI$choose$bestEstimation$4 = false;
                        $i$f$filter = this.estimateMatchup(activeBattlePokemon, request, battle, it.getEffectedPokemon());
                        target = Math.max(target, $i$f$filter);
                    }
                    v256 = target;
                }
                bestEstimation = v256;
                it = $this$filterTo$iv$iv = (Iterable)availableSwitches;
                $i$a$-maxOfOrNull-StrongBattleAI$choose$bestEstimation$4 = it.iterator();
                while ($i$a$-maxOfOrNull-StrongBattleAI$choose$bestEstimation$4.hasNext()) {
                    target = $i$a$-maxOfOrNull-StrongBattleAI$choose$bestEstimation$4.next();
                    it = (BattlePokemon)target;
                    $i$a$-find-StrongBattleAI$choose$bestMatchup$2 = false;
                    if (!Intrinsics.areEqual((double)this.estimateMatchup(activeBattlePokemon, request, battle, it.getEffectedPokemon()), (Double)bestEstimation)) continue;
                    v257 = target;
                    break block328;
                }
                v257 = null;
            }
            bestMatchup = v257;
            if (bestMatchup != null) {
                it = $this$filterTo$iv$iv = bestMatchup;
                $i$a$-let-StrongBattleAI$choose$39 = false;
                return new SwitchActionResponse(it.getUuid());
            }
        }
        mon.setFirstTurn(0);
        bestMatchup = moveset.getMoves();
        $i$f$filter = false;
        it = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (InBattleMove)element$iv$iv;
            $i$a$-filter-StrongBattleAI$choose$move$3 = false;
            if (!it.canBeUsed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (InBattleMove)element$iv$iv;
            $i$a$-filter-StrongBattleAI$choose$move$4 = false;
            if (it.mustBeUsed()) ** GOTO lbl-1000
            v258 = (List)it.getTarget().getTargetList().invoke((Object)activeBattlePokemon);
            if (!(v258 != null ? v258.isEmpty() : false)) lbl-1000:
            // 2 sources

            {
                v259 = true;
            } else {
                v259 = false;
            }
            if (!v259) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        var77_286 = (List)destination$iv$iv;
        v260 = var76_281 = (InBattleMove)CollectionsKt.randomOrNull((Collection)var77_286, (Random)((Random)Random.Default));
        if (v260 == null) {
            return new MoveActionResponse("struggle", null, null, 6, null);
        }
        move = v260;
        return this.chooseMove(move, activeBattlePokemon);
    }

    public final double estimatePartyMatchup(@NotNull ShowdownActionRequest request, @NotNull PokemonBattle battle, @NotNull Pokemon nonActiveMon) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        Intrinsics.checkNotNullParameter((Object)nonActiveMon, (String)"nonActiveMon");
        Pokemon playerPokemon = this.activeTracker.getP1Active().getActivePokemon().getPokemon();
        Pokemon npcPokemon = this.activeTracker.getP2Active().getActivePokemon().getPokemon();
        double score = 1.0;
        Pokemon pokemon = playerPokemon;
        Intrinsics.checkNotNull((Object)pokemon);
        score += this.bestDamageMultiplier(nonActiveMon, pokemon) * this.moveDamageWeightConsideration + this.typeMatchup(nonActiveMon, playerPokemon) * this.typeMatchupWeightConsideration;
        score -= this.bestDamageMultiplier(playerPokemon, nonActiveMon) * this.moveDamageWeightConsideration + this.typeMatchup(playerPokemon, nonActiveMon) * this.typeMatchupWeightConsideration;
        if (this.getBaseStats(nonActiveMon, "spe") > this.getBaseStats(playerPokemon, "spe")) {
            score += this.speedTierCoefficient * this.trickRoomCoefficient;
        } else if (this.getBaseStats(playerPokemon, "spe") > this.getBaseStats(nonActiveMon, "spe")) {
            score -= this.speedTierCoefficient * this.trickRoomCoefficient;
        }
        ShowdownSide showdownSide = request.getSide();
        if (Intrinsics.areEqual((Object)(showdownSide != null ? showdownSide.getId() : null), (Object)"p1")) {
            score += (double)nonActiveMon.getCurrentHealth() * this.hpFractionCoefficient * this.hpWeightConsideration;
            score -= (double)this.activeTracker.getP2Active().getActivePokemon().getCurrentHp() * this.hpFractionCoefficient * this.hpWeightConsideration;
        } else {
            score += (double)nonActiveMon.getCurrentHealth() * this.hpFractionCoefficient * this.hpWeightConsideration;
            score -= (double)this.activeTracker.getP1Active().getActivePokemon().getCurrentHp() * this.hpFractionCoefficient * this.hpWeightConsideration;
        }
        if (this.activeTracker.getP1Active().getActivePokemon().getAtkBoost() > 1 || this.activeTracker.getP1Active().getActivePokemon().getSpaBoost() > 1) {
            boolean bl2;
            block10: {
                Iterable $this$any$iv = nonActiveMon.getMoveSet();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Move it = (Move)element$iv;
                        boolean bl3 = false;
                        if (!this.antiBoostMoves.contains(it.getName())) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
            }
            if (bl2 || Intrinsics.areEqual((Object)nonActiveMon.getAbility().getName(), (Object)"unaware")) {
                score += (double)this.antiBoostWeightConsideration;
            }
        }
        return score;
    }

    public final double estimateMatchup(@NotNull ActiveBattlePokemon activeBattlePokemon, @NotNull ShowdownActionRequest request, @NotNull PokemonBattle battle, @Nullable Pokemon nonActiveMon) {
        Intrinsics.checkNotNullParameter((Object)activeBattlePokemon, (String)"activeBattlePokemon");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        this.updateActiveTracker(activeBattlePokemon, request, battle);
        Pair<Pokemon, Pokemon> battlePokemon = this.getCurrentPlayer(battle);
        Pokemon playerPokemon = (Pokemon)battlePokemon.getFirst();
        Object npcPokemon = null;
        npcPokemon = battlePokemon.getSecond();
        Pokemon pokemon = nonActiveMon;
        if (pokemon != null) {
            Pokemon it = pokemon;
            boolean bl2 = false;
            npcPokemon = it;
        }
        double score = 1.0;
        score += this.bestDamageMultiplier((Pokemon)npcPokemon, playerPokemon) * this.moveDamageWeightConsideration + this.typeMatchup((Pokemon)npcPokemon, playerPokemon) * this.typeMatchupWeightConsideration;
        score -= this.bestDamageMultiplier(playerPokemon, (Pokemon)npcPokemon) * this.moveDamageWeightConsideration + this.typeMatchup(playerPokemon, (Pokemon)npcPokemon) * this.typeMatchupWeightConsideration;
        if (this.getBaseStats((Pokemon)npcPokemon, "spe") > this.getBaseStats(playerPokemon, "spe")) {
            score += this.speedTierCoefficient * this.trickRoomCoefficient;
        } else if (this.getBaseStats(playerPokemon, "spe") > this.getBaseStats((Pokemon)npcPokemon, "spe")) {
            score -= this.speedTierCoefficient * this.trickRoomCoefficient;
        }
        ShowdownSide showdownSide = request.getSide();
        if (Intrinsics.areEqual((Object)(showdownSide != null ? showdownSide.getId() : null), (Object)"p1")) {
            double d;
            Pokemon pokemon2 = nonActiveMon;
            if (pokemon2 != null) {
                d = (double)pokemon2.getHp() * this.hpFractionCoefficient * this.hpWeightConsideration;
            } else {
                Pokemon pokemon3 = this.activeTracker.getP1Active().getActivePokemon().getPokemon();
                Intrinsics.checkNotNull((Object)pokemon3);
                d = (double)pokemon3.getHp() * this.hpFractionCoefficient * this.hpWeightConsideration;
            }
            score += d;
            Pokemon pokemon4 = this.activeTracker.getP2Active().getActivePokemon().getPokemon();
            Intrinsics.checkNotNull((Object)pokemon4);
            score -= (double)pokemon4.getHp() * this.hpFractionCoefficient * this.hpWeightConsideration;
        } else {
            double d;
            Pokemon pokemon5 = nonActiveMon;
            if (pokemon5 != null) {
                d = (double)pokemon5.getHp() * this.hpFractionCoefficient * this.hpWeightConsideration;
            } else {
                Pokemon pokemon6 = this.activeTracker.getP2Active().getActivePokemon().getPokemon();
                Intrinsics.checkNotNull((Object)pokemon6);
                d = (double)pokemon6.getHp() * this.hpFractionCoefficient * this.hpWeightConsideration;
            }
            score += d;
            Pokemon pokemon7 = this.activeTracker.getP1Active().getActivePokemon().getPokemon();
            Intrinsics.checkNotNull((Object)pokemon7);
            score -= (double)pokemon7.getHp() * this.hpFractionCoefficient * this.hpWeightConsideration;
        }
        if (this.activeTracker.getP1Active().getActivePokemon().getAtkBoost() > 1 || this.activeTracker.getP1Active().getActivePokemon().getSpaBoost() > 1) {
            boolean bl3;
            block15: {
                Iterable $this$any$iv = ((Pokemon)npcPokemon).getMoveSet();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Move it = (Move)element$iv;
                        boolean bl4 = false;
                        if (!this.antiBoostMoves.contains(it.getName())) continue;
                        bl3 = true;
                        break block15;
                    }
                    bl3 = false;
                }
            }
            if (bl3 || Intrinsics.areEqual((Object)((Pokemon)npcPokemon).getAbility().getName(), (Object)"unaware")) {
                score += (double)this.antiBoostWeightConsideration;
            }
        }
        return score;
    }

    public static /* synthetic */ double estimateMatchup$default(StrongBattleAI strongBattleAI, ActiveBattlePokemon activeBattlePokemon, ShowdownActionRequest showdownActionRequest, PokemonBattle pokemonBattle, Pokemon pokemon, int n, Object object) {
        if ((n & 8) != 0) {
            pokemon = null;
        }
        return strongBattleAI.estimateMatchup(activeBattlePokemon, showdownActionRequest, pokemonBattle, pokemon);
    }

    public final boolean shouldDynamax(@NotNull ActiveBattlePokemon activeBattlePokemon, @NotNull ShowdownActionRequest request, @NotNull PokemonBattle battle, boolean canDynamax) {
        Intrinsics.checkNotNullParameter((Object)activeBattlePokemon, (String)"activeBattlePokemon");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        this.updateActiveTracker(activeBattlePokemon, request, battle);
        if (canDynamax) {
            boolean bl2;
            Object object;
            boolean bl3;
            ShowdownPokemon it;
            int count$iv;
            boolean $i$f$count;
            Iterable $this$count$iv;
            ActiveTracker.TrackerActor mon = this.activeTracker.getP1Active();
            ActiveTracker.TrackerActor opponent = this.activeTracker.getP2Active();
            Object object2 = request.getSide();
            if (object2 != null && (object2 = ((ShowdownSide)object2).getPokemon()) != null) {
                int n;
                $this$count$iv = (Iterable)object2;
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        it = (ShowdownPokemon)element$iv;
                        boolean bl4 = false;
                        if (!(this.getHpFraction(it.getCondition()) == 1.0) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                bl3 = n == 1;
            } else {
                bl3 = false;
            }
            if (bl3) {
                return true;
            }
            if (StrongBattleAI.estimateMatchup$default(this, activeBattlePokemon, request, battle, null, 8, null) > 0.0) {
                double d = mon.getActivePokemon().getCurrentHp();
                Pokemon pokemon = mon.getActivePokemon().getPokemon();
                Intrinsics.checkNotNull((Object)pokemon);
                if (d / (double)pokemon.getHp() == 1.0) {
                    double d2 = opponent.getActivePokemon().getCurrentHp();
                    Pokemon pokemon2 = opponent.getActivePokemon().getPokemon();
                    Intrinsics.checkNotNull((Object)pokemon2);
                    if (d2 / (double)pokemon2.getHp() == 1.0) {
                        return true;
                    }
                }
            }
            if ((object = request.getSide()) != null && (object = ((ShowdownSide)object).getPokemon()) != null) {
                int n;
                $this$count$iv = (Iterable)object;
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        it = (ShowdownPokemon)element$iv;
                        boolean bl5 = false;
                        if (!(!(this.getHpFraction(it.getCondition()) == 0.0)) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                bl2 = n == 1;
            } else {
                bl2 = false;
            }
            if (bl2) {
                double d = mon.getActivePokemon().getCurrentHp();
                Pokemon pokemon = mon.getActivePokemon().getPokemon();
                Intrinsics.checkNotNull((Object)pokemon);
                if (d / (double)pokemon.getHp() == 1.0) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldSwitchOut(@NotNull ShowdownActionRequest request, @NotNull PokemonBattle battle, @NotNull ActiveBattlePokemon activeBattlePokemon, @Nullable ShowdownMoveset moveset) {
        BattlePokemon it;
        Object element$iv;
        Boolean isTrapped;
        List availableSwitches;
        ActiveTracker.TrackerActor npcActivePokemon;
        ActiveTracker.TrackerActor playerActivePokemon;
        block36: {
            boolean bl2;
            boolean bl3;
            String currentNPCAbility;
            block35: {
                boolean bl4;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block34: {
                    Boolean bl5;
                    Object it2;
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
                    Intrinsics.checkNotNullParameter((Object)activeBattlePokemon, (String)"activeBattlePokemon");
                    this.updateActiveTracker(activeBattlePokemon, request, battle);
                    BattleActor p1Actor = (BattleActor)ArraysKt.first((Object[])battle.getSide1().getActors());
                    BattleActor p2Actor = (BattleActor)ArraysKt.first((Object[])battle.getSide2().getActors());
                    BattlePokemon battlePokemon = activeBattlePokemon.getBattlePokemon();
                    Intrinsics.checkNotNull((Object)battlePokemon);
                    UUID uUID = battlePokemon.getEffectedPokemon().getUuid();
                    Pokemon pokemon = this.activeTracker.getP1Active().getActivePokemon().getPokemon();
                    Intrinsics.checkNotNull((Object)pokemon);
                    Pair pair = Intrinsics.areEqual((Object)uUID, (Object)pokemon.getUuid()) ? new Pair((Object)this.activeTracker.getP1Active(), (Object)this.activeTracker.getP2Active()) : new Pair((Object)this.activeTracker.getP2Active(), (Object)this.activeTracker.getP1Active());
                    ActiveTracker.TrackerActor mon = (ActiveTracker.TrackerActor)pair.component1();
                    ActiveTracker.TrackerActor opponent = (ActiveTracker.TrackerActor)pair.component2();
                    playerActivePokemon = this.activeTracker.getP1Active();
                    npcActivePokemon = this.activeTracker.getP2Active();
                    Iterable $this$filter$iv = p2Actor.getPokemonList();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object t : $this$filterTo$iv$iv) {
                        it2 = (BattlePokemon)t;
                        boolean bl6 = false;
                        UUID uUID2 = ((BattlePokemon)it2).getUuid();
                        Pokemon pokemon2 = mon.getActivePokemon().getPokemon();
                        Intrinsics.checkNotNull((Object)pokemon2);
                        if (!(!Intrinsics.areEqual((Object)uUID2, (Object)pokemon2.getUuid()) && ((BattlePokemon)it2).getHealth() > 0)) continue;
                        destination$iv$iv.add(t);
                    }
                    availableSwitches = (List)destination$iv$iv;
                    ShowdownSide showdownSide = request.getSide();
                    List<ShowdownPokemon> list = showdownSide != null ? showdownSide.getPokemon() : null;
                    Intrinsics.checkNotNull(list);
                    currentNPCAbility = ((ShowdownPokemon)CollectionsKt.first(list)).getAbility();
                    List<ShowdownMoveset> list2 = request.getActive();
                    if (list2 != null) {
                        boolean bl7;
                        block33: {
                            Iterable $this$any$iv2 = list2;
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl7 = false;
                            } else {
                                for (Object t : $this$any$iv2) {
                                    it2 = (ShowdownMoveset)t;
                                    boolean bl8 = false;
                                    if (!((ShowdownMoveset)it2).getTrapped()) continue;
                                    bl7 = true;
                                    break block33;
                                }
                                bl7 = false;
                            }
                        }
                        bl5 = bl7;
                    } else {
                        bl5 = null;
                    }
                    isTrapped = bl5;
                    double d = npcActivePokemon.getActivePokemon().getCurrentHp();
                    Pokemon pokemon3 = npcActivePokemon.getActivePokemon().getPokemon();
                    Intrinsics.checkNotNull((Object)pokemon3);
                    if (d / (double)pokemon3.getHp() < this.hpSwitchOutThreshold) {
                        Pokemon pokemon4 = npcActivePokemon.getActivePokemon().getPokemon();
                        Intrinsics.checkNotNull((Object)pokemon4);
                        Integer n = pokemon4.getSpecies().getBaseStats().get(Stats.SPEED);
                        Intrinsics.checkNotNull((Object)n);
                        int n2 = ((Number)n).intValue();
                        Pokemon pokemon5 = playerActivePokemon.getActivePokemon().getPokemon();
                        Intrinsics.checkNotNull((Object)pokemon5);
                        Integer n3 = pokemon5.getSpecies().getBaseStats().get(Stats.SPEED);
                        Intrinsics.checkNotNull((Object)n3);
                        if (n2 < ((Number)n3).intValue()) {
                            return false;
                        }
                    }
                    Pokemon pokemon6 = npcActivePokemon.getActivePokemon().getPokemon();
                    Intrinsics.checkNotNull((Object)pokemon6);
                    $this$any$iv = pokemon6.getSpecies().getAbilities();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object t : $this$any$iv) {
                            PotentialAbility potentialAbility = (PotentialAbility)t;
                            boolean bl9 = false;
                            if (!Intrinsics.areEqual((Object)potentialAbility.getTemplate(), (Object)Abilities.INSTANCE.get("truant"))) continue;
                            bl4 = true;
                            break block34;
                        }
                        bl4 = false;
                    }
                }
                if (!bl4) {
                    if (Intrinsics.areEqual((Object)currentNPCAbility, (Object)"truant")) return true;
                }
                Pokemon pokemon = npcActivePokemon.getActivePokemon().getPokemon();
                Intrinsics.checkNotNull((Object)pokemon);
                $this$any$iv = pokemon.getSpecies().getAbilities();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object t : $this$any$iv) {
                        PotentialAbility potentialAbility = (PotentialAbility)t;
                        boolean bl10 = false;
                        if (!Intrinsics.areEqual((Object)potentialAbility.getTemplate(), (Object)Abilities.INSTANCE.get("slowstart"))) continue;
                        bl3 = true;
                        break block35;
                    }
                    bl3 = false;
                }
            }
            if (!bl3 && Intrinsics.areEqual((Object)currentNPCAbility, (Object)"slowstart")) {
                return true;
            }
            ShowdownMoveset showdownMoveset = moveset;
            Intrinsics.checkNotNull((Object)showdownMoveset);
            Iterable $this$filter$iv = showdownMoveset.getMoves();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection collection = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : iterable) {
                InBattleMove it3 = (InBattleMove)element$iv$iv;
                boolean bl11 = false;
                if (!it3.canBeUsed()) continue;
                collection.add(element$iv$iv);
            }
            List availableMoves = (List)collection;
            Iterable $this$filter$iv2 = moveset.getMoves();
            boolean bl12 = false;
            Iterable iterable2 = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : iterable2) {
                InBattleMove it4 = (InBattleMove)element$iv$iv;
                boolean bl13 = false;
                if (!(!it4.canBeUsed())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List unavailableMoves = (List)destination$iv$iv;
            if (!(!((Collection)unavailableMoves).isEmpty())) break block36;
            Iterable $this$all$iv = availableMoves;
            boolean bl14 = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                block38: {
                    block37: {
                        if (!iterator.hasNext()) return true;
                        element$iv = iterator.next();
                        InBattleMove it5 = (InBattleMove)element$iv;
                        boolean bl15 = false;
                        if (this.moveDamageMultiplier(it5.getId(), playerActivePokemon.getActivePokemon()) == 0.0) break block37;
                        MoveTemplate moveTemplate = Moves.INSTANCE.getByName(it5.getId());
                        Intrinsics.checkNotNull((Object)moveTemplate);
                        if (!(moveTemplate.getPower() < 40.0)) break block38;
                    }
                    bl2 = true;
                    continue;
                }
                bl2 = false;
            } while (bl2);
            boolean bl16 = false;
            if (bl16) {
                return true;
            }
        }
        Iterable $this$any$iv = availableSwitches;
        boolean bl17 = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (BattlePokemon)element$iv;
            boolean bl18 = false;
        } while (!(this.estimateMatchup(activeBattlePokemon, request, battle, it.getEffectedPokemon()) > 0.0));
        boolean bl19 = true;
        if (!bl19) return false;
        Boolean bl20 = isTrapped;
        Intrinsics.checkNotNull((Object)bl20);
        if (bl20 != false) return false;
        Integer n = playerActivePokemon.getActivePokemon().getBoosts().get(Stats.ACCURACY);
        if ((n != null ? n : 0) <= this.accuracySwitchThreshold) {
            return true;
        }
        Integer n4 = playerActivePokemon.getActivePokemon().getBoosts().get(Stats.DEFENCE);
        if ((n4 != null ? n4 : 0) <= -3) return true;
        Integer n5 = playerActivePokemon.getActivePokemon().getBoosts().get(Stats.SPECIAL_DEFENCE);
        if ((n5 != null ? n5 : 0) <= -3) {
            return true;
        }
        Integer n6 = playerActivePokemon.getActivePokemon().getBoosts().get(Stats.ATTACK);
        if ((n6 != null ? n6 : 0) <= -3) {
            Integer n7 = playerActivePokemon.getActivePokemon().getStats().get(Stats.ATTACK);
            Integer n8 = playerActivePokemon.getActivePokemon().getStats().get(Stats.SPECIAL_ATTACK);
            if ((n7 != null ? n7 : 0) >= (n8 != null ? n8 : 0)) {
                return true;
            }
        }
        Integer n9 = playerActivePokemon.getActivePokemon().getBoosts().get(Stats.SPECIAL_ATTACK);
        if ((n9 != null ? n9 : 0) <= -3) {
            Integer n10 = playerActivePokemon.getActivePokemon().getStats().get(Stats.ATTACK);
            Integer n11 = playerActivePokemon.getActivePokemon().getStats().get(Stats.SPECIAL_ATTACK);
            if ((n10 != null ? n10 : 0) <= (n11 != null ? n11 : 0)) {
                return true;
            }
        }
        if (!(StrongBattleAI.estimateMatchup$default(this, activeBattlePokemon, request, battle, null, 8, null) < (double)this.switchOutMatchupThreshold)) return false;
        double d = npcActivePokemon.getActivePokemon().getCurrentHp();
        Pokemon pokemon = npcActivePokemon.getActivePokemon().getPokemon();
        Intrinsics.checkNotNull((Object)pokemon);
        if (!(d / (double)pokemon.getHp() > this.hpSwitchOutThreshold)) return false;
        return true;
    }

    public final double statEstimationActive(@NotNull ActiveTracker.TrackerPokemon mon, @NotNull Stat stat) {
        Intrinsics.checkNotNullParameter((Object)mon, (String)"mon");
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        Integer n = mon.getBoosts().get(stat);
        int boost = n != null ? n : 0;
        double actualBoost = boost > 1 ? (double)(2 + boost) / 2.0 : (double)2 / (2.0 - (double)boost);
        Pokemon pokemon = mon.getPokemon();
        Intrinsics.checkNotNull((Object)pokemon);
        int baseStat = this.getBaseStats(pokemon, stat.getShowdownId());
        return (double)(2 * baseStat + 31 + 5) * actualBoost;
    }

    public final double statEstimation(@NotNull Pokemon mon, @NotNull Stat stat) {
        Intrinsics.checkNotNullParameter((Object)mon, (String)"mon");
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        return this.getBaseStats(mon, stat.getShowdownId());
    }

    @NotNull
    public final String getMoveSlot(@NotNull String move, @Nullable List<InBattleMove> possibleMoves) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        List<InBattleMove> list = possibleMoves;
        if (list != null) {
            int n2;
            block4: {
                List<InBattleMove> $this$indexOfFirst$iv = list;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<InBattleMove> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    InBattleMove item$iv;
                    InBattleMove it = item$iv = iterator.next();
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getId(), (Object)move)) {
                        n2 = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            n = n2 + 1;
        } else {
            n = null;
        }
        Integer bestMoveSlotIndex = n;
        return "move " + bestMoveSlotIndex;
    }

    public final double moveDamageMultiplier(@NotNull String moveID, @NotNull ActiveTracker.TrackerPokemon defender) {
        Intrinsics.checkNotNullParameter((Object)moveID, (String)"moveID");
        Intrinsics.checkNotNullParameter((Object)defender, (String)"defender");
        MoveTemplate move = Moves.INSTANCE.getByName(moveID);
        List typeList = null;
        typeList = new ArrayList();
        List<String> list = defender.getCurrentTypes();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ElementalType it1;
                String it = (String)element$iv;
                boolean bl2 = false;
                String string = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                if (ElementalTypes.INSTANCE.get(string) == null) continue;
                boolean bl3 = false;
                typeList.add(it1);
            }
        }
        List defenderTypes = typeList;
        double multiplier = 1.0;
        for (ElementalType defenderType : defenderTypes) {
            MoveTemplate moveTemplate = move;
            Intrinsics.checkNotNull((Object)moveTemplate);
            multiplier *= StrongBattleAIKt.getDamageMultiplier(moveTemplate.getElementalType(), defenderType);
        }
        return multiplier;
    }

    public final double bestDamageMultiplier(@NotNull Pokemon attacker, @NotNull Pokemon defender) {
        Intrinsics.checkNotNullParameter((Object)attacker, (String)"attacker");
        Intrinsics.checkNotNullParameter((Object)defender, (String)"defender");
        List<Move> attackerMoves = attacker.getMoveSet().getMoves();
        Iterable<ElementalType> defenderTypes = defender.getTypes();
        double multiplier = 1.0;
        double bestMultiplier = 1.0;
        for (Move attackerMove : attackerMoves) {
            for (ElementalType defenderType : defenderTypes) {
                multiplier *= StrongBattleAIKt.getDamageMultiplier(attackerMove.getType(), defenderType);
            }
            if (multiplier > bestMultiplier) {
                bestMultiplier = multiplier;
            }
            multiplier = 1.0;
        }
        return bestMultiplier;
    }

    public final double typeMatchup(@NotNull Pokemon attackingPokemon, @NotNull Pokemon defendingPokemon) {
        Intrinsics.checkNotNullParameter((Object)attackingPokemon, (String)"attackingPokemon");
        Intrinsics.checkNotNullParameter((Object)defendingPokemon, (String)"defendingPokemon");
        Iterable<ElementalType> attackerTypes = attackingPokemon.getTypes();
        Iterable<ElementalType> defenderTypes = defendingPokemon.getTypes();
        double multiplier = 1.0;
        for (ElementalType atkType : attackerTypes) {
            for (ElementalType defType : defenderTypes) {
                multiplier *= StrongBattleAIKt.getDamageMultiplier(atkType, defType);
            }
        }
        return multiplier;
    }

    public final boolean isBoosted(@NotNull ActiveTracker.TrackerPokemon trackerPokemon) {
        Intrinsics.checkNotNullParameter((Object)trackerPokemon, (String)"trackerPokemon");
        return trackerPokemon.getAtkBoost() > this.boostWeightCoefficient || trackerPokemon.getDefBoost() > this.boostWeightCoefficient || trackerPokemon.getSpaBoost() > this.boostWeightCoefficient || trackerPokemon.getSpdBoost() > this.boostWeightCoefficient || trackerPokemon.getSpeBoost() > this.boostWeightCoefficient;
    }

    public final int expectedHits(@NotNull MoveTemplate move) {
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        Map<Integer, Integer> minMaxHits = StrongBattleAIKt.getMultiHitMoves().get(move.getName());
        if (Intrinsics.areEqual((Object)move.getName(), (Object)"triplekick") || Intrinsics.areEqual((Object)move.getName(), (Object)"tripleaxel")) {
            return 5;
        }
        if (Intrinsics.areEqual((Object)move.getName(), (Object)"populationbomb")) {
            return 7;
        }
        if (minMaxHits == null) {
            return 1;
        }
        if (Intrinsics.areEqual((Object)minMaxHits.get(0), (Object)minMaxHits.get(1))) {
            Integer n = minMaxHits.get(0);
            Intrinsics.checkNotNull((Object)n);
            return ((Number)n).intValue();
        }
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    private final double getHpFraction(String condition) {
        void $this$mapTo$iv$iv;
        if (Intrinsics.areEqual((Object)condition, (Object)"0 fnt")) {
            return 0.0;
        }
        char[] cArray = new char[]{'/'};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)condition, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(Integer.parseInt((String)it));
        }
        List list = (List)destination$iv$iv;
        int numerator = ((Number)list.get(0)).intValue();
        int denominator = ((Number)list.get(1)).intValue();
        return (double)numerator / (double)denominator;
    }

    private final Map<Stat, Integer> getNonZeroStats(String name) {
        Map map = StrongBattleAIKt.getBoostFromMoves().get(name);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateActiveTracker(ActiveBattlePokemon activeBattlePokemon, ShowdownActionRequest request, PokemonBattle battle) {
        Object v47;
        ActiveTracker.TrackerActor p2;
        block80: {
            Object object;
            Object v35;
            int n;
            BattlePokemon pokemon;
            int n2;
            Map p2BoostsMap;
            Pokemon pokemon2;
            Object it;
            Object object2;
            ActiveTracker.TrackerActor p1;
            BattleActor npcActor;
            block78: {
                Object object3;
                Object destination$iv$iv;
                Map map;
                Map p1BoostsMap;
                BattleActor[] $this$associateByTo$iv$iv$iv;
                int playerSPENegBoosts;
                int playerSPDNegBoosts;
                int playerSPANegBoosts;
                int playerDEFNegBoosts;
                int playerATKNegBoosts;
                int playerSPEPosBoosts;
                int playerSPDPosBoosts;
                int playerSPAPosBoosts;
                int playerDEFPosBoosts;
                int playerATKPosBoosts;
                Pokemon pokemon1;
                BattleActor playerActor;
                block85: {
                    block84: {
                        Map map2;
                        block83: {
                            block82: {
                                void $this$mapKeysTo$iv$iv2;
                                int n3;
                                int n4;
                                int n5;
                                int n6;
                                int n7;
                                int n8;
                                int n9;
                                int n10;
                                int n11;
                                int n12;
                                playerActor = activeBattlePokemon.getBattle().getSide1().getActors()[0];
                                npcActor = activeBattlePokemon.getBattle().getSide2().getActors()[0];
                                Object object4 = ((BattleActor)ArraysKt.first((Object[])battle.getSide1().getActors())).getActivePokemon().get(0).getBattlePokemon();
                                Collection<BattleContext> playerPosBoostContext = object4 != null && (object4 = ((BattlePokemon)object4).getContextManager()) != null ? ((ContextManager)object4).get(BattleContext.Type.BOOST) : null;
                                Object object5 = ((BattleActor)ArraysKt.first((Object[])battle.getSide1().getActors())).getActivePokemon().get(0).getBattlePokemon();
                                Collection<BattleContext> playerNegBoostContext = object5 != null && (object5 = ((BattlePokemon)object5).getContextManager()) != null ? ((ContextManager)object5).get(BattleContext.Type.UNBOOST) : null;
                                p1 = this.activeTracker.getP1Active();
                                Object object6 = (ActiveBattlePokemon)CollectionsKt.firstOrNull(battle.getSide1().getActivePokemon());
                                pokemon1 = object6 != null && (object6 = ((ActiveBattlePokemon)object6).getBattlePokemon()) != null ? ((BattlePokemon)object6).getEffectedPokemon() : null;
                                Collection<BattleContext> collection = playerPosBoostContext;
                                if (collection != null) {
                                    Iterable $this$count$iv = collection;
                                    boolean $i$f$count = false;
                                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                        n12 = 0;
                                    } else {
                                        int count$iv = 0;
                                        for (Object element$iv : $this$count$iv) {
                                            BattleContext it2 = (BattleContext)element$iv;
                                            boolean bl2 = false;
                                            if (!Intrinsics.areEqual((Object)it2.getId(), (Object)"atk") || ++count$iv >= 0) continue;
                                            CollectionsKt.throwCountOverflow();
                                        }
                                        n12 = count$iv;
                                    }
                                } else {
                                    n12 = 0;
                                }
                                playerATKPosBoosts = n12;
                                Collection<BattleContext> collection2 = playerPosBoostContext;
                                if (collection2 != null) {
                                    Iterable $this$count$iv = collection2;
                                    boolean $i$f$count = false;
                                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                        n11 = 0;
                                    } else {
                                        int count$iv = 0;
                                        for (Object element$iv : $this$count$iv) {
                                            BattleContext it3 = (BattleContext)element$iv;
                                            boolean bl3 = false;
                                            if (!Intrinsics.areEqual((Object)it3.getId(), (Object)"def") || ++count$iv >= 0) continue;
                                            CollectionsKt.throwCountOverflow();
                                        }
                                        n11 = count$iv;
                                    }
                                } else {
                                    n11 = 0;
                                }
                                playerDEFPosBoosts = n11;
                                Collection<BattleContext> collection3 = playerPosBoostContext;
                                if (collection3 != null) {
                                    Iterable $this$count$iv = collection3;
                                    boolean $i$f$count = false;
                                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                        n10 = 0;
                                    } else {
                                        int count$iv = 0;
                                        for (Object element$iv : $this$count$iv) {
                                            BattleContext it4 = (BattleContext)element$iv;
                                            boolean bl4 = false;
                                            if (!Intrinsics.areEqual((Object)it4.getId(), (Object)"spa") || ++count$iv >= 0) continue;
                                            CollectionsKt.throwCountOverflow();
                                        }
                                        n10 = count$iv;
                                    }
                                } else {
                                    n10 = 0;
                                }
                                playerSPAPosBoosts = n10;
                                Collection<BattleContext> collection4 = playerPosBoostContext;
                                if (collection4 != null) {
                                    Iterable $this$count$iv = collection4;
                                    boolean $i$f$count = false;
                                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                        n9 = 0;
                                    } else {
                                        int count$iv = 0;
                                        for (Object element$iv : $this$count$iv) {
                                            BattleContext it5 = (BattleContext)element$iv;
                                            boolean bl5 = false;
                                            if (!Intrinsics.areEqual((Object)it5.getId(), (Object)"spd") || ++count$iv >= 0) continue;
                                            CollectionsKt.throwCountOverflow();
                                        }
                                        n9 = count$iv;
                                    }
                                } else {
                                    n9 = 0;
                                }
                                playerSPDPosBoosts = n9;
                                Collection<BattleContext> collection5 = playerPosBoostContext;
                                if (collection5 != null) {
                                    Iterable $this$count$iv = collection5;
                                    boolean $i$f$count = false;
                                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                        n8 = 0;
                                    } else {
                                        int count$iv = 0;
                                        for (Object element$iv : $this$count$iv) {
                                            BattleContext it6 = (BattleContext)element$iv;
                                            boolean bl6 = false;
                                            if (!Intrinsics.areEqual((Object)it6.getId(), (Object)"spe") || ++count$iv >= 0) continue;
                                            CollectionsKt.throwCountOverflow();
                                        }
                                        n8 = count$iv;
                                    }
                                } else {
                                    n8 = 0;
                                }
                                playerSPEPosBoosts = n8;
                                Collection<BattleContext> collection6 = playerNegBoostContext;
                                if (collection6 != null) {
                                    Iterable $this$count$iv = collection6;
                                    boolean $i$f$count = false;
                                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                        n7 = 0;
                                    } else {
                                        int count$iv = 0;
                                        for (Object element$iv : $this$count$iv) {
                                            BattleContext it7 = (BattleContext)element$iv;
                                            boolean bl7 = false;
                                            if (!Intrinsics.areEqual((Object)it7.getId(), (Object)"atk") || ++count$iv >= 0) continue;
                                            CollectionsKt.throwCountOverflow();
                                        }
                                        n7 = count$iv;
                                    }
                                } else {
                                    n7 = 0;
                                }
                                playerATKNegBoosts = n7;
                                Collection<BattleContext> collection7 = playerNegBoostContext;
                                if (collection7 != null) {
                                    Iterable $this$count$iv = collection7;
                                    boolean $i$f$count = false;
                                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                        n6 = 0;
                                    } else {
                                        int count$iv = 0;
                                        for (Object element$iv : $this$count$iv) {
                                            BattleContext it8 = (BattleContext)element$iv;
                                            boolean bl8 = false;
                                            if (!Intrinsics.areEqual((Object)it8.getId(), (Object)"def") || ++count$iv >= 0) continue;
                                            CollectionsKt.throwCountOverflow();
                                        }
                                        n6 = count$iv;
                                    }
                                } else {
                                    n6 = 0;
                                }
                                playerDEFNegBoosts = n6;
                                Collection<BattleContext> collection8 = playerNegBoostContext;
                                if (collection8 != null) {
                                    Iterable $this$count$iv = collection8;
                                    boolean $i$f$count = false;
                                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                        n5 = 0;
                                    } else {
                                        int count$iv = 0;
                                        for (Object element$iv : $this$count$iv) {
                                            BattleContext it9 = (BattleContext)element$iv;
                                            boolean bl9 = false;
                                            if (!Intrinsics.areEqual((Object)it9.getId(), (Object)"spa") || ++count$iv >= 0) continue;
                                            CollectionsKt.throwCountOverflow();
                                        }
                                        n5 = count$iv;
                                    }
                                } else {
                                    n5 = 0;
                                }
                                playerSPANegBoosts = n5;
                                Collection<BattleContext> collection9 = playerNegBoostContext;
                                if (collection9 != null) {
                                    Iterable $this$count$iv = collection9;
                                    boolean $i$f$count = false;
                                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                        n4 = 0;
                                    } else {
                                        int count$iv = 0;
                                        for (Object element$iv : $this$count$iv) {
                                            BattleContext it10 = (BattleContext)element$iv;
                                            boolean bl10 = false;
                                            if (!Intrinsics.areEqual((Object)it10.getId(), (Object)"spd") || ++count$iv >= 0) continue;
                                            CollectionsKt.throwCountOverflow();
                                        }
                                        n4 = count$iv;
                                    }
                                } else {
                                    n4 = 0;
                                }
                                playerSPDNegBoosts = n4;
                                Collection<BattleContext> collection10 = playerNegBoostContext;
                                if (collection10 != null) {
                                    Iterable $this$count$iv = collection10;
                                    boolean $i$f$count = false;
                                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                        n3 = 0;
                                    } else {
                                        int count$iv = 0;
                                        for (Object element$iv : $this$count$iv) {
                                            BattleContext it11 = (BattleContext)element$iv;
                                            boolean bl11 = false;
                                            if (!Intrinsics.areEqual((Object)it11.getId(), (Object)"spe") || ++count$iv >= 0) continue;
                                            CollectionsKt.throwCountOverflow();
                                        }
                                        n3 = count$iv;
                                    }
                                } else {
                                    n3 = 0;
                                }
                                playerSPENegBoosts = n3;
                                Object object7 = (ActiveBattlePokemon)CollectionsKt.firstOrNull(battle.getSide1().getActivePokemon());
                                Map p1Boosts = object7 != null && (object7 = ((ActiveBattlePokemon)object7).getBattlePokemon()) != null ? ((BattlePokemon)object7).getStatChanges() : null;
                                BattleActor playerSide1 = (BattleActor)ArraysKt.first((Object[])battle.getSide1().getActors());
                                int numPlayerPokemon = ((Collection)playerSide1.getPokemonList()).size();
                                map2 = p1Boosts;
                                if (map2 == null) break block82;
                                Map $this$mapKeys$iv = map2;
                                boolean $i$f$mapKeys = false;
                                Map bl11 = $this$mapKeys$iv;
                                Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                                boolean $i$f$mapKeysTo = false;
                                $this$associateByTo$iv$iv$iv = (BattleActor[])$this$mapKeysTo$iv$iv2.entrySet();
                                boolean $i$f$associateByTo = false;
                                for (Object t : $this$associateByTo$iv$iv$iv) {
                                    void it$iv$iv;
                                    Map.Entry entry = (Map.Entry)t;
                                    object2 = destination$iv$iv2;
                                    boolean bl2 = false;
                                    Map.Entry entry2 = (Map.Entry)t;
                                    Stat stat = (Stat)it.getKey();
                                    Object object8 = object2;
                                    boolean bl13 = false;
                                    it = it$iv$iv.getValue();
                                    object8.put(stat, it);
                                }
                                map2 = MapsKt.toMutableMap((Map)destination$iv$iv2);
                                if (map2 != null) break block83;
                            }
                            map2 = new LinkedHashMap();
                        }
                        p1BoostsMap = map2;
                        p2 = this.activeTracker.getP2Active();
                        Object object9 = (ActiveBattlePokemon)CollectionsKt.firstOrNull(battle.getSide2().getActivePokemon());
                        pokemon2 = object9 != null && (object9 = ((ActiveBattlePokemon)object9).getBattlePokemon()) != null ? ((BattlePokemon)object9).getEffectedPokemon() : null;
                        Object object10 = (ActiveBattlePokemon)CollectionsKt.firstOrNull(battle.getSide2().getActivePokemon());
                        Map p2Boosts = object10 != null && (object10 = ((ActiveBattlePokemon)object10).getBattlePokemon()) != null ? ((BattlePokemon)object10).getStatChanges() : null;
                        BattleActor playerSide2 = (BattleActor)ArraysKt.first((Object[])battle.getSide2().getActors());
                        int numNPCPokemon = ((Collection)playerSide2.getPokemonList()).size();
                        map = p2Boosts;
                        if (map == null) break block84;
                        Map $this$mapKeys$iv232 = map;
                        boolean $i$f$mapKeys = false;
                        Map map3 = $this$mapKeys$iv232;
                        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv232.size()));
                        boolean bl3 = false;
                        Iterable $this$associateByTo$iv$iv$iv2 = map3.entrySet();
                        boolean $i$f$associateByTo = false;
                        for (Object element$iv$iv$iv3 : $this$associateByTo$iv$iv$iv2) {
                            void it$iv$iv;
                            void it12;
                            Iterator iterator = (Map.Entry)element$iv$iv$iv3;
                            object2 = destination$iv$iv;
                            boolean bl14 = false;
                            Map.Entry entry = (Map.Entry)element$iv$iv$iv3;
                            Stat stat = (Stat)it12.getKey();
                            Map map4 = object2;
                            boolean bl15 = false;
                            iterator = it$iv$iv.getValue();
                            map4.put(stat, iterator);
                        }
                        map = MapsKt.toMutableMap((Map)destination$iv$iv);
                        if (map != null) break block85;
                    }
                    map = new LinkedHashMap();
                }
                p2BoostsMap = map;
                Pokemon pokemon3 = pokemon1;
                p1.setActivePokemon(this.getActiveTrackerPokemon(p1, pokemon3 != null ? pokemon3.getUuid() : null));
                p1.getActivePokemon().setPokemon(pokemon1);
                ActiveTracker.TrackerPokemon trackerPokemon = p1.getActivePokemon();
                Pokemon pokemon4 = pokemon1;
                Intrinsics.checkNotNull((Object)pokemon4);
                trackerPokemon.setSpecies(pokemon4.getSpecies().getName());
                p1.getActivePokemon().setCurrentHp(pokemon1.getCurrentHealth());
                p1.getActivePokemon().setCurrentHpPercent((double)pokemon1.getCurrentHealth() / (double)pokemon1.getHp());
                p1.getActivePokemon().setBoosts(p1BoostsMap);
                p1.getActivePokemon().setAtkBoost(playerATKPosBoosts - playerATKNegBoosts);
                p1.getActivePokemon().setDefBoost(playerDEFPosBoosts - playerDEFNegBoosts);
                p1.getActivePokemon().setSpaBoost(playerSPAPosBoosts - playerSPANegBoosts);
                p1.getActivePokemon().setSpdBoost(playerSPDPosBoosts - playerSPDNegBoosts);
                p1.getActivePokemon().setSpeBoost(playerSPEPosBoosts - playerSPENegBoosts);
                p1.getActivePokemon().getBoosts().put(Stats.ATTACK, p1.getActivePokemon().getAtkBoost());
                p1.getActivePokemon().getBoosts().put(Stats.DEFENCE, p1.getActivePokemon().getDefBoost());
                p1.getActivePokemon().getBoosts().put(Stats.SPECIAL_ATTACK, p1.getActivePokemon().getSpaBoost());
                p1.getActivePokemon().getBoosts().put(Stats.SPECIAL_DEFENCE, p1.getActivePokemon().getSpdBoost());
                p1.getActivePokemon().getBoosts().put(Stats.SPEED, p1.getActivePokemon().getSpeBoost());
                p1.getActivePokemon().setCurrentTypes((object3 = playerActor.getRequest()) != null && (object3 = ((ShowdownActionRequest)object3).getSide()) != null && (object3 = ((ShowdownSide)object3).getPokemon()) != null && (object3 = object3.get(0)) != null ? ((ShowdownPokemon)object3).getTypes() : null);
                p1.getActivePokemon().setMoves(pokemon1.getMoveSet().getMoves());
                $this$associateByTo$iv$iv$iv = battle.getSide1().getActors();
                object2 = p1;
                int $this$mapKeys$iv232 = 0;
                int n13 = $this$associateByTo$iv$iv$iv.length;
                for (int $i$f$mapKeys = 0; $i$f$mapKeys < n13; ++$i$f$mapKeys) {
                    int n14;
                    Object object11 = destination$iv$iv = $this$associateByTo$iv$iv$iv[$i$f$mapKeys];
                    n2 = $this$mapKeys$iv232;
                    boolean bl16 = false;
                    Iterable $this$count$iv = ((BattleActor)object11).getPokemonList();
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n14 = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv) {
                            pokemon = (BattlePokemon)element$iv;
                            boolean bl17 = false;
                            if (!(pokemon.getHealth() != 0) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n14 = count$iv;
                    }
                    n = n14;
                    $this$mapKeys$iv232 = n2 + n;
                }
                n2 = $this$mapKeys$iv232;
                ((ActiveTracker.TrackerActor)object2).setNRemainingMons(n2);
                Iterable $this$mapKeys$iv232 = p1.getParty();
                for (Object t : $this$mapKeys$iv232) {
                    it = (ActiveTracker.TrackerPokemon)t;
                    boolean bl4 = false;
                    Pokemon pokemon5 = ((ActiveTracker.TrackerPokemon)it).getPokemon();
                    Pokemon pokemon6 = p1.getActivePokemon().getPokemon();
                    if (!Intrinsics.areEqual((Object)(pokemon5 != null ? pokemon5.getUuid() : null), (Object)(pokemon6 != null ? pokemon6.getUuid() : null))) continue;
                    v35 = t;
                    break block78;
                }
                v35 = null;
            }
            if (v35 == null) {
                v36 = p1.getParty().add(p1.getActivePokemon());
            } else {
                int n15;
                block79: {
                    List<ActiveTracker.TrackerPokemon> $this$indexOfFirst$iv232 = p1.getParty();
                    boolean $i$f$indexOfFirst = false;
                    boolean bl5 = false;
                    it = $this$indexOfFirst$iv232.iterator();
                    while (it.hasNext()) {
                        void var33_125;
                        Object e = it.next();
                        ActiveTracker.TrackerPokemon it13 = (ActiveTracker.TrackerPokemon)e;
                        boolean bl19 = false;
                        Pokemon pokemon7 = it13.getPokemon();
                        Pokemon pokemon8 = p1.getActivePokemon().getPokemon();
                        if (Intrinsics.areEqual((Object)(pokemon7 != null ? pokemon7.getUuid() : null), (Object)(pokemon8 != null ? pokemon8.getUuid() : null))) {
                            n15 = var33_125;
                            break block79;
                        }
                        ++var33_125;
                    }
                    n15 = -1;
                }
                int partyPokemonIndex = n15;
                p1.getParty().set(partyPokemonIndex, p1.getActivePokemon());
                v36 = Unit.INSTANCE;
            }
            Pokemon pokemon9 = pokemon2;
            p2.setActivePokemon(this.getActiveTrackerPokemon(p2, pokemon9 != null ? pokemon9.getUuid() : null));
            p2.getActivePokemon().setPokemon(pokemon2);
            ActiveTracker.TrackerPokemon trackerPokemon = p2.getActivePokemon();
            Pokemon pokemon10 = pokemon2;
            Intrinsics.checkNotNull((Object)pokemon10);
            trackerPokemon.setSpecies(pokemon10.getSpecies().getName());
            p2.getActivePokemon().setCurrentHp(pokemon2.getCurrentHealth());
            p2.getActivePokemon().setCurrentHpPercent((double)pokemon2.getCurrentHealth() / (double)pokemon2.getHp());
            p2.getActivePokemon().setBoosts(p2BoostsMap);
            p2.getActivePokemon().getBoosts().put(Stats.ATTACK, p2.getActivePokemon().getAtkBoost());
            p2.getActivePokemon().getBoosts().put(Stats.DEFENCE, p2.getActivePokemon().getDefBoost());
            p2.getActivePokemon().getBoosts().put(Stats.SPECIAL_ATTACK, p2.getActivePokemon().getSpaBoost());
            p2.getActivePokemon().getBoosts().put(Stats.SPECIAL_DEFENCE, p2.getActivePokemon().getSpdBoost());
            p2.getActivePokemon().getBoosts().put(Stats.SPEED, p2.getActivePokemon().getSpeBoost());
            p2.getActivePokemon().setCurrentTypes((object = npcActor.getRequest()) != null && (object = ((ShowdownActionRequest)object).getSide()) != null && (object = ((ShowdownSide)object).getPokemon()) != null && (object = object.get(0)) != null ? ((ShowdownPokemon)object).getTypes() : null);
            p2.getActivePokemon().setMoves(pokemon2.getMoveSet().getMoves());
            BattleActor[] partyPokemonIndex = battle.getSide2().getActors();
            object2 = p2;
            int $this$indexOfFirst$iv232 = 0;
            int n16 = partyPokemonIndex.length;
            for (int $i$f$indexOfFirst = 0; $i$f$indexOfFirst < n16; ++$i$f$indexOfFirst) {
                int n17;
                Object object12 = it = partyPokemonIndex[$i$f$indexOfFirst];
                n2 = $this$indexOfFirst$iv232;
                boolean bl20 = false;
                Iterable $this$count$iv = ((BattleActor)object12).getPokemonList();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n17 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        pokemon = (BattlePokemon)element$iv;
                        boolean bl21 = false;
                        if (!(pokemon.getHealth() != 0) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n17 = count$iv;
                }
                n = n17;
                $this$indexOfFirst$iv232 = n2 + n;
            }
            n2 = $this$indexOfFirst$iv232;
            ((ActiveTracker.TrackerActor)object2).setNRemainingMons(n2);
            Iterable $this$indexOfFirst$iv232 = p2.getParty();
            for (Object t : $this$indexOfFirst$iv232) {
                it = (ActiveTracker.TrackerPokemon)t;
                boolean bl6 = false;
                Pokemon pokemon11 = ((ActiveTracker.TrackerPokemon)it).getPokemon();
                Pokemon pokemon12 = p2.getActivePokemon().getPokemon();
                if (!Intrinsics.areEqual((Object)(pokemon11 != null ? pokemon11.getUuid() : null), (Object)(pokemon12 != null ? pokemon12.getUuid() : null))) continue;
                v47 = t;
                break block80;
            }
            v47 = null;
        }
        if (v47 == null) {
            v48 = p2.getParty().add(p2.getActivePokemon());
        } else {
            int n;
            block81: {
                List<ActiveTracker.TrackerPokemon> $this$indexOfFirst$iv = p2.getParty();
                boolean $i$f$indexOfFirst = false;
                boolean bl7 = false;
                for (Object e : $this$indexOfFirst$iv) {
                    void var33_129;
                    ActiveTracker.TrackerPokemon it = (ActiveTracker.TrackerPokemon)e;
                    boolean bl23 = false;
                    Pokemon pokemon = it.getPokemon();
                    Pokemon pokemon13 = p2.getActivePokemon().getPokemon();
                    if (Intrinsics.areEqual((Object)(pokemon != null ? pokemon.getUuid() : null), (Object)(pokemon13 != null ? pokemon13.getUuid() : null))) {
                        n = var33_129;
                        break block81;
                    }
                    ++var33_129;
                }
                n = -1;
            }
            int partyPokemonIndex = n;
            p2.getParty().set(partyPokemonIndex, p2.getActivePokemon());
            v48 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final MoveActionResponse chooseMove(InBattleMove move, ActiveBattlePokemon activeBattlePokemon) {
        void $this$filterTo$iv$iv;
        List target;
        List list = target = move.mustBeUsed() ? null : (List)move.getTarget().getTargetList().invoke((Object)activeBattlePokemon);
        if (target == null) {
            return new MoveActionResponse(move.getId(), null, null, 6, null);
        }
        Iterable $this$filter$iv = target;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Targetable it = (Targetable)element$iv$iv;
            boolean bl2 = false;
            if (!(!it.isAllied(activeBattlePokemon))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Targetable targetable = (Targetable)CollectionsKt.randomOrNull((Collection)((List)destination$iv$iv), (Random)((Random)Random.Default));
        if (targetable == null) {
            targetable = (Targetable)CollectionsKt.random((Collection)target, (Random)((Random)Random.Default));
        }
        Targetable chosenTarget = targetable;
        String string = move.getId();
        Intrinsics.checkNotNull((Object)chosenTarget, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.battles.ActiveBattlePokemon");
        return new MoveActionResponse(string, ((ActiveBattlePokemon)chosenTarget).getPNX(), null, 4, null);
    }

    private final ActiveTracker.TrackerPokemon getActiveTrackerPokemon(ActiveTracker.TrackerActor actor, UUID pokemonUUID) {
        Object v1;
        block2: {
            Iterable iterable = actor.getParty();
            for (Object t : iterable) {
                ActiveTracker.TrackerPokemon it = (ActiveTracker.TrackerPokemon)t;
                boolean bl2 = false;
                Pokemon pokemon = it.getPokemon();
                Intrinsics.checkNotNull((Object)pokemon);
                if (!Intrinsics.areEqual((Object)pokemon.getUuid(), (Object)pokemonUUID)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        ActiveTracker.TrackerPokemon trackerPokemon = v1;
        if (trackerPokemon != null) {
            return trackerPokemon;
        }
        return new ActiveTracker.TrackerPokemon(null, null, null, 0, 0.0, null, 0, 0, 0, 0, 0, null, null, null, null, null, 0, 0, 262143, null);
    }

    private final Pair<Pokemon, Pokemon> getCurrentPlayer(PokemonBattle battle) {
        Object object = (ActiveBattlePokemon)CollectionsKt.firstOrNull(battle.getSide1().getActivePokemon());
        Pokemon mon = object != null && (object = ((ActiveBattlePokemon)object).getBattlePokemon()) != null ? ((BattlePokemon)object).getEffectedPokemon() : null;
        Object object2 = (ActiveBattlePokemon)CollectionsKt.firstOrNull(battle.getSide2().getActivePokemon());
        Pokemon opponent = object2 != null && (object2 = ((ActiveBattlePokemon)object2).getBattlePokemon()) != null ? ((BattlePokemon)object2).getEffectedPokemon() : null;
        Pokemon pokemon = mon;
        Intrinsics.checkNotNull((Object)pokemon);
        Pokemon pokemon2 = opponent;
        Intrinsics.checkNotNull((Object)pokemon2);
        return new Pair((Object)pokemon, (Object)pokemon2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean choose$hasMajorStatusImmunity(ActiveTracker.TrackerPokemon opponent, String currentWeather, ActiveTracker.TrackerPokemon target) {
        Object[] objectArray = new String[]{"comatose", "purifyingsalt"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        Pokemon pokemon = opponent.getPokemon();
        Intrinsics.checkNotNull((Object)pokemon);
        if (!list.contains(pokemon.getAbility().getName())) return false;
        if (!Intrinsics.areEqual((Object)currentWeather, (Object)"sunny")) return false;
        Pokemon pokemon2 = opponent.getPokemon();
        Intrinsics.checkNotNull((Object)pokemon2);
        if (!Intrinsics.areEqual((Object)pokemon2.getAbility().getName(), (Object)"leafguard")) return false;
        return true;
    }
}

