/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.interpreter.instructions;

import com.cobblemon.mod.common.api.battles.interpreter.BattleContext;
import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.EntityBackedBattleActor;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.dispatch.BattleDispatch;
import com.cobblemon.mod.common.battles.dispatch.DispatchResult;
import com.cobblemon.mod.common.battles.dispatch.InstructionSet;
import com.cobblemon.mod.common.battles.dispatch.InterpreterInstruction;
import com.cobblemon.mod.common.battles.interpreter.instructions.SwitchInstruction;
import com.cobblemon.mod.common.battles.interpreter.instructions.TransformInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0016\u001a\u0004\b\u0019\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/cobblemon/mod/common/battles/interpreter/instructions/DragInstruction;", "Lcom/cobblemon/mod/common/battles/dispatch/InterpreterInstruction;", "Lcom/cobblemon/mod/common/battles/dispatch/InstructionSet;", "instructionSet", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "battleActor", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "publicMessage", "privateMessage", "<init>", "(Lcom/cobblemon/mod/common/battles/dispatch/InstructionSet;Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;)V", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "", "invoke", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V", "Lcom/cobblemon/mod/common/battles/dispatch/InstructionSet;", "getInstructionSet", "()Lcom/cobblemon/mod/common/battles/dispatch/InstructionSet;", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "getBattleActor", "()Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "getPublicMessage", "()Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "getPrivateMessage", "common"})
@SourceDebugExtension(value={"SMAP\nDragInstruction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DragInstruction.kt\ncom/cobblemon/mod/common/battles/interpreter/instructions/DragInstruction\n+ 2 InstructionSet.kt\ncom/cobblemon/mod/common/battles/dispatch/InstructionSet\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 InstructionSet.kt\ncom/cobblemon/mod/common/battles/dispatch/InstructionSet$getNextInstruction$1\n*L\n1#1,64:1\n42#2,6:65\n808#3,11:71\n295#3:82\n296#3:84\n42#4:83\n*S KotlinDebug\n*F\n+ 1 DragInstruction.kt\ncom/cobblemon/mod/common/battles/interpreter/instructions/DragInstruction\n*L\n36#1:65,6\n36#1:71,11\n36#1:82\n36#1:84\n36#1:83\n*E\n"})
public final class DragInstruction
implements InterpreterInstruction {
    @NotNull
    private final InstructionSet instructionSet;
    @NotNull
    private final BattleActor battleActor;
    @NotNull
    private final BattleMessage publicMessage;
    @NotNull
    private final BattleMessage privateMessage;

    public DragInstruction(@NotNull InstructionSet instructionSet, @NotNull BattleActor battleActor, @NotNull BattleMessage publicMessage, @NotNull BattleMessage privateMessage) {
        Intrinsics.checkNotNullParameter((Object)instructionSet, (String)"instructionSet");
        Intrinsics.checkNotNullParameter((Object)battleActor, (String)"battleActor");
        Intrinsics.checkNotNullParameter((Object)publicMessage, (String)"publicMessage");
        Intrinsics.checkNotNullParameter((Object)privateMessage, (String)"privateMessage");
        this.instructionSet = instructionSet;
        this.battleActor = battleActor;
        this.publicMessage = publicMessage;
        this.privateMessage = privateMessage;
    }

    @NotNull
    public final InstructionSet getInstructionSet() {
        return this.instructionSet;
    }

    @NotNull
    public final BattleActor getBattleActor() {
        return this.battleActor;
    }

    @NotNull
    public final BattleMessage getPublicMessage() {
        return this.publicMessage;
    }

    @NotNull
    public final BattleMessage getPrivateMessage() {
        return this.privateMessage;
    }

    @Override
    public void invoke(@NotNull PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        battle.dispatchInsert((Function0<? extends Iterable<? extends BattleDispatch>>)((Function0)() -> DragInstruction.invoke$lambda$2(this, battle)));
    }

    private static final DispatchResult invoke$lambda$2$lambda$1(class_1309 $entity, PokemonBattle $battle, DragInstruction this$0, String $pnx, ActiveBattlePokemon $activePokemon, BattlePokemon $pokemon, BattlePokemon $illusion, boolean $imposter, PokemonBattle it) {
        Intrinsics.checkNotNullParameter((Object)$battle, (String)"$battle");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$pnx, (String)"$pnx");
        Intrinsics.checkNotNullParameter((Object)$activePokemon, (String)"$activePokemon");
        Intrinsics.checkNotNullParameter((Object)$pokemon, (String)"$pokemon");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $entity != null ? SwitchInstruction.Companion.createEntitySwitch($battle, this$0.battleActor, $entity, $pnx, $activePokemon, $pokemon, $illusion, $imposter) : SwitchInstruction.Companion.createNonEntitySwitch($battle, this$0.battleActor, $pnx, $activePokemon, $pokemon, $illusion);
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable invoke$lambda$2(DragInstruction this$0, PokemonBattle $battle) {
        Object v1;
        ActiveBattlePokemon activePokemon;
        String pnx;
        block6: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$battle, (String)"$battle");
            Pair<String, String> pair = this$0.publicMessage.pnxAndUuid(0);
            Intrinsics.checkNotNull(pair);
            pnx = (String)pair.component1();
            activePokemon = (ActiveBattlePokemon)$battle.getActorAndActiveSlotFromPNX(pnx).component2();
            InstructionSet $this$iv = this$0.instructionSet;
            boolean $i$f$getNextInstruction = false;
            int index$iv = $this$iv.getInstructions().indexOf(this$0);
            if (Intrinsics.areEqual((Object)CollectionsKt.last($this$iv.getInstructions()), (Object)this$0)) {
                v1 = null;
            } else {
                void $this$firstOrNull$iv$iv;
                Iterator $this$filterIsInstanceTo$iv$iv$iv;
                Iterable $this$filterIsInstance$iv$iv = $this$iv.getInstructions().subList(index$iv + 1, $this$iv.getInstructions().size());
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator iterator = $this$filterIsInstanceTo$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv$iv = iterator.next();
                    if (!(element$iv$iv$iv instanceof TransformInstruction)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                $this$filterIsInstance$iv$iv = (List)destination$iv$iv$iv;
                boolean $i$f$firstOrNull = false;
                $this$filterIsInstanceTo$iv$iv$iv = $this$firstOrNull$iv$iv.iterator();
                while ($this$filterIsInstanceTo$iv$iv$iv.hasNext()) {
                    Object element$iv$iv;
                    Object t = element$iv$iv = $this$filterIsInstanceTo$iv$iv$iv.next();
                    boolean bl2 = false;
                    Object it = t;
                    if (!true) continue;
                    v1 = element$iv$iv;
                    break block6;
                }
                v1 = null;
            }
        }
        TransformInstruction transformInstruction = v1;
        boolean imposter = (transformInstruction != null ? transformInstruction.getExpectedTarget() : null) != null;
        BattlePokemon illusion = this$0.publicMessage.battlePokemonFromOptional($battle, "is");
        BattlePokemon battlePokemon = this$0.publicMessage.battlePokemon(0, $battle);
        if (battlePokemon == null) {
            return SetsKt.emptySet();
        }
        BattlePokemon pokemon = battlePokemon;
        String string = this$0.privateMessage.argumentAt(2);
        Intrinsics.checkNotNull((Object)string);
        String[] $i$f$getNextInstruction = new String[]{" "};
        String newHealth = (String)StringsKt.split$default((CharSequence)string, (String[])$i$f$getNextInstruction, (boolean)false, (int)0, (int)6, null).get(0);
        String[] index$iv = new String[]{"/"};
        int remainingHealth = Integer.parseInt((String)StringsKt.split$default((CharSequence)newHealth, (String[])index$iv, (boolean)false, (int)0, (int)6, null).get(0));
        pokemon.getEffectedPokemon().setCurrentHealth(remainingHealth);
        Object[] objectArray = new Object[]{pokemon.getName()};
        class_5250 class_52502 = LocalizationUtilsKt.battleLang("dragged_out", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"battleLang(...)");
        $battle.broadcastChatMessage((class_2561)class_52502);
        BattlePokemon battlePokemon2 = activePokemon.getBattlePokemon();
        if (battlePokemon2 != null) {
            BattlePokemon oldPokemon = battlePokemon2;
            boolean bl3 = false;
            BattleContext.Type[] typeArray = new BattleContext.Type[]{BattleContext.Type.VOLATILE, BattleContext.Type.BOOST, BattleContext.Type.UNBOOST};
            oldPokemon.getContextManager().clear(typeArray);
            ((Map)$battle.getMajorBattleActions()).put(oldPokemon.getUuid(), this$0.publicMessage);
        }
        ((Map)$battle.getMajorBattleActions()).put(pokemon.getUuid(), this$0.publicMessage);
        class_1309 entity = this$0.battleActor instanceof EntityBackedBattleActor ? (class_1309)((EntityBackedBattleActor)((Object)this$0.battleActor)).getEntity() : null;
        return SetsKt.setOf(arg_0 -> DragInstruction.invoke$lambda$2$lambda$1(entity, $battle, this$0, pnx, activePokemon, pokemon, illusion, imposter, arg_0));
    }
}

