/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.interpreter.instructions;

import com.cobblemon.mod.common.api.battles.interpreter.BattleContext;
import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.EntityBackedBattleActor;
import com.cobblemon.mod.common.api.entity.PokemonSender;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleFaintedEvent;
import com.cobblemon.mod.common.api.scheduling.SchedulingFunctionsKt;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.ShowdownInterpreter;
import com.cobblemon.mod.common.battles.dispatch.InterpreterInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.battle.BattleFaintPacket;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\rR\"\u0010\u000f\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0016\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/cobblemon/mod/common/battles/interpreter/instructions/FaintInstruction;", "Lcom/cobblemon/mod/common/battles/dispatch/InterpreterInstruction;", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "message", "<init>", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;)V", "", "invoke", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "getMessage", "()Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "", "waitTime", "F", "getWaitTime", "()F", "setWaitTime", "(F)V", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "faintingPokemon", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "getFaintingPokemon", "()Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "common"})
@SourceDebugExtension(value={"SMAP\nFaintInstruction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FaintInstruction.kt\ncom/cobblemon/mod/common/battles/interpreter/instructions/FaintInstruction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class FaintInstruction
implements InterpreterInstruction {
    @NotNull
    private final BattleMessage message;
    private float waitTime;
    @NotNull
    private final BattlePokemon faintingPokemon;

    public FaintInstruction(@NotNull PokemonBattle battle, @NotNull BattleMessage message) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.message = message;
        this.waitTime = 2.5f;
        BattlePokemon battlePokemon = this.message.battlePokemon(0, battle);
        Intrinsics.checkNotNull((Object)battlePokemon);
        this.faintingPokemon = battlePokemon;
    }

    @NotNull
    public final BattleMessage getMessage() {
        return this.message;
    }

    public final float getWaitTime() {
        return this.waitTime;
    }

    public final void setWaitTime(float f) {
        this.waitTime = f;
    }

    @NotNull
    public final BattlePokemon getFaintingPokemon() {
        return this.faintingPokemon;
    }

    @Override
    public void invoke(@NotNull PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        battle.dispatchFuture(() -> FaintInstruction.invoke$lambda$2(this, battle));
        battle.dispatchWaiting(0.5f, (Function0<Unit>)((Function0)() -> FaintInstruction.invoke$lambda$3(this, battle)));
    }

    private static final void invoke$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final CompletableFuture invoke$lambda$2(FaintInstruction this$0, PokemonBattle $battle) {
        CompletableFuture<Unit> completableFuture;
        CompletableFuture<Object> completableFuture2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$battle, (String)"$battle");
        Pair<String, String> pair = this$0.message.pnxAndUuid(0);
        if (pair == null) {
            CompletableFuture<Unit> completableFuture3 = CompletableFuture.completedFuture(Unit.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(completableFuture3, (String)"completedFuture(...)");
            return completableFuture3;
        }
        String pnx = (String)pair.component1();
        BattlePokemon battlePokemon = this$0.message.battlePokemon(0, $battle);
        if (battlePokemon == null) {
            CompletableFuture<Unit> completableFuture4 = CompletableFuture.completedFuture(Unit.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(completableFuture4, (String)"completedFuture(...)");
            return completableFuture4;
        }
        BattlePokemon pokemon = battlePokemon;
        $battle.sendUpdate(new BattleFaintPacket(pnx));
        BattleActor actor = pokemon.getActor();
        pokemon.getEffectedPokemon().setCurrentHealth(0);
        if (actor instanceof EntityBackedBattleActor) {
            Object t = ((EntityBackedBattleActor)((Object)actor)).getEntity();
            PokemonSender pokemonSender = t instanceof PokemonSender ? (PokemonSender)t : null;
            if (pokemonSender != null) {
                PokemonSender sender = pokemonSender;
                boolean bl2 = false;
                PokemonEntity pokemonEntity = pokemon.getEntity();
                completableFuture2 = pokemonEntity != null ? pokemonEntity.recallWithAnimation() : null;
            } else {
                completableFuture2 = null;
            }
        } else {
            completableFuture2 = completableFuture = null;
        }
        if (completableFuture2 == null) {
            completableFuture = SchedulingFunctionsKt.delayedFuture(this$0.waitTime);
        }
        CompletableFuture<Unit> preamble = completableFuture;
        BattleContext context = ShowdownInterpreter.INSTANCE.getContextFromFaint(this$0.faintingPokemon, $battle);
        CompletionStage completionStage = preamble.thenAccept(arg_0 -> FaintInstruction.invoke$lambda$2$lambda$1(new Function1(this$0, $battle, pokemon, context, pnx){
            final /* synthetic */ FaintInstruction this$0;
            final /* synthetic */ PokemonBattle $battle;
            final /* synthetic */ BattlePokemon $pokemon;
            final /* synthetic */ BattleContext $context;
            final /* synthetic */ String $pnx;
            {
                this.this$0 = $receiver;
                this.$battle = $battle;
                this.$pokemon = $pokemon;
                this.$context = $context;
                this.$pnx = $pnx;
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(Object it) {
                void events$iv;
                void $this$iv;
                this.this$0.getFaintingPokemon().getEffectedPokemon().setCurrentHealth(0);
                this.this$0.getFaintingPokemon().sendUpdate();
                Object[] objectArray = CobblemonEvents.BATTLE_FAINTED;
                BattleFaintedEvent[] battleFaintedEventArray = new BattleFaintedEvent[]{new BattleFaintedEvent(this.$battle, this.$pokemon, this.$context)};
                boolean $i$f$post = false;
                $this$iv.emit(Arrays.copyOf(events$iv, ((void)events$iv).length));
                void $this$forEach$iv$iv = events$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void var10_10 = element$iv$iv = $this$forEach$iv$iv[i];
                    boolean bl2 = false;
                    void it2 = var10_10;
                }
                ((ActiveBattlePokemon)this.$battle.getActorAndActiveSlotFromPNX(this.$pnx).getSecond()).setBattlePokemon(null);
                objectArray = new BattleContext[]{this.$context};
                this.this$0.getFaintingPokemon().getContextManager().add((BattleContext[])objectArray);
                objectArray = new BattleContext.Type[]{BattleContext.Type.STATUS, BattleContext.Type.VOLATILE, BattleContext.Type.BOOST, BattleContext.Type.UNBOOST};
                this.this$0.getFaintingPokemon().getContextManager().clear((BattleContext.Type[])objectArray);
                ((Map)this.$battle.getMajorBattleActions()).put(this.this$0.getFaintingPokemon().getUuid(), this.this$0.getMessage());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenAccept(...)");
        return completionStage;
    }

    private static final Unit invoke$lambda$3(FaintInstruction this$0, PokemonBattle $battle) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$battle, (String)"$battle");
        Object[] objectArray = new Object[]{this$0.faintingPokemon.getName()};
        class_5250 class_52502 = LocalizationUtilsKt.battleLang("fainted", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"battleLang(...)");
        class_5250 faintMessage = TextKt.red(class_52502);
        $battle.broadcastChatMessage((class_2561)faintMessage);
        return Unit.INSTANCE;
    }
}

