/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.interpreter.instructions;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.interpreter.BattleContext;
import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.interpreter.Effect;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.pokemon.status.Status;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.ShowdownInterpreter;
import com.cobblemon.mod.common.battles.dispatch.InterpreterInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.net.messages.client.battle.BattlePersistentStatusPacket;
import com.cobblemon.mod.common.pokemon.status.PersistentStatus;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/battles/interpreter/instructions/StatusInstruction;", "Lcom/cobblemon/mod/common/battles/dispatch/InterpreterInstruction;", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "message", "<init>", "(Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;)V", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "", "invoke", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "getMessage", "()Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "common"})
public final class StatusInstruction
implements InterpreterInstruction {
    @NotNull
    private final BattleMessage message;

    public StatusInstruction(@NotNull BattleMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.message = message;
    }

    @NotNull
    public final BattleMessage getMessage() {
        return this.message;
    }

    @Override
    public void invoke(@NotNull PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        Pair<String, String> pair = this.message.pnxAndUuid(0);
        if (pair == null) {
            return;
        }
        String pnx = (String)pair.component1();
        BattlePokemon battlePokemon = this.message.battlePokemon(0, battle);
        if (battlePokemon == null) {
            return;
        }
        BattlePokemon pokemon = battlePokemon;
        Object object = this.message.actorAndActivePokemonFromOptional(battle, "of");
        BattlePokemon otherPokemon = object != null && (object = (ActiveBattlePokemon)object.getSecond()) != null ? ((ActiveBattlePokemon)object).getBattlePokemon() : null;
        String string = this.message.argumentAt(1);
        if (string == null) {
            return;
        }
        String statusLabel = string;
        Status status = Statuses.INSTANCE.getStatus(statusLabel);
        if (status == null) {
            Cobblemon.LOGGER.error("Unrecognized status: " + statusLabel);
            return;
        }
        Status status2 = status;
        Effect effect = BattleMessage.effect$default(this.message, null, 1, null);
        BattlePokemon battlePokemon2 = otherPokemon;
        if (battlePokemon2 == null) {
            battlePokemon2 = pokemon;
        }
        ShowdownInterpreter.INSTANCE.broadcastOptionalAbility(battle, effect, battlePokemon2);
        PokemonBattle.dispatchWaiting$default(battle, 0.0f, () -> StatusInstruction.invoke$lambda$0(status2, pokemon, battle, pnx, this), 1, null);
    }

    private static final Unit invoke$lambda$0(Status $status, BattlePokemon $pokemon, PokemonBattle $battle, String $pnx, StatusInstruction this$0) {
        Intrinsics.checkNotNullParameter((Object)$status, (String)"$status");
        Intrinsics.checkNotNullParameter((Object)$pokemon, (String)"$pokemon");
        Intrinsics.checkNotNullParameter((Object)$battle, (String)"$battle");
        Intrinsics.checkNotNullParameter((Object)$pnx, (String)"$pnx");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($status instanceof PersistentStatus) {
            $pokemon.getEffectedPokemon().applyStatus((PersistentStatus)$status);
            $battle.sendUpdate(new BattlePersistentStatusPacket($pnx, (PersistentStatus)$status));
            $pokemon.sendUpdate();
        }
        Object[] objectArray = new Object[]{$pokemon.getName()};
        class_5250 class_52502 = MiscUtilsKt.asTranslated($status.getApplyMessage(), objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"asTranslated(...)");
        $battle.broadcastChatMessage((class_2561)class_52502);
        BattleContext[] battleContextArray = new BattleContext[]{ShowdownInterpreter.INSTANCE.getContextFromAction(this$0.message, BattleContext.Type.STATUS, $battle)};
        $pokemon.getContextManager().add(battleContextArray);
        ((Map)$battle.getMinorBattleActions()).put($pokemon.getUuid(), this$0.message);
        return Unit.INSTANCE;
    }
}

