/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render;

import com.cobblemon.mod.common.api.molang.ExpressionLike;
import com.cobblemon.mod.common.client.render.ModelAssetVariation;
import com.cobblemon.mod.common.client.render.ModelLayer;
import com.cobblemon.mod.common.client.render.ModelTextureSupplier;
import com.cobblemon.mod.common.client.render.SpriteType;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.client.render.models.blockbench.pose.Bone;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.VaryingModelRepository;
import com.cobblemon.mod.common.util.adapters.ExpressionLikeAdapter;
import com.cobblemon.mod.common.util.adapters.IdentifierAdapter;
import com.cobblemon.mod.common.util.adapters.ModelTextureSupplierAdapter;
import com.cobblemon.mod.common.util.adapters.SpriteTypeAdapter;
import com.cobblemon.mod.common.util.adapters.Vector3fAdapter;
import com.cobblemon.mod.common.util.adapters.Vector4fAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector4f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 =*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003:\u0001=B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u001f\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J:\u0010\u0018\u001a\u0004\u0018\u00018\u0001\"\u0004\b\u0001\u0010\u00022\u0006\u0010\f\u001a\u00020\u000b2\u0019\u0010\u0017\u001a\u0015\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0015\u00a2\u0006\u0002\b\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001b\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e\u00a2\u0006\u0004\b\u001f\u0010 J\u001b\u0010$\u001a\u00020#2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000!\u00a2\u0006\u0004\b$\u0010%J\u0015\u0010&\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b&\u0010'J\u0015\u0010(\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b(\u0010\u000eJ\u001b\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b)\u0010\u001dR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010*\u001a\u0004\b+\u0010,R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010-\u001a\u0004\b.\u0010/R(\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000!8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\"\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u0010%R/\u00106\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000405\u0012\u0004\u0012\u00028\u0000048\u0006\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R#\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020:048\u0006\u00a2\u0006\f\n\u0004\b;\u00107\u001a\u0004\b<\u00109\u00a8\u0006>"}, d2={"Lcom/cobblemon/mod/common/client/render/VaryingRenderableResolver;", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableModel;", "T", "", "Lnet/minecraft/class_2960;", "name", "", "Lcom/cobblemon/mod/common/client/render/ModelAssetVariation;", "variations", "<init>", "(Lnet/minecraft/class_2960;Ljava/util/List;)V", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;", "state", "getResolvedPoser", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;)Lnet/minecraft/class_2960;", "getResolvedModel", "getResolvedTexture", "Lcom/cobblemon/mod/common/client/render/SpriteType;", "type", "getSprite", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;Lcom/cobblemon/mod/common/client/render/SpriteType;)Lnet/minecraft/class_2960;", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "selector", "getVariationValue", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "", "Lcom/cobblemon/mod/common/client/render/ModelLayer;", "getResolvedLayers", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;)Ljava/lang/Iterable;", "", "getAllModels", "()Ljava/util/Set;", "Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/VaryingModelRepository;", "repository", "", "initialize", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/VaryingModelRepository;)V", "getPoser", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;)Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableModel;", "getTexture", "getLayers", "Lnet/minecraft/class_2960;", "getName", "()Lnet/minecraft/class_2960;", "Ljava/util/List;", "getVariations", "()Ljava/util/List;", "Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/VaryingModelRepository;", "getRepository", "()Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/VaryingModelRepository;", "setRepository", "", "Lkotlin/Pair;", "posers", "Ljava/util/Map;", "getPosers", "()Ljava/util/Map;", "Lcom/cobblemon/mod/common/client/render/models/blockbench/pose/Bone;", "models", "getModels", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nVaryingRenderableResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VaryingRenderableResolver.kt\ncom/cobblemon/mod/common/client/render/VaryingRenderableResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n543#2,6:230\n774#2:236\n865#2,2:237\n1863#2,2:239\n*S KotlinDebug\n*F\n+ 1 VaryingRenderableResolver.kt\ncom/cobblemon/mod/common/client/render/VaryingRenderableResolver\n*L\n61#1:230,6\n74#1:236\n74#1:237,2\n104#1:239,2\n*E\n"})
public final class VaryingRenderableResolver<T extends PosableModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_2960 name;
    @NotNull
    private final List<ModelAssetVariation> variations;
    public VaryingModelRepository<T> repository;
    @NotNull
    private final Map<Pair<class_2960, class_2960>, T> posers;
    @NotNull
    private final Map<class_2960, Bone> models;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter((Type)((Object)class_2960.class), (Object)IdentifierAdapter.INSTANCE).registerTypeAdapter((Type)((Object)Vector3f.class), (Object)Vector3fAdapter.INSTANCE).registerTypeAdapter((Type)((Object)Vector4f.class), (Object)Vector4fAdapter.INSTANCE).registerTypeAdapter((Type)((Object)ModelTextureSupplier.class), (Object)ModelTextureSupplierAdapter.INSTANCE).registerTypeAdapter((Type)((Object)ExpressionLike.class), (Object)ExpressionLikeAdapter.INSTANCE).registerTypeAdapter((Type)((Object)SpriteType.class), (Object)SpriteTypeAdapter.INSTANCE).disableHtmlEscaping().setLenient().create();

    public VaryingRenderableResolver(@NotNull class_2960 name, @NotNull List<ModelAssetVariation> variations) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(variations, (String)"variations");
        this.name = name;
        this.variations = variations;
        this.posers = new LinkedHashMap();
        this.models = new LinkedHashMap();
    }

    @NotNull
    public final class_2960 getName() {
        return this.name;
    }

    @NotNull
    public final List<ModelAssetVariation> getVariations() {
        return this.variations;
    }

    @NotNull
    public final VaryingModelRepository<T> getRepository() {
        VaryingModelRepository<T> varyingModelRepository = this.repository;
        if (varyingModelRepository != null) {
            return varyingModelRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        return null;
    }

    public final void setRepository(@NotNull VaryingModelRepository<T> varyingModelRepository) {
        Intrinsics.checkNotNullParameter(varyingModelRepository, (String)"<set-?>");
        this.repository = varyingModelRepository;
    }

    @NotNull
    public final Map<Pair<class_2960, class_2960>, T> getPosers() {
        return this.posers;
    }

    @NotNull
    public final Map<class_2960, Bone> getModels() {
        return this.models;
    }

    @NotNull
    public final class_2960 getResolvedPoser(@NotNull PosableState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        class_2960 class_29602 = (class_2960)this.getVariationValue(state, VaryingRenderableResolver::getResolvedPoser$lambda$0);
        if (class_29602 == null) {
            throw new IllegalStateException("Unable to find a poser for " + this.name + " with aspects " + CollectionsKt.joinToString$default((Iterable)state.getCurrentAspects(), null, null, null, (int)0, null, null, (int)63, null) + ". This shouldn't be possible if you've defined the fallback variation.");
        }
        return class_29602;
    }

    @NotNull
    public final class_2960 getResolvedModel(@NotNull PosableState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        class_2960 class_29602 = (class_2960)this.getVariationValue(state, VaryingRenderableResolver::getResolvedModel$lambda$1);
        if (class_29602 == null) {
            throw new IllegalStateException("Unable to find a model for " + this.name + " with aspects " + CollectionsKt.joinToString$default((Iterable)state.getCurrentAspects(), null, null, null, (int)0, null, null, (int)63, null) + ". This shouldn't be possible if you've defined the fallback variation.");
        }
        return class_29602;
    }

    @NotNull
    public final class_2960 getResolvedTexture(@NotNull PosableState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ModelTextureSupplier modelTextureSupplier = (ModelTextureSupplier)this.getVariationValue(state, VaryingRenderableResolver::getResolvedTexture$lambda$2);
        if (modelTextureSupplier == null || (modelTextureSupplier = modelTextureSupplier.invoke(state)) == null) {
            throw new IllegalStateException("Unable to find a texture for " + this.name + " with aspects " + CollectionsKt.joinToString$default((Iterable)state.getCurrentAspects(), null, null, null, (int)0, null, null, (int)63, null) + ". This shouldn't be possible if you've defined the fallback variation.");
        }
        return modelTextureSupplier;
    }

    @Nullable
    public final class_2960 getSprite(@NotNull PosableState state, @NotNull SpriteType type) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Map map = (Map)this.getVariationValue(state, VaryingRenderableResolver::getSprite$lambda$3);
        return map != null ? (class_2960)map.get((Object)type) : null;
    }

    private final <T> T getVariationValue(PosableState state, Function1<? super ModelAssetVariation, ? extends T> selector) {
        ModelAssetVariation modelAssetVariation;
        block1: {
            List<ModelAssetVariation> $this$lastOrNull$iv = this.variations;
            boolean $i$f$lastOrNull = false;
            ListIterator<ModelAssetVariation> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                ModelAssetVariation element$iv;
                ModelAssetVariation it = element$iv = iterator$iv.previous();
                boolean bl2 = false;
                if (!(it.fits(state) && selector.invoke((Object)it) != null)) continue;
                modelAssetVariation = element$iv;
                break block1;
            }
            modelAssetVariation = null;
        }
        ModelAssetVariation modelAssetVariation2 = modelAssetVariation;
        return (T)(modelAssetVariation2 != null ? selector.invoke((Object)modelAssetVariation2) : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<ModelLayer> getResolvedLayers(@NotNull PosableState state) {
        void $this$filterTo$iv$iv;
        Iterable<ModelLayer> layers;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Map layerMaps = new LinkedHashMap();
        for (ModelAssetVariation variation : this.variations) {
            layers = variation.getLayers();
            if (layers == null || !variation.fits(state)) continue;
            for (ModelLayer layer : layers) {
                layerMaps.put(layer.getName(), layer);
            }
        }
        Iterable $this$filter$iv = layerMaps.values();
        boolean $i$f$filter = false;
        layers = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModelLayer p0 = (ModelLayer)element$iv$iv;
            boolean bl2 = false;
            if (!p0.getEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Set<class_2960> getAllModels() {
        Set models = new LinkedHashSet();
        for (ModelAssetVariation variation : this.variations) {
            if (variation.getModel() == null) continue;
            models.add(variation.getModel());
        }
        return models;
    }

    public final void initialize(@NotNull VaryingModelRepository<T> repository) {
        Intrinsics.checkNotNullParameter(repository, (String)"repository");
        this.setRepository(repository);
        this.posers.clear();
        Iterable $this$forEach$iv = this.getAllModels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_2960 identifier2 = (class_2960)element$iv;
            boolean bl2 = false;
            try {
                Function1<Boolean, Bone> function1 = repository.getTexturedModels().get(identifier2);
                Intrinsics.checkNotNull(function1);
                this.models.put(identifier2, (Bone)function1.invoke((Object)repository.isForLivingEntityRenderer()));
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load model " + identifier2 + " for " + this.name, e);
            }
        }
    }

    @NotNull
    public final T getPoser(@NotNull PosableState state) {
        PosableModel posableModel;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        class_2960 poserName = this.getResolvedPoser(state);
        Function1<Bone, T> function1 = this.getRepository().getPosers().get(poserName);
        if (function1 == null) {
            throw new IllegalStateException("No poser found for name: " + poserName + " for " + this.name);
        }
        Function1<Bone, T> poserSupplier = function1;
        class_2960 modelName = this.getResolvedModel(state);
        PosableModel existingEntityModel = (PosableModel)this.posers.get(TuplesKt.to((Object)poserName, (Object)modelName));
        if (existingEntityModel != null) {
            posableModel = existingEntityModel;
        } else {
            Bone bone = this.models.get(modelName);
            Intrinsics.checkNotNull((Object)bone);
            Bone model = bone;
            PosableModel entityModel = (PosableModel)poserSupplier.invoke((Object)model);
            entityModel.initializeLocatorAccess();
            entityModel.registerPoses();
            this.posers.put((Pair<class_2960, class_2960>)TuplesKt.to((Object)poserName, (Object)modelName), entityModel);
            posableModel = entityModel;
        }
        return (T)posableModel;
    }

    @NotNull
    public final class_2960 getTexture(@NotNull PosableState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.getRepository().getPosers().get(this.getResolvedPoser(state)) == null) {
            throw new IllegalStateException("No poser for " + this.name);
        }
        return this.getResolvedTexture(state);
    }

    @NotNull
    public final Iterable<ModelLayer> getLayers(@NotNull PosableState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.getRepository().getPosers().get(this.getResolvedPoser(state)) == null) {
            throw new IllegalStateException("No poser for " + this.name);
        }
        return this.getResolvedLayers(state);
    }

    private static final class_2960 getResolvedPoser$lambda$0(ModelAssetVariation $this$getVariationValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getVariationValue, (String)"$this$getVariationValue");
        return $this$getVariationValue.getPoser();
    }

    private static final class_2960 getResolvedModel$lambda$1(ModelAssetVariation $this$getVariationValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getVariationValue, (String)"$this$getVariationValue");
        return $this$getVariationValue.getModel();
    }

    private static final ModelTextureSupplier getResolvedTexture$lambda$2(ModelAssetVariation $this$getVariationValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getVariationValue, (String)"$this$getVariationValue");
        return $this$getVariationValue.getTexture();
    }

    private static final Map getSprite$lambda$3(ModelAssetVariation $this$getVariationValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getVariationValue, (String)"$this$getVariationValue");
        return $this$getVariationValue.getSprites();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/client/render/VaryingRenderableResolver$Companion;", "", "<init>", "()V", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "common"})
    public static final class Companion {
        private Companion() {
        }

        public final Gson getGSON() {
            return GSON;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

