/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.models.blockbench.animation;

import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.client.render.models.blockbench.animation.ActiveAnimation;
import com.cobblemon.mod.common.client.render.models.blockbench.animation.PoseAnimation;
import com.cobblemon.mod.common.client.render.models.blockbench.pose.Pose;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.RenderContext;
import com.cobblemon.mod.common.client.render.models.blockbench.wavefunction.WaveFunctionKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1297;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b!\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0018\b\u0002\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011JW\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001f\u001a\u0004\b \u0010!R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001f\u001a\u0004\b\"\u0010!R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010#\u001a\u0004\b$\u0010%R'\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010&\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020\u001c8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b)\u0010+R\u001a\u0010,\u001a\u00020\u001c8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b,\u0010*\u001a\u0004\b-\u0010+R\u001a\u0010.\u001a\u00020\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R\"\u00102\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u0010*\u001a\u0004\b3\u0010+\"\u0004\b4\u00105R\"\u00106\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b6\u0010/\u001a\u0004\b7\u00101\"\u0004\b8\u00109R\"\u0010:\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010/\u001a\u0004\b;\u00101\"\u0004\b<\u00109\u00a8\u0006="}, d2={"Lcom/cobblemon/mod/common/client/render/models/blockbench/animation/PoseTransitionAnimation;", "Lcom/cobblemon/mod/common/client/render/models/blockbench/animation/ActiveAnimation;", "Lcom/cobblemon/mod/common/client/render/models/blockbench/pose/Pose;", "beforePose", "afterPose", "", "durationTicks", "Lkotlin/Function1;", "", "Lcom/cobblemon/mod/common/client/render/models/blockbench/wavefunction/WaveFunction;", "curve", "<init>", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/pose/Pose;Lcom/cobblemon/mod/common/client/render/models/blockbench/pose/Pose;ILkotlin/jvm/functions/Function1;)V", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;", "state", "", "initialize", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;)V", "Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/RenderContext;", "context", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableModel;", "model", "limbSwing", "limbSwingAmount", "ageInTicks", "headYaw", "headPitch", "intensity", "", "run", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/RenderContext;Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableModel;Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;FFFFFF)Z", "Lcom/cobblemon/mod/common/client/render/models/blockbench/pose/Pose;", "getBeforePose", "()Lcom/cobblemon/mod/common/client/render/models/blockbench/pose/Pose;", "getAfterPose", "I", "getDurationTicks", "()I", "Lkotlin/jvm/functions/Function1;", "getCurve", "()Lkotlin/jvm/functions/Function1;", "isTransition", "Z", "()Z", "enduresPrimaryAnimations", "getEnduresPrimaryAnimations", "duration", "F", "getDuration", "()F", "initialized", "getInitialized", "setInitialized", "(Z)V", "startTime", "getStartTime", "setStartTime", "(F)V", "endTime", "getEndTime", "setEndTime", "common"})
@SourceDebugExtension(value={"SMAP\nPoseTransitionAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoseTransitionAnimation.kt\ncom/cobblemon/mod/common/client/render/models/blockbench/animation/PoseTransitionAnimation\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,82:1\n13346#2,2:83\n13346#2,2:85\n*S KotlinDebug\n*F\n+ 1 PoseTransitionAnimation.kt\ncom/cobblemon/mod/common/client/render/models/blockbench/animation/PoseTransitionAnimation\n*L\n71#1:83,2\n76#1:85,2\n*E\n"})
public final class PoseTransitionAnimation
implements ActiveAnimation {
    @NotNull
    private final Pose beforePose;
    @NotNull
    private final Pose afterPose;
    private final int durationTicks;
    @NotNull
    private final Function1<Float, Float> curve;
    private final boolean isTransition;
    private final boolean enduresPrimaryAnimations;
    private final float duration;
    private boolean initialized;
    private float startTime;
    private float endTime;

    public PoseTransitionAnimation(@NotNull Pose beforePose, @NotNull Pose afterPose, int durationTicks, @NotNull Function1<? super Float, Float> curve) {
        Intrinsics.checkNotNullParameter((Object)beforePose, (String)"beforePose");
        Intrinsics.checkNotNullParameter((Object)afterPose, (String)"afterPose");
        Intrinsics.checkNotNullParameter(curve, (String)"curve");
        this.beforePose = beforePose;
        this.afterPose = afterPose;
        this.durationTicks = durationTicks;
        this.curve = curve;
        this.isTransition = true;
        this.duration = (float)this.durationTicks / 20.0f;
    }

    public /* synthetic */ PoseTransitionAnimation(Pose pose, Pose pose2, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 20;
        }
        if ((n2 & 8) != 0) {
            function1 = WaveFunctionKt.sineFunction(0.5f, 2.0f, 0.5f, 0.5f);
        }
        this(pose, pose2, n, function1);
    }

    @NotNull
    public final Pose getBeforePose() {
        return this.beforePose;
    }

    @NotNull
    public final Pose getAfterPose() {
        return this.afterPose;
    }

    public final int getDurationTicks() {
        return this.durationTicks;
    }

    @NotNull
    public final Function1<Float, Float> getCurve() {
        return this.curve;
    }

    @Override
    public boolean isTransition() {
        return this.isTransition;
    }

    @Override
    public boolean getEnduresPrimaryAnimations() {
        return this.enduresPrimaryAnimations;
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    public final boolean getInitialized() {
        return this.initialized;
    }

    public final void setInitialized(boolean bl2) {
        this.initialized = bl2;
    }

    public final float getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(float f) {
        this.startTime = f;
    }

    public final float getEndTime() {
        return this.endTime;
    }

    public final void setEndTime(float f) {
        this.endTime = f;
    }

    public final void initialize(@NotNull PosableState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.startTime = state.getAnimationSeconds();
        this.endTime = this.startTime + (float)this.durationTicks / 20.0f;
        this.initialized = true;
    }

    @Override
    public boolean run(@NotNull RenderContext context, @NotNull PosableModel model, @NotNull PosableState state, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch, float intensity) {
        PoseAnimation it;
        PoseAnimation element$iv;
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.initialized) {
            this.initialize(state);
        }
        float now = state.getAnimationSeconds();
        float durationSeconds = this.endTime - this.startTime;
        float passedSeconds = now - this.startTime;
        float ratio = Float.min(passedSeconds / durationSeconds, 1.0f);
        float newIntensity = ((Number)((Object)RangesKt.coerceIn((Comparable)((Comparable)this.curve.invoke((Object)Float.valueOf(ratio))), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        float oldIntensity = 1.0f - newIntensity;
        model.setDefault();
        model.applyPose(state, this.beforePose, oldIntensity);
        PoseAnimation[] $this$forEach$iv = this.beforePose.getAnimations();
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl2 = false;
            it.apply(context, model, state, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch, oldIntensity);
        }
        model.applyPose(state, this.afterPose, newIntensity);
        $this$forEach$iv = this.afterPose.getAnimations();
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl3 = false;
            it.apply(context, model, state, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch, newIntensity);
        }
        return ratio < 1.0f;
    }

    @Override
    public void start(@NotNull PosableState state) {
        ActiveAnimation.DefaultImpls.start(this, state);
    }

    @Override
    public void applyEffects(@Nullable class_1297 entity, @NotNull PosableState state, float previousSeconds, float newSeconds) {
        ActiveAnimation.DefaultImpls.applyEffects(this, entity, state, previousSeconds, newSeconds);
    }
}

