/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.models.blockbench.bedrock.animation;

import com.bedrockk.molang.runtime.MoLangRuntime;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.client.render.models.blockbench.bedrock.animation.BedrockBoneTimeline;
import com.cobblemon.mod.common.client.render.models.blockbench.bedrock.animation.BedrockEffectKeyframe;
import com.cobblemon.mod.common.client.render.models.blockbench.pose.Bone;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.RenderContext;
import com.cobblemon.mod.common.util.EntityExtensionsKt;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_243;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011JM\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001e\u0010\u001fJ/\u0010$\u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0018\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010&\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b&\u0010'J\u0010\u0010(\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b(\u0010)J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003\u00a2\u0006\u0004\b*\u0010+J\u001c\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u00c6\u0003\u00a2\u0006\u0004\b,\u0010-JJ\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u00c6\u0001\u00a2\u0006\u0004\b.\u0010/J\u001a\u00101\u001a\u00020\u00022\b\u00100\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b1\u00102J\u0010\u00104\u001a\u000203H\u00d6\u0001\u00a2\u0006\u0004\b4\u00105J\u0010\u00106\u001a\u00020\nH\u00d6\u0001\u00a2\u0006\u0004\b6\u00107R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00108\u001a\u0004\b9\u0010'R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010:\u001a\u0004\b;\u0010)R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010<\u001a\u0004\b=\u0010+R#\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010>\u001a\u0004\b?\u0010-R\"\u0010@\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010A\u001a\u0004\bB\u00107\"\u0004\bC\u0010D\u00a8\u0006E"}, d2={"Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimation;", "", "", "shouldLoop", "", "animationLength", "", "Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockEffectKeyframe;", "effects", "", "", "Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockBoneTimeline;", "boneTimelines", "<init>", "(ZDLjava/util/List;Ljava/util/Map;)V", "", "checkForErrors", "()V", "Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/RenderContext;", "context", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableModel;", "model", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;", "state", "", "animationSeconds", "limbSwing", "limbSwingAmount", "ageInTicks", "intensity", "run", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/RenderContext;Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableModel;Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;FFFFF)Z", "Lnet/minecraft/class_1297;", "entity", "previousSeconds", "newSeconds", "applyEffects", "(Lnet/minecraft/class_1297;Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;FF)V", "component1", "()Z", "component2", "()D", "component3", "()Ljava/util/List;", "component4", "()Ljava/util/Map;", "copy", "(ZDLjava/util/List;Ljava/util/Map;)Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimation;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Z", "getShouldLoop", "D", "getAnimationLength", "Ljava/util/List;", "getEffects", "Ljava/util/Map;", "getBoneTimelines", "name", "Ljava/lang/String;", "getName", "setName", "(Ljava/lang/String;)V", "common"})
@SourceDebugExtension(value={"SMAP\nBedrockAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BedrockAnimation.kt\ncom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimation\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,364:1\n216#2,2:365\n216#2,2:367\n774#3:369\n865#3,2:370\n1863#3,2:372\n*S KotlinDebug\n*F\n+ 1 BedrockAnimation.kt\ncom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimation\n*L\n136#1:365,2\n166#1:367,2\n227#1:369\n227#1:370,2\n227#1:372,2\n*E\n"})
public final class BedrockAnimation {
    private final boolean shouldLoop;
    private final double animationLength;
    @NotNull
    private final List<BedrockEffectKeyframe> effects;
    @NotNull
    private final Map<String, BedrockBoneTimeline> boneTimelines;
    @NotNull
    private String name;

    public BedrockAnimation(boolean shouldLoop, double animationLength, @NotNull List<? extends BedrockEffectKeyframe> effects, @NotNull Map<String, BedrockBoneTimeline> boneTimelines) {
        Intrinsics.checkNotNullParameter(effects, (String)"effects");
        Intrinsics.checkNotNullParameter(boneTimelines, (String)"boneTimelines");
        this.shouldLoop = shouldLoop;
        this.animationLength = animationLength;
        this.effects = effects;
        this.boneTimelines = boneTimelines;
        this.name = "";
    }

    public final boolean getShouldLoop() {
        return this.shouldLoop;
    }

    public final double getAnimationLength() {
        return this.animationLength;
    }

    @NotNull
    public final List<BedrockEffectKeyframe> getEffects() {
        return this.effects;
    }

    @NotNull
    public final Map<String, BedrockBoneTimeline> getBoneTimelines() {
        return this.boneTimelines;
    }

    public final void checkForErrors() {
        Map<String, BedrockBoneTimeline> $this$forEach$iv = this.boneTimelines;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, BedrockBoneTimeline>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BedrockBoneTimeline> element$iv;
            Map.Entry<String, BedrockBoneTimeline> entry = element$iv = iterator.next();
            boolean bl2 = false;
            BedrockBoneTimeline timeline = entry.getValue();
            if (!timeline.getPosition().isEmpty()) {
                timeline.getPosition().resolve(2.0, MoLangExtensionsKt.getGenericRuntime());
            }
            if (!timeline.getRotation().isEmpty()) {
                timeline.getRotation().resolve(2.0, MoLangExtensionsKt.getGenericRuntime());
            }
            if (timeline.getScale().isEmpty()) continue;
            timeline.getScale().resolve(2.0, MoLangExtensionsKt.getGenericRuntime());
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    public final boolean run(@NotNull RenderContext context, @NotNull PosableModel model, @NotNull PosableState state, float animationSeconds, float limbSwing, float limbSwingAmount, float ageInTicks, float intensity) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        float animationSeconds2 = 0.0f;
        animationSeconds2 = animationSeconds;
        if (this.shouldLoop) {
            animationSeconds2 %= (float)this.animationLength;
        } else if ((double)animationSeconds2 > this.animationLength && this.animationLength > 0.0) {
            return false;
        }
        MoLangRuntime runtime = state.getRuntime();
        runtime.getEnvironment().setSimpleVariable("limb_swing", new DoubleValue(limbSwing));
        runtime.getEnvironment().setSimpleVariable("limb_swing_amount", new DoubleValue(limbSwingAmount));
        runtime.getEnvironment().setSimpleVariable("age_in_ticks", new DoubleValue(ageInTicks));
        Map<String, BedrockBoneTimeline> $this$forEach$iv = this.boneTimelines;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, BedrockBoneTimeline>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            class_630 class_6302;
            class_630 part;
            Map.Entry<String, BedrockBoneTimeline> element$iv;
            Map.Entry<String, BedrockBoneTimeline> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String boneName = entry.getKey();
            BedrockBoneTimeline timeline = entry.getValue();
            class_630 class_6303 = model.getRelevantPartsByName().get(boneName);
            if (class_6303 == null) {
                if (Intrinsics.areEqual((Object)boneName, (Object)"root_part")) {
                    Bone bone = model.getRootPart();
                    Intrinsics.checkNotNull((Object)bone, (String)"null cannot be cast to non-null type net.minecraft.client.model.geom.ModelPart");
                    class_6303 = (class_630)bone;
                } else {
                    class_6303 = null;
                }
            }
            if ((part = class_6303) == null) continue;
            if (!timeline.getPosition().isEmpty()) {
                class_243 position = timeline.getPosition().resolve(animationSeconds2, runtime).method_1021((double)intensity);
                class_630 $this$run_u24lambda_u243_u24lambda_u241 = class_6302 = part;
                boolean bl3 = false;
                $this$run_u24lambda_u243_u24lambda_u241.field_3657 += (float)position.field_1352;
                $this$run_u24lambda_u243_u24lambda_u241.field_3656 += (float)position.field_1351;
                $this$run_u24lambda_u243_u24lambda_u241.field_3655 += (float)position.field_1350;
            }
            if (!timeline.getRotation().isEmpty()) {
                try {
                    class_243 rotation = timeline.getRotation().resolve(animationSeconds2, runtime).method_1021((double)intensity);
                    class_630 $this$run_u24lambda_u243_u24lambda_u242 = class_6302 = part;
                    boolean bl4 = false;
                    $this$run_u24lambda_u243_u24lambda_u242.field_3654 += AngleExtensionsKt.toRadians(Float.valueOf((float)rotation.field_1352));
                    $this$run_u24lambda_u243_u24lambda_u242.field_3675 += AngleExtensionsKt.toRadians(Float.valueOf((float)rotation.field_1351));
                    $this$run_u24lambda_u243_u24lambda_u242.field_3674 += AngleExtensionsKt.toRadians(Float.valueOf((float)rotation.field_1350));
                }
                catch (Exception e) {
                    class_1297 class_12972 = model.getContext().request(RenderContext.Companion.getENTITY());
                    Intrinsics.checkNotNull((Object)class_12972);
                    IllegalStateException exception = new IllegalStateException("Bad animation for entity: " + EntityExtensionsKt.effectiveName(class_12972).getString(), e);
                    class_128 crash = new class_128("Cobblemon encountered an unexpected crash", (Throwable)exception);
                    class_129 section = crash.method_562("Animation Details");
                    String string = state.getCurrentPose();
                    Intrinsics.checkNotNull((Object)string);
                    section.method_578("Pose", (Object)string);
                    section.method_578("Bone", (Object)boneName);
                    throw new class_148(crash);
                }
            }
            if (timeline.getScale().isEmpty()) continue;
            class_243 scale = timeline.getScale().resolve(animationSeconds2, runtime);
            if (Intrinsics.areEqual((Object)scale, (Object)class_243.field_1353) && (double)intensity > 0.5) {
                part.field_37938 *= (float)scale.field_1352;
                part.field_37939 *= (float)scale.field_1351;
                part.field_37940 *= (float)scale.field_1350;
                continue;
            }
            class_243 deviation = scale.method_1021(-1.0).method_1031(1.0, 1.0, 1.0);
            class_243 weakenedDeviation = deviation.method_1021((double)intensity);
            scale = weakenedDeviation.method_1023(1.0, 1.0, 1.0).method_1021(-1.0);
            part.field_37938 *= (float)scale.field_1352;
            part.field_37939 *= (float)scale.field_1351;
            part.field_37940 *= (float)scale.field_1350;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void applyEffects(@Nullable class_1297 entity, @NotNull PosableState state, float previousSeconds, float newSeconds) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Function1 effectCondition = previousSeconds > newSeconds ? arg_0 -> BedrockAnimation.applyEffects$lambda$4(previousSeconds, newSeconds, arg_0) : arg_0 -> BedrockAnimation.applyEffects$lambda$5(previousSeconds, newSeconds, arg_0);
        Iterable $this$filter$iv = this.effects;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)effectCondition.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BedrockEffectKeyframe it = (BedrockEffectKeyframe)element$iv;
            boolean bl2 = false;
            it.run(entity, state);
        }
    }

    public final boolean component1() {
        return this.shouldLoop;
    }

    public final double component2() {
        return this.animationLength;
    }

    @NotNull
    public final List<BedrockEffectKeyframe> component3() {
        return this.effects;
    }

    @NotNull
    public final Map<String, BedrockBoneTimeline> component4() {
        return this.boneTimelines;
    }

    @NotNull
    public final BedrockAnimation copy(boolean shouldLoop, double animationLength, @NotNull List<? extends BedrockEffectKeyframe> effects, @NotNull Map<String, BedrockBoneTimeline> boneTimelines) {
        Intrinsics.checkNotNullParameter(effects, (String)"effects");
        Intrinsics.checkNotNullParameter(boneTimelines, (String)"boneTimelines");
        return new BedrockAnimation(shouldLoop, animationLength, effects, boneTimelines);
    }

    public static /* synthetic */ BedrockAnimation copy$default(BedrockAnimation bedrockAnimation, boolean bl2, double d, List list, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            bl2 = bedrockAnimation.shouldLoop;
        }
        if ((n & 2) != 0) {
            d = bedrockAnimation.animationLength;
        }
        if ((n & 4) != 0) {
            list = bedrockAnimation.effects;
        }
        if ((n & 8) != 0) {
            map = bedrockAnimation.boneTimelines;
        }
        return bedrockAnimation.copy(bl2, d, list, map);
    }

    @NotNull
    public String toString() {
        return "BedrockAnimation(shouldLoop=" + this.shouldLoop + ", animationLength=" + this.animationLength + ", effects=" + this.effects + ", boneTimelines=" + this.boneTimelines + ")";
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.shouldLoop);
        result = result * 31 + Double.hashCode(this.animationLength);
        result = result * 31 + ((Object)this.effects).hashCode();
        result = result * 31 + ((Object)this.boneTimelines).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BedrockAnimation)) {
            return false;
        }
        BedrockAnimation bedrockAnimation = (BedrockAnimation)other;
        if (this.shouldLoop != bedrockAnimation.shouldLoop) {
            return false;
        }
        if (Double.compare(this.animationLength, bedrockAnimation.animationLength) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual(this.effects, bedrockAnimation.effects)) {
            return false;
        }
        return Intrinsics.areEqual(this.boneTimelines, bedrockAnimation.boneTimelines);
    }

    private static final boolean applyEffects$lambda$4(float $previousSeconds, float $newSeconds, BedrockEffectKeyframe it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSeconds() >= $previousSeconds || it.getSeconds() <= $newSeconds;
    }

    private static final boolean applyEffects$lambda$5(float $previousSeconds, float $newSeconds, BedrockEffectKeyframe it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        float f = it.getSeconds();
        return $previousSeconds <= f ? f <= $newSeconds : false;
    }
}

