/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.api.storage.pc.link.PCLinkManager;
import com.cobblemon.mod.common.api.storage.pc.link.PermissiblePcLink;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.net.messages.client.storage.pc.OpenPCPacket;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/cobblemon/mod/common/command/PcCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;)I", "", "NAME", "Ljava/lang/String;", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "IN_BATTLE_EXCEPTION", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "common"})
public final class PcCommand {
    @NotNull
    public static final PcCommand INSTANCE = new PcCommand();
    @NotNull
    private static final String NAME = "pc";
    @NotNull
    private static final SimpleCommandExceptionType IN_BATTLE_EXCEPTION;

    private PcCommand() {
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = class_2170.method_9247((String)NAME);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.INSTANCE.getPC(), false, 2, null)).then(class_2170.method_9244((String)"box", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(this::execute))).executes(this::execute));
    }

    private final int execute(CommandContext<class_2168> context) {
        int n;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        try {
            n = IntegerArgumentType.getInteger(context, (String)"box");
        }
        catch (IllegalArgumentException e) {
            n = 1;
        }
        int box = n;
        Intrinsics.checkNotNull((Object)player);
        PCStore pc = PlayerExtensionsKt.pc(player);
        if (PlayerExtensionsKt.isInBattle(player)) {
            throw IN_BATTLE_EXCEPTION.create();
        }
        if (pc.getBoxes().size() < box) {
            Object[] objectArray = new Object[]{box, pc.getBoxes().size()};
            class_5250 class_52502 = LocalizationUtilsKt.lang("command.pc.invalid-box", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"lang(...)");
            throw new SimpleCommandExceptionType((Message)TextKt.red(class_52502)).create();
        }
        PCLinkManager.INSTANCE.addLink(new PermissiblePcLink(pc, player, CobblemonPermissions.INSTANCE.getPC()));
        new OpenPCPacket(pc.getUuid(), box - 1).sendToPlayer(player);
        class_3218 class_32182 = ((class_2168)context.getSource()).method_9225();
        Intrinsics.checkNotNullExpressionValue((Object)class_32182, (String)"getLevel(...)");
        class_1937 class_19372 = (class_1937)class_32182;
        class_3222 class_32222 = ((class_2168)context.getSource()).method_44023();
        Intrinsics.checkNotNull((Object)class_32222);
        class_243 class_2432 = class_32222.method_19538();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"position(...)");
        WorldExtensionsKt.playSoundServer$default(class_19372, class_2432, CobblemonSounds.PC_ON, null, 0.5f, 1.0f, 4, null);
        return 1;
    }

    static {
        class_5250 class_52502 = LocalizationUtilsKt.lang("pc.inbattle", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"lang(...)");
        IN_BATTLE_EXCEPTION = new SimpleCommandExceptionType((Message)TextKt.red(class_52502));
    }
}

