/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCBox;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.settings.ServerSettings;
import com.cobblemon.mod.common.command.argument.PartySlotArgumentType;
import com.cobblemon.mod.common.net.messages.client.storage.RemoveClientPokemonPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.CommandContextExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ?\u0010\u0013\u001a\u00020\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R(\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R(\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u001c\u0010\u001b\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lcom/cobblemon/mod/common/command/PokeboxCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Lnet/minecraft/class_3222;", "player", "", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemons", "", "box", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/class_3222;Ljava/util/Collection;Ljava/lang/Integer;)I", "Lkotlin/Function1;", "Lnet/minecraft/class_5250;", "kotlin.jvm.PlatformType", "BOX_DOES_NOT_EXIST", "Lkotlin/jvm/functions/Function1;", "BOX_IS_FULL_EXCEPTION", "STORAGE_IS_FULL_EXCEPTION", "Lnet/minecraft/class_5250;", "LAST_POKE_MESSAGE", "common"})
@SourceDebugExtension(value={"SMAP\nPokeboxCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokeboxCommand.kt\ncom/cobblemon/mod/common/command/PokeboxCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1863#2,2:135\n*S KotlinDebug\n*F\n+ 1 PokeboxCommand.kt\ncom/cobblemon/mod/common/command/PokeboxCommand\n*L\n103#1:135,2\n*E\n"})
public final class PokeboxCommand {
    @NotNull
    public static final PokeboxCommand INSTANCE = new PokeboxCommand();
    @NotNull
    private static final Function1<Integer, class_5250> BOX_DOES_NOT_EXIST = PokeboxCommand::BOX_DOES_NOT_EXIST$lambda$0;
    @NotNull
    private static final Function1<Integer, class_5250> BOX_IS_FULL_EXCEPTION = PokeboxCommand::BOX_IS_FULL_EXCEPTION$lambda$1;
    private static final class_5250 STORAGE_IS_FULL_EXCEPTION = LocalizationUtilsKt.commandLang("pokebox.storage_is_full", new Object[0]);
    private static final class_5250 LAST_POKE_MESSAGE = LocalizationUtilsKt.commandLang("pokebox.last_pokemon", new Object[0]);

    private PokeboxCommand() {
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = class_2170.method_9247((String)"pokebox");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.INSTANCE.getPOKEBOX(), false, 2, null)).then(class_2170.method_9244((String)"player", (ArgumentType)((ArgumentType)class_2186.method_9305())).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"slot", (ArgumentType)PartySlotArgumentType.Companion.partySlot()).then(class_2170.method_9244((String)"box", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(PokeboxCommand::register$lambda$2))).executes(PokeboxCommand::register$lambda$3))));
        LiteralArgumentBuilder literalArgumentBuilder2 = class_2170.method_9247((String)"pokeboxall");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder2, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder2, CobblemonPermissions.INSTANCE.getPOKEBOX(), false, 2, null)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)((ArgumentType)class_2186.method_9305())).then(class_2170.method_9244((String)"box", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(PokeboxCommand::register$lambda$4))).executes(PokeboxCommand::register$lambda$5)));
    }

    private final int execute(CommandContext<class_2168> context, class_3222 player, Collection<? extends Pokemon> pokemons, Integer box) {
        PCStore playerPc = PlayerExtensionsKt.pc(player);
        PlayerPartyStore playerParty = PlayerExtensionsKt.party(player);
        if (box != null) {
            if (playerPc.getBoxes().size() < box) {
                Object object = BOX_DOES_NOT_EXIST.invoke((Object)box);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                throw new SimpleCommandExceptionType((Message)TextKt.red((class_5250)object)).create();
            }
            PCBox pcBox = playerPc.getBoxes().get(box - 1);
            if (pcBox.getUnoccupiedSlots() < pokemons.size()) {
                Object object = BOX_IS_FULL_EXCEPTION.invoke((Object)box);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                throw new SimpleCommandExceptionType((Message)TextKt.red((class_5250)object)).create();
            }
        }
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)pokemons);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PCPosition pCPosition;
            Pokemon pokemon = (Pokemon)element$iv;
            boolean bl2 = false;
            if (ServerSettings.INSTANCE.getPreventCompletePartyDeposit() && playerParty.occupied() == 1) {
                ((class_2168)context.getSource()).method_9226(PokeboxCommand::execute$lambda$7$lambda$6, false);
                return pokemons.size() - 1;
            }
            if (box == null) {
                pCPosition = playerPc.getFirstAvailablePosition();
                if (pCPosition == null) {
                    class_5250 class_52502 = STORAGE_IS_FULL_EXCEPTION;
                    Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"STORAGE_IS_FULL_EXCEPTION");
                    throw new SimpleCommandExceptionType((Message)TextKt.red(class_52502)).create();
                }
            } else {
                PCBox pcBox = playerPc.getBoxes().get(box - 1);
                pCPosition = pcBox.getFirstAvailablePosition();
                if (pCPosition == null) {
                    Object object = BOX_IS_FULL_EXCEPTION.invoke((Object)box);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                    throw new SimpleCommandExceptionType((Message)TextKt.red((class_5250)object)).create();
                }
            }
            PCPosition pcPosition = pCPosition;
            playerParty.remove(pokemon);
            playerPc.set(pcPosition, pokemon);
            PokemonStore pokemonStore = PlayerExtensionsKt.party(player);
            UUID uUID = pokemon.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
            playerParty.sendPacketToObservers(new RemoveClientPokemonPacket(pokemonStore, uUID));
        }
        return pokemons.size();
    }

    static /* synthetic */ int execute$default(PokeboxCommand pokeboxCommand, CommandContext commandContext, class_3222 class_32222, Collection collection, Integer n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        return pokeboxCommand.execute((CommandContext<class_2168>)commandContext, class_32222, collection, n);
    }

    private static final class_5250 BOX_DOES_NOT_EXIST$lambda$0(int boxNo) {
        Object[] objectArray = new Object[]{boxNo};
        return LocalizationUtilsKt.commandLang("pokebox.box_does_not_exist", objectArray);
    }

    private static final class_5250 BOX_IS_FULL_EXCEPTION$lambda$1(int boxNo) {
        Object[] objectArray = new Object[]{boxNo};
        return LocalizationUtilsKt.commandLang("pokebox.box_is_full", objectArray);
    }

    private static final int register$lambda$2(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        class_3222 player = CommandContextExtensionsKt.player$default(context, null, 1, null);
        Intrinsics.checkNotNull((Object)player);
        Pokemon pokemon = PartySlotArgumentType.Companion.getPokemonOf(context, "slot", player);
        int box = IntegerArgumentType.getInteger((CommandContext)context, (String)"box");
        return INSTANCE.execute((CommandContext<class_2168>)context, player, CollectionsKt.listOf((Object)pokemon), box);
    }

    private static final int register$lambda$3(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        class_3222 player = CommandContextExtensionsKt.player$default(context, null, 1, null);
        Intrinsics.checkNotNull((Object)player);
        Pokemon pokemon = PartySlotArgumentType.Companion.getPokemonOf(context, "slot", player);
        return PokeboxCommand.execute$default(INSTANCE, context, player, CollectionsKt.listOf((Object)pokemon), null, 8, null);
    }

    private static final int register$lambda$4(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        class_3222 player = CommandContextExtensionsKt.player$default(context, null, 1, null);
        int box = IntegerArgumentType.getInteger((CommandContext)context, (String)"box");
        Intrinsics.checkNotNull((Object)player);
        return INSTANCE.execute((CommandContext<class_2168>)context, player, CollectionsKt.toList((Iterable)PlayerExtensionsKt.party(player)), box);
    }

    private static final int register$lambda$5(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        class_3222 player = CommandContextExtensionsKt.player$default(context, null, 1, null);
        Intrinsics.checkNotNull((Object)player);
        return PokeboxCommand.execute$default(INSTANCE, context, player, CollectionsKt.toList((Iterable)PlayerExtensionsKt.party(player)), null, 8, null);
    }

    private static final class_2561 execute$lambda$7$lambda$6() {
        class_5250 class_52502 = LAST_POKE_MESSAGE;
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"LAST_POKE_MESSAGE");
        return (class_2561)TextKt.red(class_52502);
    }
}

