/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.compat;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.client.render.layer.PokemonOnShoulderRenderer;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.lighthing.LightingData;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandler;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import java.util.Optional;
import kotlin.Pair;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambDynamicLightsCompat {
    public static void hookCompat() {
        DynamicLightHandlers.registerDynamicLightHandler(CobblemonEntities.POKEMON, (DynamicLightHandler)DynamicLightHandler.makeHandler(LambDynamicLightsCompat::resolvedPokemonLightLevel, pokemon -> false));
        DynamicLightHandlers.registerDynamicLightHandler((class_1299)class_1299.field_6097, (DynamicLightHandler)DynamicLightHandler.makeHandler(LambDynamicLightsCompat::resolvedShoulderLightLevel, player -> false));
    }

    private static int resolvedPokemonLightLevel(PokemonEntity pokemon) {
        boolean underwater = !pokemon.method_37908().method_8316(class_2338.method_49637((double)pokemon.method_23317(), (double)pokemon.method_23320(), (double)pokemon.method_23321())).method_15769();
        return LambDynamicLightsCompat.extractFormLightLevel(pokemon.getForm(), underwater).orElse(0);
    }

    private static int resolvedShoulderLightLevel(class_1657 player) {
        Pair<PokemonOnShoulderRenderer.ShoulderData, PokemonOnShoulderRenderer.ShoulderData> shoulderDataPair = PokemonOnShoulderRenderer.shoulderDataOf(player);
        boolean underwater = !player.method_37908().method_8316(class_2338.method_49637((double)player.method_23317(), (double)player.method_23320(), (double)player.method_23321())).method_15769();
        Optional<Integer> leftLightLevel = LambDynamicLightsCompat.extractShoulderLightLevel((PokemonOnShoulderRenderer.ShoulderData)shoulderDataPair.getFirst(), underwater);
        Optional<Integer> rightLightLevel = LambDynamicLightsCompat.extractShoulderLightLevel((PokemonOnShoulderRenderer.ShoulderData)shoulderDataPair.getSecond(), underwater);
        return Math.max(leftLightLevel.orElse(0), rightLightLevel.orElse(0));
    }

    private static Optional<Integer> extractFormLightLevel(@NotNull FormData form, boolean underwater) {
        if (form.getLightingData() == null || !LambDynamicLightsCompat.liquidGlowModeSupport(form.getLightingData().getLiquidGlowMode(), underwater)) {
            return Optional.empty();
        }
        return Optional.of(form.getLightingData().getLightLevel());
    }

    private static Optional<Integer> extractShoulderLightLevel(@Nullable PokemonOnShoulderRenderer.ShoulderData shoulderData, boolean underwater) {
        if (shoulderData == null) {
            return Optional.empty();
        }
        return LambDynamicLightsCompat.extractFormLightLevel(shoulderData.getForm(), underwater);
    }

    private static boolean liquidGlowModeSupport(@NotNull LightingData.LiquidGlowMode liquidGlowMode, boolean underwater) {
        return underwater ? liquidGlowMode.getGlowsUnderwater() : liquidGlowMode.getGlowsInLand();
    }
}

