/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.goals;

import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.ai.MoveBehaviour;
import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1379;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\n\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\bJ\u0011\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0014\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u000e\u0010\rJ\u001d\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/goals/PokemonWanderAroundGoal;", "Lnet/minecraft/class_1379;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "<init>", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "", "canMove", "()Z", "canUse", "canContinueToUse", "Lnet/minecraft/class_243;", "getPosition", "()Lnet/minecraft/class_243;", "getLandTarget", "Lnet/minecraft/class_6862;", "Lnet/minecraft/class_3611;", "fluidTag", "getFluidTarget", "(Lnet/minecraft/class_6862;)Lnet/minecraft/class_243;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getEntity", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "common"})
@SourceDebugExtension(value={"SMAP\nPokemonWanderAroundGoal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokemonWanderAroundGoal.kt\ncom/cobblemon/mod/common/entity/pokemon/ai/goals/PokemonWanderAroundGoal\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1#2:151\n*E\n"})
public final class PokemonWanderAroundGoal
extends class_1379 {
    @NotNull
    private final PokemonEntity entity;

    public PokemonWanderAroundGoal(@NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super((class_1314)entity, entity.getBehaviour().getMoving().getWanderSpeed());
        this.entity = entity;
        this.field_6564 = this.entity.getBehaviour().getMoving().getWanderChance();
    }

    @NotNull
    public final PokemonEntity getEntity() {
        return this.entity;
    }

    public final boolean canMove() {
        MoveBehaviour moving = this.entity.getBehaviour().getMoving();
        return moving.getWalk().getCanWalk() || moving.getFly().getCanFly() || moving.getSwim().getCanBreatheUnderwater() && this.field_6566.method_5777(class_3486.field_15517);
    }

    public boolean method_6264() {
        return super.method_6264() && this.canMove() && !this.entity.isBusy() && (this.entity.method_6139() == null || this.entity.getTethering() != null);
    }

    public boolean method_6266() {
        return super.method_6266() && this.canMove() && !this.entity.isBusy();
    }

    @Nullable
    protected class_243 method_6302() {
        MoveBehaviour moving = this.entity.getBehaviour().getMoving();
        if (this.entity.method_5777(class_3486.field_15517) && moving.getSwim().getCanBreatheUnderwater()) {
            class_6862 class_68622 = class_3486.field_15517;
            Intrinsics.checkNotNullExpressionValue((Object)class_68622, (String)"WATER");
            class_243 class_2432 = this.getFluidTarget((class_6862<class_3611>)class_68622);
            if (class_2432 != null) {
                class_243 it = class_2432;
                boolean bl2 = false;
                return it;
            }
        } else {
            if (this.entity.method_5777(class_3486.field_15518) && moving.getSwim().getCanBreatheUnderlava()) {
                class_6862 class_68623 = class_3486.field_15518;
                Intrinsics.checkNotNullExpressionValue((Object)class_68623, (String)"LAVA");
                return this.getFluidTarget((class_6862<class_3611>)class_68623);
            }
            if (this.entity.method_5799() && moving.getSwim().getCanWalkOnWater()) {
                class_6862 class_68624 = class_3486.field_15517;
                Intrinsics.checkNotNullExpressionValue((Object)class_68624, (String)"WATER");
                class_243 class_2433 = this.getFluidTarget((class_6862<class_3611>)class_68624);
                if (class_2433 != null) {
                    class_243 it = class_2433;
                    boolean bl3 = false;
                    return it;
                }
            } else if (this.entity.method_5771() && moving.getSwim().getCanWalkOnLava()) {
                class_6862 class_68625 = class_3486.field_15518;
                Intrinsics.checkNotNullExpressionValue((Object)class_68625, (String)"LAVA");
                class_243 class_2434 = this.getFluidTarget((class_6862<class_3611>)class_68625);
                if (class_2434 != null) {
                    class_243 it = class_2434;
                    boolean bl4 = false;
                    return it;
                }
            }
        }
        if (moving.getWalk().getAvoidsLand()) {
            return null;
        }
        return this.getLandTarget();
    }

    @Nullable
    public final class_243 getLandTarget() {
        Function1 roamDistanceCondition = arg_0 -> PokemonWanderAroundGoal.getLandTarget$lambda$3(this, arg_0);
        Iterable iterable = class_2338.method_27156((class_5819)this.entity.method_59922(), (int)64, (int)(this.entity.method_31477() - 10), (int)this.entity.method_31478(), (int)(this.entity.method_31479() - 10), (int)(this.entity.method_31477() + 10), (int)this.entity.method_31478(), (int)(this.entity.method_31479() + 10));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"randomBetweenClosed(...)");
        Iterable iterable2 = iterable;
        Function2 condition = (arg_0, arg_1) -> PokemonWanderAroundGoal.getLandTarget$lambda$4(this, roamDistanceCondition, arg_0, arg_1);
        Iterator iterator = iterable2.iterator();
        block0: while (iterator.hasNext()) {
            class_2338.class_2339 pos = ((class_2338)iterator.next()).method_25503();
            class_2680 blockState = this.entity.method_37908().method_8320((class_2338)pos);
            int maxSteps = 16;
            int steps = 0;
            boolean good = false;
            if (!blockState.method_51367() && !blockState.method_51176()) {
                pos.method_10100(0, -1, 0);
                boolean previousWasAir = true;
                while (steps++ < maxSteps && pos.method_10264() > this.entity.method_37908().method_31607()) {
                    if (pos.method_10264() <= this.entity.method_37908().method_31607()) continue block0;
                    blockState = this.entity.method_37908().method_8320((class_2338)pos);
                    if (blockState.method_51367() && !blockState.method_26164(class_3481.field_15503) && previousWasAir) {
                        pos.method_10100(0, 1, 0);
                        blockState = this.entity.method_37908().method_8320((class_2338)pos);
                        good = true;
                        break;
                    }
                    previousWasAir = blockState.method_26215();
                    pos.method_10100(0, -1, 0);
                }
            } else {
                boolean previousWasSolid = blockState.method_51367() && !blockState.method_26164(class_3481.field_15503);
                pos.method_10100(0, 1, 0);
                while (steps++ < maxSteps) {
                    if (pos.method_10264() >= this.entity.method_37908().method_31600()) continue block0;
                    blockState = this.entity.method_37908().method_8320((class_2338)pos);
                    if (blockState.method_26215() && previousWasSolid) {
                        good = true;
                        break;
                    }
                    previousWasSolid = blockState.method_51367() && !blockState.method_26164(class_3481.field_15503);
                    pos.method_10100(0, 1, 0);
                }
            }
            if (!good) continue;
            class_2680 class_26802 = blockState;
            Intrinsics.checkNotNull((Object)class_26802);
            Intrinsics.checkNotNull((Object)pos);
            if (!((Boolean)condition.invoke((Object)class_26802, (Object)pos)).booleanValue()) continue;
            return BlockPosExtensionsKt.toVec3d((class_2338)pos);
        }
        return null;
    }

    @Nullable
    public final class_243 getFluidTarget(@NotNull class_6862<class_3611> fluidTag) {
        Intrinsics.checkNotNullParameter(fluidTag, (String)"fluidTag");
        Function1 roamDistanceCondition = arg_0 -> PokemonWanderAroundGoal.getFluidTarget$lambda$5(this, arg_0);
        boolean walksOnFloor = !this.entity.getBehaviour().getMoving().getSwim().canSwimInFluid(fluidTag);
        Iterable iterable = class_2338.method_34848((class_5819)this.entity.method_59922(), (int)32, (class_2338)this.entity.method_24515(), (int)12);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"randomInCube(...)");
        Iterable iterable2 = iterable;
        Function2 condition = (arg_0, arg_1) -> PokemonWanderAroundGoal.getFluidTarget$lambda$6(roamDistanceCondition, fluidTag, this, arg_0, arg_1);
        if (walksOnFloor) {
            condition = (arg_0, arg_1) -> PokemonWanderAroundGoal.getFluidTarget$lambda$7(this, roamDistanceCondition, fluidTag, arg_0, arg_1);
        }
        if (this.entity.method_37908().method_22347(this.entity.method_24515().method_10084()) && (Intrinsics.areEqual(fluidTag, (Object)class_3486.field_15517) && this.entity.getBehaviour().getMoving().getSwim().getCanWalkOnWater() || Intrinsics.areEqual(fluidTag, (Object)class_3486.field_15518) && this.entity.getBehaviour().getMoving().getSwim().getCanWalkOnLava())) {
            iterable2 = class_2338.method_27156((class_5819)this.entity.method_59922(), (int)16, (int)(this.entity.method_31477() - 16), (int)this.entity.method_31478(), (int)(this.entity.method_31479() - 16), (int)(this.entity.method_31477() + 16), (int)this.entity.method_31478(), (int)(this.entity.method_31479() + 16));
        }
        for (class_2338 pos : iterable2) {
            class_2680 blockState = this.entity.method_37908().method_8320(pos);
            Intrinsics.checkNotNull((Object)blockState);
            if (!((Boolean)condition.invoke((Object)blockState, (Object)pos)).booleanValue()) continue;
            return BlockPosExtensionsKt.toVec3d(pos);
        }
        return null;
    }

    private static final boolean getLandTarget$lambda$3(PokemonWanderAroundGoal this$0, class_2338 it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PokemonPastureBlockEntity.Tethering tethering = this$0.entity.getTethering();
        return !(tethering != null ? !tethering.canRoamTo(it) : false);
    }

    private static final boolean getLandTarget$lambda$4(PokemonWanderAroundGoal this$0, Function1 $roamDistanceCondition, class_2680 class_26802, class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$roamDistanceCondition, (String)"$roamDistanceCondition");
        Intrinsics.checkNotNullParameter((Object)class_26802, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return WorldExtensionsKt.canFit((class_1297)this$0.entity, pos) && (Boolean)$roamDistanceCondition.invoke((Object)pos) != false;
    }

    private static final boolean getFluidTarget$lambda$5(PokemonWanderAroundGoal this$0, class_2338 it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PokemonPastureBlockEntity.Tethering tethering = this$0.entity.getTethering();
        return !(tethering != null ? !tethering.canRoamTo(it) : false);
    }

    private static final boolean getFluidTarget$lambda$6(Function1 $roamDistanceCondition, class_6862 $fluidTag, PokemonWanderAroundGoal this$0, class_2680 blockState, class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)$roamDistanceCondition, (String)"$roamDistanceCondition");
        Intrinsics.checkNotNullParameter((Object)$fluidTag, (String)"$fluidTag");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return (Boolean)$roamDistanceCondition.invoke((Object)pos) != false && blockState.method_26227().method_15767($fluidTag) && WorldExtensionsKt.canFit((class_1297)this$0.entity, pos);
    }

    private static final boolean getFluidTarget$lambda$7(PokemonWanderAroundGoal this$0, Function1 $roamDistanceCondition, class_6862 $fluidTag, class_2680 blockState, class_2338 blockPos) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$roamDistanceCondition, (String)"$roamDistanceCondition");
        Intrinsics.checkNotNullParameter((Object)$fluidTag, (String)"$fluidTag");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        class_2338 down = blockPos.method_10074();
        class_2680 below = this$0.entity.method_37908().method_8320(down);
        return (Boolean)$roamDistanceCondition.invoke((Object)blockPos) != false && blockState.method_26227().method_15767($fluidTag) && below.method_26212((class_1922)this$0.entity.method_37908(), down) && WorldExtensionsKt.canFit((class_1297)this$0.entity, blockPos);
    }
}

