/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item.berry;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.berry.Berry;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.healing.PokemonHealedEvent;
import com.cobblemon.mod.common.api.item.HealingSource;
import com.cobblemon.mod.common.api.item.PokemonSelectingItem;
import com.cobblemon.mod.common.api.molang.ExpressionLike;
import com.cobblemon.mod.common.api.reactive.CancelableObservable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.block.BerryBlock;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.item.berry.BerryItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J/\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ-\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010$R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010%\u001a\u0004\b&\u0010'R\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010(\u001a\u0004\b)\u0010*R\u001a\u0010,\u001a\u00020+8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\u00a8\u00060"}, d2={"Lcom/cobblemon/mod/common/item/berry/PortionHealingBerryItem;", "Lcom/cobblemon/mod/common/item/berry/BerryItem;", "Lcom/cobblemon/mod/common/api/item/PokemonSelectingItem;", "Lcom/cobblemon/mod/common/api/item/HealingSource;", "Lcom/cobblemon/mod/common/block/BerryBlock;", "block", "", "canCauseConfusion", "Lkotlin/Function0;", "Lcom/cobblemon/mod/common/api/molang/ExpressionLike;", "portion", "<init>", "(Lcom/cobblemon/mod/common/block/BerryBlock;ZLkotlin/jvm/functions/Function0;)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "canUseOnPokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/class_1799;", "stack", "Lnet/minecraft/class_1271;", "applyToPokemon", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_1799;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lnet/minecraft/class_1271;", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "battlePokemon", "", "applyToBattlePokemon", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_1799;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;)V", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_1657;", "user", "Lnet/minecraft/class_1268;", "hand", "use", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_1657;Lnet/minecraft/class_1268;)Lnet/minecraft/class_1271;", "Z", "getCanCauseConfusion", "()Z", "Lkotlin/jvm/functions/Function0;", "getPortion", "()Lkotlin/jvm/functions/Function0;", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "bagItem", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "getBagItem", "()Lcom/cobblemon/mod/common/item/battle/BagItem;", "common"})
@SourceDebugExtension(value={"SMAP\nPortionHealingBerryItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortionHealingBerryItem.kt\ncom/cobblemon/mod/common/item/berry/PortionHealingBerryItem\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,82:1\n40#2:83\n41#2,6:87\n47#2:95\n17#3,2:84\n19#3:94\n13346#4:86\n13347#4:93\n*S KotlinDebug\n*F\n+ 1 PortionHealingBerryItem.kt\ncom/cobblemon/mod/common/item/berry/PortionHealingBerryItem\n*L\n60#1:83\n60#1:87,6\n60#1:95\n60#1:84,2\n60#1:94\n60#1:86\n60#1:93\n*E\n"})
public final class PortionHealingBerryItem
extends BerryItem
implements PokemonSelectingItem,
HealingSource {
    private final boolean canCauseConfusion;
    @NotNull
    private final Function0<ExpressionLike> portion;
    @NotNull
    private final BagItem bagItem;

    public PortionHealingBerryItem(@NotNull BerryBlock block, boolean canCauseConfusion, @NotNull Function0<? extends ExpressionLike> portion) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter(portion, (String)"portion");
        super(block);
        this.canCauseConfusion = canCauseConfusion;
        this.portion = portion;
        this.bagItem = new BagItem(this){
            private final class_1792 returnItem;
            final /* synthetic */ PortionHealingBerryItem this$0;
            {
                this.this$0 = $receiver;
                this.returnItem = class_1802.field_8162;
            }

            public String getItemName() {
                Berry berry = this.this$0.berry();
                Intrinsics.checkNotNull((Object)berry);
                return "item.cobblemon." + berry.getIdentifier().method_12832();
            }

            public class_1792 getReturnItem() {
                return this.returnItem;
            }

            public String getShowdownInput(BattleActor actor, BattlePokemon battlePokemon, String data) {
                boolean bl2;
                Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
                Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
                if (this.this$0.getCanCauseConfusion()) {
                    Berry berry = this.this$0.berry();
                    Intrinsics.checkNotNull((Object)berry);
                    bl2 = berry.dislikedBy(battlePokemon.getNature());
                } else {
                    bl2 = false;
                }
                boolean confuse = bl2;
                return "potion_by_portion " + MoLangExtensionsKt.resolveFloat$default(MoLangExtensionsKt.getGenericRuntime(), (ExpressionLike)this.this$0.getPortion().invoke(), battlePokemon, null, 4, null) + " " + confuse;
            }

            public boolean canUse(PokemonBattle battle, BattlePokemon target) {
                Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return target.getHealth() < target.getMaxHealth() && target.getHealth() > 0;
            }

            public boolean canStillUse(class_3222 player, PokemonBattle battle, BattleActor actor, BattlePokemon target, class_1799 stack) {
                return BagItem.DefaultImpls.canStillUse(this, player, battle, actor, target, stack);
            }
        };
    }

    public final boolean getCanCauseConfusion() {
        return this.canCauseConfusion;
    }

    @NotNull
    public final Function0<ExpressionLike> getPortion() {
        return this.portion;
    }

    @Override
    @NotNull
    public BagItem getBagItem() {
        return this.bagItem;
    }

    @Override
    public boolean canUseOnPokemon(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        return !pokemon.isFainted() && !pokemon.isFullHealth();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public class_1271<class_1799> applyToPokemon(@NotNull class_3222 player, @NotNull class_1799 stack, @NotNull Pokemon pokemon) {
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (pokemon.isFullHealth() || pokemon.isFainted()) {
            return class_1271.method_22431((Object)stack);
        }
        int amount = 0;
        amount = Integer.min(pokemon.getCurrentHealth() + (int)(MoLangExtensionsKt.resolveFloat$default(MoLangExtensionsKt.getGenericRuntime(), (ExpressionLike)this.portion.invoke(), pokemon, null, 4, null) * (float)pokemon.getMaxHealth()), pokemon.getMaxHealth());
        CancelableObservable<PokemonHealedEvent> cancelableObservable = CobblemonEvents.POKEMON_HEALED;
        Cancelable event$iv = new PokemonHealedEvent(pokemon, amount, this);
        boolean $i$f$postThen = false;
        EventObservable eventObservable = (EventObservable)this_$iv;
        Cancelable[] cancelableArray = new Cancelable[]{event$iv};
        Cancelable[] events$iv$iv = cancelableArray;
        boolean $i$f$post = false;
        this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
        Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            Cancelable element$iv$iv$iv;
            Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl2 = false;
            if (it$iv.isCanceled()) {
                PokemonHealedEvent cancelledEvent = (PokemonHealedEvent)it$iv;
                boolean bl3 = false;
                return class_1271.method_22431((Object)stack);
            }
            PokemonHealedEvent event = (PokemonHealedEvent)it$iv;
            boolean bl4 = false;
            amount = event.getAmount();
        }
        pokemon.setCurrentHealth(amount);
        player.method_5783(CobblemonSounds.BERRY_EAT, 1.0f, 1.0f);
        if (!player.method_7337()) {
            stack.method_7934(1);
        }
        return class_1271.method_22427((Object)stack);
    }

    @Override
    public void applyToBattlePokemon(@NotNull class_3222 player, @NotNull class_1799 stack, @NotNull BattlePokemon battlePokemon) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
        PokemonSelectingItem.DefaultImpls.applyToBattlePokemon(this, player, stack, battlePokemon);
        player.method_5783(CobblemonSounds.BERRY_EAT, 1.0f, 1.0f);
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 world, @NotNull class_1657 user, @NotNull class_1268 hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (user instanceof class_3222) {
            class_3222 class_32222 = (class_3222)user;
            class_1799 class_17992 = user.method_5998(hand);
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getItemInHand(...)");
            return this.use(class_32222, class_17992);
        }
        class_1271 class_12712 = super.method_7836(world, user, hand);
        Intrinsics.checkNotNullExpressionValue((Object)class_12712, (String)"use(...)");
        return class_12712;
    }

    @Override
    @NotNull
    public class_1271<class_1799> use(@NotNull class_3222 player, @NotNull class_1799 stack) {
        return PokemonSelectingItem.DefaultImpls.use(this, player, stack);
    }

    @Override
    public boolean canUseOnBattlePokemon(@NotNull BattlePokemon battlePokemon) {
        return PokemonSelectingItem.DefaultImpls.canUseOnBattlePokemon(this, battlePokemon);
    }

    @Override
    @NotNull
    public class_1271<class_1799> interactWithSpecificBattle(@NotNull class_3222 player, @NotNull class_1799 stack, @NotNull BattlePokemon battlePokemon) {
        return PokemonSelectingItem.DefaultImpls.interactWithSpecificBattle(this, player, stack, battlePokemon);
    }

    @Override
    @NotNull
    public class_1271<class_1799> interactGeneral(@NotNull class_3222 player, @NotNull class_1799 stack) {
        return PokemonSelectingItem.DefaultImpls.interactGeneral(this, player, stack);
    }

    @Override
    @NotNull
    public class_1271<class_1799> interactGeneralBattle(@NotNull class_3222 player, @NotNull class_1799 stack, @NotNull BattleActor actor) {
        return PokemonSelectingItem.DefaultImpls.interactGeneralBattle(this, player, stack, actor);
    }
}

