/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item.interactive;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.advancement.criterion.PokemonInteractContext;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.callback.PartySelectCallbacks;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.healing.PokemonHealedEvent;
import com.cobblemon.mod.common.api.item.HealingSource;
import com.cobblemon.mod.common.api.reactive.CancelableObservable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.BagItemActionResponse;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.CobblemonItem;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.item.interactive.ReviveItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.ItemStackExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J-\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0015\u001a\u00020\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/cobblemon/mod/common/item/interactive/ReviveItem;", "Lcom/cobblemon/mod/common/item/CobblemonItem;", "Lcom/cobblemon/mod/common/api/item/HealingSource;", "", "max", "<init>", "(Z)V", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_1657;", "user", "Lnet/minecraft/class_1268;", "hand", "Lnet/minecraft/class_1271;", "Lnet/minecraft/class_1799;", "use", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_1657;Lnet/minecraft/class_1268;)Lnet/minecraft/class_1271;", "Z", "getMax", "()Z", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "bagItem", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "getBagItem", "()Lcom/cobblemon/mod/common/item/battle/BagItem;", "common"})
@SourceDebugExtension(value={"SMAP\nReviveItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReviveItem.kt\ncom/cobblemon/mod/common/item/interactive/ReviveItem\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,109:1\n40#2:110\n41#2,6:114\n47#2:122\n17#3,2:111\n19#3:121\n13346#4:113\n13347#4:120\n*S KotlinDebug\n*F\n+ 1 ReviveItem.kt\ncom/cobblemon/mod/common/item/interactive/ReviveItem\n*L\n93#1:110\n93#1:114,6\n93#1:122\n93#1:111,2\n93#1:121\n93#1:113\n93#1:120\n*E\n"})
public final class ReviveItem
extends CobblemonItem
implements HealingSource {
    private final boolean max;
    @NotNull
    private final BagItem bagItem;

    public ReviveItem(boolean max) {
        super(new class_1792.class_1793());
        this.max = max;
        this.bagItem = new BagItem(this){
            private final String itemName;
            private final class_1792 returnItem;
            final /* synthetic */ ReviveItem this$0;
            {
                this.this$0 = $receiver;
                this.itemName = "item.cobblemon." + ($receiver.getMax() ? "max_revive" : "revive");
                this.returnItem = class_1802.field_8162;
            }

            public String getItemName() {
                return this.itemName;
            }

            public class_1792 getReturnItem() {
                return this.returnItem;
            }

            public boolean canUse(PokemonBattle battle, BattlePokemon target) {
                Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return target.getHealth() <= 0;
            }

            public String getShowdownInput(BattleActor actor, BattlePokemon battlePokemon, String data) {
                Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
                Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
                return "revive " + (this.this$0.getMax() ? "1" : "0.5");
            }

            public boolean canStillUse(class_3222 player, PokemonBattle battle, BattleActor actor, BattlePokemon target, class_1799 stack) {
                return BagItem.DefaultImpls.canStillUse(this, player, battle, actor, target, stack);
            }
        };
    }

    public final boolean getMax() {
        return this.max;
    }

    @NotNull
    public final BagItem getBagItem() {
        return this.bagItem;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 world, @NotNull class_1657 user, @NotNull class_1268 hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (!(world instanceof class_3218)) {
            class_1271 class_12712 = class_1271.method_22427((Object)user.method_5998(hand));
            Intrinsics.checkNotNullExpressionValue((Object)class_12712, (String)"success(...)");
            return class_12712;
        }
        class_3222 player = (class_3222)user;
        class_1799 stack = user.method_5998(hand);
        PokemonBattle battle = BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(player);
        if (battle != null) {
            BattleActor battleActor = battle.getActor(player);
            Intrinsics.checkNotNull((Object)battleActor);
            BattleActor actor = battleActor;
            List<BattlePokemon> battlePokemon = actor.getPokemonList();
            if (!actor.canFitForcedAction()) {
                class_5250 class_52502 = LocalizationUtilsKt.battleLang("bagitem.cannot", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"battleLang(...)");
                player.method_43502((class_2561)TextKt.red(class_52502), true);
                class_1271 class_12713 = class_1271.method_22428((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)class_12713, (String)"consume(...)");
                return class_12713;
            }
            int turn = battle.getTurn();
            PartySelectCallbacks.createBattleSelect$default(PartySelectCallbacks.INSTANCE, player, null, battlePokemon, arg_0 -> ReviveItem.use$lambda$0(this, battle, arg_0), null, arg_0 -> ReviveItem.use$lambda$1(actor, battle, turn, stack, player, this, arg_0), 18, null);
        } else {
            List pokemon = CollectionsKt.toList((Iterable)PlayerExtensionsKt.party(player));
            PartySelectCallbacks.createFromPokemon$default(PartySelectCallbacks.INSTANCE, player, null, pokemon, use.3.INSTANCE, null, arg_0 -> ReviveItem.use$lambda$4(player, stack, this, arg_0), 18, null);
        }
        class_1271 class_12714 = class_1271.method_22427((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)class_12714, (String)"success(...)");
        return class_12714;
    }

    private static final boolean use$lambda$0(ReviveItem this$0, PokemonBattle $battle, BattlePokemon it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.bagItem.canUse($battle, it);
    }

    private static final Unit use$lambda$1(BattleActor $actor, PokemonBattle $battle, int $turn, class_1799 $stack, class_3222 $player, ReviveItem this$0, BattlePokemon bp) {
        Intrinsics.checkNotNullParameter((Object)$actor, (String)"$actor");
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)bp, (String)"bp");
        if ($actor.canFitForcedAction() && bp.getHealth() <= 0 && $battle.getTurn() == $turn) {
            Intrinsics.checkNotNull((Object)$stack);
            if (ItemStackExtensionsKt.isHeld($stack, $player)) {
                $player.method_5783(CobblemonSounds.ITEM_USE, 1.0f, 1.0f);
                $actor.forceChoose(new BagItemActionResponse(this$0.bagItem, bp, bp.getUuid().toString()));
                class_2960 class_29602 = class_7923.field_41178.method_10221((Object)$stack.method_7909());
                Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"getKey(...)");
                class_2960 stackName = class_29602;
                if (!$player.method_7337()) {
                    $stack.method_7934(1);
                }
                CobblemonCriteria.INSTANCE.getPOKEMON_INTERACT().trigger($player, new PokemonInteractContext(bp.getEffectedPokemon().getSpecies().getResourceIdentifier(), stackName));
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit use$lambda$4(class_3222 $player, class_1799 $stack, ReviveItem this$0, Pokemon pk) {
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)pk, (String)"pk");
        if (pk.isFainted() && !PlayerExtensionsKt.isInBattle($player)) {
            Intrinsics.checkNotNull((Object)$stack);
            if (ItemStackExtensionsKt.isHeld($stack, $player)) {
                void this_$iv$iv;
                void this_$iv;
                int amount = 0;
                amount = this$0.max ? pk.getMaxHealth() : (int)Math.ceil((float)pk.getMaxHealth() / 2.0f);
                CancelableObservable<PokemonHealedEvent> cancelableObservable = CobblemonEvents.POKEMON_HEALED;
                Cancelable event$iv = new PokemonHealedEvent(pk, amount, this$0);
                boolean $i$f$postThen = false;
                EventObservable eventObservable = (EventObservable)this_$iv;
                Cancelable[] cancelableArray = new Cancelable[]{event$iv};
                Cancelable[] events$iv$iv = cancelableArray;
                boolean $i$f$post = false;
                this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
                Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv$iv$iv.length;
                for (int i = 0; i < n; ++i) {
                    Cancelable element$iv$iv$iv;
                    Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl2 = false;
                    if (it$iv.isCanceled()) {
                        PokemonHealedEvent cancelledEvent = (PokemonHealedEvent)it$iv;
                        boolean bl3 = false;
                        return Unit.INSTANCE;
                    }
                    PokemonHealedEvent event = (PokemonHealedEvent)it$iv;
                    boolean bl4 = false;
                    amount = event.getAmount();
                }
                pk.setCurrentHealth(amount);
                class_2960 class_29602 = class_7923.field_41178.method_10221((Object)$stack.method_7909());
                Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"getKey(...)");
                class_2960 stackName = class_29602;
                if (!$player.method_7337()) {
                    $stack.method_7934(1);
                }
                CobblemonCriteria.INSTANCE.getPOKEMON_INTERACT().trigger($player, new PokemonInteractContext(pk.getSpecies().getResourceIdentifier(), stackName));
            }
        }
        return Unit.INSTANCE;
    }
}

