/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.messages.client.dialogue.dto;

import com.cobblemon.mod.common.api.dialogue.ActiveDialogue;
import com.cobblemon.mod.common.api.dialogue.input.DialogueAutoContinueInput;
import com.cobblemon.mod.common.api.dialogue.input.DialogueOption;
import com.cobblemon.mod.common.api.dialogue.input.DialogueOptionSetInput;
import com.cobblemon.mod.common.api.dialogue.input.DialogueTextInput;
import com.cobblemon.mod.common.api.dialogue.input.DialogueTimeout;
import com.cobblemon.mod.common.api.net.Decodable;
import com.cobblemon.mod.common.api.net.Encodable;
import com.cobblemon.mod.common.net.messages.client.dialogue.dto.DialogueOptionDTO;
import com.cobblemon.mod.common.util.BufferUtilsKt;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u00012\u00020\u0002:\u0001AB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0003\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0003\u0010\fB\u0019\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0003\u0010\u000fB\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0010J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0015R\"\u0010\u0018\u001a\u00020\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\"\u0010\u001f\u001a\u00020\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010&\u001a\u00020%8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\"\u0010-\u001a\u00020,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\"\u0004\b1\u00102R(\u00105\u001a\b\u0012\u0004\u0012\u000204038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b5\u00106\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\"\u0010;\u001a\u00020,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010.\u001a\u0004\b<\u00100\"\u0004\b=\u00102R\"\u0010>\u001a\u00020,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b>\u0010.\u001a\u0004\b?\u00100\"\u0004\b@\u00102\u00a8\u0006B"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/dialogue/dto/DialogueInputDTO;", "Lcom/cobblemon/mod/common/api/net/Encodable;", "Lcom/cobblemon/mod/common/api/net/Decodable;", "<init>", "()V", "Lcom/cobblemon/mod/common/api/dialogue/input/DialogueOptionSetInput;", "optionSet", "Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;", "activeDialogue", "(Lcom/cobblemon/mod/common/api/dialogue/input/DialogueOptionSetInput;Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;)V", "Lcom/cobblemon/mod/common/api/dialogue/input/DialogueAutoContinueInput;", "autoContinue", "(Lcom/cobblemon/mod/common/api/dialogue/input/DialogueAutoContinueInput;Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;)V", "Lcom/cobblemon/mod/common/api/dialogue/input/DialogueTextInput;", "text", "(Lcom/cobblemon/mod/common/api/dialogue/input/DialogueTextInput;Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;)V", "(Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;)V", "Lnet/minecraft/class_9129;", "buffer", "", "encode", "(Lnet/minecraft/class_9129;)V", "decode", "Ljava/util/UUID;", "inputId", "Ljava/util/UUID;", "getInputId", "()Ljava/util/UUID;", "setInputId", "(Ljava/util/UUID;)V", "Lcom/cobblemon/mod/common/net/messages/client/dialogue/dto/DialogueInputDTO$InputType;", "inputType", "Lcom/cobblemon/mod/common/net/messages/client/dialogue/dto/DialogueInputDTO$InputType;", "getInputType", "()Lcom/cobblemon/mod/common/net/messages/client/dialogue/dto/DialogueInputDTO$InputType;", "setInputType", "(Lcom/cobblemon/mod/common/net/messages/client/dialogue/dto/DialogueInputDTO$InputType;)V", "", "deadline", "F", "getDeadline", "()F", "setDeadline", "(F)V", "", "showTimer", "Z", "getShowTimer", "()Z", "setShowTimer", "(Z)V", "", "Lcom/cobblemon/mod/common/net/messages/client/dialogue/dto/DialogueOptionDTO;", "options", "Ljava/util/List;", "getOptions", "()Ljava/util/List;", "setOptions", "(Ljava/util/List;)V", "vertical", "getVertical", "setVertical", "allowSkip", "getAllowSkip", "setAllowSkip", "InputType", "common"})
@SourceDebugExtension(value={"SMAP\nDialogueInputDTO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogueInputDTO.kt\ncom/cobblemon/mod/common/net/messages/client/dialogue/dto/DialogueInputDTO\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1557#2:124\n1628#2,3:125\n1863#2,2:128\n*S KotlinDebug\n*F\n+ 1 DialogueInputDTO.kt\ncom/cobblemon/mod/common/net/messages/client/dialogue/dto/DialogueInputDTO\n*L\n50#1:124\n50#1:125,3\n91#1:128,2\n*E\n"})
public final class DialogueInputDTO
implements Encodable,
Decodable {
    @NotNull
    private UUID inputId;
    @NotNull
    private InputType inputType;
    private float deadline;
    private boolean showTimer;
    @NotNull
    private List<DialogueOptionDTO> options;
    private boolean vertical;
    private boolean allowSkip;

    public DialogueInputDTO() {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.inputId = uUID;
        this.inputType = InputType.NONE;
        this.deadline = -1.0f;
        this.showTimer = true;
        this.options = new ArrayList();
        this.allowSkip = true;
    }

    @NotNull
    public final UUID getInputId() {
        return this.inputId;
    }

    public final void setInputId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.inputId = uUID;
    }

    @NotNull
    public final InputType getInputType() {
        return this.inputType;
    }

    public final void setInputType(@NotNull InputType inputType) {
        Intrinsics.checkNotNullParameter((Object)((Object)inputType), (String)"<set-?>");
        this.inputType = inputType;
    }

    public final float getDeadline() {
        return this.deadline;
    }

    public final void setDeadline(float f) {
        this.deadline = f;
    }

    public final boolean getShowTimer() {
        return this.showTimer;
    }

    public final void setShowTimer(boolean bl2) {
        this.showTimer = bl2;
    }

    @NotNull
    public final List<DialogueOptionDTO> getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull List<DialogueOptionDTO> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.options = list;
    }

    public final boolean getVertical() {
        return this.vertical;
    }

    public final void setVertical(boolean bl2) {
        this.vertical = bl2;
    }

    public final boolean getAllowSkip() {
        return this.allowSkip;
    }

    public final void setAllowSkip(boolean bl2) {
        this.allowSkip = bl2;
    }

    /*
     * WARNING - void declaration
     */
    public DialogueInputDTO(@NotNull DialogueOptionSetInput optionSet, @NotNull ActiveDialogue activeDialogue) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)optionSet, (String)"optionSet");
        Intrinsics.checkNotNullParameter((Object)activeDialogue, (String)"activeDialogue");
        this();
        this.inputId = activeDialogue.getActiveInput().getInputId();
        Iterable iterable = optionSet.getVisibleOptions(activeDialogue);
        DialogueInputDTO dialogueInputDTO = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DialogueOption dialogueOption = (DialogueOption)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new DialogueOptionDTO(it.getText().invoke(activeDialogue), it.getValue(), it.isSelectable().invoke(activeDialogue)));
        }
        dialogueInputDTO.options = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        DialogueTimeout dialogueTimeout = optionSet.getTimeout();
        this.deadline = dialogueTimeout != null ? dialogueTimeout.getDuration() : -1.0f;
        DialogueTimeout dialogueTimeout2 = optionSet.getTimeout();
        this.showTimer = dialogueTimeout2 != null ? dialogueTimeout2.getShowTimer() : true;
        this.inputType = InputType.OPTION;
        this.vertical = optionSet.getVertical();
    }

    public DialogueInputDTO(@NotNull DialogueAutoContinueInput autoContinue, @NotNull ActiveDialogue activeDialogue) {
        Intrinsics.checkNotNullParameter((Object)autoContinue, (String)"autoContinue");
        Intrinsics.checkNotNullParameter((Object)activeDialogue, (String)"activeDialogue");
        this();
        this.inputId = activeDialogue.getActiveInput().getInputId();
        DialogueTimeout dialogueTimeout = autoContinue.getTimeout();
        this.deadline = dialogueTimeout != null ? dialogueTimeout.getDuration() : -1.0f;
        this.inputType = InputType.AUTO_CONTINUE;
        this.allowSkip = autoContinue.getAllowSkip();
        this.showTimer = autoContinue.getShowTimer();
    }

    public DialogueInputDTO(@NotNull DialogueTextInput text, @NotNull ActiveDialogue activeDialogue) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)activeDialogue, (String)"activeDialogue");
        this();
        this.inputId = activeDialogue.getActiveInput().getInputId();
        DialogueTimeout dialogueTimeout = text.getTimeout();
        this.deadline = dialogueTimeout != null ? dialogueTimeout.getDuration() : -1.0f;
        this.inputType = InputType.TEXT;
        DialogueTimeout dialogueTimeout2 = text.getTimeout();
        this.showTimer = dialogueTimeout2 != null ? dialogueTimeout2.getShowTimer() : true;
    }

    public DialogueInputDTO(@NotNull ActiveDialogue activeDialogue) {
        Intrinsics.checkNotNullParameter((Object)activeDialogue, (String)"activeDialogue");
        this();
        this.inputId = activeDialogue.getActiveInput().getInputId();
    }

    @Override
    public void encode(@NotNull class_9129 buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.method_10797(this.inputId);
        BufferUtilsKt.writeEnumConstant((ByteBuf)buffer, this.inputType);
        buffer.method_52941(this.deadline);
        buffer.method_52964(this.showTimer);
        switch (WhenMappings.$EnumSwitchMapping$0[this.inputType.ordinal()]) {
            case 1: {
                buffer.method_52964(this.vertical);
                buffer.method_53002(this.options.size());
                Iterable $this$forEach$iv = this.options;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DialogueOptionDTO it = (DialogueOptionDTO)element$iv;
                    boolean bl2 = false;
                    it.encode(buffer);
                }
                break;
            }
            case 2: {
                buffer.method_52964(this.allowSkip);
                break;
            }
        }
    }

    @Override
    public void decode(@NotNull class_9129 buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.inputId = buffer.method_10790();
        this.inputType = BufferUtilsKt.readEnumConstant((ByteBuf)buffer, InputType.class);
        this.deadline = buffer.readFloat();
        this.showTimer = buffer.readBoolean();
        switch (WhenMappings.$EnumSwitchMapping$0[this.inputType.ordinal()]) {
            case 1: {
                this.vertical = buffer.readBoolean();
                int size = buffer.readInt();
                for (int i = 0; i < size; ++i) {
                    DialogueOptionDTO option = new DialogueOptionDTO(null, null, false, 7, null);
                    option.decode(buffer);
                    this.options.add(option);
                }
                break;
            }
            case 2: {
                this.allowSkip = buffer.readBoolean();
                break;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/dialogue/dto/DialogueInputDTO$InputType;", "", "<init>", "(Ljava/lang/String;I)V", "OPTION", "TEXT", "AUTO_CONTINUE", "NONE", "common"})
    public static final class InputType
    extends Enum<InputType> {
        public static final /* enum */ InputType OPTION = new InputType();
        public static final /* enum */ InputType TEXT = new InputType();
        public static final /* enum */ InputType AUTO_CONTINUE = new InputType();
        public static final /* enum */ InputType NONE = new InputType();
        private static final /* synthetic */ InputType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static InputType[] values() {
            return (InputType[])$VALUES.clone();
        }

        public static InputType valueOf(String value) {
            return Enum.valueOf(InputType.class, value);
        }

        @NotNull
        public static EnumEntries<InputType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = inputTypeArray = new InputType[]{InputType.OPTION, InputType.TEXT, InputType.AUTO_CONTINUE, InputType.NONE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InputType.values().length];
            try {
                nArray[InputType.OPTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InputType.AUTO_CONTINUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

