/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.serverhandling;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.net.ServerNetworkPacketHandler;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.TeamManager;
import com.cobblemon.mod.common.net.messages.client.PlayerInteractOptionsPacket;
import com.cobblemon.mod.common.net.messages.server.RequestPlayerInteractionsPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/cobblemon/mod/common/net/serverhandling/RequestInteractionsHandler;", "Lcom/cobblemon/mod/common/api/net/ServerNetworkPacketHandler;", "Lcom/cobblemon/mod/common/net/messages/server/RequestPlayerInteractionsPacket;", "<init>", "()V", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_3222;", "player", "", "handle", "(Lcom/cobblemon/mod/common/net/messages/server/RequestPlayerInteractionsPacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_3222;)V", "common"})
@SourceDebugExtension(value={"SMAP\nRequestInteractionsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestInteractionsHandler.kt\ncom/cobblemon/mod/common/net/serverhandling/RequestInteractionsHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1782#2,4:96\n1782#2,4:100\n*S KotlinDebug\n*F\n+ 1 RequestInteractionsHandler.kt\ncom/cobblemon/mod/common/net/serverhandling/RequestInteractionsHandler\n*L\n61#1:96,4\n62#1:100,4\n*E\n"})
public final class RequestInteractionsHandler
implements ServerNetworkPacketHandler<RequestPlayerInteractionsPacket> {
    @NotNull
    public static final RequestInteractionsHandler INSTANCE = new RequestInteractionsHandler();

    private RequestInteractionsHandler() {
    }

    @Override
    public void handle(@NotNull RequestPlayerInteractionsPacket packet, @NotNull MinecraftServer server, @NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        class_1937 world = player.method_37908();
        class_1657 targetPlayerEntity = world.method_18470(packet.getTargetId());
        EnumMap<PlayerInteractOptionsPacket.Options, PlayerInteractOptionsPacket.OptionStatus> options = new EnumMap<PlayerInteractOptionsPacket.Options, PlayerInteractOptionsPacket.OptionStatus>(PlayerInteractOptionsPacket.Options.class);
        if (targetPlayerEntity != null) {
            class_3959.class_242 class_2422;
            Class<class_1309> clazz = class_1309.class;
            float f = Cobblemon.INSTANCE.getConfig().getBattleSpectateMaxDistance();
            if (Intrinsics.areEqual((Object)PlayerExtensionsKt.traceFirstEntityCollision$default((class_1657)player, f, 0.0f, clazz, (class_1297)player, class_2422 = class_3959.class_242.field_1348, 2, null), (Object)targetPlayerEntity)) {
                boolean isTargetBattling;
                double squaredDistance = targetPlayerEntity.method_19538().method_1025(player.method_19538());
                if (squaredDistance <= (double)((float)Math.pow(Cobblemon.INSTANCE.getConfig().getTradeMaxDistance(), 2))) {
                    int playerPartyCount = CollectionsKt.count((Iterable)PlayerExtensionsKt.party(player));
                    int targetPartyCount = CollectionsKt.count((Iterable)PlayerExtensionsKt.party((class_3222)targetPlayerEntity));
                    if (playerPartyCount >= 1 && targetPartyCount >= 1) {
                        ((Map)options).put(PlayerInteractOptionsPacket.Options.TRADE, PlayerInteractOptionsPacket.OptionStatus.AVAILABLE);
                    } else {
                        ((Map)options).put(PlayerInteractOptionsPacket.Options.TRADE, PlayerInteractOptionsPacket.OptionStatus.INSUFFICIENT_POKEMON);
                    }
                } else {
                    ((Map)options).put(PlayerInteractOptionsPacket.Options.TRADE, PlayerInteractOptionsPacket.OptionStatus.TOO_FAR);
                }
                boolean bl2 = isTargetBattling = BattleRegistry.INSTANCE.getBattleByParticipatingPlayerId(packet.getTargetId()) != null;
                if (isTargetBattling & Cobblemon.INSTANCE.getConfig().getAllowSpectating() && squaredDistance <= (double)((float)Math.pow(Cobblemon.INSTANCE.getConfig().getBattleSpectateMaxDistance(), 2))) {
                    ((Map)options).put(PlayerInteractOptionsPacket.Options.SPECTATE_BATTLE, PlayerInteractOptionsPacket.OptionStatus.AVAILABLE);
                } else if (squaredDistance <= (double)((float)Math.pow(Cobblemon.INSTANCE.getConfig().getBattlePvPMaxDistance(), 2))) {
                    int targetPartyCount;
                    int n;
                    Iterable $this$count$iv = PlayerExtensionsKt.party(player);
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv) {
                            Pokemon pokemon = (Pokemon)element$iv;
                            boolean bl3 = false;
                            if (!(!pokemon.isFainted()) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    int playerPartyCount = n;
                    Iterable $this$count$iv2 = PlayerExtensionsKt.party((class_3222)targetPlayerEntity);
                    boolean $i$f$count2 = false;
                    if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                        v2 = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv2) {
                            Pokemon pokemon = (Pokemon)element$iv;
                            boolean bl4 = false;
                            if (!(!pokemon.isFainted()) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        v2 = targetPartyCount = count$iv;
                    }
                    if (playerPartyCount >= 1 && targetPartyCount >= 1) {
                        ((Map)options).put(PlayerInteractOptionsPacket.Options.SINGLE_BATTLE, PlayerInteractOptionsPacket.OptionStatus.AVAILABLE);
                        if (TeamManager.INSTANCE.getTeam(player) != null && TeamManager.INSTANCE.getTeam((class_3222)targetPlayerEntity) != null) {
                            TeamManager.MultiBattleTeam multiBattleTeam = TeamManager.INSTANCE.getTeam(player);
                            TeamManager.MultiBattleTeam multiBattleTeam2 = TeamManager.INSTANCE.getTeam((class_3222)targetPlayerEntity);
                            if (!Intrinsics.areEqual((Object)(multiBattleTeam != null ? multiBattleTeam.getTeamID() : null), (Object)(multiBattleTeam2 != null ? multiBattleTeam2.getTeamID() : null))) {
                                ((Map)options).put(PlayerInteractOptionsPacket.Options.MULTI_BATTLE, PlayerInteractOptionsPacket.OptionStatus.AVAILABLE);
                            } else {
                                ((Map)options).put(PlayerInteractOptionsPacket.Options.TEAM_LEAVE, PlayerInteractOptionsPacket.OptionStatus.AVAILABLE);
                            }
                        } else if (TeamManager.INSTANCE.getTeam(player) == null && TeamManager.INSTANCE.getTeam((class_3222)targetPlayerEntity) == null) {
                            ((Map)options).put(PlayerInteractOptionsPacket.Options.TEAM_REQUEST, PlayerInteractOptionsPacket.OptionStatus.AVAILABLE);
                        }
                        if (playerPartyCount >= 2 && targetPartyCount >= 2) {
                            ((Map)options).put(PlayerInteractOptionsPacket.Options.DOUBLE_BATTLE, PlayerInteractOptionsPacket.OptionStatus.AVAILABLE);
                            if (playerPartyCount >= 3 && targetPartyCount >= 3) {
                                ((Map)options).put(PlayerInteractOptionsPacket.Options.TRIPLE_BATTLE, PlayerInteractOptionsPacket.OptionStatus.AVAILABLE);
                            }
                        }
                    } else {
                        ((Map)options).put(PlayerInteractOptionsPacket.Options.SINGLE_BATTLE, PlayerInteractOptionsPacket.OptionStatus.INSUFFICIENT_POKEMON);
                    }
                } else {
                    ((Map)options).put(PlayerInteractOptionsPacket.Options.SINGLE_BATTLE, PlayerInteractOptionsPacket.OptionStatus.TOO_FAR);
                }
            }
        }
        if (!options.isEmpty()) {
            new PlayerInteractOptionsPacket(options, packet.getTargetId(), packet.getTargetNumericId(), packet.getPokemonId()).sendToPlayer(player);
        }
    }
}

