/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokemon.evolution.adapters;

import com.cobblemon.mod.common.api.pokemon.evolution.adapters.RequirementAdapter;
import com.cobblemon.mod.common.api.pokemon.evolution.requirement.EvolutionRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.AnyRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.AreaRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.AttackDefenceRatioRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.BattleCriticalHitsRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.BiomeRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.BlocksTraveledRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.DamageTakenRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.DefeatRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.FriendshipRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.HeldItemRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.LevelRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.MoonPhaseRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.MoveSetRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.MoveTypeRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.PartyMemberRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.PlayerHasAdvancementRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.PokemonPropertiesRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.PropertyRangeRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.RecoilRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.StatCompareRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.StatEqualRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.StructureRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.TimeRangeRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.UseMoveRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.WeatherRequirement;
import com.cobblemon.mod.common.pokemon.evolution.requirements.WorldRequirement;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u000b\u001a\u00020\n\"\b\b\u0000\u0010\u0005*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bRt\u0010\u001e\u001ab\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00060\u0006\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\u0004 \u001d*\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\b0\b \u001d*0\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00060\u0006\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\u0004 \u001d*\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\b0\b\u0018\u00010\u001c0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/cobblemon/mod/common/pokemon/evolution/adapters/CobblemonRequirementAdapter;", "Lcom/cobblemon/mod/common/api/pokemon/evolution/adapters/RequirementAdapter;", "<init>", "()V", "Lcom/cobblemon/mod/common/api/pokemon/evolution/requirement/EvolutionRequirement;", "T", "", "id", "Lkotlin/reflect/KClass;", "type", "", "registerType", "(Ljava/lang/String;Lkotlin/reflect/KClass;)V", "Lcom/google/gson/JsonElement;", "json", "Ljava/lang/reflect/Type;", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "context", "deserialize", "(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Lcom/cobblemon/mod/common/api/pokemon/evolution/requirement/EvolutionRequirement;", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "serialize", "(Lcom/cobblemon/mod/common/api/pokemon/evolution/requirement/EvolutionRequirement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonSerializationContext;)Lcom/google/gson/JsonElement;", "VARIANT", "Ljava/lang/String;", "Lcom/google/common/collect/HashBiMap;", "kotlin.jvm.PlatformType", "types", "Lcom/google/common/collect/HashBiMap;", "common"})
public final class CobblemonRequirementAdapter
implements RequirementAdapter {
    @NotNull
    public static final CobblemonRequirementAdapter INSTANCE = new CobblemonRequirementAdapter();
    @NotNull
    private static final String VARIANT = "variant";
    private static final HashBiMap<String, KClass<? extends EvolutionRequirement>> types = HashBiMap.create();

    private CobblemonRequirementAdapter() {
    }

    @Override
    public <T extends EvolutionRequirement> void registerType(@NotNull String id, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        HashBiMap<String, KClass<? extends EvolutionRequirement>> hashBiMap = types;
        Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"types");
        Map map = (Map)hashBiMap;
        String string = id.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = string;
        map.put(string2, type);
    }

    @NotNull
    public EvolutionRequirement deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = json.getAsJsonObject().get(VARIANT).getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String variant = string2;
        KClass kClass = (KClass)types.get((Object)variant);
        if (kClass == null) {
            throw new IllegalArgumentException("Cannot resolve evolution requirement type for variant " + variant);
        }
        KClass type = kClass;
        Object object = context.deserialize(json, (Type)JvmClassMappingKt.getJavaClass((KClass)type));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"deserialize(...)");
        return (EvolutionRequirement)object;
    }

    @NotNull
    public JsonElement serialize(@NotNull EvolutionRequirement src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsonObject json = context.serialize((Object)src, (Type)src.getClass()).getAsJsonObject();
        String string = (String)types.inverse().get((Object)Reflection.getOrCreateKotlinClass(src.getClass()));
        if (string == null) {
            throw new IllegalArgumentException("Cannot resolve evolution requirement for type " + Reflection.getOrCreateKotlinClass(src.getClass()).getQualifiedName());
        }
        String variant = string;
        json.addProperty(VARIANT, variant);
        Intrinsics.checkNotNull((Object)json);
        return (JsonElement)json;
    }

    static {
        INSTANCE.registerType("area", Reflection.getOrCreateKotlinClass(AreaRequirement.class));
        INSTANCE.registerType("biome", Reflection.getOrCreateKotlinClass(BiomeRequirement.class));
        INSTANCE.registerType("friendship", Reflection.getOrCreateKotlinClass(FriendshipRequirement.class));
        INSTANCE.registerType("held_item", Reflection.getOrCreateKotlinClass(HeldItemRequirement.class));
        INSTANCE.registerType("world", Reflection.getOrCreateKotlinClass(WorldRequirement.class));
        INSTANCE.registerType("has_move", Reflection.getOrCreateKotlinClass(MoveSetRequirement.class));
        INSTANCE.registerType("has_move_type", Reflection.getOrCreateKotlinClass(MoveTypeRequirement.class));
        INSTANCE.registerType("party_member", Reflection.getOrCreateKotlinClass(PartyMemberRequirement.class));
        INSTANCE.registerType("properties", Reflection.getOrCreateKotlinClass(PokemonPropertiesRequirement.class));
        INSTANCE.registerType("time_range", Reflection.getOrCreateKotlinClass(TimeRangeRequirement.class));
        INSTANCE.registerType("level", Reflection.getOrCreateKotlinClass(LevelRequirement.class));
        INSTANCE.registerType("weather", Reflection.getOrCreateKotlinClass(WeatherRequirement.class));
        INSTANCE.registerType("stat_compare", Reflection.getOrCreateKotlinClass(StatCompareRequirement.class));
        INSTANCE.registerType("stat_equal", Reflection.getOrCreateKotlinClass(StatEqualRequirement.class));
        INSTANCE.registerType("attack_defence_ratio", Reflection.getOrCreateKotlinClass(AttackDefenceRatioRequirement.class));
        INSTANCE.registerType("battle_critical_hits", Reflection.getOrCreateKotlinClass(BattleCriticalHitsRequirement.class));
        INSTANCE.registerType("damage_taken", Reflection.getOrCreateKotlinClass(DamageTakenRequirement.class));
        INSTANCE.registerType("use_move", Reflection.getOrCreateKotlinClass(UseMoveRequirement.class));
        INSTANCE.registerType("moon_phase", Reflection.getOrCreateKotlinClass(MoonPhaseRequirement.class));
        INSTANCE.registerType("recoil", Reflection.getOrCreateKotlinClass(RecoilRequirement.class));
        INSTANCE.registerType("defeat", Reflection.getOrCreateKotlinClass(DefeatRequirement.class));
        INSTANCE.registerType("blocks_traveled", Reflection.getOrCreateKotlinClass(BlocksTraveledRequirement.class));
        INSTANCE.registerType("structure", Reflection.getOrCreateKotlinClass(StructureRequirement.class));
        INSTANCE.registerType("any", Reflection.getOrCreateKotlinClass(AnyRequirement.class));
        INSTANCE.registerType("property_range", Reflection.getOrCreateKotlinClass(PropertyRangeRequirement.class));
        INSTANCE.registerType(PlayerHasAdvancementRequirement.Companion.getADAPTER_VARIANT(), Reflection.getOrCreateKotlinClass(PlayerHasAdvancementRequirement.class));
    }
}

