/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokemon.misc;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.api.pokemon.feature.IntSpeciesFeature;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0014\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\u00020\u00168\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0018\u001a\u0004\b\u001c\u0010\u001aR\u0017\u0010\u001d\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0018\u001a\u0004\b\u001e\u0010\u001aR\u001a\u0010\u001f\u001a\u00020\u00168\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0018\u001a\u0004\b \u0010\u001aR\u0017\u0010!\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b!\u0010\u0018\u001a\u0004\b\"\u0010\u001aR\u0017\u0010#\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b#\u0010\u0018\u001a\u0004\b$\u0010\u001a\u00a8\u0006%"}, d2={"Lcom/cobblemon/mod/common/pokemon/misc/GimmighoulStashHandler;", "", "<init>", "()V", "Lnet/minecraft/class_1657;", "player", "Lnet/minecraft/class_1268;", "hand", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "interactMob", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_1268;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Lcom/cobblemon/mod/common/api/events/pokemon/HeldItemEvent$Post;", "event", "", "giveHeldItem", "(Lcom/cobblemon/mod/common/api/events/pokemon/HeldItemEvent$Post;)V", "Lnet/minecraft/class_1792;", "item", "handleItem", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lnet/minecraft/class_1792;)Z", "", "COIN_VALUE", "I", "getCOIN_VALUE", "()I", "POUCH_VALUE", "getPOUCH_VALUE", "SACK_VALUE", "getSACK_VALUE", "SCRAP_VALUE", "getSCRAP_VALUE", "INGOT_VALUE", "getINGOT_VALUE", "BLOCK_VALUE", "getBLOCK_VALUE", "common"})
public final class GimmighoulStashHandler {
    @NotNull
    public static final GimmighoulStashHandler INSTANCE = new GimmighoulStashHandler();
    private static final int COIN_VALUE = 1;
    private static final int POUCH_VALUE = COIN_VALUE * 9;
    private static final int SACK_VALUE = POUCH_VALUE * 9;
    private static final int SCRAP_VALUE = 1;
    private static final int INGOT_VALUE = SCRAP_VALUE * 4;
    private static final int BLOCK_VALUE = INGOT_VALUE * 9;

    private GimmighoulStashHandler() {
    }

    public final int getCOIN_VALUE() {
        return COIN_VALUE;
    }

    public final int getPOUCH_VALUE() {
        return POUCH_VALUE;
    }

    public final int getSACK_VALUE() {
        return SACK_VALUE;
    }

    public final int getSCRAP_VALUE() {
        return SCRAP_VALUE;
    }

    public final int getINGOT_VALUE() {
        return INGOT_VALUE;
    }

    public final int getBLOCK_VALUE() {
        return BLOCK_VALUE;
    }

    public final boolean interactMob(@NotNull class_1657 player, @NotNull class_1268 hand, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        class_1799 itemStack = player.method_5998(hand);
        boolean success = false;
        if (player instanceof class_3222 && Intrinsics.areEqual((Object)pokemon.getOwnerPlayer(), (Object)player)) {
            class_1792 class_17922 = itemStack.method_7909();
            Intrinsics.checkNotNullExpressionValue((Object)class_17922, (String)"getItem(...)");
            success = this.handleItem(pokemon, class_17922);
            if (success) {
                itemStack.method_7934(1);
            }
        }
        return success;
    }

    public final void giveHeldItem(@NotNull HeldItemEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Pokemon pokemon = event.getPokemon();
        class_1792 item = event.getReceived().method_7909();
        Intrinsics.checkNotNull((Object)item);
        if (this.handleItem(pokemon, item)) {
            pokemon.removeHeldItem();
        }
    }

    public final boolean handleItem(@NotNull Pokemon pokemon, @NotNull class_1792 item) {
        int increase;
        class_1792 class_17922;
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        IntSpeciesFeature goldHoard = (IntSpeciesFeature)pokemon.getFeature("gimmighoul_coins");
        IntSpeciesFeature netheriteHoard = (IntSpeciesFeature)pokemon.getFeature("gimmighoul_netherite");
        if (goldHoard != null && goldHoard.getValue() < 999) {
            class_17922 = item;
            int n = Intrinsics.areEqual((Object)class_17922, (Object)((Object)CobblemonItems.RELIC_COIN)) ? COIN_VALUE : (Intrinsics.areEqual((Object)class_17922, (Object)CobblemonItems.RELIC_COIN_POUCH) ? POUCH_VALUE : (increase = Intrinsics.areEqual((Object)class_17922, (Object)CobblemonItems.RELIC_COIN_SACK) ? SACK_VALUE : 0));
            if (increase != 0) {
                goldHoard.setValue(goldHoard.getValue() + increase);
                if (goldHoard.getValue() > 999) {
                    goldHoard.setValue(999);
                }
                if (pokemon.getEntity() != null) {
                    PokemonEntity pokemonEntity = pokemon.getEntity();
                    Intrinsics.checkNotNull((Object)pokemonEntity);
                    pokemonEntity.method_5783(CobblemonSounds.GIMMIGHOUL_GIVE_ITEM, 1.0f, 1.0f);
                }
                pokemon.markFeatureDirty(goldHoard);
                return true;
            }
        }
        if (netheriteHoard != null && netheriteHoard.getValue() < 256) {
            class_17922 = item;
            int n = Intrinsics.areEqual((Object)class_17922, (Object)class_1802.field_22021) ? SCRAP_VALUE : (Intrinsics.areEqual((Object)class_17922, (Object)class_1802.field_22020) ? INGOT_VALUE : (increase = Intrinsics.areEqual((Object)class_17922, (Object)class_1802.field_22018) ? BLOCK_VALUE : 0));
            if (increase != 0) {
                netheriteHoard.setValue(netheriteHoard.getValue() + increase);
                if (netheriteHoard.getValue() > 256) {
                    netheriteHoard.setValue(256);
                }
                if (pokemon.getEntity() != null) {
                    PokemonEntity pokemonEntity = pokemon.getEntity();
                    Intrinsics.checkNotNull((Object)pokemonEntity);
                    pokemonEntity.method_5783(CobblemonSounds.GIMMIGHOUL_GIVE_ITEM, 1.0f, 1.0f);
                }
                pokemon.markFeatureDirty(netheriteHoard);
                return true;
            }
        }
        return false;
    }
}

