/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.starter;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.starter.StarterChosenEvent;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.starter.StarterHandler;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.player.GeneralPlayerData;
import com.cobblemon.mod.common.api.storage.player.PlayerInstancedDataStoreTypes;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.config.starter.StarterCategory;
import com.cobblemon.mod.common.net.messages.client.starter.OpenStarterUIPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.world.gamerules.CobblemonGameRules;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\fJ'\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/cobblemon/mod/common/starter/CobblemonStarterHandler;", "Lcom/cobblemon/mod/common/api/starter/StarterHandler;", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "", "Lcom/cobblemon/mod/common/config/starter/StarterCategory;", "getStarterList", "(Lnet/minecraft/class_3222;)Ljava/util/List;", "", "handleJoin", "(Lnet/minecraft/class_3222;)V", "requestStarterChoice", "", "categoryName", "", "index", "chooseStarter", "(Lnet/minecraft/class_3222;Ljava/lang/String;I)V", "common"})
@SourceDebugExtension(value={"SMAP\nCobbledStarterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobbledStarterHandler.kt\ncom/cobblemon/mod/common/starter/CobblemonStarterHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable\n+ 4 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable$postThen$1\n*L\n1#1,75:1\n1#2:76\n39#3,2:77\n41#3,2:82\n44#3,3:85\n47#3:90\n17#4,2:79\n19#4:89\n13346#5:81\n13347#5:88\n39#6:84\n*S KotlinDebug\n*F\n+ 1 CobbledStarterHandler.kt\ncom/cobblemon/mod/common/starter/CobblemonStarterHandler\n*L\n61#1:77,2\n61#1:82,2\n61#1:85,3\n61#1:90\n61#1:79,2\n61#1:89\n61#1:81\n61#1:88\n61#1:84\n*E\n"})
public class CobblemonStarterHandler
implements StarterHandler {
    @Override
    @NotNull
    public List<StarterCategory> getStarterList(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return Cobblemon.INSTANCE.getStarterConfig().getStarters();
    }

    @Override
    public void handleJoin(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
    }

    @Override
    public void requestStarterChoice(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        GeneralPlayerData playerData = Cobblemon.INSTANCE.getPlayerDataManager().getGenericData(player);
        if (playerData.getStarterSelected()) {
            playerData.sendToPlayer(player);
            class_5250 class_52502 = LocalizationUtilsKt.lang("ui.starter.alreadyselected", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"lang(...)");
            player.method_43502((class_2561)TextKt.red(class_52502), true);
        } else if (playerData.getStarterLocked()) {
            class_5250 class_52503 = LocalizationUtilsKt.lang("ui.starter.cannotchoose", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"lang(...)");
            player.method_43502((class_2561)TextKt.red(class_52503), true);
        } else {
            new OpenStarterUIPacket((Collection<StarterCategory>)this.getStarterList(player)).sendToPlayer(player);
            playerData.setStarterPrompted(true);
            Cobblemon.INSTANCE.getPlayerDataManager().saveSingle(playerData, PlayerInstancedDataStoreTypes.INSTANCE.getGENERAL());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void chooseStarter(@NotNull class_3222 player, @NotNull String categoryName, int index) {
        void this_$iv$iv;
        void $this$iv;
        Object v2;
        Object object;
        GeneralPlayerData playerData;
        block8: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)categoryName, (String)"categoryName");
            playerData = Cobblemon.INSTANCE.getPlayerDataManager().getGenericData(player);
            if (playerData.getStarterSelected()) {
                class_5250 class_52502 = LocalizationUtilsKt.lang("ui.starter.alreadyselected", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"lang(...)");
                player.method_43502((class_2561)TextKt.red(class_52502), true);
                return;
            }
            if (playerData.getStarterLocked()) {
                class_5250 class_52503 = LocalizationUtilsKt.lang("ui.starter.cannotchoose", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"lang(...)");
                player.method_43502((class_2561)TextKt.red(class_52503), true);
                return;
            }
            object = this.getStarterList(player);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                StarterCategory it = (StarterCategory)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)categoryName)) continue;
                v2 = t;
                break block8;
            }
            v2 = null;
        }
        StarterCategory starterCategory = v2;
        if (starterCategory == null) {
            return;
        }
        StarterCategory category = starterCategory;
        if (index > category.getPokemon().size()) {
            return;
        }
        PokemonProperties properties = category.getPokemon().get(index);
        Pokemon pokemon = properties.create(player);
        object = CobblemonEvents.STARTER_CHOSEN;
        Cancelable event$iv = new StarterChosenEvent(player, properties, pokemon);
        boolean $i$f$postThen = false;
        EventObservable bl2 = (EventObservable)$this$iv;
        Cancelable[] cancelableArray = new Cancelable[]{event$iv};
        Cancelable[] events$iv$iv = cancelableArray;
        boolean $i$f$post = false;
        this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
        Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            void it;
            Pokemon pokemon2;
            Cancelable it2;
            Cancelable element$iv$iv$iv;
            Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl3 = false;
            if (it$iv.isCanceled()) {
                Cancelable cancelable = it$iv;
                boolean bl4 = false;
                it2 = cancelable;
                continue;
            }
            it2 = (StarterChosenEvent)it$iv;
            boolean bl5 = false;
            Pokemon pokemon3 = pokemon2 = ((StarterChosenEvent)it2).getPokemon();
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            boolean bl6 = false;
            playerData.setStarterSelected(true);
            playerData.setStarterUUID(it.getUuid());
            if (player.method_37908().method_8450().method_8355(CobblemonGameRules.SHINY_STARTERS)) {
                pokemon.setShiny(true);
            }
            playerPartyStore.add(pokemon2);
            CobblemonCriteria.INSTANCE.getPICK_STARTER().trigger(player, pokemon);
            Cobblemon.INSTANCE.getPlayerDataManager().saveSingle(playerData, PlayerInstancedDataStoreTypes.INSTANCE.getGENERAL());
            playerData.sendToPlayer(player);
        }
    }
}

