/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.trade;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.trade.TradeManager;
import com.cobblemon.mod.common.trade.TradeOffer;
import com.cobblemon.mod.common.trade.TradeParticipant;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0015\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010\u001f\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001f\u0010\u001eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\"R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010 \u001a\u0004\b#\u0010\"R\u0017\u0010$\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u0017\u0010(\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b(\u0010%\u001a\u0004\b)\u0010'\u00a8\u0006*"}, d2={"Lcom/cobblemon/mod/common/trade/ActiveTrade;", "", "Lcom/cobblemon/mod/common/trade/TradeParticipant;", "player1", "player2", "<init>", "(Lcom/cobblemon/mod/common/trade/TradeParticipant;Lcom/cobblemon/mod/common/trade/TradeParticipant;)V", "Ljava/util/UUID;", "uuid", "getTradeParticipant", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/trade/TradeParticipant;", "tradeParticipant", "Lcom/cobblemon/mod/common/trade/TradeOffer;", "getOffer", "(Lcom/cobblemon/mod/common/trade/TradeParticipant;)Lcom/cobblemon/mod/common/trade/TradeOffer;", "getOpposingOffer", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "updateOffer", "(Lcom/cobblemon/mod/common/trade/TradeParticipant;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "", "acceptance", "updateAcceptance", "(Lcom/cobblemon/mod/common/trade/TradeParticipant;Z)V", "getOppositePlayer", "(Lcom/cobblemon/mod/common/trade/TradeParticipant;)Lcom/cobblemon/mod/common/trade/TradeParticipant;", "performTrade", "(Lcom/cobblemon/mod/common/trade/TradeParticipant;)V", "cancelTrade", "()V", "completeTrade", "Lcom/cobblemon/mod/common/trade/TradeParticipant;", "getPlayer1", "()Lcom/cobblemon/mod/common/trade/TradeParticipant;", "getPlayer2", "player1Offer", "Lcom/cobblemon/mod/common/trade/TradeOffer;", "getPlayer1Offer", "()Lcom/cobblemon/mod/common/trade/TradeOffer;", "player2Offer", "getPlayer2Offer", "common"})
public final class ActiveTrade {
    @NotNull
    private final TradeParticipant player1;
    @NotNull
    private final TradeParticipant player2;
    @NotNull
    private final TradeOffer player1Offer;
    @NotNull
    private final TradeOffer player2Offer;

    public ActiveTrade(@NotNull TradeParticipant player1, @NotNull TradeParticipant player2) {
        Intrinsics.checkNotNullParameter((Object)player1, (String)"player1");
        Intrinsics.checkNotNullParameter((Object)player2, (String)"player2");
        this.player1 = player1;
        this.player2 = player2;
        this.player1Offer = new TradeOffer();
        this.player2Offer = new TradeOffer();
    }

    @NotNull
    public final TradeParticipant getPlayer1() {
        return this.player1;
    }

    @NotNull
    public final TradeParticipant getPlayer2() {
        return this.player2;
    }

    @NotNull
    public final TradeOffer getPlayer1Offer() {
        return this.player1Offer;
    }

    @NotNull
    public final TradeOffer getPlayer2Offer() {
        return this.player2Offer;
    }

    @NotNull
    public final TradeParticipant getTradeParticipant(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return Intrinsics.areEqual((Object)this.player1.getUuid(), (Object)uuid) ? this.player1 : this.player2;
    }

    @NotNull
    public final TradeOffer getOffer(@NotNull TradeParticipant tradeParticipant) {
        Intrinsics.checkNotNullParameter((Object)tradeParticipant, (String)"tradeParticipant");
        return Intrinsics.areEqual((Object)tradeParticipant, (Object)this.player1) ? this.player1Offer : this.player2Offer;
    }

    @NotNull
    public final TradeOffer getOpposingOffer(@NotNull TradeParticipant tradeParticipant) {
        Intrinsics.checkNotNullParameter((Object)tradeParticipant, (String)"tradeParticipant");
        return Intrinsics.areEqual((Object)tradeParticipant, (Object)this.player1) ? this.player2Offer : this.player1Offer;
    }

    public final void updateOffer(@NotNull TradeParticipant tradeParticipant, @Nullable Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)tradeParticipant, (String)"tradeParticipant");
        this.getOffer(tradeParticipant).updateOffer(pokemon);
        this.getOffer(this.getOppositePlayer(tradeParticipant)).setAccepted(false);
        this.player1.updateOffer(this, tradeParticipant, pokemon);
        this.player2.updateOffer(this, tradeParticipant, pokemon);
    }

    public final void updateAcceptance(@NotNull TradeParticipant tradeParticipant, boolean acceptance) {
        Intrinsics.checkNotNullParameter((Object)tradeParticipant, (String)"tradeParticipant");
        TradeOffer offer = this.getOpposingOffer(tradeParticipant);
        if (offer.getAccepted() != acceptance) {
            offer.setAccepted(acceptance);
            TradeParticipant tradeParticipant2 = this.getOppositePlayer(tradeParticipant);
            Pokemon pokemon = offer.getPokemon();
            Intrinsics.checkNotNull((Object)pokemon);
            UUID uUID = pokemon.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
            tradeParticipant2.changeTradeAcceptance(this, uUID, acceptance);
            Pokemon pokemon2 = offer.getPokemon();
            Intrinsics.checkNotNull((Object)pokemon2);
            UUID uUID2 = pokemon2.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"<get-uuid>(...)");
            tradeParticipant.changeTradeAcceptance(this, uUID2, acceptance);
        }
        if (offer.getAccepted() && this.getOffer(tradeParticipant).getAccepted()) {
            this.player1.startTradeProcess(this, Intrinsics.areEqual((Object)tradeParticipant, (Object)this.player1));
            this.player2.startTradeProcess(this, Intrinsics.areEqual((Object)tradeParticipant, (Object)this.player2));
        }
    }

    @NotNull
    public final TradeParticipant getOppositePlayer(@NotNull TradeParticipant tradeParticipant) {
        Intrinsics.checkNotNullParameter((Object)tradeParticipant, (String)"tradeParticipant");
        return Intrinsics.areEqual((Object)tradeParticipant, (Object)this.player1) ? this.player2 : this.player1;
    }

    public final void performTrade(@NotNull TradeParticipant tradeParticipant) {
        Intrinsics.checkNotNullParameter((Object)tradeParticipant, (String)"tradeParticipant");
        TradeOffer offer = this.getOpposingOffer(tradeParticipant);
        if (offer.getAccepted() && this.getOffer(tradeParticipant).getAccepted()) {
            TradeManager tradeManager = TradeManager.INSTANCE;
            TradeParticipant tradeParticipant2 = this.player1;
            TradeParticipant tradeParticipant3 = this.player2;
            Pokemon pokemon = this.player1Offer.getPokemon();
            Intrinsics.checkNotNull((Object)pokemon);
            Pokemon pokemon2 = pokemon;
            Pokemon pokemon3 = this.player2Offer.getPokemon();
            Intrinsics.checkNotNull((Object)pokemon3);
            Pokemon pokemon4 = pokemon3;
            tradeManager.performTrade(tradeParticipant2, pokemon2, tradeParticipant3, pokemon4);
            this.completeTrade();
        }
    }

    public final void cancelTrade() {
        this.player1.cancelTrade(this);
        this.player2.cancelTrade(this);
        TradeManager.INSTANCE.removeActiveTrade(this);
    }

    public final void completeTrade() {
        Pokemon pokemon = this.player1Offer.getPokemon();
        Intrinsics.checkNotNull((Object)pokemon);
        UUID uUID = pokemon.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
        Pokemon pokemon2 = this.player2Offer.getPokemon();
        Intrinsics.checkNotNull((Object)pokemon2);
        UUID uUID2 = pokemon2.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"<get-uuid>(...)");
        this.player1.completeTrade(this, uUID, uUID2);
        Pokemon pokemon3 = this.player2Offer.getPokemon();
        Intrinsics.checkNotNull((Object)pokemon3);
        UUID uUID3 = pokemon3.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"<get-uuid>(...)");
        Pokemon pokemon4 = this.player1Offer.getPokemon();
        Intrinsics.checkNotNull((Object)pokemon4);
        UUID uUID4 = pokemon4.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID4, (String)"<get-uuid>(...)");
        this.player2.completeTrade(this, uUID3, uUID4);
        this.player1Offer.setPokemon(null);
        this.player1Offer.setAccepted(false);
        this.player2Offer.setPokemon(null);
        this.player2Offer.setAccepted(false);
    }
}

