/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.trade;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.net.messages.client.trade.TradeAcceptanceChangedPacket;
import com.cobblemon.mod.common.net.messages.client.trade.TradeCancelledPacket;
import com.cobblemon.mod.common.net.messages.client.trade.TradeCompletedPacket;
import com.cobblemon.mod.common.net.messages.client.trade.TradeProcessStartedPacket;
import com.cobblemon.mod.common.net.messages.client.trade.TradeUpdatedPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.trade.ActiveTrade;
import com.cobblemon.mod.common.trade.TradeParticipant;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\"\u0010\"\u001a\n !*\u0004\u0018\u00010 0 8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\"\u0010&\u001a\n !*\u0004\u0018\u00010\u000e0\u000e8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u001a\u0010+\u001a\u00020*8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lcom/cobblemon/mod/common/trade/PlayerTradeParticipant;", "Lcom/cobblemon/mod/common/trade/TradeParticipant;", "Lnet/minecraft/class_3222;", "player", "<init>", "(Lnet/minecraft/class_3222;)V", "Lcom/cobblemon/mod/common/trade/ActiveTrade;", "trade", "tradeParticipant", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "updateOffer", "(Lcom/cobblemon/mod/common/trade/ActiveTrade;Lcom/cobblemon/mod/common/trade/TradeParticipant;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Ljava/util/UUID;", "pokemonId", "", "acceptance", "changeTradeAcceptance", "(Lcom/cobblemon/mod/common/trade/ActiveTrade;Ljava/util/UUID;Z)V", "isTradeInitiator", "startTradeProcess", "(Lcom/cobblemon/mod/common/trade/ActiveTrade;Z)V", "cancelTrade", "(Lcom/cobblemon/mod/common/trade/ActiveTrade;)V", "pokemonId1", "pokemonId2", "completeTrade", "(Lcom/cobblemon/mod/common/trade/ActiveTrade;Ljava/util/UUID;Ljava/util/UUID;)V", "Lnet/minecraft/class_3222;", "getPlayer", "()Lnet/minecraft/class_3222;", "Lnet/minecraft/class_2561;", "kotlin.jvm.PlatformType", "name", "Lnet/minecraft/class_2561;", "getName", "()Lnet/minecraft/class_2561;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;", "party", "Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;", "getParty", "()Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;", "common"})
public final class PlayerTradeParticipant
implements TradeParticipant {
    @NotNull
    private final class_3222 player;
    private final class_2561 name;
    private final UUID uuid;
    @NotNull
    private final PlayerPartyStore party;

    public PlayerTradeParticipant(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.player = player;
        this.name = this.player.method_5477();
        this.uuid = this.player.method_5667();
        this.party = PlayerExtensionsKt.party(this.player);
    }

    @NotNull
    public final class_3222 getPlayer() {
        return this.player;
    }

    @Override
    public class_2561 getName() {
        return this.name;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    @NotNull
    public PlayerPartyStore getParty() {
        return this.party;
    }

    @Override
    public void updateOffer(@NotNull ActiveTrade trade, @NotNull TradeParticipant tradeParticipant, @Nullable Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)trade, (String)"trade");
        Intrinsics.checkNotNullParameter((Object)tradeParticipant, (String)"tradeParticipant");
        CobblemonNetwork.INSTANCE.sendPacket(this.player, new TradeUpdatedPacket(tradeParticipant.getUuid(), pokemon));
    }

    @Override
    public void changeTradeAcceptance(@NotNull ActiveTrade trade, @NotNull UUID pokemonId, boolean acceptance) {
        Intrinsics.checkNotNullParameter((Object)trade, (String)"trade");
        Intrinsics.checkNotNullParameter((Object)pokemonId, (String)"pokemonId");
        CobblemonNetwork.INSTANCE.sendPacket(this.player, new TradeAcceptanceChangedPacket(pokemonId, acceptance));
    }

    @Override
    public void startTradeProcess(@NotNull ActiveTrade trade, boolean isTradeInitiator) {
        Intrinsics.checkNotNullParameter((Object)trade, (String)"trade");
        CobblemonNetwork.INSTANCE.sendPacket(this.player, new TradeProcessStartedPacket(isTradeInitiator));
    }

    @Override
    public void cancelTrade(@NotNull ActiveTrade trade) {
        Intrinsics.checkNotNullParameter((Object)trade, (String)"trade");
        CobblemonNetwork.INSTANCE.sendPacket(this.player, new TradeCancelledPacket());
    }

    @Override
    public void completeTrade(@NotNull ActiveTrade trade, @NotNull UUID pokemonId1, @NotNull UUID pokemonId2) {
        Intrinsics.checkNotNullParameter((Object)trade, (String)"trade");
        Intrinsics.checkNotNullParameter((Object)pokemonId1, (String)"pokemonId1");
        Intrinsics.checkNotNullParameter((Object)pokemonId2, (String)"pokemonId2");
        CobblemonNetwork.INSTANCE.sendPacket(this.player, new TradeCompletedPacket(pokemonId1, pokemonId2));
    }
}

